(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   3084859,      59183]
NotebookOptionsPosition[   3077833,      58965]
NotebookOutlinePosition[   3078365,      58984]
CellTagsIndexPosition[   3078322,      58981]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Class 03 Lines, Planes, Surfaces - Notes and Worksheet\
\>", "Title",
 CellChangeTimes->{{3.5441705070554495`*^9, 3.544170512079737*^9}, {
  3.544377860217*^9, 3.5443778650629997`*^9}, {3.5444272380281506`*^9, 
  3.5444272387758417`*^9}, {3.544450034381*^9, 3.5444500522586*^9}, {
  3.576499608484373*^9, 3.5764996195799637`*^9}, {3.576568720932519*^9, 
  3.5765687298366747`*^9}}],

Cell[CellGroupData[{

Cell["Lines", "Section",
 CellChangeTimes->{{3.544427256798315*^9, 3.5444272637310343`*^9}, 
   3.544453282761227*^9, {3.576499637191373*^9, 3.576499638139241*^9}}],

Cell[TextData[{
 StyleBox["One way to describe a line in ", "Text"],
 StyleBox[Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "3"], TraditionalForm]], "Text"],
   "Text"],
 StyleBox[" is by specifying two different points.  For example, the line \
that passes through the points ", "Text"],
 StyleBox[Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"3", ",", "5", ",", 
     RowBox[{"-", "1"}]}], ")"}], TraditionalForm]], "Text"], "Text"],
 StyleBox[" and ", "Text"],
 StyleBox[Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "4"}], ")"}], TraditionalForm]], "Text"], 
  "Text"],
 StyleBox[".  What are other ways to describe a line in ", "Text"],
 StyleBox[Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "3"], TraditionalForm]], "Text"],
   "Text"],
 StyleBox["?  For each of these other ways of describing a line, use it to \
describe the example line.", "Text"]
}], "Text",
 CellChangeTimes->{3.5764999643086033`*^9}],

Cell[CellGroupData[{

Cell[TextData[{
 "All ",
 StyleBox["affine combinations of two vectors",
  FontWeight->"Bold"],
 ".  For example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "t"}], ")"}], 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"3", ",", "5", ",", 
         RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}]}], "+", 
      RowBox[{"t", 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}], ",", "4"}], "\[RightAngleBracket]"}]}]}], ":", 
     RowBox[{
      RowBox[{"-", "\[Infinity]"}], "<", "t", "<", "\[Infinity]"}]}], "}"}], 
   TraditionalForm]]],
 "."
}], "Item",
 CellChangeTimes->{{3.57650001290501*^9, 3.576500016306849*^9}}],

Cell[TextData[{
 "A ",
 StyleBox["graph",
  FontWeight->"Bold"],
 ".  For example, see below where a line between two affine combinations is \
used.  "
}], "Item",
 CellChangeTimes->{{3.57650001290501*^9, 3.576500026080832*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"myAxis", "[", 
    RowBox[{
    "label_", ",", "color_", ",", "component_", ",", "lo_", ",", "hi_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "g", ",", "o"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"o", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
      RowBox[{"e", "=", "o"}], ";", 
      RowBox[{
       RowBox[{
       "e", "\[LeftDoubleBracket]", "component", "\[RightDoubleBracket]"}], 
       "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"g", "=", 
       RowBox[{"{", 
        RowBox[{"color", ",", 
         RowBox[{"Text", "[", 
          RowBox[{"label", ",", 
           RowBox[{"1.05", " ", "hi", " ", "e"}]}], "]"}], ",", 
         RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"o", ",", 
            RowBox[{"hi", " ", "e"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"lo", "<", "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"g", ",", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"lo", " ", "e"}], ",", "o"}], "}"}], "]"}], ",", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", "}"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "g"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myPoint", "[", 
    RowBox[{"p_", ",", "color_", ",", "label_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"color", ",", "Dashed", ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"p", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
     RowBox[{"Point", "[", "p", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{"label", ",", 
       RowBox[{"1.1", "p"}]}], "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "]"}], ",", 
     RowBox[{"myPoint", "[", 
      RowBox[{"a", ",", "Black", ",", "\"\<a\>\""}], "]"}], ",", 
     RowBox[{"myPoint", "[", 
      RowBox[{"b", ",", "Black", ",", "\"\<b\>\""}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"1.5", "a"}], "-", 
           RowBox[{"0.5", "b"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "0.5"}], "a"}], "+", 
           RowBox[{"1.5", "b"}]}]}], "}"}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], 
  "]"}], "\n"}], "Input",
 CellChangeTimes->{3.576500079701023*^9, 3.5765001132207737`*^9}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Text3DBox["\<\"x\"\>", {5.25, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {5, 0, 0}}], 
    {Dashing[{Small, Small}], Line3DBox[{{-2, 0, 0}, {0, 0, 0}}]}, 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], 
     Text3DBox["\<\"y\"\>", {0., 5.25, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 5, 0}}], 
      {Dashing[{Small, Small}], Line3DBox[{{0, -2, 0}, {0, 0, 0}}]}, 
      {RGBColor[0, 1, 0], Dashing[{}], Text3DBox["\<\"z\"\>", {0., 0., 5.25}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 5}}], 
        {Dashing[{Small, Small}], Line3DBox[{{0, 0, -2}, {0, 0, 0}}]}, 
        {GrayLevel[0], Dashing[{Small, Small}], 
         Line3DBox[{{3, 0, 0}, {3, 5, 0}, {3, 5, -1}}], 
         {PointSize[Medium], Point3DBox[{3, 5, -1}], 
          {Dashing[{}], 
           Text3DBox["\<\"a\"\>", {3.3000000000000003`, 5.5, -1.1}]}, 
          {GrayLevel[0], Dashing[{Small, Small}], 
           Line3DBox[{{1, 0, 0}, {1, -1, 0}, {1, -1, 4}}], 
           {PointSize[Medium], Point3DBox[{1, -1, 4}], 
            {Dashing[{}], Text3DBox["\<\"b\"\>", {1.1, -1.1, 4.4}], 
             {RGBColor[0, 0, 1], 
              Line3DBox[{{4., 8., -3.5}, {0., -4., 6.5}}]}}}}}}}}}}}},
  Axes->True,
  ViewPoint->{100, 100, 100}]], "Output",
 CellChangeTimes->{3.576500151280987*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Specify a point and a direction.  For example, the line that passes through \
the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"3", ",", "5", ",", 
     RowBox[{"-", "1"}]}], ")"}], TraditionalForm]]],
 " in the direction ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "6"}], ",", "5"}], "\[RightAngleBracket]"}], 
   TraditionalForm]]],
 ". "
}], "Item",
 CellChangeTimes->{{3.57650001290501*^9, 3.576500041401132*^9}, 
   3.576500220313157*^9}],

Cell[TextData[{
 "A parametric equation using a point and a direction.  For example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"3", ",", "5", ",", 
        RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}], "+", 
      RowBox[{"t", 
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "6"}], ",", "5"}], "\[RightAngleBracket]"}]}]}], ":", 
     RowBox[{
      RowBox[{"-", "\[Infinity]"}], "<", "t", "<", "\[Infinity]"}]}], "}"}], 
   TraditionalForm]]],
 "."
}], "Item",
 CellChangeTimes->{{3.57650001290501*^9, 3.5765000557050056`*^9}, 
   3.5765002203139343`*^9}],

Cell[TextData[{
 "Symmetric equations.  For example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y", ",", "z"}], ")"}], ":", 
      FractionBox[
       RowBox[{"x", "-", "3"}], 
       RowBox[{"-", "2"}]]}], "=", 
     RowBox[{
      FractionBox[
       RowBox[{"y", "-", "5"}], 
       RowBox[{"-", "6"}]], "=", 
      FractionBox[
       RowBox[{"z", "+", "1"}], "5"]}]}], "}"}], TraditionalForm]]],
 "."
}], "Item",
 CellChangeTimes->{{3.57650001290501*^9, 3.576500055702448*^9}, {
  3.576500188063999*^9, 3.576500220314687*^9}}],

Cell["\<\
Specify two planes that are not coincident or parallel.  For example, use two \
of the three planes specified by the symmetric equations.\
\>", "Item",
 CellChangeTimes->{{3.57650001290501*^9, 3.576500055702448*^9}, {
  3.576500188063999*^9, 3.5765002264135942`*^9}}],

Cell["\<\
A graph of the two or more intersecting planes and/or a parametric plot.  For \
example, see below.\
\>", "Item",
 CellChangeTimes->{{3.57650001290501*^9, 3.576500055702448*^9}, {
  3.576500188063999*^9, 3.576500234224637*^9}, {3.5765003830097322`*^9, 
  3.5765003830127068`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ";", 
  RowBox[{"p0", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"myAxis", "[", 
        RowBox[{"\"\<x\>\"", ",", "Black", ",", "1", ",", 
         RowBox[{"-", "2"}], ",", "5"}], "]"}], ",", 
       RowBox[{"myAxis", "[", 
        RowBox[{"\"\<y\>\"", ",", "Black", ",", "2", ",", 
         RowBox[{"-", "2"}], ",", "5"}], "]"}], ",", 
       RowBox[{"myAxis", "[", 
        RowBox[{"\"\<z\>\"", ",", "Black", ",", "3", ",", 
         RowBox[{"-", "2"}], ",", "5"}], "]"}], ",", 
       RowBox[{"myPoint", "[", 
        RowBox[{"a", ",", "Black", ",", "\"\<a\>\""}], "]"}], ",", 
       RowBox[{"myPoint", "[", 
        RowBox[{"b", ",", "Black", ",", "\"\<b\>\""}], "]"}]}], "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "-", 
        RowBox[{"2", "t"}]}], ",", 
       RowBox[{"5", "-", 
        RowBox[{"6", "t"}]}], ",", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"5", "t"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "0.5"}], ",", "1.5"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Black"}], "}"}]}]}], "]"}]}], ";", 
  RowBox[{"pxy", "=", 
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "3"}], ")"}], "/", 
       RowBox[{"-", "2"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "5"}], ")"}], "/", 
       RowBox[{"-", "6"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pyz", "=", 
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "5"}], ")"}], "/", 
       RowBox[{"-", "6"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "/", "5"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Blue", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pxz", "=", 
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "3"}], ")"}], "/", 
       RowBox[{"-", "2"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "/", "5"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Yellow", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"p0", ",", "p1", ",", "pxy", ",", "pyz", ",", "pxz"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.544457689316657*^9, 3.544457724482438*^9}, {
  3.5444577639436584`*^9, 3.5444578456604333`*^9}, {3.5444578785614233`*^9, 
  3.544458057904707*^9}, {3.54445814617667*^9, 3.544458208418911*^9}, {
  3.544458242884745*^9, 3.544458245286437*^9}, {3.54445827602497*^9, 
  3.5444583660022726`*^9}, {3.5444584079947805`*^9, 3.544458421597109*^9}, {
  3.5444585137716*^9, 3.5444585170005927`*^9}, {3.5444585854802027`*^9, 
  3.5444586182537017`*^9}, {3.544458658719095*^9, 3.544458710293357*^9}, {
  3.5444588049715204`*^9, 3.544458806952771*^9}, {3.5444588527555456`*^9, 
  3.5444588661250887`*^9}, {3.544458968755125*^9, 3.5444589947765923`*^9}, {
  3.544459034510811*^9, 3.5444590606424813`*^9}, {3.5444649440340047`*^9, 
  3.5444649529837556`*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0], Text3DBox[
     FormBox["\<\"x\"\>", StandardForm], {5.25, 0., 0.}], 
    {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {5, 0, 0}}], 
     {Dashing[{Small, Small}], Line3DBox[{{-2, 0, 0}, {0, 0, 0}}]}, 
     {GrayLevel[0], Dashing[{}], Text3DBox[
       FormBox["\<\"y\"\>", StandardForm], {0., 5.25, 0.}], 
      {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 5, 0}}], 
       {Dashing[{Small, Small}], Line3DBox[{{0, -2, 0}, {0, 0, 0}}]}, 
       {GrayLevel[0], Dashing[{}], Text3DBox[
         FormBox["\<\"z\"\>", StandardForm], {0., 0., 5.25}], 
        {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 5}}], 
         {Dashing[{Small, Small}], Line3DBox[{{0, 0, -2}, {0, 0, 0}}]}, 
         {GrayLevel[0], Dashing[{Small, Small}], 
          Line3DBox[{{3, 0, 0}, {3, 5, 0}, {3, 5, -1}}], 
          {PointSize[Medium], Point3DBox[{3, 5, -1}], 
           {Dashing[{}], Text3DBox[
             FormBox["\<\"a\"\>", StandardForm], {3.3000000000000003`, 
             5.5, -1.1}]}, 
           {GrayLevel[0], Dashing[{Small, Small}], 
            Line3DBox[{{1, 0, 0}, {1, -1, 0}, {1, -1, 4}}], 
            {PointSize[Medium], Point3DBox[{1, -1, 4}], 
             {Dashing[{}], Text3DBox[
               FormBox["\<\"b\"\>", StandardForm], {1.1, -1.1, 
               4.4}]}}}}}}}}}}}, {{}, {}, 
    {GrayLevel[0], Thickness[Large], Line3DBox[CompressedData["
1:eJwV1Xs01HkfB/BpBo2ZMT+mXEYYujAelFzbyPeTbpJrbimtJyVWCpVqtziS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      "]]}}, GraphicsComplex3DBox[CompressedData["
1:eJx1mXtolmUYh7/t2+ZhSlOp5YjEVkkYlZJpEryvWZbkH5p0QqMsU0s6RyrL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    "], {{
      {RGBColor[1, 0, 0], Opacity[0.5], EdgeForm[None], 
       GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmHdYVmUYh89JcafiQHOUigtCQSxBRRRFwxBSceRARQQNw4ntYWW7zLaW
lZqlLY0sy2zvsmlLG+Zo7122f7/r3N/V98d9nYfnffb7nnO+Q+eZ88fOOyQI
gtFhENTV1bKvdUSIXE80Fo3Q10VuIhqIhtjWF81Ec9FUHMpaS+KGxGmBXSJx
GiO3EQnki9WSiK1jtSJWa+y83ha/JNGRmhqh81oHdJbbic7U7FoPpyb31And
QJFDDQnESSR3Eja2PQL/9uRw7MNYq0PODvSawkzcRxfRVRwpuiN3E2kiFX1X
ZPv1FhkiXfQSPUVfkUysPiITm97U1Yncrq0HPl3Il4H90eIo4mYg9xNZIlsM
EP2pIw1dFn1kseY9HkSO7syuNbqBzC+Z/rpSQwoxY7G603MOPkNFlSgSo9iH
HOboczJTlIvZoiCI9jxX5IthYHmEGC4GiyHEzcPnWDFSHCNGIx8nislZxFqh
mCimiilifBCdgyHETcJuJHEKkR1/DDHtVyLGiuPFBGI61jh87DsZm1xi55E3
j9pHESeJ9Vx6L2GtEP+YTwm5c5hvCjPMx3cqdRQx0wJ6qRDTRamYxXWaqGTu
MV05fj7z7Zi7592UGGVBdM96rS21DmNf8sk9AZsyZurZ+tzNoIb+MJ2Yjj0n
iM6sz+oJQXRPpKOfzeznsDaG2BXUXUWeMuShxJ5Bj6XEmEOcAuxm0WsRM/Ze
TWI/y5lNL3x9b20S9wTRPVYtFomFYi5Y9j2RjOz1BWK+qBEniSViMWuWT8Fm
njiZtWp8rD9TnCFOxKaaXIvxX4RuCfFPJWY2fqcx+zRinsHaueI8cY44m7oX
YpNGDMc6XywDyxeKC4jj2k4nxwJ8lqE/m9hLxVnoluF7Or1eyVzcy0ViBT3U
sHYJev+9XFwhLheXiYvRrcDmKtaXs2b5enEdPpeKq7Hz+jWsX4HOva4SK+lz
kV4gn+j6secSRvob6OVGbFYiX0gO57pJrKau5dS6Ci4jxkp6u5RaLqLvFdid
it1q5uicfTkD3vtkYl2OjW3XiLXiFnEzWL5dbKTGW7G5gLV1YgM2d4m7xZ3i
DmzWEje2x7cF0T01AB/71orNrK0h73p81qC37yZyOLbvoXupy+85v98q0Vn2
PTeNOPeytp7YG9HVEm8T+dfS3zp628xaJjlmUMt6Yq9mr85lxhvpaTP2j4jH
mMl2cZ/YIh4QDwXRvt9Pzths78duHXu2FJ1tfS/4fntYPAiWt4mt2C0lRyzG
feTawNo5+G1B9xC11XK9m5nUIrv+R9nTJ8RT4knxOH1sRY716rWn8dlCrq1x
PT+A7Xb024j7ODxJnEeQne8ZYj4vXhDPiWfFa+J18ap4RexEZ/kNrl57WewQ
b4t3xFviTfEZdl+Kr8RL2HjtRfGu2IXOa++he4k6PhR7xAfifbFX7EP/EXzI
2qdB9CzYi/5AED0XPkHeLz4XX1DXHuSd1Gjdbmp4gVnEetxBD/uIsYe8dfy7
PYx6cN31JP+s64/CP26/1+UH8S1zeQf5a2b0i/hN/Cp+CiLfX5Ad46D4Q/wu
vsPX12+IYf2f4h/xN7Z/oYv5/M7aN9R0iAjFv+Sogy625r/fZQ4huveYjfv8
nj68Z+49gT53UXddYvzInD5j7z+gzwRm9hPnph65/2VWB+N6bSh9I9FA1MfG
NXUTPUTzMNr3proeKlqgs5wYRnrHaIbufepoJbklcRuLNuJwYtmmJb7WtxVJ
onUY+TWhJtu0p6524jCujtNRdBBdsPFa5zgbr3WK01k+QiRTa3t8m1F/fXQt
yd0w/L/nZvglkrsNtXak1gyRTp+N0DWm9x7MsqfoztV/dxWpYbRvPvdeSwmj
2VmXwiz2c281Z/bdOFs+K46xgz32vjnXAe7NT/H5knurB/l7id4iTRyJ7PvQ
z6I0+kjFri19pCPH9qoXvkn03hOfdHrIYAatmGsD5tYubgYZ2KYyi97E9XPB
zyY/u56jx908K2xzlOgnjhaZor8YKLLRDRK5YgBrvuZg47/9m9Xv3UHE6YdP
f/z9u9vfis7TV4zg2kfkY+NcWeS3rWP2o7Y8MVQMEYPx8/Pdz/R8YrzGM9E2
/g3v3/Ij8LPsGmK5/Y1lm6HEniyKxFhxfBh909nGa8OoKYucfdDlUctwcoyg
jiHEGScmEc/vKL+r/P+S4jD6DvD3wBjJBWKUGCmOcW1htObvu2Js/N3n7zJ/
OxSG0dUx7FOIr/8uIIbfsc5ZTF/+ZhyP77GixDGpMdbzJPbUe+u99G+pXPbR
73jHLIqbVTFxxnI2JhNnQFxNo8g3QUwkZwm+o9H7b+dyjsnE8pw97ylh9J7u
yznIZO+tnxpG75162Fhn2fftdF1niGmilHPq3maKMp8HMTeM3jl+92RjU0Zc
280S5WH0nitDZ9nvuUrJc8RsUYG+HNnvigrWEvh7NvYHeVcksP4D76VSarJN
JXXPRVdKTa7Bud1zVRj1WIq9c1chV3BWs/GbQlzH+oP3VLXkBWK+mMeZ87k5
USzmWs2av1V8zv2bw78hfN59xn2vWTcY3wJ84mPYdyG5fM8MJ6fPtM/2MNb8
7XRtEH03XcU5HsOaYy4RJ7Gn7ttn1We3hn3KQTcrbu9qmEk5fewNot9Ui6hh
XxDp5mG7hNhV1OlebTOfXOOxqUGeSE3W/QcJbS7W
         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], 
      Line3DBox[{9, 8, 33, 30, 31, 27, 25, 69, 70, 86, 84, 330, 332, 335, 371,
        369, 228, 226, 274, 273, 291, 290, 289, 287, 288, 284, 285, 277, 278, 
       299, 300, 197, 198, 201, 211, 212, 236, 237, 253, 254, 251, 252, 363, 
       350, 352, 374, 343, 342, 336, 196, 194, 192, 185, 186, 131, 130, 157, 
       150, 151, 148, 149, 147, 139, 138, 145, 119, 110, 108, 51, 40, 39, 61, 
       21, 19, 9}]}},
    VertexNormals->CompressedData["
1:eJxTTMoPSmViYGAoY2RgYAbS03NzhOdGv7Pn9/RIEra9sp8BCkbFR8VHxUfF
R8VHhjgvieKDzf2j4sMj3kl1z2BLn6PuGRUfFR8VHxUfnPUFrcvP0fJ2aMUv
reNxND0MD3FS06EAieKkmjPYwmewhT+t44Va5pPqX2qZPyo+Ko4sTmq6opb4
QLmfVHOo5Z7BFu+j4vSJ39F0NbTcT+tybLQeHxWnhfhA1YPUat8OlXkHWvf3
ad2+Gq7lDKX9RACttpSJ
     "]], GraphicsComplex3DBox[CompressedData["
1:eJx1mHmIVWUYh+/MHWdyq3HLnIK0SY1CrajckHtNsQQjsz9SXMowFLWsFNTc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    "], {{
      {RGBColor[0, 0, 1], Opacity[0.5], EdgeForm[None], 
       GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmXe8j+Ubx79PRspIsld2NsmeGSUkHCsj2dlCNsksZJSZkYrIPnaSneyT
ESJUTqFDNlnx+3xez/u8fueP9+u57+u+1n3d1/d5bkfOtj2jejwRiUQOBZFI
Yj31iHjucSKeSUQy5ilFKpFaPCOeFEnRsW4a8axIIZ7GLgnjp7B9TqTFRyJ0
sors2GZExz4yiPQiHTZJiJcGn841E3kkRma75MRLi21m4qXAd6oEOn4WEDlE
TpGLXLKJ3CKPyCfyiizkat3nedq2IHPXpAg2hfEVsM/skBU/9l9SlBB1RX1R
iBo/g31yck1JnNTspQg6L5Cjc8uPTkr8FGSvGamja1FJlBGlRUXwuLyoIEqJ
l8ipJHKvFxflGNv+RWTWrSxeFlXYWzLq6tqUFUXxW5JxMVEVWQl82LYazxqi
OvPi2JQlvuO8gk4V/FTGh/3VFq+K10QdbGxbC1lN1mtzpq+yx3Ksv4bu69hX
I5d64g3wOEo0pGbl8VOTuhQj5+Kcawn8vIHfWpx1A8ZlqY1l40V/MViMRWYf
jdAfh47XPhLNRGPRVLSMhD3oc2+BzGtZkHv+lnhTNBHNGbvnsyFzz7l33VOt
RCdi2HcX0S4S9lZh1tuK1uJt0QaZbd2X7cnDNh1FB2I0xmdzci2ETgv02uHH
9j1FV9FNvItNM/LqRl722538urLH5qx3Q/cd7DsQow823Rm/J3qg1wlfnalL
FnJuQk7eWy/RG9uOyHtT4xbEacm51eXsGxKnD7p9xWgxWUwSE8WwSNib7r0R
4gNkHg+PhL0xQAyJhD1iPffUSHQsf18MZX0k6+6dQcR17v2I3495W86vF/vL
j8w5R+FzCH4akYP95SNf5+h30Chiem0geo3wM4Q9jGLP3vuESNjP7uuPI2Ef
tWbN9XCffyjGRMJ+z09NWpPfJHxNwH4gNRqPrDX6w/E5iJz6ozuZfAain5e9
fECsEexnFD7cF+4Z90pnajyUHJ2rvzX+Xvk963frLDFFTBNzxRzxqfhEzGZt
qpiOjpkhPkff8pnIpqE7T3zB2jaxXawQ0eJrsRCdBWK++Ep8ic036HhtESwg
pznkNYW8P8PmS3KYju488rDNGrFWrBQbxWqxSiwRy8R61q23jhyd63JsvhOL
0fP692KL2Cw2wWZ8rMfnEmyWIt+M35WsrcJPvO0W6hRNzT9hb1vFBnJz7t/i
dwm269nrQuroWvis94jdkfDM/S34QeyMhL+THYx/FLvQ3cF4H3Z7GO+NhL+r
HciGYmt/Mfg4IA5SV+/d36L96MTH3k8tYhgfQNeyGsz3Y3tEHBI/icPioS4n
M8VscV/8zNps6nOUszqC/mHWrXdMHEfnMPMT4pdI2GeLOGv35ylxEk6QwxFq
6Jr8Ggl/41HUYAe1+ZV11+o0sW07hxyXE+Mk/tyT7s0pnPMp8jmBzhlxVvwu
fuPMvYcL4i/kf4hY1mOZe+1PEScui0vib+S2Pc/6JdaviH/Ef66xuC/u4WsD
cf9C75q4ir5zuyjOkctNcZ24NyJhT1xEbxeyOHK5RZ3uiNvUy3dFv5P8LvJd
pQgyj31fyYPMY7/L91GjOwl8naEWD4h5Ftk+9uy932WP9xn/y37Psd8/EtQ8
lpo8gIfU6RHjWPze56x9du6lOezrDnbWD9SzSYOwRq7VE75si8d6JAnC3C4g
99w96t61jmV+Z7iH3MN+ByTC9ia1da39jlrHXh5j67jWiWH9ImdjvTXs+Ry6
jreVXDcS6zg9cJf6ObfEQfibXYzPGOz8rkpKTPdWcj2fCsLe8fPJIOyhK/RK
cvTisEsRhLLrnItjOlZKavKYfSdGz/pPE8PPZMTw/AK5H6OmtrFtKvw5V387
UnAuqVi/QX9a7nV/2+zbT3/rkhHrGZFapBHP8nxOpGWelnl6kY5nRpGBub/J
/jZnZC2TyCyyiiyMs4nsyPx8XuRgblvf0bLh17n4Duq7o3Mphs8XRfHg/3eo
5/GVEf+ZySmPyCVyitw8Pc8n8ooCoqAoLAqJIsg8LsqeMhA3HxQjtu1fEPmJ
k5u8MrHXEuzJe3sJWRbGBVl3LX3ndd3SEyszPoolqHkuYuTnjJ5lXlaUFnXE
GyKK8euigSgnyqBj3TaR8I5XXuMqQfj03He9UkFISVFBVBSV0CnFPN7G8sr4
9t3Rd8OXg/Dp70j1IJxXwF854lvmtWqiahDG9R2yZILYnvsuaRs/7b8MPioT
u4Z4hWclcns1gew1ztS94H5yn2RHXgPdWjxritrMK5JzTdbqULuq1LQm62Wp
d1X2Upf1XJxXOnqlNjbWrcezDudUDxvb1ue8SlPTl/Ed37MNRSN0rDtEDBJN
WWssmosmQdiTudFvxLr13hQt0GnE3D3sXm6GD/eke9O/gZasuafboNOGeQnW
42XtRTvRW/QS74o+orVoJd4Sb6PXBtu2ooPoKDqJd0RncnRuXdiT/XZFpxPj
buh3x8a6PXh2xG8P/DRF1oWY/o33JMfG7KFdgljt2UNX8iyATVvk7Rm/i9+m
2Mbn1os6OMexoq8YKD7kLHJS98as9eMsrTM0CHvUvfgBcp/1YNYLs269Qui5
x4aj/z5rHg9D7nX32gAxApnH/cV71KI152O9KHIaAP3Isz+6rkVRbPqh34Bc
W5GDY49kz6PFKDEmCPugFWsf85woJjAfRo4TWSuKv1bEG09NPxLj0BtBbuPZ
93Bkw/A7kbVxnFlP9t2HGg4lRlH8jiXvMfjti8w+/B3y+9rv7TScyWD2aJtP
xKdiqpgC08ScILzjz0RnCnPrTUdnCrZzxeesTULfdjOC8I7qu+o8dJaKNWKx
+CYIv/G+i36h8ZdBOPad2D7jZX5OFrPwMY8cpiKbTNzP0J1LXpZ/LeaLr8QC
sYrxcrGMp3NawnwF42ixMgjvxL5Dzk/g6zZ3ydXEnMRe1wbhHdZ3pkXs0Xi8
kP3uEHvZl3N/xF3WNVkNa8hpOWOv2+9icluKr2j2Mh876/8otpOX8/FvcZ3Y
xLlvYv6t2Mx4vdiIbIvYyl5dr++wse73rPnfWK6Ldepjv45Y1fCxIQi/E/62
Wt921dH12jZiVsfnFmzjc3Tc0ehuIRfb/EANvcedYo/YxXg3z+3UYTe94H5y
H36O7kL87OQsfOd0H/pM9hPbez0g9qGzA5vtjGdR47rkuJ5a+Kx9/imxXYhs
H/aj8e84fsekJP5edA6KmCD8/5WfgrCH3cv+TU1CflgcZf0o82PiZ54nxHHm
K6nRCdZc81+I4fM+JU77TMVJESv+QH5OnBW/i9/EGexsf4Rc/hGXRZz4Gz+n
sTuDj1P4/pO6nhd/UV/bXRQXsPdd0/dP35t8NyqIzGN/S3xv9v25TSS82+VA
VgWbzdTwfIJYB6nVJfYcg2xzghpeZt21XEHdjiE/Si3jeB4n5zhsLlOHK9Rl
BX4Osc/z6F3hHHwe7s0b+DrB+DZy9+41ZDfFVc7lHLJryKzv94B7zH0dzdn4
HbeMXKJZ28OetrFuvY3s4zi+bmG3hD0cIY7jXSeHa+S3Fpn/b8V/b/LfjPy3
I/9OvyKGY/lvRHfFv+IeeOyeco+41x4EYc+cwucd5LHIH2B3lrWHyKxzgT04
9//Yx1Xqdgs8fsS6856Bn+vIb1LbP/H7kLzvoTsTmW38DZzDnqzzP26Rodo=

         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0DtLggEYBeCvBmvrMmiNtugWTU1FDf2BhghEBCEkvEH1EyJEbCwbIqko
WmuWsDnduyA5FNFQttVS9HzQ8MCBFw6HN54tL5cGgiBIMUiYp4izSpo8ZUYd
R0iSYIUU6xQJi9bIUWCDTbbIkKbGLlUq7LDNLW1e+OCdN1754Zdn7nmkyxM9
vvjmkD32adC3+ZMheZgjuc4Bx5xwyjlnXHDHAze0uKbJJVd0WGKBeRaZZoZZ
5ogSY4IxxomEO5j8//Mf/1Qvew==
       "]]}},
    VertexNormals->CompressedData["
1:eJztyLENQEAUANCPSUxyjQmMQNQWEFtIbhQjiDkUhpCL0gS698rXDnM/1RFR
qogmPvlZy7hcaT/K2W138t5777333nvvvffee++9995777333nvvvffee+/9
f/8CbV6jJg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJxl2nmI1WUUxvGZuePkKNZUVCREiC3/pdGiYTRXixawsgUyNDQ1kmxTgzRz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    "], {{
      {RGBColor[1, 1, 0], Opacity[0.5], EdgeForm[None], 
       GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxdmHd4ldUdx983DCFMgQQQDEOQDUkgEBmJhhVBkLBCgABGISAShLCCgAKK
LEWWCXWjpQ7cVjtVKA7U0mpFqbXUgQuqrVVcqPj9PudzH/P0j89zz/2d3z7n
vO89t13J/LFlSVEUXRlHUU19euzPGkKiqLaoI84QtURX0U6cK7qIZNEAvbqi
mUgRTUUT0VicKRqJhvitiV1d5M1FKvP21YKYtcnBNvVFPXSse5ZoKVoRoyHf
zxadREdxDnk63zTRGpnnOoj24kKRLfqJwdToWjuLNsStQa5toRZzadCGuK3R
q41OW2LXZ5zQ7UyOtskQvelZnugp0kUv0Z2a6+OnK7lmiUxyzhXnixwxSAwQ
A0V/cR56fYiRge9cdBMxrHeB6IbvvthkojMAnYSufSdhk0rew1iTPGpphiyF
2EOjsCd6UGN34vUm1nB0+hA/H5n3zhDWJrFXMoiTSg8ykXnuuijsiXXiWuz6
MWf7NWKtWCGWi9HiYjFKXCSmicvETDFdjIzCHvQ6FERhTxeKiWICeDxejBNj
sbHuGOaKxCR0HGuKmEzMbvRxJLbj0Z2C7rhqds51qigWl4pL6Pkw5CUwlbkZ
+E6ihkRerqUrdU4iv7HkOwXZGHoxjLUsxm8Ra9gNG6/NiCico8HYFeDb9hXi
KrFMLInCmfPZmyNK0XMuXej5FaJMLBBXIvcZXiTKo3DGfG58jheKufi0r8vR
se58MY/PRdV0E7IyYi3Cf2t0FuK7PforxSpxjbhaLBZLkXmukH4Usdal1DZb
zKKOMnJbzWcpc/7uPbiCHlXQo2XEWIztfHKx7WTWyL31/vQe9173nvbe9rk+
FIUz67O7UWwSG8T14ldReF76jPis3CS2ii3iBnR3iO3YrBfbovBMboCOdW8U
m8VOcTM667HZydjxapKDx37mDySGZf1hY/Tzu6dS7BK7xZ3iNlGF/C6oZO4O
cXcU9qCfE/eKe6KwH4cw90uxB5nnbhG3il/gt4rxLvxuprY92N6OTRW53Eus
xvTyT+LX4hl69oh4QDwqHhb3i4fEg+I+8UfxO2See0w8Lp7Ej+f+IH5fze4J
dKy7V/wWP7b/Dd8tfwr2koNzeZr13ETvq/QguFlsFzvikPezrKHXbZ/Yj83T
1PQMcxvwu5fY96G3nz5sp+4HmDtADx5FZx/yB6nlADU/SQ6O433iveO9lozO
Y+g5xgviRfG8eI513cPYzyC/M14Tr0bhfWLdl8VL2Hj8Z3EQmdfa+/kVfO9B
9gI+D6LvfXcHNpb5HZWFjv1mE/95dLKQ/YW63ctD5Ob3bzo5HmLOa+Mzm4ON
5YOIc5DYfif+LQrv+1x8DcXPX6Pwfm3K2M+lJoz9vu2BLOHjNXq1n/U5QH9f
Jbee2Lov/6SP7smbrOk+8vS58fk5LF4X/4jCnvQ+fIu87yRmPuPd1GDZkSjs
04fxfRi7I/h7A59vVYtxBN2/I38KH0dYq7ejcFbvIs5udHNYaz/v3qE2f75L
ja9Qy63EPYzdm9Rq+6P4d5yXGf8rCs+J2/BzlLkXib2LvO3rPfTfRu9dZEex
PSY+FB+I98VHyDz+TPxbfCpOiOPilPgPep73c9hn+X/icz5Pii/5btv/YnMC
2Zf4/RrbZ8UX2LbA5+fMf0vM78Q34gdxWvwovkfmudp6ttQQteJgY3nNOOCx
55LEJxp/Rc3HyMv5fUxNcRxi2Ld/xJxA5xS5HKcOjx3rM3r1A7aNRGNRV5wR
B9+NGDtGsj7ri3qiDnjsnJxbQ+xt0wA/yejZx5miCTrWTRVNkaegU4c6HS+F
Oet6XazbDB8JX/7eQjQnD+dzlmhJrmeL1qJVHNbKz8+0OKxZGjmk8P0LYp5k
Pd9nb52mR1571/Upe6AeMVoR8yQ9sE5CtxF9tI1zaSvakFNjamhOr9qLDuIc
0S4O+8Sxh2o8SHREx3Nd0bN+F9FZ9BEZor84X3QTPUUPdDzORKcHtt3R64Is
Az+9mUsXvf5Ppzfx+opzyStL9BPZyPoi60iu58Xht55/zybm/LvPsizmOxGz
A3VmkO8AarKt76P98J9Dj9ybgejmMLaNdX13zCW37zl71sknz07Ecp5fs64+
JxfEgeOclcHgsc9lXhzu3S0469b9kPPpvTckDuf6O86Wz6PvynXQta8POMvW
HYbuKZ5NtjnN/vOc94CfAX4WDKfPvaijJ+uTzVwnahvO+nVHlk5OEba5+Mym
P+6V79t5zNVAPx1fnnMNg6k/j14koZ9P/zPJ6WOeC8d4PkWsQT7xR4nR4iIx
UhSIC8UYcbGYLC4VJWJSHH7D+94zFhuPfecpRzZBTBTjxTh8jsBnAbF8J7Af
29vGtr7nJPR8z/Fdakz8s84IfBWRk3MpJLdiMZUcC5m7RMyIw93Ed5Ui5jz2
/aUMX5fRg0Ttk/AzCx/T8T1FTGPseL57WzYTHwX0y/cgxywkfgk20/E5Ef2Z
9GhOHO7Gvjf7vjwjCnfh2ZKXxuE/It+ZfU++HF3fbSdg47Hvu02QzcZnMb3x
PWsdtnPjMPZdqiUyx5iNrvtqWQl5zKXueV4T6nfv1jJXhuwK6prAeBQ1WuZa
nPMc4hSTn2t1D/2fgvfDaOLMY4+MwldCZx65OK5zKyV+GTVMZj0XiIVx+H9w
PvvGe8t7yntrGTqeWxqHd8ESsTgO7wTfXXyXuda9835xzWK5qGB8tViEbAk+
l+JjOXN+J/pdWS5WiZVxeEdWoOO5VOTOwe+l1WINOp5LQ+Y5v+OS8bESeXNY
zVxdYju/a4jtOq6jDtfjd6/vZmvwv05cj451Xbvvc+v4bl33ZC25NSNGObkk
elTBvPe8z80GsT4O/zv4TMzg+ybWx2uwEZl1bxCb4/C/hW3W832L2CpuEjfG
4QxNR7aFWLMYb0DPc96L45BtwdYxHmJ9XZPvdVvxNw0b92EH63wVfaxkDcsZ
L2PdV8ES1nAlvfdddRu226izku+e8312J3M76cnGaroLiFFJLtvxu4K1qkLu
XH8C1XBtcw==
         "]]]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0L1KQgEYBuDjZWRBHFykNZf+wCFbj5RXIBROHgtMFEKLtCFP2FAERouF
XYKG3kZLQ9aV9AgNz/LxvXw/YTk+rKaCIIg4ocKWwgYhGbJskiPPNjvsskeB
A/ZZIc0qa6xTp0FMjTNueeCRJ27oMTP/gzlTJnzxyTNDXvjmlx8W3DMgoc8b
r4x4Z0yXa65o0eScOhe06Szz9ki4Y8ARJY6JKC7v0HfK5f/f/gAnCib9
       "]]}},
    VertexNormals->CompressedData["
1:eJxTTMoPSmViYGCYwcjAwAykM7PO7RfZ9taeAQo6dtul3T1y3X6gxLPRxNsJ
iA829w/XcBsNf/qE/2BP/50kipNqzkCH82BLV4Mlvkaq+FBJV/QuZ0hNV+Sm
w8GWTwdb/A628BkVHxUfFR/85Qyp5Qm16gVKzRmo8BxtLw0O8aHe/h+oeny4
thOGSrhRq7wdjceRmc6Hq/hgS/+j6WdUfFR88IuP5tNRcWLEaV2/DLZ0SOtx
4MHmX3qLD9b5lOGaboeqv+iVTgaqfzpY8uOoOG3ER1q9OdjCc7C5H5c4AAnd
SE8=
     "]]},
  Axes->True,
  ViewPoint->{100, 100, 100}]], "Output",
 CellChangeTimes->{3.5444590917688503`*^9, 
  3.5444649535762477`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Planes", "Section",
 CellChangeTimes->{{3.576500300339919*^9, 3.576500301570046*^9}}],

Cell[TextData[{
 "One way to describe a plane in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "3"], TraditionalForm]]],
 " is by specifying three different points.  For example, the plane that \
passes through the points ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], ")"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", ",", "2", ",", "1"}], ")"}], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"4", ",", "1", ",", "2"}], ")"}], TraditionalForm]]],
 ".  What are other ways to describe a plane in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "3"], TraditionalForm]]],
 "?  For each of these other ways of describing a plane, use it to describe \
the example plane."
}], "Text",
 CellChangeTimes->{3.5765003220876493`*^9}],

Cell[CellGroupData[{

Cell[TextData[{
 "All affine combinations of three vectors.  For example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "s", "-", "t"}], ")"}], 
        RowBox[{"\[LeftAngleBracket]", 
         RowBox[{"1", ",", "0", ",", 
          RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}]}], "+", 
       RowBox[{"s", 
        RowBox[{"\[LeftAngleBracket]", 
         RowBox[{"2", ",", "2", ",", "1"}], "\[RightAngleBracket]"}]}], "+", 
       RowBox[{"t", 
        RowBox[{"\[LeftAngleBracket]", 
         RowBox[{"4", ",", "1", ",", "2"}], "\[RightAngleBracket]"}]}]}], ":",
       "s"}], ",", 
     RowBox[{"t", "\[Element]", "\[DoubleStruckCapitalR]"}]}], "}"}], 
   TraditionalForm]]],
 "."
}], "Item",
 CellChangeTimes->{{3.5765003494638243`*^9, 3.576500350734342*^9}}],

Cell["\<\
A graph.  For example, see below where a polygon formed by three affine \
combinations of the three original points is used.\
\>", "Item",
 CellChangeTimes->{{3.5765003494638243`*^9, 3.576500357198807*^9}, {
  3.576500403099389*^9, 3.576500403101655*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], ";", 
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "5"}], "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "4"}], "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
       RowBox[{"-", "2"}], ",", "4"}], "]"}], ",", 
     RowBox[{"myPoint", "[", 
      RowBox[{"a", ",", "Black", ",", "\"\<a\>\""}], "]"}], ",", 
     RowBox[{"myPoint", "[", 
      RowBox[{"b", ",", "Black", ",", "\"\<b\>\""}], "]"}], ",", 
     RowBox[{"myPoint", "[", 
      RowBox[{"c", ",", "Black", ",", "\"\<c\>\""}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", 
        RowBox[{".5", ",", "Blue"}], "]"}], ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"17", "a"}], "-", 
           RowBox[{"8", "b"}], "-", 
           RowBox[{"8", "c"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], "a"}], "+", 
           RowBox[{"17", "b"}], "-", 
           RowBox[{"8", "c"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], "a"}], "-", 
           RowBox[{"8", "b"}], "+", 
           RowBox[{"17", "c"}]}]}], "}"}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5443610784474154`*^9, 3.5443611362401943`*^9}, {
   3.5443613949800653`*^9, 3.544361396563224*^9}, {3.5443614885004168`*^9, 
   3.544361605875153*^9}, {3.544361852158779*^9, 3.544361872019765*^9}, {
   3.544361953787941*^9, 3.5443620448600473`*^9}, {3.544362166049165*^9, 
   3.5443622084204016`*^9}, {3.5443640531058517`*^9, 
   3.5443640561951604`*^9}, {3.5443669177612886`*^9, 3.54436692477199*^9}, {
   3.544366955665078*^9, 3.544366961128625*^9}, {3.544377637197*^9, 
   3.544377638352*^9}, {3.5443950683415627`*^9, 3.544395068606578*^9}, {
   3.5444510717038016`*^9, 3.5444510845619917`*^9}, {3.5444511552365685`*^9, 
   3.544451159777071*^9}, {3.5444512108626204`*^9, 3.544451225139457*^9}, {
   3.5444512632266245`*^9, 3.5444512802350035`*^9}, 3.5444513909127927`*^9, 
   3.5444514533256063`*^9, {3.5444514921290236`*^9, 3.5444515050322914`*^9}, {
   3.5444527464003973`*^9, 3.5444528586124196`*^9}, 3.5444529007383595`*^9, {
   3.5444530878419423`*^9, 3.544453174793003*^9}, 3.5444532828548403`*^9, 
   3.5444551167465677`*^9, {3.5444551534857454`*^9, 3.544455162518446*^9}, {
   3.544455206434698*^9, 3.5444552674338255`*^9}, {3.5444553258276205`*^9, 
   3.5444553453754225`*^9}, {3.5444553855474825`*^9, 3.544455445828974*^9}, {
   3.5444554791059194`*^9, 3.544455514380233*^9}, {3.544455832568611*^9, 
   3.5444558498549623`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Text3DBox["\<\"x\"\>", {5.25, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {5, 0, 0}}], 
    {Dashing[{Small, Small}], Line3DBox[{{-1, 0, 0}, {0, 0, 0}}]}, 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], 
     Text3DBox["\<\"y\"\>", {0., 4.2, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 4, 0}}], 
      {Dashing[{Small, Small}], Line3DBox[{{0, -1, 0}, {0, 0, 0}}]}, 
      {RGBColor[0, 1, 0], Dashing[{}], Text3DBox["\<\"z\"\>", {0., 0., 4.2}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 4}}], 
        {Dashing[{Small, Small}], Line3DBox[{{0, 0, -2}, {0, 0, 0}}]}, 
        {GrayLevel[0], Dashing[{Small, Small}], 
         Line3DBox[{{1, 0, 0}, {1, 0, 0}, {1, 0, -1}}], 
         {PointSize[Medium], Point3DBox[{1, 0, -1}], 
          {Dashing[{}], Text3DBox["\<\"a\"\>", {1.1, 0., -1.1}]}, 
          {GrayLevel[0], Dashing[{Small, Small}], 
           Line3DBox[{{2, 0, 0}, {2, 2, 0}, {2, 2, 1}}], 
           {PointSize[Medium], Point3DBox[{2, 2, 1}], 
            {Dashing[{}], Text3DBox["\<\"b\"\>", {2.2, 2.2, 1.1}]}, 
            {GrayLevel[0], Dashing[{Small, Small}], 
             Line3DBox[{{4, 0, 0}, {4, 1, 0}, {4, 1, 2}}], 
             {PointSize[Medium], Point3DBox[{4, 1, 2}], 
              {Dashing[{}], Text3DBox["\<\"c\"\>", {4.4, 1.1, 2.2}], 
               {RGBColor[0, 0, 1], Opacity[0.5], 
                Polygon3DBox[{{-31, -24, -41}, {-6, 26, 9}, {44, 1, 
                 34}}]}}}}}}}}}}}}}},
  Axes->True,
  PlotRange->{{-1, 6}, {-1, 5}, {-2, 5}},
  ViewPoint->{100, 100, 100}]], "Output",
 CellChangeTimes->{3.576500425975173*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Specify a point and two directions.  For example, the plane that contains \
the heads of all vectors with base point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], ")"}], TraditionalForm]]],
 " and components that are linear combinations of the directions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"1", ",", "2", ",", "2"}], "\[RightAngleBracket]"}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"3", ",", "1", ",", "3"}], "\[RightAngleBracket]"}], 
   TraditionalForm]]],
 ".  "
}], "Item",
 CellChangeTimes->{{3.5765003494638243`*^9, 3.576500357198807*^9}, 
   3.576500403099389*^9, {3.576500440799176*^9, 3.576500442357501*^9}}],

Cell[TextData[{
 "A parametric equation using a point and two directions.  For example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"1", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "\[RightAngleBracket]"}], "+", 
       RowBox[{"s", 
        RowBox[{"\[LeftAngleBracket]", 
         RowBox[{"1", ",", "2", ",", "2"}], "\[RightAngleBracket]"}]}], "+", 
       RowBox[{"t", 
        RowBox[{"\[LeftAngleBracket]", 
         RowBox[{"3", ",", "1", ",", "2"}], "\[RightAngleBracket]"}]}]}], ":",
       "s"}], ",", 
     RowBox[{"t", "\[Element]", "\[DoubleStruckCapitalR]"}]}], "}"}], 
   TraditionalForm]]],
 "."
}], "Item",
 CellChangeTimes->{{3.5765003494638243`*^9, 3.576500357198807*^9}, 
   3.576500403099389*^9, {3.576500440799176*^9, 3.5765004524603233`*^9}}],

Cell[TextData[{
 "A linear equation.  For example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", ",", "y", ",", "z"}], ")"}], ":", 
       RowBox[{
        RowBox[{"4", "x"}], "+", 
        RowBox[{"3", "y"}], "-", 
        RowBox[{"5", "z"}]}]}], "=", "9"}], "}"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", ",", "y", ",", "z"}], ")"}], ":", 
       RowBox[{
        RowBox[{"4", 
         RowBox[{"(", 
          RowBox[{"x", "-", "2"}], ")"}]}], "+", 
        RowBox[{"3", 
         RowBox[{"(", 
          RowBox[{"y", "-", "2"}], ")"}]}], "-", 
        RowBox[{"5", 
         RowBox[{"(", 
          RowBox[{"z", "-", "1"}], ")"}]}]}]}], "=", "0"}], "}"}]}], 
   TraditionalForm]]],
 ".  ",
 "\[LineSeparator]\[LineSeparator]We want to find an equantion ax+by+cz=d. We \
want the points (1,0,-1), (2,2,1) and (4,1,2) to be on the line. \
\[LineSeparator]\[LineSeparator]The equation coefficients, a,b,c,d, were \
found by solving the following equations and then choosing a nice value for ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]]],
 "."
}], "Item",
 CellChangeTimes->{{3.5765003494638243`*^9, 3.576500357198807*^9}, 
   3.576500403099389*^9, {3.576500440799176*^9, 3.5765004598145523`*^9}, {
   3.576500848126595*^9, 3.576500988763061*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "-", "c"}], "\[Equal]", "d"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "a"}], "+", 
       RowBox[{"2", "b"}], "+", "c"}], "\[Equal]", "d"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"4", "a"}], "+", "b", "+", 
       RowBox[{"2", "c"}]}], "\[Equal]", "d"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], "\n", 
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     FractionBox[
      RowBox[{"4", " ", "d"}], "9"]}], ",", 
    RowBox[{"b", "\[Rule]", 
     FractionBox["d", "3"]}], ",", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"5", " ", "d"}], "9"]}]}]}], "}"}], "}"}]}], "Input",
 CellChangeTimes->{3.57650099999149*^9}],

Cell[CellGroupData[{

Cell[TextData[{
 "A point and a normal vector.  For example, the plane that passes through \
the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"1", ",", "2", ",", "2"}], ")"}], TraditionalForm]]],
 " and is perpendicular to the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", 
    RowBox[{"4", ",", "3", ",", 
     RowBox[{"-", "5"}]}], "\[RightAngleBracket]"}], TraditionalForm]]],
 ".  Note that any point on the plane could be used."
}], "Item",
 CellChangeTimes->{{3.5765003494638243`*^9, 3.576500357198807*^9}, 
   3.576500403099389*^9, {3.576500440799176*^9, 3.5765004598145523`*^9}, {
   3.576500848126595*^9, 3.576501014244845*^9}}],

Cell[TextData[{
 "A linear equation.  For example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y", ",", "z"}], ")"}], ":", 
      RowBox[{
       RowBox[{"4", "x"}], "+", 
       RowBox[{"3", "y"}], "-", 
       RowBox[{"5", "z"}]}]}], "=", "9"}], "}"}], TraditionalForm]]],
 "."
}], "Item",
 CellChangeTimes->{{3.5765003494638243`*^9, 3.576500357198807*^9}, 
   3.576500403099389*^9, {3.576500440799176*^9, 3.5765004598145523`*^9}, {
   3.576500848126595*^9, 3.576501022372213*^9}}],

Cell["\<\
A graph.  For example see below where a contour plot is used.\
\>", "Item",
 CellChangeTimes->{{3.5765003494638243`*^9, 3.576500357198807*^9}, 
   3.576500403099389*^9, {3.576500440799176*^9, 3.5765004598145523`*^9}, {
   3.576500848126595*^9, 3.57650102236945*^9}, 3.576501063053423*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], ";", 
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p0", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"myAxis", "[", 
        RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
         RowBox[{"-", "1"}], ",", "5"}], "]"}], ",", 
       RowBox[{"myAxis", "[", 
        RowBox[{"\"\<y\>\"", ",", 
         RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
         RowBox[{"-", "1"}], ",", "4"}], "]"}], ",", 
       RowBox[{"myAxis", "[", 
        RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
         RowBox[{"-", "2"}], ",", "4"}], "]"}], ",", 
       RowBox[{"myPoint", "[", 
        RowBox[{"a", ",", "Black", ",", "\"\<a\>\""}], "]"}], ",", 
       RowBox[{"myPoint", "[", 
        RowBox[{"b", ",", "Black", ",", "\"\<b\>\""}], "]"}], ",", 
       RowBox[{"myPoint", "[", 
        RowBox[{"c", ",", "Black", ",", "\"\<c\>\""}], "]"}]}], "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}], ";", 
  RowBox[{"p1", "=", 
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"4", "x"}], "+", 
       RowBox[{"3", "y"}], "-", 
       RowBox[{"5", "z"}]}], "\[Equal]", "9"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", 
        RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p0", ",", "p1"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.5444599548589754`*^9, {3.544459984999914*^9, 3.5444600404621143`*^9}, {
   3.5444601361216335`*^9, 3.544460203330311*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0.5, 0], Text3DBox[
     FormBox["\<\"x\"\>", StandardForm], {5.25, 0., 0.}], 
    {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {5, 0, 0}}], 
     {Dashing[{Small, Small}], Line3DBox[{{-1, 0, 0}, {0, 0, 0}}]}, 
     {RGBColor[
       NCache[
        Rational[2, 3], 0.6666666666666666], 
       NCache[
        Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], Text3DBox[
       FormBox["\<\"y\"\>", StandardForm], {0., 4.2, 0.}], 
      {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 4, 0}}], 
       {Dashing[{Small, Small}], Line3DBox[{{0, -1, 0}, {0, 0, 0}}]}, 
       {RGBColor[0, 1, 0], Dashing[{}], Text3DBox[
         FormBox["\<\"z\"\>", StandardForm], {0., 0., 4.2}], 
        {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 4}}], 
         {Dashing[{Small, Small}], Line3DBox[{{0, 0, -2}, {0, 0, 0}}]}, 
         {GrayLevel[0], Dashing[{Small, Small}], 
          Line3DBox[{{1, 0, 0}, {1, 0, 0}, {1, 0, -1}}], 
          {PointSize[Medium], Point3DBox[{1, 0, -1}], 
           {Dashing[{}], Text3DBox[
             FormBox["\<\"a\"\>", StandardForm], {1.1, 0., -1.1}]}, 
           {GrayLevel[0], Dashing[{Small, Small}], 
            Line3DBox[{{2, 0, 0}, {2, 2, 0}, {2, 2, 1}}], 
            {PointSize[Medium], Point3DBox[{2, 2, 1}], 
             {Dashing[{}], Text3DBox[
               FormBox["\<\"b\"\>", StandardForm], {2.2, 2.2, 1.1}]}, 
             {GrayLevel[0], Dashing[{Small, Small}], 
              Line3DBox[{{4, 0, 0}, {4, 1, 0}, {4, 1, 2}}], 
              {PointSize[Medium], Point3DBox[{4, 1, 2}], 
               {Dashing[{}], Text3DBox[
                 FormBox["\<\"c\"\>", StandardForm], {4.4, 1.1, 
                 2.2}]}}}}}}}}}}}}}, GraphicsComplex3DBox[CompressedData["
1:eJxlm3k0Vesbxw/HdBIOx5TSgDRc13WjFGnv5oFKk9wokUJz3G5pFF2pVCpJ
iTQPGqWROqfcDHWVUopMmWUMZcjwu2v9+j57re0f1vqs7/q+z/u807Pfvc8g
j3Vzl8sLBIKl//0R/vc//h/G2LRMj/U8XtWnu7teWtEnrftvoZB1PmVoXv5c
l11exX6ZqlRKXF7Zbu70SbqkL9R5MkXmIyAO/eT4ieenj5Znt7zY6+FzTJu4
86Hvv7UodDNhVueunD+tww71rf3YKsok/5pfft1WFqRNfLCe1v0uWznisly3
9JFLSsgH7T6T+kd6u+T3iBM+12ely2UpKbDZjXELryToUPzwgT/4jSS11g92
P4gj/m3f9O98ye1irHrvSvAM0GYbHkbt21wsZdBubskSqYm7hO0327b/yB+F
DL9f0O+/c1w7pBfHoW+abeirmaPAPrjbuO/MYR3ixjXhXmG7lahf4P573iWV
nVMmvjnxW13UsDc99GhXUj3LzfW9IrtWyXrjoEw9yg/0WgXaAZ9vcXpwqdi3
oLub01sGBzhcesNx6KOMlK5axKoQR94yqtrrDIWKxOVfWMYsb8+S8v2Rf6+Z
Gw+HW3H5KdKVvl1mxOX5VOu3iBpPLfIv+uK6tFi+lXkXtlUrbpwmxUnc0fDi
rmROvzb4quGEyW3EobeR3v04v7iDeOz7wCn31SvJJ95Do2DIOgnpMX9aB+qH
mu2WUPzQf9p97f30NDXW6uThQfECAYv4p4/80eT3tzrx6xVrC+6e57j9OPlj
Zp2d1N+0la2FnkIxO77fuN1PBO0M3wd8qn1VgFm2HJu0US3TUKhJ/HVg7EvB
GQXiaHfkANNh+9YpET8wLenksFPN5I88YHwTp42Pvfm7gPhSwbI/YoNPUB7A
ad6WpXSOFsizzja1lRWzOR/o0S64t5F23L2MduKh9g+6cxqfUz47NF82XbLQ
JH++D/golwEr0ld2MQWjJqyOCdJh+yj88Vxf0My4PXF/fVKxF82rgg8Vvcu7
qhnNh8KLESe49QL+2XiRwTpfEenhs2nBXuFAbxXSqxWHJ1wVNvTwt0lXqsly
qqZ1ZOPm6V5wlvOHPnxPsFP/Z3oUP7j88huxg+ZJqF347FYfuGmJpzaNL/TI
P/jCRwt1369SJv7j+cw/VjZ/Jx/EuWpioV6cQ1sPH7Rbb/j2gX20Iju0vHNX
/8kSmj98Pfhjp3y/JTYiNkkl27pvgh75RIWZW18IVqP1Dv66JeLZv6rqxLe7
mfpVuzT20CNvPi6ayyfa9ab8w2eqrHBTK6vKKj04PDNqow7FAx/0F/nJ/6ru
fmVUL/IBXz4sJW67HKeHz+SD4U9GKHLtfpKtz64+/6NHnBhHOel+5Udrufws
elWydu7FclpfOxLHvigdr0X9Ajc5avD+vJEm9Qsc8xx6uRnHxHVCbr1D71Vu
sHbTW3lqF/q9uxxcnr0SUpyjb9tWxezLpXGHz7Ys2dfMb59pfV0cGxr32ZKb
V5g/M7RX3jujze0n4K4HMo+5+3LrC3xuhWjs2l/FtA97T0kOyxB8pfULvkRv
bMiJm00M9jfst/u2nFz04ySnBz9ZpdJwzqKF9MF9jdrXLXpH/uB0jgf1Z978
qGbqt78+4NqP84d+zK/7z+Xlq3L7Es+H9rE7F3TUR39j+uz8NPWagir5tOo6
77vQq5I49OEhawUvJ9UzVcNriorbVCme0onzAjd0lpB+kqZ3s29iPnH0NyDz
QvJoaU2PftG5o6mSHve0lPTgYQUWGcFaDcy/++Vf5y1VpnGBT1VaYlRpEMez
pxQuLZ7Ccexj0KeOHmC0bJwizXPECT24uN9l+9PzqplHWqfq+wkVuHaLPRs8
hlcQx7qAj47tk1JXI0Waz/w4wbX6XEurSW0mH3CF+VtXhHjWMXYBax2dBOoU
D84R5Blcd/sE281ME3HUUfw8Y73AB+3CJ/bzqeYtRYXMFu8/DFcNENO4Q795
VICbzyJFmieZ1TtDB5Slkg+4LK5suiUbRxznLPSWuZe+eySKSI+8bd+7rHfJ
NmVqFxw+4LcifRbMyXtD+YTPrQ3fn1x+kkMcdRd8Hjs9nLu6TETzCvGY7/ln
elWkMs1ncPhAL7tg8NJ79hUpOPQCw6MXEsNTSI86Hz4YF+hdL4zXDsgsIg7/
AC+nsXfNshj/9qKq5VO4dYH4d+VNeeh6WkTjxZ9XyM+fVw+/9+9Tyuz5bfiK
7KeqNG8xjpgP8DGtuZU58D3HoW82Sdpv6dvBDPi8e5yjl4j2SeyriB88f5v+
yvyXAhYc5wv0+wPVJI6lajTPwdEu+Ocby4zPKQuoPjR8OTyvcmIjw28X+vg6
59vR/u3EUc+gvwYHzxzOnqRM+z+4p93iS05KihQ/OPIJfcGc+0HdnhyH/tq+
Z+O05DuIow7hr1P41MkG97nc3sm8KSjb6hQkovihf/97+tDMC5we/Y2tutzl
pSmmcQHHuoA+s3handPrRuKI81Tf+Vd8Vn+neOBTenfm931530mP+grzymD2
btnNedw+DI5zGTx25mmP3y5/Y0K63xbkiLXY9eOqpFflRFS3QA/+9Ze1oe0X
1Il37Bec3DREmfTY/13j/ypaKKfECp1/Lz3Vm6tDwPcfqjTf8KE36eE/6Kme
vlGGKvHgFy6nO+V6s3sWR2+Mi+LiAQ+ZMbyIsRSTPi/YWK/tgyrFc/XQOmcX
J212mqmCnKKcsEc9Bh433KBfUhbHZ7m4eLcEyvfIA/TGTR5vKlRUiUec0hJ9
cJKjutTRa+ayvtYS6i+/XXDN1NP+k89qUF2Hcc94bi9SzlQnjnYNbntbTpst
Zkv3Du6jf1GP9Ctvb3/9IUjMhrgLTT4Gc3pw8zGfzSO9dKhdcPgrGZxP1bvJ
6Ve8WXHVabw2jQs44k+YMb3t+DwV4r2uTLqrayShceHr4ZN0+8gqrwcch75h
5wKDa6c12fnOgpcRJWJ24YaBN+fIaZLPV7ekuOshGqz7/Zz+W3dpEcc+A33G
kq9lVWvUiUN/cnvimTH9xax1Urh2whBV4hgXW43NT3+d8d/4jLAr6e6WkD/W
HfhLs4tmJiM0iI/M+eaxPYLzQbuHR588csBM0iNO+Lyy3+G4Q1GT5i3iH24/
X9/tFDefbWJT/Wfmisnn3GLDqjvnNdiTTq92OMpr9Fh34PVtRllWKzWo3QLW
eIbdJDHpET/ycD1Z2hqzQY2t7Z3TZblCjeLh68EnD7GJ0jmnyr56/Cm0YDC3
Lvj1PHh0YlywZJwK8UkZ920W/lAk/bac2deOvhdTfkIMPIWLJ2mRHnEu6aOX
ei6Iy1vt8XHPop/11Bfkp1+5N5x7LgCH/5GKnI2VK7XYbDnfM1nNnD98sK7B
je761qhVcXyHwXXh4pWaPfTIT135Tbt0OY6jXaegkVFzMyVs6Nx7++dZatN4
wQfrAtxkln56QzDHHRTuvh9jod6jXegf6dce3G2gSTx88uq/+iio0fwZMTw8
QqItoTj57YLHB6ous/SSsCkOqx3EQXq0Tv///PbfvDaZsTBzmS61C479BPqE
vrcZXUWOQ19e5Ve3qEbCijuGeIRN0qF2+T4KyZ1Wi1w5f8SZ4z/Hco1Ai3hC
luIax8HaNF7glVs+Bhydq8OdFz/76xxXskmsJKFx4beLfdJh5y/FoaM0iWMf
C5hZF/bGUIv4atER5wc7ReTfS3Vju3akHvmA4/kXXNx3j3JLFMeffKwxHf1J
oYce+/zVHXJX12SIiWN9FTj84xyfoMneCjCSZctz8wHjPulc+8asDVz8fH/w
SVXT79kGSYibpOXe/xjXi/JTskLrAjtIRPnE+sL+AO5fZ14kr6RCHPmBHnUX
2t1v0Gh9YbWQ9OCac68E+ltzevh/vbfpmLmtImts5V2dvleV8oD7CviAT+4T
k7ripDxxnHfQF0h+a03pUqJ2wdEuzjvwY55+xVPsRDSOfD248Y7VuX1j5Khd
8Li7xoMbvP977kr+ojZVpkD9gk/hh0OByV80uHrjZ96UnNxVorvF5IP9E/s8
uGVt7rp/LJWJY17BBxz+Lx0XaNkuV2Rnq0T5szFqXPw/9SfuOx2SuXHjwvcB
P7F3acZMeRGLuhR1EepkzCvcM2N++oSx8zOHKlM8qJORT/AtyRltJqc5jjqN
X1dT/TPfzXObqJ3xKLoz4VM4d8/GvzcDHxneb6BTrgabI7O3n5mnQHng+4OP
PrBywKGLncRRD/P1yI+wxKY284yA8oNx99kpm7FovTz7u89tLxtFEe2HGF/M
H+yH4FUPv815NFGV1jtfD164L8Eu9J2I3aq/ZvujFCXaJ6F/njr0qE2IAu2H
5P8zz9DnO/vsTonkOPQTv9V9nu3Vmzj2Z/igv/BZMCh+TGOGMnH4JD62Pr71
lIjd9HxvJntegfLA3zfovKgPdBz/UYV8cC5Df7qXzVibQDXKM+Ix+3Cr6sRX
MXF+/QYuZ1o+/EMmt76QT69nq0KWnu7N7lrlONyqSoXih88Clx2mj2QaNO78
dYp9lZ9n+C+c19l4X6RMHOc++oX+Ig/1u83yvLsV2V91Xz2SFSuRD18Pvqfy
4o5CCwXiqBOw/4QxhttlnfUMnnObo0w3J+tkShsr/uxo7a5g8BwqjlBP/BxY
JnUu8s/eL9dEvHTdsoGDbr4jPXwsSqqyT8jlk945aoSt44d68h8e5fiwZlQD
g/uNyogpLqoa5aQHDx02Tene4c/kvyVW48kr02rSW43XkxRtbaZ44B9bfLqi
sLWVfMCfldlurOorpHsY3P+oHmvZ55MvoPsW8P2u2yYuCBSQ3rHFdGT6lTtS
cOhlM1LsbkuSGcQJflV58O/Kj2ukadNO7Ll0oJ7B+Q5/6LEvNXT7v482yKA8
gIuv16yr8pWRHj4CWb+wLuEfpMd9DvzBMS63RuRmOlc/oHziPgT5GVeRvzpL
1kp6+GROXhCZNbGZ4uH7I57Np4ctjLHLZu45PDTvK2wnn7Dfggb92zeTOO6L
4AOOvD349fqaoyfSpeAY34Dnngskm08yUzVWmvgby9H9BuYDxgU8csWq4sjq
CuK434Z+/c4vo2qudzK49+P7gHc1z1/td7uI4sF95nnzyNSbuaWkB+995q8x
j5dkkR7vC+DvV3Iqvt5aSP7I/+Mjzmnr2jgfcKxf9KtZbLjuUEAOcbxHhh7t
Qu9idF5p4/6vxNHuuNgbdu+1a6QRY3MO1NxpZjDPESf04NpbhOe0x3+i+YZ7
bL4e99iIR3330KTCjZ3kA4684T0sv7+IM8ClSHGvforU9qxOvJ5FnRTnfk39
2O0nRY3Sb3+HNXX910/wEV/Daj9+4nj2bNNtuuc4vYebgkh/VJkU85bvA74m
efGCEtfv0qFOIV0WF8ukqAfQ3ylnlXWWiYqpXSPrNJHj/C/kA33aetXlodvr
SB+qvu7TqNcKPXzQ7pL59VKb1Aap2xf/9rwSeapbcL+36HjEzGVPBXQ/iftn
5BP6gIqE265+X4jj/Tv0l0+MFC++IKDnDvhDD37wWpnkaXYDI3fixCWL2Dop
zjt+/Ojv1SPmNrZzS4hD32+CRcgvFh8pP+Bm3c11KyZWSOscejdP1y2X4lzG
fIAe/MiBgs3jRUXE8dzBjwfnL3xOmdZd9XDOofGC3sTU+IhmHxnlP+aF3AKT
ZRzHPQP0lf0u7Rm+V0b9hT/08FeJz37cOaeAOO5DoL8asmJ8ll0n7W/8cwc8
UkW837jrA3G8P+XraT5sjLG1HlNC+yrmQ5rWLTW9sAImt7pvY0pIK+3bmA/Q
o27nc+g7ttR1WASWM9MOnE9JUewkf+jFlbnWJd3y3D32T/5k/qLCsiEfpODL
wrMdbqq2cXn+yR8cOuvyQuU7jSP61fZccdRSuVbSg39xOh57f1Uj6XG+wB8c
/ild4q++MT+ko9c8iWw8UEo+0Gvdej2+cU+tFP3i+4CbHWjfMtOzmeYhfFRG
/vlS5XgncehtOrzF39vapA4P7R1y9GopnvYJaf7d3d2kR70Ejv5i3Pnx4NwM
t+537W9bTg/+d9p13fwLbdIZEzxe6Kl8pHiw70FPcY7Vfzk9upb8MR/4euwn
4BZjC61Ovk6gdhHn6CPP72RIU2meQ+/dv+Z4QlsWnfuljQJzs+Ym4nhvy9+f
UefA33Wsmp5+QgGdy+DwwTkyM9rIzfNlF9U/dA6aJ6QnjuT08NnpqXd+jvkP
0gcKF7bYHCwh/9JhOvIzwgvpnMV4QQ+u6iXd/eptB/l7dPn/mTSukvSCYGnI
21m3pWgX3HHN+72/B6TTuclfL+Bz5R6+qZ/QSRznKXzQLt7zwgdxot313y6r
X4n8Jh3hNbf5ztRs8oeP718253IMS2l8wTFPcO5Tu9PK3I6xLynP4OwXibSx
pIL6hfFFPOBnk6LnRfz4Shzvi6HPnKVoVp6VT/OHP6/gE/9L76pxh1uk7dZR
Km3VzRQP9KhnwM2lk60ksU3E8b0E9CtyjPNbvdtofPk+4B0tjvWD7VqkoRFa
Vm1rGyjPfD24e7CNv0DYIG04/O6G4qUG8sF4KX0+nqA6v5LiBFcocPeosWgj
H/7zFPIwNGrJtk8vK6Vbmg6l5/hxz3fQT3LvZBOa8qhuB0c+ob880CplkF8D
cejvvZ6j2/9alXRpY1eRu+MD2g/R34QO1XcyIfe8g3Pwgd+3BYGSPDpfwOEP
fb8ltrGtG4qJ03NQzvT5F9dlE8d7UsQ/8P7dfJ/u5+QDHna5/4FhbxLp3AfX
9rE3c1SsY/DcjXstzENwvFcFx30I9N8X3PhyaWcTg+dxcIwLeHGQvN3z2Bbi
uP+B3sbUJshRtYzBvQq4LGVOwhmjjwzuJfhxQp83YPWLMcPaiEN/1XnT3w4p
HUyu2+tBPhvrGNRXqAMRD7i2fcuueGEz+SD+t9rhl/qpNhLHPQZ8wOGj8kAz
R5JXw3i2jJJe6mghjvjXDEj+a6abgO5n6PuEn3UO+Ihh764Jf+M43gtDnxkp
PXrJv4NBnQl/6ME9G9K+Nhz+QXUO/E0eLddzOdFGHPUkfIzXK7tnRMuTDz9O
1IdD+3fsLRe3Mv0NTRLmbeU4Px7Uh+DXa/QfZ6fK0z0neEpj65gEq1YGPvRc
MGf98oT7TdRfcMRP7ymmzT4z0q2ROPROuxa5Tuv4RuNO9W38Uz2Do1XEoZ+i
VZNyekUDcdThaDfWaZ5eYFkd+aAOxHwAv3wlPefw6zziuIfn1594buLPK8Sz
fsoPj7ozZZRP5M21rOFVll8zV1f/rOfhMyJ8l3rC7Q4Gen7ewCNrFPyckmqZ
xEEeY6ZOFNC9HO7Tep21jTko6qB1Bw4f6PG7BnDo8bsGX9+Lxqm75OkeDz6I
Hz74jh3cKFHlncM7cQ89/PGdPNrF+2u+Hu1236q3VF0hx8rfOZzou1uRu3/4
uT/L/pxcLlsuT/64h4QP9hl8zw+O97nQ9zKR62CHcHpwxAmO31lgviEP+D0F
OOLB7ykEHX9OivqnhfRYp/BPcfE8P3acmPgs39RR1sdqqV1w+IPj9yPg+E6A
7498NjSuf7tmVCezOrpTP2p8B3HowxfVrIuaysUPHiO4k34wtIXaxXilSCas
Dawuo/mP9fLxjPs+xZIc2sfAcT5CH5s5dr1N7Tvi0NfkWN14dusz43nIZ6N1
ci6tUzxvQo/3IOBLJQenrI95Sv7gqEvBZQ9fLdwREUH1KvZtvj/ajb3LiJ+U
PCQfxHnr0Wq/oJHpjKD13uKD058Rh0+CXFdAiv4nKfLMj4fey7MlF3prfGJQ
x5LPY6XRTzclU30LPat5kb3yOZ7Rz0qxbBT9I8W8Qp6hB8d3g+CYb/x4sH7h
k3rIMHq6uJ7a5d+H0LyyDlMcHfOG+LvWnVXOjpz+zsSwKo/gcooH7UIPju8n
EQ/lP3reueWJr6m+wvs++A/V/n4sfHQujS/45rrofu+WJNP+CR7aK2VZlEs5
cf64g1t88ItdUyul+p/OwdAxnw7c+5f2f7wfhM/6R3lWc2yTaB1hP4c/+L+3
Oq0OH22i/GN94Ttw6MHxHTj02MfgD077z8/vwB0S/jidJZ9D+w8/HrzP4nPo
BQ2lTR019YzA8Mlmn61ltG/w9TSf7e1NKr9UUjxUx/78fhv7Fe5F6TtwhxFF
svomyjM49PTednzcmWbnYoatV1zd2vqJ+suf/+D4nhYc5w70/jbahVu/l1P+
+T7g+O79QPCZIx4B9eTPn8/g+O4XHD74Dhkc+zZ8Ytd3FOknSSmf/P0T79HA
LW5ki5xePCd/jMv/AFYZyC8=
    "], {{
      {RGBColor[1, 0, 0], Opacity[0.5], EdgeForm[None], 
       GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxN1nmcz0UYwPGZ71qs265jkWMd6z7Xuo91n+vYxTpahCK0JEpuKpT7Pgop
9xGi5EpuFQkrRyRHypGKSBQ+T8/zR3+8X3N+5zsz33nm94vqMSAhJXDO3UMI
qlGohK6Io1wftRFPuQkaowbl7AhHdTRDrPVphZZIQge0D7RPVdTETe/cDbSm
Phld0Bnd0MbeK/kSiEZzNEV3eT/PN0YjtEF5ZEU9mbfNIYF+jxnfkzZCa/It
EUI+CLTe4Ql1j5CDYk7kRge0Ri08oC0t/f4mTUP6D+lDr+9tj7ZOx7lO3S8o
Q7GdvN/m0A6Jtod10RFJqIwYFKItH4rYflZBZ6SjPIrxRnrdw07oGOgaW6AO
ylIujwpIL2tFOq/5DAjDa/R7Hj1kfZQ/IF3gdE8aoj7SUh8q68N4jEUc9VdI
L+MSJmMS6lH/NulEXEAevMt4050+G0P7G6R1Sc+RnvF6ltoiNtBx6pC+Q1qK
tBxKoioqoyJqyl7IeZFzxLhb0RyFsQJFnZ6HFnYOpU9L5PM6ThXUQkHKBZDf
3lUcpQPdtzKWl/MQimKBzrlBoGuUPcloeyhrjERu/IiL+MHrN5KzkT7Q8xNh
sTAPH2IKJmAshlv9XCxGH/TFcuszHm/iPbxifarJelDDa/1CzMccTMP7cl55
d3bkxEzKi7DE6nMhMtD+szHL6Xl4FZPkXDBuLzn7EuuUu6IgxmEyRuMlDLD+
3ZCM55y+a4Z9d+nTH/2sT3d0wTIMxiBb77NWPxQ9MQy9MREvWP1UDHE6n4r/
69MLozASI2w/x9neSv2frONf/OE1vhJtf8JZW2ZkRBjlNBqu/8VCXq9xLc/e
xa/IR1skcjmN/fv4y+tZKoR7+B2/4bbdCWF2BuROu2X3QDmJT1Rwemau4arE
JuXMCHU6nwxIi/wS85bPxlhZkSHQM18IBZy+947NIT9tmfBMoHdIQRSQ+4C2
0l7Pg4wTgSwSD9TV9JovzlglUcLpOFHyHquPRjGbTzZkcTpnmVsRp+uKsrzs
bR4UDfTeK2Vjyr2RN9AYyYasCEcuPKB9m5xD8mMwGFvwMY7hSxzFEXxOvy+w
C/sp77L6vjiOPvIcbZuwERuwDitxFt/jtKT0O4WTXvNncR4JiMdprMFCfIeG
ckfhBL7i+a9xCKuxFp9gCzYj1el8GqC+zJ/ycRyUuKDcDP295rujp5w32u7i
kcVgCnrYuw5gH47iCPZK3NDWFck4R/mUnCG5d+VewDyZt9Wn2twaooHEKm29
7VnJd8O3tm/xTu9VGbM0OuEj2tbjgNxxlC/gPHZSPohtXvf2jNWvprwEK3GF
8mVcwm38jFv27fZhL7ZiE/ZIvNF2E9edvusirsk3p205dtvZkO++ETuwXc4F
lmG+rV3eu0fiw+mZ+RQ7nO7zDauXc3UYh7CT8h3rI/nPsN3Wnop1EvOU7zv9
PyRr32xz6IcX7Zv+JM9gt32vY3jo9LsswCLrc9Xq5Yytsr2SfRuKQdiApVhs
61qBtXB4QvIYL+N1pGAW9bMxE23Q3ut/myrIgVgkoROmYBqmWr4e2qK2jR8g
wmIhzurl2Q5I9PquGZiDUiiBaBuzOZp6/Z0K8TpPmU8rtLP5VEIFjMB0DPO6
loGY6zWmVlnMyt1VHWWlDwZigD073OYg91gUMnn9fVkq+2JzK4fCXu+B9aho
36sjGsu5py6G9BuncXoYlb3+n5H/NhO8/r6MQRPyRXDS6ZhvYRxGe43HLujs
9a5o4TX25U4bYuPIPtdFI6+xuQZZbMxiKOr1bszuNZZlbvtxAk8B1aRKyA==

          "]], Polygon3DBox[CompressedData["
1:eJwt1nt0z3Ucx/Hv94fjtM3WGtFoWRrmts2YMOOYSIvFxkElSSunjnXcTioh
6uCUiONQSXTqOLkccnI7xxHa6nQhl0KnHXFERA4OKkrP1/m8/njs8/28P5fv
+3P5bsseWz10QiKKooWoj2ZxFCXhbjTFRGKT8QKeQ2ukE6+PHJ5XYgWWYjHS
iDdGBu5ACrLREg3RDZ3QET3wFmM+wlRMwQ1cwWVcxUmcwWmciMJ7G2BRFN6v
+HGccvtZ/IFz+B0L8HYU3qP5Y8bWc14NnWcCyc73Xfq8h+VYhmu46byuOr4a
q9x+Cb+iDhfR1evXPqRiJLH2aIcRUdjXLGR6f5sRuwtNcafLJkhy/TscxV7s
QQtkQmfG8KgMg1CKErQlmIs2aK21+lwbINn9+qG3++9DIf06owCF1LugAPnu
p/4jnf8w9MVQDHFZiQrXa3EAh3AQ67Hf79H8WkcNvvR6eqIbMlDseI3n0fgl
yPU90/0qx4MeV+x1NUKK16d1aD33IR/N8TDxgXgAX2A3dmEnPsU6n5vO6y+e
/8YObMc9GI3HkIVeXr/2YRT660z8Hs3fEXlR2Eftn/LIwa0o5HM7ZTrSkIrP
sRabsREtke33ZjmPbdjqfHSuHdDe57uJ2BbPs9Hz5jmPVK9zA9Z4vUW43+tQ
/voOu6Onv8eE70s9368SfvTBIRzET/pGsAzrUMSA4RiFYhwm9qP7qV3xR9HL
7QXogkLku1S9O2br26Y8r7VR5iAPnT1O/Y/S9jOO4UgcxvXAnDiMH8JzGYah
q0vlV+T6V/T5Gt/iG9zEv7iBf/ABVuFDrMAJnMRZXHC/W/jP/S95vOa57rzb
oo3zX0LsNsoKvBOH36P6ffoSz0tRQrwD+mA+9XM4rjtLvRy/8TyQcgBOxWGe
Sq0rDvOdxpk49FN7P9oSyEVfzzuL+Mw4zD9Cv5N0V9EfdZiLNfgFz+IAvscP
qMRg7avejeVY6X3S/sxkLdP0TfI8IA7lQ8rZ9Scw3vNqvgl4hf5PUY6NQzkG
o11XXr1R6vyq8Ewczk3nNRyLnFeFz1HnuR/7fE91/w77vh7zfanz+gahPA73
SPdnBl7DVExGtc4IkzDR+zbL/dT+Iqa4n9p1jguxwOepfe+EUu//dGKv4mVM
i8PfDf39mO668v4MW5z/NVz2vbruezAYj/g+7CVWhhrs0X56/3UOM3CRWAb9
7sWf2lNiT2McnoxCPBtX4tCexnM6kpGE8fQZgyrMxzzMxRzMdvkGXnddeaxH
rfOpcv95Ht+KOZsjEy38Xr1f35W+p8d1F6KQp/JLoa1RIoxT/1rPvxbb45Cn
2lOc75uMqY7CPmj9H9PnfazGLo/7BDs8fhM2Yxt243nGTIrC/zn6/+Z/hDMG
aw==
          "]], Polygon3DBox[CompressedData["
1:eJwt1WlQjlEUwPH7vibKWpIlI5QlSQ1jKUtEllKpZJtWS5a0fDBo1PTBjG2s
EVFZZiwlayIG0zB8MZMxhjHWagpZMoxt8AH/M/d8+M3z3vs+9z7n3ufc8wxc
kpuQ4zTGJMEFgTTCEIQADIeHw5gh/Dccz9GFdpHcz7U3+mAP7U3YjBzaGejB
2HZcHXDC4C+XuUhEMfbjGO7z30PcwV3U4wD9h1GKchyRGOgPRE/m7gUvtNLf
jI/4hDZ00mfKs13hhkr6z+McLqACa+nPw1ZswxZcpf8aqnEJUSjTOCSevcau
dwr3hmEywjEJQRiHwfCDLz5obBJjC75gGP3+smZ+38Nofj8yti39ATp2Ge0M
7MBGFGK27pPsVyamIhXpSMNipCASUViI1cjCCixHEpL1vhrmPIMqPMFjrNK5
ZM5sHZsu/cjESs2ZkRI7diEPGzCHe2MQizhEI17b0p+ge5Wr65L1rcd2mUdy
CfOxADvxz9j9lH0N0RxaihSkYpQ+t0jHyfgC7Ec+ClGMfdq3jnuPIwvZ+tzr
9J/CSdxCHRbp3ske7tZY1ug4GV+iOVmu42T8CZTgK/3fcAt1uIGh5Ko/gjFC
z9ZR7j2EUlShQtYna4aLnB840KZt6Tdc33GdprknORiheVCpuSw5fVrne6A5
L7n/Bn9QQ381LuEyLqKznG0MgC8GSa7xrHjEIgYzUKtnQ87ITV3bPMYn8l8E
pjvtOx+oc8mcrvCDJ8ZhLMajO16jEfVSBzS+Rjk3aEYLGlCr8UrcV3FF9hk/
4YP++IEJCEU34nBHV7g5bQ5ILnTgtyve6/zynI8Ou6cdebYX3NEP7WUNshZ8
xhd9Riveoi/zDIAPvDUOiecXfsND55I5e+h6nbpPsl8J+n5nIhKzEKX7/Ip7
m/ACz/ASAcbWYanHQ6VWSP5rTklupSEVnk4br8Q90WH34Knusex1g84XiWh5
zwjHGEzT+i/fgR2MDedaYGxdl/q+BflSw4yt4VLLAzWWjg77TZBvQ3uHrbse
Tvsu5J0EO2zN3q01Q2rHAmO/Acl6nuVcp2l9Oat1SerTaWNrdpzmo+RliK7X
22nfhbyTJs2X23r+5Bx+N7buhmjuSQ6G6npjdP2yD7HG1vuDeiblbJbpmf4P
QjTNwQ==
          "]], Polygon3DBox[CompressedData["
1:eJwt1Xt0zmUcAPD3HdncYsgarZnraZnGorGJNRpJzdaMnRWWohyWe5JcUro7
OEmHUlKHUpzSTdRJIpXquFMqh+6lm45Kqs9z3t8fn/N+39/3eZ7fc/m+z5tV
U1s2ISkWi11FPQbFY7F+7GYvL/Auz0fxOpaxmucYwyg+YRc72cFfxjrFH/zG
ZjZxkEMc4APe5x3ei/p+yBY28jErWM5jPMFTrIrabGMr29nMBgYb60U28BIb
KeZtjnGU43zFW+zT51M+Yw3Psj+sOZrbjjA3drKdbzjBzxzhc74O74rm8Dqb
eIPXWMlaJjGZ9TzOP/qc4Vu+5ySn6StXxgEORXPbwytyb7KFNazlZS52eJdQ
SG8K6MlN+ozjcoq5mbG00qc1LWlAfcL5143iUAPJpHBWODt9fuEEv3OSXzkT
xT/xXTwxyGmfFwlLGUI5leSxinNCXVBP22RmidM9H0ohzWlBGl/IfclxSrQd
zJU0phntyaQN7ahPXf7W/t+wh+JyLgt7yjCy6UwZqfSiiopozk3Ip4hL6RP1
7R1LzPlP454KZxdPvCuFLLku5NKVbmQykhGMYjRjuJHJrGAZT7KaSdQynnHc
wkQm8AxtOZ9qxvI0c5nHbOYwi5ncE73rjqjNAuazkIdZwlIe4cHorDM4m5xo
Le3IsrYMzqMVx6z5KM3FTWlAo6hNW1JJ41zSozNqyAXG6kQHFrGYlfSLJX6b
e9nHYYbzo3f8wNX6ljKCjgyQK6E/A+lJAXW0zacXBRTSiBnRHi4VP8RCBtCC
HuTyn3wsrIlFLGExFZRyDVOZzhSmMZFaupBNRy4MdU8OeeEuNOxu9oS99L09
o7mBGq6jmirWabM+1I64WzS37uHu82wXW9kWS4z5UdgjuUrKGUIR/bk9qoES
8UDGcz2D7N0VjGQ4lVQwJaq9GdrMDP25jft5gPuYE619AUn61KEDncgOZxvq
Q65luPeM9Wos8T/S2veh0buGUc21VLFcPl0+LdxF8cSd8Gj43cjl050e0Z3W
NdSZfArJtCGTDDrL5ZBLHnd71tfn3HgivpP53MVsUmlKMxqGOyj8huOJ2tsf
6l/cJGrTONRf2Ndwf1BMHw56djieiIuSEnt1L0fCXhvjVqYyjenU8D9AJ9K0

          "]]}]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0M8rA3AUAPAvjhy1Nhap1VKOTuTKnNQO2owaacXBj5Q/gO3AX+FHXJ1s
StmcyMrVwcVFo5hc/KgpH+Xw6b36ft97vTewsJpeaQshzPMXO+ikiwTHHLHM
ErvssE2J7vYQFhXOkKPADXVuKXNKhUvOOOeCGlUOOGSPfU7YYI11NtmiRJER
M0cZI8ccs2TIkifFJI/+N+iT95MgRpQIQ96SDDLMtZ2uqHPHPQ+880aTF155
5okfWnzwyTdfRPSLMy6fIMUU08SI0ksP8f/7/wJVajHe
       "]]}},
    VertexNormals->CompressedData["
1:eJztmzFOQzEMQL9g+mVlqNiQkHoIBs7QnqACwcrOwgnaAgeoepN/AOgJujFw
jc8f2iWSlTi2Y//USys9ffk7duI4sf/t4+vi+aJpmuXwczn8T576+fTmt/u4
7t/uZoduf//+st39PZz455F/Bzx8/ip4/idTTnvkG0DOmkkONF7suFLlYPXH
6hPjG+R714EcyJ5cdsbaDesXbj+W9rs0L+VHqj65ftSyvzW/S+sDycdyK+tC
m7t9bMUf6XURi29a6xf7fGq+N3aeO09i84Gaz1iPG2Pbx2vl52bPcxuvc+fO
nTt37ty5c+fOnUtxa3WEWnjqvZA0t3bvBOnTJnJuPa3Of2r9JdXOVHum1p0n
wn488S8m+aXvw6XvV7F9CFzvjdWFueoXXPYsHR+sxR+t8WLnA1d/y9jtn6s/
1F+ErXPV6i9s/obdB7n0KR0PY3lFah+g1rrj7ouD/KJVT+fKfyC/h3Ejt1+R
qid0XsCu3zbQR6ovkdoPaW0/iq2XldL8Hwun7i/a+ju3MX9y+8O55Wudf63n
887r4tJ90VznKWr+iZUTy6OkvgfJ/f6o1r4y7LigPK1W+1izf+n9UdsOVPv8
A9E3OyQ=
     "]]},
  Axes->True,
  ViewPoint->{100, 100, 100}]], "Output",
 CellChangeTimes->{
  3.5444602512612762`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equations and Surfaces", "Section",
 CellChangeTimes->{{3.576501125513276*^9, 3.576501132334875*^9}}],

Cell[TextData[{
 "What can the set ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}], ":", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "+", 
       RowBox[{"b", " ", "y"}], "+", "c"}]}], "=", "0"}], "}"}], 
   TraditionalForm]]],
 " look like graphically for different values of the parameters ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]]],
 "?"
}], "ItemNumbered",
 CellGroupingRules->{GroupTogetherGrouping, 15002.},
 CellChangeTimes->{{3.544170550294923*^9, 3.5441705822637515`*^9}, {
   3.544171333144699*^9, 3.5441713331647005`*^9}, {3.5443605264757805`*^9, 
   3.5443606282469997`*^9}, 3.544360662051*^9, {3.544360693273*^9, 
   3.5443606948389997`*^9}, {3.5443607548710003`*^9, 
   3.5443608389370003`*^9}, {3.5443609355411263`*^9, 3.54436096187876*^9}, {
   3.544361449687536*^9, 3.5443614526968365`*^9}, {3.5443616805676217`*^9, 
   3.5443617279743614`*^9}, {3.5443618107886424`*^9, 
   3.5443618174523087`*^9}, {3.5443624050700645`*^9, 
   3.5443624221117687`*^9}, {3.5443625969932547`*^9, 
   3.5443626219957547`*^9}, {3.5443629046400166`*^9, 
   3.5443629220427566`*^9}, {3.5443639895985017`*^9, 
   3.5443639897495165`*^9}, {3.5443641738079205`*^9, 
   3.5443641795204916`*^9}, {3.5443642628558245`*^9, 3.544364314837022*^9}, 
   3.544368198953044*^9, 3.5444521816415625`*^9, {3.544452582888341*^9, 
   3.5444525956197357`*^9}, {3.544452631770034*^9, 3.544452682976454*^9}, 
   3.544453282839238*^9, 3.5444533400223017`*^9, {3.5444533950980673`*^9, 
   3.5444534948907385`*^9}, {3.5444535353472433`*^9, 3.544453538358468*^9}, {
   3.544453620239814*^9, 3.544453622502133*^9}}],

Cell[TextData[{
 "\tPlane if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", 
    RowBox[{"b", "=", 
     RowBox[{"c", "=", "0"}]}]}], TraditionalForm]]],
 ".  Empty set if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", 
    RowBox[{"b", "=", 
     RowBox[{"0", "\[NotEqual]", "c"}]}]}], TraditionalForm]]],
 ".  Line otherwise."
}], "Text",
 CellChangeTimes->{{3.544453773844473*^9, 3.5444538320260773`*^9}, 
   3.544459604976591*^9}],

Cell[TextData[{
 "What can the set ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}], ":", 
      RowBox[{
       RowBox[{"A", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"B", " ", 
        SuperscriptBox["y", "2"]}], "+", 
       RowBox[{"C", " ", "x", " ", "y"}], "+", 
       RowBox[{"a", " ", "x"}], "+", 
       RowBox[{"b", " ", "y"}], "+", "c"}]}], "=", "0"}], "}"}], 
   TraditionalForm]]],
 " look like graphically for different values of the parameters ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]]],
 "?"
}], "ItemNumbered",
 CellChangeTimes->{{3.5444535465818276`*^9, 3.5444535866638794`*^9}, {
  3.5444536259034123`*^9, 3.544453649337917*^9}}],

Cell["\tGenerically a hyperbola, ellipse, or parabola.", "Text",
 CellChangeTimes->{{3.5444603099996643`*^9, 3.544460326599022*^9}, {
  3.5444607568114405`*^9, 3.544460774315651*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "-", "y"}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.544460394026112*^9, 3.5444604863210363`*^9}, {
  3.5444605356198807`*^9, 3.544460544418788*^9}, {3.5444605875718775`*^9, 
  3.5444606465432796`*^9}, {3.5444607000397654`*^9, 3.544460737154307*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmAt0TlcWx/MiIRKR6FCPSRkZWVOWtyQi9jHGu4+pqoV4TQhSQ5mm5DFS
mhSJxVQq6CSIZrRGPRrGK2H26VS9JqGoCOI1omki4kuCoGTmy93/c9ea71tn
LVzn3nvuPnv//799usS8Ny7Ww83NLdzdza3pT/m1VVMT1b6zWUG6vCI0Iiol
SKk/xN3zbRukM7uNdo4g1aXPrAl1ZYE6a/CSGcmNgcq6nBmoN/zxtHMEqn0h
0c4RqEPkuvpwd7HnZ8GBOqMw6uR3bQNVeXDiFy993kY/6FkZ99uNbZQ1rVsb
3eyNW15vzGij1pbMXVPyU4AeI9fVv16J7VD5ZYDOfa/4T767AlT7Rr/fxfQK
0I9eW5yT1i9AXTs43zla6+n1mXktHa3V5KRRQTPv+esbcl0Vb59yZvsUf52+
qunnrxKXNP389IDJec7hh/W30gd8V72+vYuf2rAi5+dqj1a6u1xXYwbe2544
y1cf6Zjgk1Toq675nE/fuaalHlMztXpneUs131pACz0zZEJMyISWKmldu8R1
7VrohXJdBWfEdsqI9dGDi2sHFdf6qKrk3MrkXG/twz2ahrKWea25vpfrX5W7
1lulDdqROii0uT4i11Xk0cdbuk5tprNbz5hT1qO56jwt+c11e7x0Sn55u7Ep
zdR/rZ+nPlvU9PNS/fs1/Ty17KmXWlg+YkH5CA9dU7LgfskCTzWl8EB04QF3
fXX3defwUKOsOLvr8OVBzuGhrLAMcNNj5bpKVcFvrRjYyO+Pd2/8qNBNXTxe
WjBn1gv+6y9u7Ht/nJvqasXpOce8HXfqyLlG+mlI4bLS8c/4mzYXt5xSjTTP
isNTDpV5VBSQdzIgr4GVZ3/neE45+yOy90c08JOoQ8f/fvNn+of13Y95kdxH
67I//vWA4IdsxWXHU6pqipP/Q351XHbPcdlP6YX1/fXs88PQzj8MfUrrn2Ts
fZJRzyMa541snNdAI6zvqGUrLP0aqNiKk4ML5D204HbPyO7DHTxqmZdzPCaP
bso5avjCn90i78x+RL+01l3NVn7eekgdd5/vsPt8FYc3LSf1Ic211lnJnla8
H9Knux6t3PWogpfxrT2Jp+vpUM3Lk5JGVfDCpOedQr6sp3zrvT9yYlO4w+sp
Z/3YI+vH3mW/iIYrzY7XUe9XBmatyLmDeNVRTXXxjeri/3CFs1ryf1VHw6zv
uc1Tjl2KPnaplkYlpI1MSLvJp6zvqqXm1nfe5Csfblt18qNaam89p4xfkzjQ
1ZXJh1cml/IHv/d2jlrysf5ymdOHnZhW+NxBX1nrK+EtTWGuclDdtNqXptde
4jnbRhd7f+2gC+98En708QUOn1V94N9/cVCU9dzzLPXmoNyM3mE9jxbzbOvn
oNPWuoq4W1N5xDho8LCw+GFhRVzw1tt1/lEO2mq97wRfyezpHA6aaAnIt2yl
UQcHzX43caZX0DG+HeExPNrPQSul4DhHt3AOBxV1aNqQfC4b0Ctip5uDXrUS
M5OvzTw7r/LZAxJdOzXY/P9X2db/k7k/1NrQfDLPr5DnE+H9Z+X9dBXrS5X1
USHWf07WTyH4vsXyfbQ0rs/XObOc32vFv4jmIB51Eg8y8dol8aIIxPMdiSfN
RbzLJd60DfvRbrq1H7Qa+/Wt7Bctxn6+LPtJZr+vuK8/7L6+lJJ/DJ1cFFVL
SdbnXaFPLsetvRxXS136L23df+k1ynq37vD+tFrqLflCRcinPpJPNA35NlHy
jaqQj29KPpLJ1/uSr9Qa+Rwm+UzLke+HJd8pHvVwTOqBUlEv/5R6IVNPmVJP
NBj1Fi/1Rt6ox65Sj1SCev2N1Cu51DcNRP1/L/VPY6APJk6doB97RD+oN/TF
rGMF9KdG9Idc9IleQL/Me4dB37aKvpGL/tEJ6KN5Tiz0857oJ22Gvpr74qG/
JaK/ZPQ5TfSZBkG/p4h+qzLou5n3APo/TfRfGX9YJP6gzsE/Boh/qGXwFzNv
M/wnWPxHufiTqoZ/rRD/Ui3hb2ZeFPyvWvxPufijioV/Jot/qtfhr2ZeAfz3
uvivcvFndRD+vUn8W4XD38281fD/JPF/5cIHagb4IVr4QTWAL8w8F/5QLnyi
mv8/vygH+MbMWw3+uSv8o1z4SG0EP+0XflIbwFdmngt/KcNnQ4XP1LPxxZvm
5AfZ8wzPbTqX/PToRvvfGnxn7tfmftynzfPxfpvjsD4NvrO5LwXrB99p8J35
fpvjwHfaxMdw3zeIH+KrTXwRf5vjwHcafGdz3xnsX4bsr07A/mL/bY4D32nw
nc19I5E/hyW/dBnyC/lncxz4ToPvbO7riPwF32nwncl/m+PAd/pj1IfhvnDU
D/hOg+9M/dkcJ9zipfuhPg33LUD9gu80+M7Uv81xEaIPOhr6YLhvKfQDfKfB
d0Z/tNEf8B2D74x+2ZxmOPA76Bv4jsF3Rh9t7jJcmAH9BN8x+I76ih7zGejx
aNFrm2PAcwyes7lxNvQefsDGD8BvDH6zuXFi493pjXcrCLzGB+E/QwryIgvy
6tn40yrxL74I/wKvcS/4m3x/HV+C/8Ef2fgjeI1Hwj8viL/yVPhrmfAaG/81
3LpJeI3Aa+wNf4f/s/H/vwkfcCT4ALzG4DXDF2z4olT4gyvThT/Aa1wEPuku
PMP54BnwDhveAa/xZPAQeInD5wkvgafY8BR4i88LrxF4jEM3C4+N/GLj7laN
D9iF13iH8JrhPf4AvHcLzzc8aN5/DrxYivX1Ak+CN9nwJniNl4BHY/H9n4NX
TXyuS3wM77Lh3VjEl8HD4DNuL/E3PM2Gp+Oxf4/ihbfN/mYJn3GC8BnHCJ/x
GuEzbuxn8Rl/KnzGhueLkT99wfuTkV9h6AfQL7DpF0x+lqCf8EX+hqLfAJ8x
+IwXCZ+x6VdSUB970c+Y+klBv4N+iE0/5IF6a4t+Cf0Um37KpV65D+r5NPqz
4ah3E6fO0IO96O96CJ/Z61gO/ahAf2j0JR39I/pL+71DoE+b0H8a/TqO/hT9
q/2cGdC/cvS36H+1uW8R9PN79Mcu+sph0N9J6K/Rf2sz7z70Oxr9udH3+ejf
i6D/fdHfL4U/mHmfwT864nzAxV90JfwnFecLOH+w50XCvypxPuHibzoG/peA
8w2cf9jzDsE/r+J8xMVf9X74bxbOV3D+Ys9bBf9egvMZF3/XU+H/k3C+g/Mf
e95W8EM7nA+58IU5X9JrcL6E8yd7Xjr45Q7Op1z4xpxvGf4x51/2PBd+Mudn
2pyfgc/seYbHwGf6f25sl9o=
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {Hue[0.67, 0.6, 0.6], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158}], LineBox[CompressedData["
1:eJwN0WciFgAAANAPGVEokSIZLWWUkHM4QgfgPv6QWVqU0SQrlTQoIqFUthSS
zPfjneClXS0tLgkKBAJllFPBNSqpopoaaqnjOjeo5ya3uM0d7tJAI/e4TxPN
tNDKAx7yiMc84SlttPOMDjrpopsentPLC17yij5e088b3vKO9wwwyAc+MsQw
nxhhlM+M8YVxJpjkK9+Y4js/+Mk0M8wyxzwLLLLEL5b5zR9WWGWNv6zzjw3+
s8kW2+ywS0BGEMGEsI9Qwggngv1EEsUBDhJNDLEc4jBxHCGeBI6SyDGOk0Qy
J0jhJKmkkU4GpzjNGc5yjkzOc4Essskhl4tcIo/L5FNAIVcoYg/nWFcy
          "]]},
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]],
       Annotation[#, $CellContext`x^2 - $CellContext`y^2 == 1, "Tooltip"]& ]}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-5, 5}, {-5, 5}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlln9M1HUYxy9Y/JFsrWZbBWMSZ2s1gZr5V+1Bo9QSWSRixZpRbZI7sM1F
nKcEtFno5o/BgAQJt2CooVajZquHoYIGIR0K4t0acHDBwd3ZlfzQ1QXf53l/
Wdd3xz77fvn8eH68nvfzScwrzHovymKxtC38LY5Ts+4Hm/cF6cP8hKHT1Z1c
3nP/b286g1T76HR3leU8336tJiPeFaT9Nlfbwo87H7lv7/7xIL2xda5lIv4b
dr3Tu3PyTpCOHH8oNqvpiPluMZ7Lz+H9gS+M/xPWt8t6+kv3/132pzI9PyTn
06Tad1bsozTrTOjbPUG6aszvpJHFVbYgnTrbsnrM3UVJKaHHUkIBGipbdaNs
VR95M2a2VTkDlH3UuvGo9Veq6Lj9RO6hAEXvWd66fsRJBSfeHXz85QC50q+0
ZlReo7VlbQeXu/x0wdh/gJ7J9A1t/9hP/cUHEuu/u0G3Ks7MVZyZpi8v5Tgu
5bjpz3ZfXl3jNKVuXDzATU8a4zT90LP4uOnmvRebnIenKLx5a3dc0jBlJo9n
JY/7KNOwZ4Q2jNgXDJnUeR760TjXS+1p9pLWbC/VrenLj65fGvEd87AO+2Bf
nINzYQfsgp2/PLupNLbZTR9R0HmybskP+AU/4TfigLggToibo6Ng37J7+qn3
+OUFS5fiXvLqySue3gCtjbKmRVn7aLDAP1DgD5h5Qx7bdm3PjVvWRcdme9NP
FC/lGXkHB+ACnIAbcASuwBm4A4eRnK5vqv4q9p//cwzOsR51gLpAnaBuUEeo
qwaxn9ep/Y3iL8PfZIkHD2k8npd4cZnGa5vEk/s1nqck3vySxrtD8sFrNB9F
ki++q/l6WPLJ85rP85J/Rv5tdtut/KeGecvTru4VtVP0gvDD7SnW0IW7PgoU
hmcKw6O823B7kvITdnbsqPSwZz4xNf2VSboTXnw8/FlL6JOW0AQ5whfja9/y
Mvgc3dA8GNPg5YCMdE6+86cyj0plHccYeRijIdmXi+Qc2iHncljsoO/FLgbn
m8RudogflCB+sVc53y1cs1s5D0kcGJzPS5zYrpynSBx5TDlXrhmcax74deVc
uWZwfk3yyFuU8+uSZy4+J5zXCNfsVs6VawbnPuGGi5XzUuGKX4wTzpVrBufK
Jecq58ot720UzpVrjtBj/rtBOO/S9bPZwrlyzeBc64qnlXO/2pemnCvXDM7h
7y7xl1WPWfWYfaLHDM6rRI/5J7uhx2wTPWbVY3DO4F51h53KffQByd9m5X5O
8wvuwYNHuVcdZNVFzhGdZHCvOqrzPAxer4rucr3osDniO+ZhHfbBvjgH58IO
2AU7u4VTVj02/YBf8BN+Iw6IS4Q+8GrVj5vKLeJertyuU/1RPTbzhjx+LZzy
58pthJ6ZHIALcAJuIvTS5AzcgUNwGckpOMZ77n/1nCP03qwT1A3qCHUV0U/M
uoS/U3pvWKHcoq71HsGjwikdUm79em94X7mN6IemjkBXoDPQHegQdAm6BR5i
MqV/X1deoHvQQegidBK6CR2FrkJnobvgFboMnYZuQ8dr+hzH/rBM0EBe41j5
ynFT56H76APoC+gT6BvoI6gD9Bn0HfQh9CX0KXCPPoa+hj6Hvoc+CO4/0Pvc
z6ofh/W+N6z6gr6KOlip98VO1afSyqK3k1KDFGuc37PUp0vmq0vmu7hO7yUH
tS7Q11EXkffpfwHY+4/0
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {Hue[0.67, 0.6, 0.6], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182}]},
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]],
       Annotation[#, $CellContext`x^2 + $CellContext`y^2 == 1, "Tooltip"]& ]}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-5, 5}, {-5, 5}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxFlgs81Wkax885Do1LufYhmi4khgxhM0x6Xlm1pbmxYTRNo8tWg10zm5Y+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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {Hue[0.67, 0.6, 0.6], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178}]},
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "2"], "-", "y"}], "\[Equal]", "1"}]],
       Annotation[#, $CellContext`x^2 - $CellContext`y == 1, "Tooltip"]& ]}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-5, 5}, {-5, 5}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 CellChangeTimes->{3.5444606601316633`*^9, 3.5444607390576167`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      SuperscriptBox["y", "2"]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "-", "y"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.544460394026112*^9, 3.5444604863210363`*^9}, {
  3.5444605356198807`*^9, 3.544460544418788*^9}, {3.5444605875718775`*^9, 
  3.5444606465432796`*^9}, {3.5444607000397654`*^9, 3.544460737154307*^9}, {
  3.544460822943656*^9, 3.544460829714446*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyNnQmYXlWR99PdSdOd7vTydjswgqLAJ5tsggEx8h4UcdgNqww7IgiICAww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     "], {{{}, 
       {RGBColor[
        0.33397672886243995`, 0.1279285534584573, 0.5864250111696041], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVktsVFUYPlMyM507vXeuxMS4kqcLXejCjcZHqHuRuvGRuGCBugHEqdoK
+AQaHytN7PSBKbYudCO2pRqUPmdSbGemxSgUdIMYg5ggMUEIJPp9fJ9hcXLO
/c9//uf3//9du3VHx/aWEMJ5rFVYhzIh1LMhDGHvSEP4sDWE3mIIVdB6QDsH
njnQPsIaxvc+rH6c86AvFfC2IL5Z8O/H/ivltogGtnAwDgHiQohC+AK8X+Lh
lVwI03npmgffpxnZcRpsV8BXx91oSTTebcYayUj/GfD0ws5ZGD9dlC0DWGdB
P9oWwjrwvAwZH4NnBjzv4vw31v3QeSaW7sOQPwl7n0719knsz+ItSOE27FW8
eyQn338AcbmgeNBfng9Ax0M53ZFOn7ZCztXcTT76f28q+j3YR8FzJ2i/QWYj
o/uNWJ/ZN/rFWP5VUNwuYr+MNb1KNtG2f/F9e5vimYFPYxnxj3q/5HMVurZY
5iL2BazHsa7nFIefQW9pUb6YR8bp4ZxyNwdFD+aUz1pWftKnhu2hfOZt1rlr
WC9tZ76GnMfzePM7Vi4IX7xbQ6xlpHcD1lJWvq/N6P2SYzuIPF3AXV+kPDdN
H3G86MtB5514XG9MEgPteemm3j+ykgMxYSfwNIa7F7F/D/7jxlUN8u8Gzxz2
13FXA8/ekr6P4H4c60/Y0w6elTblhTlhrLjP+HwsCWEKPDtiYXsK6w68/SYV
nolr2vJoXvbQFtIpfzJVbUxh7y7oPWObb5U/m5yTE1nl5bGM5K8E2UhbiVX6
wjNldhakg+ddsfL6UqxYbXJ8yrFy3Im9L1a+erGXI9sOnyqp6uF90F5DXGYh
s7skLDQcC+KS+KzEytWN2sR6IRLet7nO+p0v2li1zeS9Kyv+ckF20+bPW+XP
uH3tKshf1hBrCZ/h1rzeExuMa7tzvcU1sM555tt5790+M25l62K8Saeer4rC
1jOpehZrjTXHWNI26qbsmuUPWxdrrUkc5YXnSiQc9iMmr0TiZX+aaFNsGWPK
pDzGaLCoHvtEqh7FnnIK9N1434CcPdjfwFrG+U3se0rStRt7p/NF2YtZ5Yi1
xlgxJpRP2bR52PGj74whexbxRF2r8+r1w65TYp3YJi/jVbCPC65z0hruYw1/
M6dHgZtrkPtdItqE3/a4ztnfGMuy48l8XXNfOlIS7idKwlfdtf9WLPwPpOph
rDXyPx+p7ofg+85YZ9JY01XXQwod9+VlM/nI81Sq/k0MUT4xOGPc9tifc7aZ
82yj+xb75gafWYvE8wr0ngTvRKI6I51xG4SuX7B3YH+1JJx1YT+VKNYDyHlf
KpzPFpU74nXeuGWfIuaH3MPZVw97fjJfm83HXHMu0R/68p77Juck48W4XY7U
P9lzmV/i66rlEPtdxj9tP2G/SDtuG4gR8hNnx4zRrxPNg7r7OWfQWObm/CKd
95c81+qeFQ3PkabPBzxHmu4nb8fyZRB6PogUH8aJ8WWct0W6I88/kebBgufI
ftvD+JO26LjR79XGP/sf++r/syk1NqaKwgD/Hd4pqT+zfw/EmiWfYF9MVE8X
Yuna5xlKm2jbA5Fm6ZwxwPgxr8zRTFGYrHgmsMeNe3att5xlz0HOXM7YkmfB
iOcefaz5v4P4JK5vsf0/JfKlr6j/l5p5xpwH5oj9g7GgnG8T9SX2J9Yf65Df
7O0XnSPSr7s2JxPh+blIsW1aDvtT3T6y1zM+jBNtp++0v8O1QBkT7hWsqUpR
fD8m6k9V52h7rH+007H8a/of9ZDn9hrPBeKSmOwviu9kovwynjf+B7Lqg5wL
/wG86bXg
           "]], PolygonBox[CompressedData["
1:eJwlk7lPlGEQxgd1d3XX9/s+jb1iqYUWNiYeEf0LsPHosDBYsKBilNOz8ai0
YJcFe20MGgUPWHbXrcQzikiwQI1R7Ew8AoW/xykmmZln3pl55p1pbMk3ty0z
s33ICuRtZBZnzKorzeZzZmdis0ns9Q1mnVmz/YnZDbAa8hm8iG8hZfYdKQWz
m8F1IBtGP0B8idhhZATnNPnXkG8b8gl7bLVZI7lr2L3Uukq+p8vNNpOjCtaB
7x7YF/K1gl1GKuCbwCvgMfjejPcwRL0Iuwk7Q7376OfwvUp5DdUqUjMBn8LX
DTaDrynlOZRLnMX9OtKcOEdxXQv+nt5nkXXob3hzgfelnGMvsfuxDyfO9RL1
erLOUVxV8x1vB4j5Suw3pACexy6jb0+b/cR+EHvve/B1BOcorlU4XwEfyHlv
+pPTsccodp75tKNXwevE3iLmCL1M5vytelbvJ4ipEb+Leovkmw1eewk5RmyZ
N7dXmf3BHkefA9+R9jfHg+dU7inyXaT+QvC/0Qx/oG8BbwG/A95Kvp7Y//YF
eB/4KWpuZDZ1fP1gXUgV/Rl4F/gofDc0uK8brBff85T7hA0Gn53+WH99lHxz
1B/BzsdeU7XFYYJeHsL5b9p72or9BHsx7T08jpyzuMv3KPKZaDbasTLY3di5
agfb0T9Sfyd4nR5OovfFzkU3MZRzDuKiGypg/876ruiN3montBuv8Z3H/pV1
XTPWrEcjn/0EvjbsJfDdab+JCvkOJv7XuqlDiXMWd+3QOG/HIr9VcRZ37bh2
XTPsCb6j2lXdxNngN6Zb085cy/of6a90o4PUK2Bj/t/ZIvqH4L1N45tB7ww+
C/WoXv8BbcqrBg==
           "]]}]}, 
       {RGBColor[
        0.4150981865873198, 0.26897686037537183`, 0.7004510335088122], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmF2UlWUVx99z5sycmfe873nPCKQVjrmW12Z1QytiUYuyqIsSsbRYOmQW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           "]], PolygonBox[CompressedData["
1:eJwlldlvVVUUxnd7O3F7z7m3aB1w5B/A6QUVCSYomvigJSqiTI0gRGkLtE5Q
EDAmCopIoQNtKeiLw4sMxYrSCQVCxRcpIAVUCi2IfSha0Ij4+/IlZyXf2mvc
a6+1ztjS8pKy7BDCeigHmpcJ4cuCEHblh7AgGcI4+Dnwvcjmwq+HylAclxvC
9yn04efBX84LYXccwr1RCDvgJydCuAf8QmEIE8HbOWtBXol+O75vwX439hE0
B9kY+FbwVnTO4GsGMWdiuzwdQgP2+7FZAX4N+wPgq+h8g+5z5NeEbsB+K/br
0BnJCuFHdD4ET0P+acI608E7sfkrz3eaj/9Xk/Z9B/Z7sJ8AP4F8HkfnD/J/
EL4x33d6CvkJzp7Bn4p2CVmas1Jkt2P/NXgT9EPwWS34Tuhm+Dr0x+qu2BwM
rkkKvpkch/BfjH4T+CB0Hbkdw98BcCZtW+VUBN4B5SBfzNkVfD2Bjy+QnSPf
2dxnXcq1Vw4fgIci36UW/RZwH/RswncqxdchdA4n/KY94CPIJ8G/iP4A/p9M
+e02o38/fAn8Tvh/lW/Kb6i37EJehXwj/Oc5vmON5MToRF6Dv1bdBf9p8CBn
DeA63iQxKoRh3mwN9jdiswT7fdBM1Q6qUj/hPyDv4f1G5btH1au1UBb2q/DZ
wf1/xud47rsQvgychc3kXPuQL72x3lo9pF5SzVS7s9DH+D6X9N374bfBzyo0
Vk+qN+uJl0e81eh0FXoGNAsV+L8BPMLZffAL4UfDd6D/GfpPU9P2jHtEvaI3
u0CsMfB8YQpnpwFfUaMifD8C3wZu5uwquqfUQynXQLW4iLw5ckzFLoeuBz+A
vCHXM6nZfJl8slQ7qCO2D/nSWSf8SfhHc52DcpkBded4F0wH35Vx7v9w/7vB
7dhcy3MPqBd2wb+S7Zlqjb0DtAv0BsfJb0vkXDPoNIK3YZOV655vSXpmNbtd
0Hz4ttixtCO0K16C/stzTMUujzx7OtsLn6JGk9CdiH0vvq5R64fz3UPqJe0s
7a565A9h2x9ZN8bHGfUH9uPRL6Kf9qedg3JRz1ZEroFqoRgR8pPE/I1eLYY/
BW6gJgXEvMTZ+9g+r/dOeOdsp/b5nBVjvxQnQ/jakjRWDVSLY8SYmnANh5Et
idzLFdDiyDtRu1EzdTbpHaFd8RP5rtVuTns25UO+1mQs0510t05yWJHtGdOs
1aLTi24PtAn8XtKzpxnSLA2nLNPOKkB2GVqEfTHyJuQjSec2Gr4Rvhv/K7Nd
A9VibdK10IxoVr6Nvau1M/eA30h7V3wE/7pyj7wbtBPqk55BzeKAdjS+/+Ss
PNs7S7trUdr/Ju3ACvAg8rnZ3llHkf8ae/Z0x0PYn0h5ltTjfZqv2LtBM7k3
4x2qXboBvg1+Njp9Cb/ZLPACzipzfHYYf++k/W/p547Lk+4Z9Y52dgp5d+xZ
U85d4EbO6rD9W+8Tu2aqnXpkVeSaqrZ6o9WRc1Auqunb+D6ufwr4MepxEfm7
kf8N6sFq4g/Cb0A+BfkF8O+RdbUjtSunZhxb/9AmcqmKvLv0ppXgI5pXZDVQ
PfLzkX3pzjcR+820ZbcScyl4GVQLfxt8ddr/aP2r9Q+P0W+A34j8CtSL730p
10r/mO/AdYV+e8UsIbdPYr+13vC8ZiXlXaYdql06EHlWdUfdtTpyLoqxDPxL
7FnUP/80+Gjs2MpxM/YNSe8e1bAp8j9Q/0Lt2M3IVka+i97oLXB95H+Tdoh2
yf9QNUhZ
           "]]}]}, 
       {RGBColor[0.4962196443121998, 0.4100251672922865, 0.8144770558480205], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuwVVUdxzf3nHPPvfuuvc+NFARkxEqg4HoVsEbRISUrwZrE1AQUuIRl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           "]], PolygonBox[CompressedData["
1:eJwtlmlsVVUQx499S+t99973QBAQsaBGKrSyCBq2sLkCJlI2kVZoCwiy+MFI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           "]]}]}, 
       {RGBColor[0.5737613661287864, 0.5435370519035628, 0.9097253540741593], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuQVcURxg+73LvsOfece0R8QMgaHrIsAmr5lpiEUqqCgoD4AhZ8RyRq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           "]], PolygonBox[CompressedData["
1:eJwllmdwlVUQhs8k994k97v3u58QShRQICQkEMpgGZrCCDMiELoQCKFJNcjY
QNoPRUAHpI0akSYohMAgAj8cpSgiLYDSHB1KUJoijCZSpfq8sz925t2ze/bs
nrNnd+sPn9D75STnXDkUgtKiznVNca4q7NxnceeKEs4thl8A3xw+xXNuKRva
o1wJf9t3rkuycy3RuQPui/5qZFms9QHXD5wbkOpcNnxd8CH2ZEecy4EqOCsC
dWHvZPbUjTm3iz01sF8G/QCOQifY+w1yD7wNnRC+LGVtOb4Mg2+I30XY8zj/
LvbrwPeBvwc+jU4u9nMUE/IElIHtocgDcBNoIng5NjuhXwuaCt7OWnf2ZuHz
CfAebDYCRz07azAUZW9N+EkRs9EU/gZ0Dd9acN4t8E3f8HX8H4HuE8RbAj8E
fij4ONQLfx5mz17Obot+DvwxqB14EDF/hH4b5EeQn4IfmGI6J8HT8SmMv7eR
X8B+OfcxA9v1ke8Hz4W+dfaGQ9BvojOSzYdC+P7QInBj/P8RWQ/4OSl2B7qL
Avxb72ytJ7IunFcb2RxsLOC8Emg+OIO1XsgaojMoxXxsAO4RmGweOh+im05M
IzlrC/5dxbdi1gYiu4XPu5ENZ+1Msr2p3jYbG0XYegq+KXw5PjVkfwH7x4Cb
QvOwPx/KA9/3LDeWQQ/A/difAy7E/gvg6qztYO9B+FHYex3/tqbaG7wGrmLt
QMh8qASviJlvg+EnsLcNZ/QEv8haW3A5NtPZn4N/z3BXZazdCFtOKDeWEVNF
xO5cd58X2N4e8KOQd4W/Ap4LLYR/EhudwRvQ6c7ZH3h2d9LJV/4h78Z9dETe
Aewj34Tv78BX46yp8BOT7Y+0Rv82NgaDi6A74ITyLcViHAl/DJ+a4d8wbIzT
fyGeXPBgdCoS9mf0d3YQ4yls57G/UrnG/lkxe0O9pXyqgX4xfCtnOZCpfIH/
2tkbPA9e5FmsyqFu+HeQM7MiloPKxUYJO1tvnqX81v9Kthxvi37fwN5Wa9P0
t3V/7B+DDzngAtZaILuMfwPA0wKrTYfxYSr4mG9/TTl7HDyW8wvZexgbs+Bn
xyw21QzVjuNQZordoe7yHLQc/UnonAfHfasFNVmLgQtiVqvmwiez91P4B/C/
cf4S8NO+/dXjyB9FHuY+qyHrhf104q2DDiouH/4S+Cb+VUe3K/wt8EpiyExz
7k3OTEpYjIpVb1IB/pk97cJm8x56v8AvZH9n9C+y/xzGWyN/j7Wz4L3Im8Or
B/QD341ZrugN9ZYXY3a2fErC17Mxi1094HfwG4HlxkbkM1WLoc2qZ9Aq9Pf4
Vvv0x8fj3yfwc7E3DvlicK7k8DvhayBvFbVaK52BxPc99vcRxy7kWdiu6Zvt
AapP4F9Z6xC2GBXrYfZ0Vi2Br429A8ScGbEcO4XtABoWthqZjf4f2PguZD3m
EPp30+wudEdp6j/oDApZD3sMX3Ji9tdkQ7b0R/VXlXPN4PPhv4Dfif5k9Nex
NjNkNa86Zz2HvCxkNf1xZNdjFot6lgf/p29voze8BF6D/1fD9mf1dyuhTSGr
KUuRr0ZeL8l0SsFrfOvVo1lbDe4Yt9z8m7VV4KO+1e4M9ROwp54RspqYDm6A
P9NDNgNoFrgQt9zRHYU861nqXadZW8L+wqjV1n3wb8FXob8MW/nwV8E7Epbb
6unbwf95Njv0QH4tbjVMtewQNIaz60FTFB/+HUX3JPJGEXtDvaVmBM0KevP7
vNXpqPUuzRSaLT6P2+yiHv8seCJvcBH9KuydwV52YLVOPaMxeEPc/qJq3mZs
zSaGIxHb8y5nlcAPTbIZ4GP99ajVCulIVzODZgflcCmyFqrByKZDj3Deyrjd
vWYczTq743b3PdXjVevhV4StZ6yN2syh2UMzVKeY/Sn9rW3k06v4Wwx9lWpv
prc76ZlMPewVZC8FdnfSGR/Ym+ht1DP3c9ZwzvgLfBlaiyzPt1oiH+TLv3F7
O+WAciHDs7+kHG6uv6eaGrEYFat6snqz1lr6FrNi1x+8By6OWy7qzFL54lst
jHAf+33LIeWSetBRdDf6Vhv+gf/SNx/lq/6U/tY632q5av568AjNUPAl6nfs
7+3Z7Kk/W4f4t0Ol5Ekua9sCmyk1Wya4nz3geqz1T7U/qb+pGVWzqtYeBdfz
bBZTT23Pee/HLJc0U2m28n2bJTUDxNH9STNJsvWUM/jWz7OzlcMz0H0osLfv
jn41cLO4zS7qkeqVB3y7G83U5b7NFJot1OPveDYDahZUTp5XPiUsFv0Z/Z0r
UeuFmiE2I5sSWC3STKrZtJZntVQ9RL1kpm+zuHzuj6wsarOjaq5q72jPZhXV
nC1678DeRnfeRPKYzVLqkeqVD+I2e6tn3QevjVttV41ao3oXt7+vGqFa8bZv
s5zeaCv2gsDuRjNnN+yNjVltUE9Rb/kfDxGg4g==
           "]]}]}, 
       {RGBColor[0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmQldWVx7/X3XS/pfu9Z1xQEAWXRFQEnZmUuNVEERVQgjYQhbjgXizG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           "]], PolygonBox[CompressedData["
1:eJwtl3mQVdURxs+8NzPvce+be68KgsO+qSBiSYwFQUhFEAccRkFGRAyYSAQi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           "]]}]}, 
       {RGBColor[0.6930474506790265, 0.7351965980697337, 0.912444709395743], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnmUVdWVxm+N7753X717xYBDQhIj3Y4xgCiTFIMSS12OKAodoKIGidoC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           "]], PolygonBox[CompressedData["
1:eJwtl3uwVXMUx3f3nM45d+9z9t7C7aFSisrzpqmE7o2kYhJ6IEneKtxGckv0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           "]]}]}, 
       {RGBColor[0.7526904929541466, 0.8310263711528192, 0.9138043870565347], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmwl2UVx1/v/S33/t7tZ4hpIIkiOF1IFuWCCyAojMCAIiASkqlIIgYp
KiEI7lpMLtdGyxQHEWeSpT/MVFySNJeZXG4jSTNlmAsJLmUuCS3fj9/j1Mx9
73ne53fe85znLN9znqfvWYumfaclSZK6/rWKzm4kySPVJJmfJ8nt7Ulym56B
bUnynn4foedc8Qxq89xUjYcXSbKqliRHib5SSZLD60nycou/ha9T43bJ+lT0
mDRJ7tf4M8nfIPpmmST9xfOG6KSKx6+Kb6+eMXp+IPnflexn9dsjeh8tvuWS
P0Z0dcXrPq/5bRq/1uJ1d2gT50j+4Rp/IJ0GiP/3WvePmj9d/AezV81/X7+3
aH6Kxm9rPEjjFo17a7xONjigmSSnSp8Dm7bHasnp02o95kjOQaLna25B3XY5
Ut+u1Pww0UWZ9RmQeq9LNP+Y3g/R+3bRt6T/tNy2eVryr6v42+f0/rCeBTXr
8VvxDZS+Y6XPFWED1n1bcv4jXa7Vt/uJHij+ydhBfNPwkXSo7ZMkqeYv1vd3
1DzGdzdUbCPsc13N9v66nllaq0t7OUIyXmxY3tnS8de55W8VfUvfrdDTKdl7
EtMLRA8Q/zn6tkMyTtbaDfaruana+0Mt3gt2wl6nJbYX7+izk/gQ/0jRX+Ye
P5jbr/+uWrefN6zvu5K9Off8JtGHG7bhrtK2m121vTZUrcNcjeeVttm94l2t
mMz1DG9x/DImhoeKZ6H0GQJvYfv3Eu0p+54ivv1E99czTeMvN//3PfI3SO5h
el+jb5fpm6f07eWF4xnbniSeha22HfYa0/S4T9hsdfC1F46rX0lOm+LndM1f
orkb9WzTfJfoOPH9Vd92SeajNfsF/6fin0u+iOdOfddDcz8WT7vmZzCfOeaI
vb6KnRVa908VyxrW4nn0/FQ8x2pfe4gF2fBD/X6knn9J7o/0Plw2L2SzY9qc
nx1gg55PNL5avw8R71bJuVZrJJI/Xnu9OfRnH7cU1hN9J2qNa6THSaJTcvt5
sugD5Jbk3JPYHsQ8OVvV3O2SOUHvt+j7D8CL3Lk7LPSfV3Xuj9b4L63GA8bE
PvlAvO2bOsc+kYyPRI/Xs1zz3RV/Az94A16w7pCIjb+J9insa3w+VePdGg9O
nZuLQ9ebRTtkn9c1nq/96y+ZqbUOLcxziOhLgUe7NJ4sWVP0/d8l/4dN52ZP
zRUNY8Z8zc8T/x7x/DSz7uAFcX6J5tu131FN86LHQYFf5Fxv4qfpfW1LHe/E
LfG7W+9V8c/U76+kXpf1k8yxu1PrjimMEeNE11eMD/h4uuRP13tdvP3r3iu2
xvY7woa9Io9ekJx1TcfJzMJrrhTPKPnjIfkvE88TkvdP8R0n3UaljkHG4D+x
dmyMV+m35fr2uKb9xm/47gR9u0p6jBM9PnWs1DLHXWerY25g6lgB749I7Tt8
WJesCZLT1nR83Vdz/bkyNdaN1vyZhfEQXJyo+fHir2m+W7w7K7bJ4NL4di86
iP96/XaoeAfp97tjv2MLxznxDu7dUnPsrpFt7oo8wp7ULHCJb4hbMJxaQk05
STKekR5jiUOtNULz/9D4VM0PbbNMMJb6QM3m+3tS6zBDOl8sH22sOY+ebjiP
fyY5K8O2L+JzYlrjlyLGiRew7pKqv8cXYCmxju9HSE635n4im59QcYwSf8T1
zsjPPLdfMtGBmu8gfqTb4IYx46bMdgRHziA+S/cP74jeWDFGIQdsW1I1vuEn
9GEv14fOJzZdc8kHasZ7heMyyV1zRkYP80Tp/J6jdTvDhtPFe03q+BzbtG2O
idgbGTUL24KL4CN6z5Ruy6rGYbD8+aino7XeHeSm6P65efo3jLlLq8bwzTWP
k9gTMcy+8GFXxMb7La7f6Dw09Xtb2JJ9w79Yem8RzyLREZJza9j3VTBL+m8v
XRupkeDXVdpzpu/HRyyDueAttatvq2sGfVz/6OUu0PeLNb+wtL/7R3zyPXJ6
Sp/Npf22Q3tcL9qr7h5rTcV4Tl/ytdQx+gG1su56hh0mgEN1226LZJVgqei5
Ubup4WB4Fv3MhNy+pS8glkZFjjwbebGo6dhADj4EP/AjmHF/6XnWAdvIU2rH
q9EPMX5Yv+XU4oZ7CXod+pwFpWv5eaXjmpggHtgfNpwW8UKNBJdeq9jH+Pdk
7f0Q/CwfvaDnXXJW62wtXeeo/+PE0yaeHrntTX3am7g3BbuGZrbBnWEHZKDb
3Ogx/r8v2xs6P9Jwv7Ve6xyWO3b75bb58xEPn5W2zRm5+47HIw7As4UR8x/X
vTZ+uKgwz4WiayvuRYh/eg/ikBwFd8Hfp/TtpqrtiT4bCvcUs8MeN1SNz/Cg
M3ab2Op+Az70IC4fpBY3TCfIDisKxyk9DjFGn4Yf6LWpg+Q/uUWPQYwtj96M
Ho2c/7ynKJzrParGye7A4asTU3AZjKLP+Z2est05gG++l5qnO3CbfLsr+E+R
ng9I5jdlz/sq3id75LxBTrxZuP4/VvH77szjWZnXvLvdWFaGfPS5O/Rhre7Q
hzFnALB+p2Tvmxujv5S758M+2xu2NbbcWxhnwa3OhjGO/V+dGpfBFOrnPrl7
qZbcuLi5ar9QH9ojHy7KfN67UPS6pm14lb7tV/jMdpjoR4Xr45TU2M6YtTu0
9irx9+ZMURgr3hBd2jT+H0x+p8aYpZJf5sbHbxU+T3Cu6JN4TfaO76gP9C3k
L9hyWd1YcFrTvSg9KXlFfp1Y+kxFD5WLjmu6L6EnGtWw7Ipom96f0fzZmetn
NbBmXemcIreowawD9qwtXSsfath/SdS4oyNmwFH6I3pNeqROrZtpD0tTn02J
CeJheNN2pr+jp6QfJV7pR7LIk2/k9ssManRhnvbU5xByeiP94xfn7tLnDc4d
52s8S/Mb9e3pueWh297oN1aGPcEJemzi5qjcY/pucuz1iuvFJ9GPfqV0L7A6
zlbEPnUOfOfMTH6CjejCHPG8uGkfjSrdl/IttYX6je3oQboqrmfk1nmBvZcG
RoI11L41kSvYuVv6HC3+l0UvLpx74zPXaPCJHm5Y7tq9sXAvzP3G3LjTuD36
412Rny+nPvv3ifqVRC/HWmtDJjk2NTPO3VS4h6T2UJuRjczOsAnnLuwyJzfe
/qZhLAPTLos8oHYSsgNyY+PhovML15d5UTduC5n019ifOKYfb4uegLjYFDmL
n6lhYO+eOBuz3xm569d0+pOGzwicFVZmrluXZ64jKyI20JszI7UMXnKf3mBX
q/mT6MvBCHrJJXWvzbr00Mi5IrX+8KAL/t4WciYWHi/Rur1K95HjuIcove6K
zGd4+oEnNTc3dyw913CuLAyZ+IqzCr3IG2HTbzd9z4LNuDMAV5cFPvQojSfv
ZO6P8e866Xlg9Ewfa75WOD8rhWv7je3GRWoTcTAj6vSm2C+1j9ibGzUVX+Nz
fNMWZ3N6MWowuQqmsd/e4dt3o99eHjjWFXc41GDqLz3PoMAi6MDAmV/k7vmH
pO6LiUN6147goWegFlHjiTnuSHbHWux7UMjpiv4R/gdy83BmmhV1aoHs9HjD
Ok0r7B/6QGKAnv+CuvujlxrO07PEc3Tm3Cgk78mG1zgqcx3rjtpKffgw7hDA
oPeiV6euog+4QR3oEbk8qTDuTBb9c8M+pw9lfe6Rvjhj7Yw+jXPezLgfYR/k
GngLnu2KOwfO1s9FTtE7T4h3/LAsfEGvyh0U/RN9OucTevV5uXGCezgwHWw9
vulehp6GMxL77YjafWbcswyLWEY+e6T+UQf75r5z4ftO0e2p9dwsmW/HueiI
zHeTxDyxT84QS+dnxg/8ja/pOxlPTW3LW8OexELf4KEmr4339VHjtjTcb3ZF
PJxW+NutcT/BfSK9OHela0IHemnOQpyD6Amo0yfE/dnrcR7oF73oDv2+qWG7
H1y4VlEn2uOuiTwDxx7N3Q+PLJ1rH8X80qg1xN6uoPiRM+70uC+qRP62xT0G
vQixwpkZ+Zz/OPeXcfYnv1l7TPikjB6MuCF+iD18wHp/SH3fA3aBZ5yFyIVJ
3FEX9sGAqJ/EAPUUTAFbvlr4vIQul0re+NI6c7/y+V1FxBXnPc59w0vXM7Cl
K3NPDc6COfwGz8zcMUFsDBY9pXCPxJ0xfvs06i/3CNwn9E9tsyzsdn3he40b
CuMyPPQq4CM42Vq4XrNX+rOOyN2xcR56P3J2cuTmPdLrvwip7Yk=
           "]], PolygonBox[CompressedData["
1:eJwll3mwzmUUx5/e+773Xu/y+/1ESpa6iuhS3NRFJVzLhMLFFaKyNhQqSUWo
DMpM6dZMm8mgzJSlP2SNkBZNITOJZkqbpSxpL62f73z/OO98z3OW53ee5zzn
nLds1OTqSakQwodQGuqUC+F3FlrXCWF5EkLfQgiXwf+bCWENuFUUwtTiEM7A
vwZfAb8L+SzW2oNfjUPoAh/DvwZuzFpj+AnwTcDjoGr4tfDjwePxsSnjtbHg
waytgf8FvgPfchf8m+gu5eO65kPoxtoq+HvRSdCfhLxeUQibWZsC7oF8DfgQ
+rPQr4kcSzm0LDEJd8P/e9kQJke2XYz+XvgM/IWcw1DWisHr2KMO+M6SEBoh
bwRfxn5bWbsH+QhoBfhZ7DuxX0vkC/i2dfhoh34XzmAGtrXwM5BvY62A/mp0
hqF7C7QWXMX3jASPhvqCG6LzNrgZ/qeA5+C/OfY7CpbpTHQ21dAL4B+wqSD2
Qcg7pvzN68E1Bcu0Nhj8KvQBeDbyq7AdCH8SvhKqBq9irZbvaU+MK3UW0Dz2
3oi8Lv4fjBzbTuxngLcTXxNkN8PvAI+HtqS8Ng78KDaz8JXBRxVnPyjy3T7B
HayHb498MbZ5aAP7P4l8J/73wy8Cv5W17DfOcIV8w2fhV/KNQ9AvQqdfxjmW
ApdBm1I+s4vAd0e+q6HsX8r5pbAZi/517DEJvgz+Ufgd8G3xvbrgXK9hv7Ph
L8B+GHxzfDYFl/O9tfh7CroB/srIZ7kQ/23wtxd+DvEuIb5NxNeOtevxPR+d
rsiuiPxWdKar8d8ZnTr4n4HNbHxvKvjtKKeUW33QGYL9HXxPBfF3RT+P/kz0
H0a/M/5fwtfA0hDOS5wjyhW9Ub1VfZO+bQz25+GrLfwTacegWHaw9jR8B3zu
QdYDegV+IfqtkFXAH005BsWiN6i3OBv9cuQz4b+An4l+Gfy7UFf0f4XeJJYm
7LEP+Vd87yfgttCJlO+wv+4H+0+Qf4O8AbZT4ffDlxPPd8T7Y+zYJ0JtwQ/l
/baPo38QX8uhJUUuXkOI/374KUU+o8rEd6y7PsSek3XfyA+mfAZH8dcO/hT8
f9gMUP1grRQ8CHnP2DVGtWYaVBdcjo8Faed4xPcey9m2HvJ5iXNCuVHB91+a
8xvXW1dNGw7+CZ83pn2mrZGX5L2Xappq233QHUXOiasS57hyfRV0E3hP5FzR
m90NbpFzbDqz3vDF+Msgf46YB/J9HyP/HP595Cekj4/T4J9Za17wG9RbVM1+
B/1+6DdDtgKde9Hvhr/68A+wfwP020O9i+zjSnBl1m9HNeNWYpuIfndkG/CX
4OvvyLXkGeT/gGsS1wLd2TLkE7E5UuSYJ8TOQeViLTrb8T0t8tvVN/VHP7Dn
mIzf8Fngc7LOLd2J7mZU5FquO6xCv4a1RH0N/X3gAvqtg990Q/ZLwzcNriH1
4E9i3zLlPU6BDyIfnPIZ6Czq5HyWd3FfFyOPCq79OvMCeFfWtfwPaAt8L/S/
Rl5NPjTgQz7LOXe1Jlln9nywxD3iOvDrUFPkI7D/El/Ps+c+vu8F1Sz83ZdY
ppo1Hdwi67upUf6D+2CfL/Kb7At+Efu/0q6p/fKuSapN6vHq9aNZey/tM+iM
/ePENDLlHrYQ/DDyZcE+HwGPjdy7exJPb9XCvHOlEvlw+Cr1i2LPDN3APRO/
TdXE+TnXcNVy9aytqn+sXYuva6A/kF2Nv8eD1/6Ev4CY22Fbi81N8Avwua/Y
a5KpRqtW99J7BX+Kv0vgW0A/oHsAvmWJa8w9+J4O9QvWOY18ZcGzjO68F/gw
a4+BGyE/An45du3pwNpy8EHdT6lnHs0+3RO/ffW4uezVMHEt1h3qLmsj9zKd
6VPgv2LHqhp5Bnx2wbVFMSv2Y6z1SbtGNcNf44JrrWYOzR63af7KeEa4FbwM
/UXq5fBLVbvYv1epZyLNRsdj9/Y2rJ0A3544Nl3LeH7OTZybTVTDEtdc1V75
7KN+F7t3HMDHpaq/kXu/3sTMyGuStcDmMPjb2FgxBOIpTpwryiHlUmXBtUA5
3SHrGqVaNZs9umNbFRsrxhjdGzmDY2nf+fzId6y71h0cQHdz1nejGv4G+ufH
nlVUgxqBV2XduzXzaPb5KufaJ5+/6m5y7j3qUepVx9X/9HZVL8FX5/yW1SOH
qN/nXZs0s2h2GVpwbZ6qHGG/jrF7n3pQJ3B95NMznkk1m05I7Fs1eW/Ob1Zv
V3dWkjhnlbvKWeXuhqzvVj1zLb7m5Nz7VTO7JJ4pNVvORb83+01OPNuqpkwB
fx/77pXzLbGtz9qAUs8Mmh3Us9W7NYMOAF+e9VvTDKBZ4HTsXqYZRLOIZgLN
BprZh2Uds2LXTLuR77s+9rcoZsWumVmzs3pe36xzTLmmbzgHXBp51tabKwFv
iz1LagZ/C9w8cq3VTKfZbnfs/xKq4R+BL8p5tlLN6YL8f08ghmk=
           "]]}]}, 
       {RGBColor[0.80726725, 0.861883, 0.894034], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mH2wlVUVxl+495xz73vejwv8IakzcCGQqwIFF0FE8AOVgJQQi3CstODy
4QWFpCmnTMgECmICvTjTlBrEl6GGxCUQRGoms4JGZgIiy8RpIsvEMSOn6Pnx
rP44s9a799p7r73Wsz72ab1r0fSFPZMk6eqRJA2if25MkpFi+uu3VxMv6XuT
6KIsSV4Rv1D0Bv12SnZ4miTDmpPkhH5D9TubWf5zosdj/KzWXlFPkndEf6Xx
P4oelcwR0Y9p/Xrt0yr6w6YkOdboefbaWUmShzR3b2b5e0T/1GAdWHuR1szU
/I9zy3PeRI3fL7mTkvmS6Be1x9drPmNqaX6K6A809x/d99vaY7n41yS/TLRs
MN9D9Gnpc0ryu+A1N1Z775P8Qn2n2rdTtKvRZ72vuR2SmSD6U8k8yD01/lXR
+ZJrkvw80dMNHmf/tkL2k16DJHNW80uqtveQwvwloqtadF/psVJ0sr6/pfHB
dcstqnp9H+nYLZk3tOcHC/uqWTL3it+s+Rdlnynibxb/F939Wslu0doN+q42
mL9Ra+7gPI39RPL9Nbarant0FObniM7Vb6NkxknnNVXrw74DJXeANeL3VLwe
ubVVyx0Jn38j+OXNHmftL/X9Fe4lOkr3nCv92lt8H3jsd7JmfICN9brDH/Td
VfqsAVVjkfNfCB0OVv09Q/Kztdd/5ev18suJiv2KTwfmxvrKzDbYGnZ4q8Hj
4P/azDbElqMkv17r20VXiD6s3yHNbRfdpl+H+MU1f8ODF8bB6EytuUrfn8gd
W6xlf3CzuOJzP5D77L65cQJ2we1S7dkZsbCkYnn89EzVMmBpjGzxtvb4pNbe
rt/V4meJntP8Rv2uSmzzrzXbhtgT/nc1/5jDF2/qvtMk/9fw7/KQP6HfJo1P
ThzDxPIoYSzNHd8zC89vDJn9DdZ5vOYWVGwXbPKE+McZFz9aOv9D8w2Z7728
Yj9eltrm2L6Xxh+o2I9TI96J+8bMsb5LtEt63iJ/tev71ZqxQWz3jJgldvdo
n8WSWRpYfaLRe06UDreKvzV1DsLeX5b89NTxMVB0e9Uy+Oj1ms+4Q3NNmfdY
rLuPzewTYmhdaryBO2RZw/ej2mdt6Dkys50mFr4Dd/mF1vWp2t/4ui7ZS3T3
bnBYeO2HM+cL4n6AxnakjpuRhTH9eui2oPAdr8mM667Q/2BqnxzW+KOl9UJf
1p0KPZlD5sXUWNsecUEueDbiGuyAIbCBrw80WOe21D6kPqD7KzXbfkVpfnnq
/Lezatz+vuZ98Ncx0TatKTT/WGl9NoiO62kb4Dvy7lGN79X3ytL8Q9rz58Jh
q/acV9jPRfgarL0feHtTcwMk/xvh9ruSvVJ54H6Nvxs4BI/IDqq5zjyn+Vbx
/Yi1nGQpG+usvxeW+ZtoRWNXNNnm+3paflPQAcGjA/l9eOS6cxGP23OPUQeI
G/YHE+i+P+5LDO0P22KDPTEOXsgR4PVl8ZMajYMbU+/dO3W9ARPo1lq4XgwS
7V9a/ibJ3FOxP9gLm5Jz705sB2yA3U5GjsBHjVVj+v884+SN++rO0yNbnBfI
D/8sXZfmRm0aUTjPH9d4W7PxTU6YnTuPd+Qe456Mn6wYQ4yt0ZrjOmtFaozA
g7lP5e4TPi16Ue5ccbHoTbnt/lTuOr037kWtINeA0UeijlBP+uXOPysL70cc
YnPw/qPA/IrCOftm3W+L1vxLa7eK3le47txSN/ao1/hwmsYf0/iH6tYBzIG3
dn2fIX8qRh6vepx8TS3uG3W5d/hxh/Q6VprHt7MivogzasuQZtsK7GND9ATL
jJP7btfYNOk5NDHevxc6bKhat/M1SXo+CV833uDHR04nt4+rO16fjZilP3om
+P2p43Nz6ThgX/D2SNX5jlxHv7Y26n5HxfmacfC5IXQ43dNrGG9vMn8+15fW
/0LRd6TPZeLPFPYjPL4cWfediePncsdkt/RalbvePxA96vDoRenFGN8VeYs5
fA2eK6E/fVxRdU4/qH0uEP/r1NhvDJnnc+PkJY1Prjs/zi5s4yLs3Dt6tcGB
q6HRow6Lfplz8VVb+LFP6pgblrlXI7Y+n7lfGFYz/t4tzL+mvS+NtdyfWtld
ce2cIzqn5r2YvzTijX58WNhhaGmZy0uv2x1rwSA8OIReEJjkTu/VfK+P5K7l
raWx3hZ5ivhDD/ZZ3exeGfkW6XpYcgsyvw14IxwujQH8T2wuKbyeOJ5Qd5+a
KJ88nLo2rJb8kbrz8vwW91KsfT41fTv2ubxuDJ0pnZ/w1/lev3S9WVcaA/if
87HPkLBhd+7YJEb35N6T3go8glEwebf03KPvzsJxgjw5eU2z74yNZkUP9kLq
3Dc/8g/1mLq8KvM7itjoKdkxmWv0lZlxAkbI7Ydy++CzuftZepcZEd/EPzE+
PHx6IHp58gj+epKYkS7fL+0f5vdHHiIfod9ndIen9H1n4fgGw8T16MwYob+j
B6BPJRauK40HYoJehJ5khOhvU+cg6jBYpcelNx4hO35H49ML1xzqH3VqZdX9
In3lg1XXROZGF/4eI/qz1LG0u8VvnDcijy9LXRu+mdsP3YG56wrve73olibn
YurloOjXB5Mb9Jsrvpq7HhKb1OhT0aeBiQFRF+u568Or0ReNqTtf36b989y9
eBFvJexG7sWWfcMH9IxQeifsxF3Jb7flfiN8PDDSGdiYFDFFbIG1sYE3etvT
sXZ3br/PyI2jXoEHcHp14J+Y64y4w3bYcEZhH04IP74X9Ys6diLezuSjrnjL
onMv3Xeh1vYv7EP6+HGB93GBeeozNqZml7nve33pd8npwBL6z6v4DjcU7nPo
p1izIN5KxAz5ZUK8NagT3Bf8kpOJYXrO5fFm4U7/jjW833ivXZj7/4Oj8R9C
R+CLnmpZvPGrssedLcbHXaK13LpdnBoXHfF+4e3DHtSs7aXP2ibaI3dflIge
Sq0v7/6nc/dwU3l/Ud911rrM711yMftgb+7JmmsK6zaw7rfHeaxIvj16JHql
pZnv84XMuYX19FWcPyd62gXxPsAfc6Jn46xzmeOpX+ke4OWIO3o+4rAzc+2d
F/3hR1P7qQf5uXDPM6nuPpa+lh54fuRLMIaO7E9fMq3u9/bSwudwHv0G/dRb
8T8S9yY3gsnN0dMf0JnzC2N4ivaoV9zfg9+tmb+3ZR7bG5gmf40P7FFD9kX8
sjc2wj702sQ1vfXxwrnjROF9V4fMwOiH6YtnltaVHhC8o//g8NeayOf/A7rs
eRk=
           "]], PolygonBox[CompressedData["
1:eJwtlmlsVVUQxw9t32257977HhIjIgldKKgsNbQsUmQXWUrZtUqCglA2KVgW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           "]]}]}, 
       {RGBColor[0.8608307500000001, 0.879745, 0.8700376], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG2wVWUVxzf33HPvOXufffaBJgJ1vLwk9KEMuNwLOjRZk0oq08VmKstp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           "]], PolygonBox[CompressedData["
1:eJwllnmIVWUYxr+5M3eWc5dzbSGtwEzKkDJJx1GYMCJTM0kNykooTUmt0dzG
snIZx9l0zGaxwkgjmlLURstJcEnJUhRbCUnTXCiajKJcSgPt9/j88cLznXf9
3u9dTo8J08dMS4QQVkMFUMiFMAaQnx/C4FQIc9MhfA0eCasS3Ar/v+IQ1vNt
B/wnsyGsKwzhLXTuht+SCeFUMoSzeSFs4jwYWgOvtiiEW6IQquEvxGHXkhDe
xtZA9CcgfyffysAb4hCGgK/F5kZwE/Ink7bZDN4M5cObhL1u2BsOPYj9Q9Ac
fA1KO/Z64h2YdkyK7RRUDV4HHQb/TnxrwR/g43vuMxD6B7wzY9+6k+42EZk+
2BqH/wvgcmgV+h3wJ8N/Pu3cHCXmGeCexLOgyDkcA46wNx3dlZzL4DdAneA2
dO4B74ZfkG+de/G/m5x0kJt5fJtPfm+PbbsRnTvAvbH5ctI5VW6v4fw05zrO
vTmvRv8G9F9E5yK8r9DpWuw76C7KmXKnnCl3DfhYgmx/dNrQXQLtR76ab9Xg
Zug851/J10Lkl0TO3VF81mN7AedfOH9HvA3c5TDfuiNfRX4G6W3R/xZ/Jdgb
D96OfBO+c+h/SDxlyM+CX4bOOXA58ZyA9y76Y9E/nLWvf/HxA7gO/T/zLLMc
+RfweQBcio0O7NfJH7Z2EM9ObK3inOJu59BZju5lbNQQyzF0AvrL0D8C7oRf
BX8ZOrXwB6Dzfs4xKTbJ9IO3j5j7gjdjfxvnZvhFSfdIU+w30FsoB8rFF8gU
JRyDYhmPvw7kH+DbU+CHoNKEa/qjjO+su6tmVDtDiamcUB/lfjdhr0/atTCW
89XwVmLzUrF76lN8nY9dy2XIlHLeCn9FiXvqAPIHsR+h24aPJ8DdY9tWD17G
dg0+SwpcQ6qloTnnshZqxN6rGefuD/JVg703Yr/9z9h4E9wO/0d8NWB/CPbr
sfkx8deg0xPeQc6lSffggJRzqFzK5w54szlP5rwXugvfXfg2pcA5P51yzah2
RvEtAa7Axyf4GoHP58AziGknsWSR2QB/IxSrd/n2WeRv4ikHysX+yL15Hd+2
wKvKeXapBxaD63Ou3UPIN4CnZN37OeLbx32mob8NXhf029Hvn3OtPoN+KXhx
5NpSD9SRnwbNG/Bx5FegXwi9hv9OfCQztiFb+6AKdHelnWvpLI2tI13V+Fny
0cK3jeDj8FvBX0bOhWaKZktTZJ5qtA1b78Tuzb7IrAE3wz8J/wS0knNnyr0y
mvdvJ/7K2G+vnM4Ft0R+63Z8ToKfl3bsj/HGI+FtiTzLVQOqhXFZ19pFyYBf
j+1LMSv2fjnnSjNkTso2ZVsxKbaq2LtGM1GzcSrfOuAVcp/30t4p2i3qqUfA
N0aORTOmKGMZyaqmZmG/I/Ldj0Gb4Keg0ci2onMzvBa9X7F7dnvKb6y3flg1
AH9e2rulFZ2X0n4jvdVeqBLZas6n87wjtSvXxq497Rjtmq7IvILsfKibdmHa
vrP4WAQ+GHk2HOG+e9Tb5GxAkXtgJry/s45FNs6ov/j2V55ngGbBUL41FjpH
ylUvzr2Qn8m328AV+PimwDNFs2U2Mc0odg3PiT3zNPtkcyn3nxV5tioGxaId
oV2hO9bDvy/rXlcN98P2rVn70s65KuUdpl0mH+Xo3p917hXjsKx7Tr2nNygA
D0s5F9qxE+Hnp93rV3YE8Z1JeTdpJ2k3LYq8m/RmervhmjEJ33kY+PGsa08z
ULNwT+S300zQbNAO1i7eSjzPIjsiZayZMpXzJXwm8r1jLoN/wmZlwjvzOPhE
xrtWO+MkeE/Ks2s98UzMuYfUS9o5v8FrjD1LtMNqieX6jGtBM1KzcjTn0wnv
hFEZ/yPpX0k+L0Se6Vdme9Kz9POUfekfSf9KPWLvBuVAuTgbuzZl80zsmlJt
6U674P8PhGli9w==
           "]]}]}, 
       {RGBColor[0.91439425, 0.8976069999999999, 0.8460411999999999], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVktMXVUUvZfHg8f9vPdUbHToAGNwZlKNRgNqIhJN/AxMbE38lA4kEYNt
AdOEKFBKP4KxtYZCQBNp0yim1QjKp4LFtpQ2KVBt4gTrTO2glk7aGOpaWavp
4OTst985++y99t5r3/veevflppIgCErDIMhgfxD7plwQbIR8JhsEVyGfgu6p
siBYzd3WUb4L+ivY/8XKQZ7P6vcs5Noy6albDnWH50egr8Tqgf3v8d86yAcg
T+G/SayHse6EfgHn1+DQot/I2eaTZZJpu9byXFF2zkVB8Ecq/Qr2zqLsdGA/
ht8l0I/hzI/lQbAe997Gu4/l5BP9OcKzWAOhcNgL/WXo9+HuafjyCfbqnPTP
Q78xj1hw7hz2Z/PSP0MZui9tsz2GD3hvFj78mQrHS6nwo0xMwjL5RpvUPW39
RLl87Yd8PzAZhw9jWNszwmrCmBPvIaxmyPWh8SyXH+9D3hIrjpFEMTCWX6B7
I1UO3sQ+XhoECVYF7qxglUA+if0gVkdGPnRmJBPzqFS+3Ahkjz7RH/renZH/
u2LdOYTYx0p1h+fnoevC6g2Vz07bZEzbbfNEqDP052KoGqyjb/D3gax8nYb9
CZz5FPY/L6DGEPMX2IdxLinR+Z9D4VODdQ3nU9z7GPHOhXqjFuso7ofQ/+Vc
TRjz5lL5Sj8/iOT/Ppz9CedmoD8A+e9Yd2ljKiP7rB++QXl3QXGExpbxrTnG
r3LCjrjtiYXbYdiZLlf+aIf9xtiZixgxDTqn3AcsMyfMEzFkTvpC2WfNMZ6O
gvAgLm3Q78hIZo6GXTvU03/apZ+vIN4R6Koi5Y852h3rnX73DmuEtXIP1iXn
aCf0Qzh/AX53pcrpefc1sSOGq7ATlcgW7fT5DH0+7zqgzJ28QC4iByw6lxdh
+7esMBmyjv7POt+Ue53fRshLlivs54rxHK0Igq8rxHfcJ/1WVVZv8Azz/GtW
7wwX9W53Kj5bdsy0Pee3yAHkDvbyit8jJswr87sXsedKFDPPE6d52ycnXDXH
kt+umD9b8N51nH0HuRgoqiZPxrLRazuVWfUCa2FdVn4zzw1F1dkczm/OSWa9
0RZtHk1Unyds61Hw1xPQ/15Q/R4xH7Ln+Js10oSaOozfGwLhccZYEacLjuXu
rGq+y/XImFkDg67jWnML66DGnL9mHqHtQ7Z/yhjS/kIkrv6hqLuLrvlZyzW2
v+RcnzJ37DSfLLnfqV82n9S7Hnhm2Hr2Rbfxo9xaUE+2YN9WED9sxT4Zq1ZO
J7I9aPtd8O8scNuBvToRnpXw/ViiOPen4nLyCzGfSTW/OMfqce45nL830gzh
fOpxX/S5j96L1HNrecV90LGPJppHzZHmG2cHc0xuf6RcnPldKmxfwN4YaS7U
5YVBS4XstmJvszxWlNyG8x/Fmo910L2YKk8vpcKNWDHvrCe+2RRpHtFmvW23
2mZ7uf7jnHo1rzhfY93h7mfQvZ5XHoadI/7PWcbY+B/PHE81dysdN/HmjGEN
sQaz7h3WMfFnHvqNCTnnJvS1/MbA/rh5st3z5Kz5v8v+0K9tifLC/PCNsdLb
HEXuYE815MQpt/hk1HrOXeJMvGl7wfY5rzj3Of9v3SH/sG/GPS+qzMM1iRbl
6kjx8TuHMZb5W4J9SIyJNfFlfRDvLa6HRvfUVKz621+Ujw3mBM6Occ879jxn
EOcLz1H/YSQbtMUcfwPs/sOZ0YJ4oMzcdSPSb/IlbW+2ffYt+3dDXvVNPL9N
5e+Ke5F48BuL/Mm5znx0RZq15LRdkfpgzH4m5qQK9x/lAdfjjGuSnDjhbxi+
T5/5DbqnIF6bSVQXE+6X3kgcO2D/mRvmrzvS90ef+5V1zBq+Hpn3iqpT4sa6
pA3yIDmQc569T347HotXezxXyd308aGisNoaa7ZWmVcZI/1kbEFBvXwzL44i
1zNW5oW8zPz+4/t3IK71Oen5P+PgbLrs78Np+8mZzO9LYsqY2Besn9WC7l8j
/yXyZ9IcMO3vk/8BUdC0Uw==
           "]], PolygonBox[CompressedData["
1:eJwllEtszHEQx2df7dr//neXrMbVoSJuiIhGk5ZEhYPHQeJxQOriUFmq5SL6
pA91QFxJlIiQ9LWSxm73gFRaN49jcfM4aS8Vdn2+mcMkM7/5zndmfjO/38az
F452RM3sABJHenJm1ZjZQtKsD/11YPYM/RyyDXsuNMvXmf2tN3uRNZtGEvg+
JMxWU2ZbwbRj/4LrErFV/C3Y18C3ol8lvpDwsxp2W8axo3DuR3+ede5x7AX4
VrB3gD1PTDexVyRr0JEZcnUGXptyKvcM+Dr0T+D/EP8Q+zd8Efia4L9N/BK+
NM2OoffmvNd1nE2kqZmYDRHPUcRn8O8ldg/yDXwnfLPwLSC78Tfi30J8FP8E
/sHQc39GboQu0huREvxrkWjcc1wk14mM99oERzNcb5F33H8BzD3837Ej6OuJ
nyL2CHxP0DvIv51ahvH3gW+Fowp+GTsFvoj8w+4PfTYfkQH0YWJCfJuxR9BH
wQ/GvEf1KoywFc7mAucQ1yL19dNvb9Z7X0T60G9y9jTpnCvge8C/JHYTHOW0
16TaWpAvcNfkj3tPP8C/QeZjvmPtcPXjn8XOEz9J/CFiHie858Oh34nuRjle
ETuU8lob8E+Db1ONSa+pHPid6m4fkf84d70v47ummWl2xZTPTjvygH66kFK9
c9wKvEf1qppK2AXw+YhjurPeo3rVnV/H14Gsmu/IZfynMp5bMSfR59O+C9qB
n/CdoacZ7HFijqV8ppqtdn45629Gb6cBjgrYStpnpx0eBP819N3Uzmv3dQe6
C810JPCd1+43w78LfSn0WejN6u3qTeltqeYu9IGcz1p/gP6C9ynPrRpPh76D
2kXt6Bi+Mmf3zf8E/Q2TyEHzmU2FPkPNUjs6FPib09vbSU9G/lrGde2EdkNv
Wm9bf4T+iruhv03tyB30/2WZpH0=
           "]]}]}}, {{}, 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwVzr0uxGEQxeGj9V24AYVGR0eitVo6H4lEVAoihNayRIgldlUaCiWxkYhC
/hRoxA24A1paWc8Wv5yZM2fmffsXVqaW25JMoq89GexMPnuSke5kFJfqC9yb
NbqSgY5knD+BEpb4V3bW+EO9yTodpi90kb7SU3s11NGQ3ebvoIxdVPDnzo9s
Tb2lLuTKtK5/5J+p3+i5vqq+M//S3+q/aZPX9J/4a9U7x9jjPcsd8g5wwvuV
3bdT0BI9ohtmm1iVv5b/cGcWc5jGmMwMfZB/b2Vkb/DkXoH5VsZeBf/CuDLs

           "]], LineBox[CompressedData["
1:eJwNzK0zxGEYheGjLhZRFBRVNWNEwWCDjG7NYH0UgcWsVYk0qlm7itnBjKD4
G3xUkUL4cYV7znue936ekeXVSrUnyQzGSslkXzIqF7DUnyzixftpMHnwnhpI
CvxhR++Yb8tbuc4rysmaHHLnszd5lneyK494h7jg/nI6brzrHwjnBFf+mrLN
b3DO9Hv9gFPHuf5j3rb7qr+h0I85l/4asmW3bnaqd/V97h4e9V19Qm7oNVR5
1/wVuenWFr7NvzCOeX0Os7hBC8PcadTs/QN94zJx
           "]]},
         "20"],
        Annotation[#, 20, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwVzj1LwnEUxfFraoFaOVoIPe0tBv8GRyMbXMKhVYuooXoLPQxpWeDiCwia
c8gtiGiJ3kC9DqO5Pg5fzr3nnN/lt9I+2z1NRUQT5XzESSFiOxexPB+xhD/7
5lxEgmd+YzZiRId0i1dDRWfankUG6+6keA29MmZ4G/YX8xOdQhqJ+7+o6D8U
I271erjUe5Vf0Y78Gm15CwNel96gx7+b5Lw3/Q69t/fdeJRX3d3zv5w9kb/z
PnVG5gyyyMtWeefmC+x4s+9NnR7QKu+IHuND90v3kH7TMe8HJfsCFtHVX5vc
xD9/sCe2
           "]], LineBox[CompressedData["
1:eJwVzr0ug2EYBuBHbNRP9AgaggELFSaNQSomHQ2GphY/xYBgMBk06UD9ngCt
gWNoWEjKzIEom+sbrtzv+/R+3q+Z4nah3BERKyx3R1RSETk2eiOW3NflFpuU
eiKKfHRFNOV8X8Sgc4Hoj5jTX9XLyVlvzHDEMdO86j3JF9mwW6fND1k7raQn
D+UjDeqc6p/pVH3z2/tflH1viiyT7Nl70D3Rrei9u9/auePSbE2nJq/db5IZ
V1yY3durJWfOebN7YLbPDrsMmXV6d8zv40yYpe1mnBfN8yzwbDbi/40yzIC9
T52S/h+//AP4zzA7
           "]]},
         "15"],
        Annotation[#, 15, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwVzrsuRHEUxeGtEXdDoqFg4pJIiDhmNNNgYgpOTmLiFgkSyZhCwhNoRkPr
JXSjQ4PQqXRC6RUkovVN8cv677XXXufkj86qp20RsY9cd8RJT0S5K2KkP2IY
f+YB/lhfRJO/QAtI8GX/iQp/EM3eiFukyLAiU8YSxnUs03l9CWbNmXmG/uhI
W9/Enbt7bGIL21i076CJbNXNk9wN75k+8Av8os4X8zt9pTtyJX6nfUn2kb7x
D+ghNrzzOJdP7dcxxK+4ueA10J6LWDPXdNVxjA83Nbk69rynsSo7R3d1jPKv
5C6Ruf2l33SCP4kpXMsXW/+Nf5EJKYE=
           "]], LineBox[CompressedData["
1:eJwVz8suA0AYhuG/FuLQg31t6hixYKfpriHEIWmjRGkkxc6iDcqNuAN2WFhI
nCIRYo3LkJZr8HTx5p3/m28mM7n95nojERF11AYjzpMRizhNR5TMLS7zGffJ
j/kE2VTEMKYHIoryI9mb+R0H+JTXZXvImOczEQuoyHv1i+5MylNIoyDb1X2y
fsa17hU+9O+HIjbszTlT4Txvck1vB686j5zX3+YqtvAiL+vN6pd4hu/kD/IL
3UusyVfxY93yhhXrCb1lnuSmrIEe5xII/Nn7xa17lsw33fdiSjauO8KjyHVn
jKHfXR3+5jZ/8aF/VfU7aOMfsjAt/w==
           "]]},
         "10"],
        Annotation[#, 10, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwV0bkvxEEYh/FxFOJO3HGukohFHFEscQZRkCBRCT06CqFwrFKtUVgKITQa
/gAaoqUicUUUNCoSny2ePO9855135rcbmV0Yn08JIcSRkRXCXHYIscwQ0lGQ
F8KHdVpuCKlIyCq4EuW4tX+DHnkOytQ/+qvtVeFYtic74aOcENpkrWjQUyqr
t1eHFzwjyN+51jteOcJv3CiPot561Pk6/pKPmNHMTfhGFAdI4MLeIV/yubub
nBlz9o238t3DcV7nPt7kHt7gXv7kSd7nCU7wFG/xAG9zP8f5ztwLdac6wZPW
+3zl7mNvuOYF60XErLvQjRXfNMxDKPTGfufXZKu4V5/qf+BBFKtLUIAiFCZn
JX9HLsOZGY/uOeUnXpIto8bcCKKyHf3tPKOnRXaS/I8wbf4v/6FN3o4Ofbv6
u9Qx/AOk0kLB
           "]], LineBox[CompressedData["
1:eJwV0LsvnmEYB+CbUMeiGjaSLkhMFqLSjxKMEqQWFolD6xhNWofW11rbOK5W
f4RE0pIwOiVOOwYkjFqL6xuu/N7n997P8z553/RPdI6nRUSSgbyI9fyIDpYL
IlZYYo1V8vS/5G8qX0ZUUZMb0a6f031jlnm+k5Oa58JMsyw1X+G5h6yiiGzG
zU0ywaG+X7a4x2uzrYURbXSn5u1v1hfpX1FMg+6f9wn9o3ziP33e9bJn35as
171ljFFmzNf59rR8Lxdko/wpm2S5fSPmPvGRr/pa/ReZkD/kO5mUB+67T5fv
dLKr37T/1r47bqgyN+2uD+bOPN/Lc/lZN5X6L+aX7DvVlXHConWJvtr7Ajnk
nEEG2LDeljvkOOuv/EOv2UzrF2SQTRbpzruS11wy7OwhPpg/5ohnhVBANA==

           "]]},
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], 
          LineBox[{1, 648, 17, 654, 33, 1952, 49, 2393, 2270, 65, 2553, 81, 
           239, 97, 352, 243, 342, 2207, 113, 4189, 346, 259, 367, 129, 273, 
           145, 161, 2273, 177, 2045, 193, 818, 209, 843, 225}], 
          LineBox[CompressedData["
1:eJwVzjsvg3EUB+DTSAzUNaE0qbDpwsJoMDQRg8FisnQlJEwM1AfwDQwug1KV
iFuCb8DiProlTK1NwuTp8OR3zu/83+Tty89PziUiIk8LU/URV4aNhojfpog/
frjUXTCir6Pd/JWMSDT7iB1dl+ymgxv3a0b1ydrNnNan5HprRKcs6R/kI7fc
c0dO30aPOcMzTxzrXuUbL/Q2RozpUmTt/XzwzrmuKr+pkPV2XJdm0D7AIgvM
6Lbci/5rW26yai6wwqd9wpsMw94PsUaBZV3ZveTdoTygypG9Imfdi3Lfvid3
a29rO0tup7LsdiZPmDb/A5deOTw=
           "]], LineBox[CompressedData["
1:eJwV0bsrxWEYB/AH57gfx0xCTkmZbIpNsbhTRIdMJofJkYFZMZHCSsnJdXD5
GyyyGf0BbiUGysfw6fs+3/d5f8uveS43slAUEfM88l4acVET8VIZsS13aEtF
TKYjOnRZWmojMmy422KTZ/2aXKfB/rD9dt0UdXbrWXa3Qp4nfY0uTb/dAVp1
E1TqqqggRTUP+oRM0mu3j4xunJ6qiCJ9CcXc637c/9JFN026IXbZMx+wz6L5
0Ptj745kJyfVEQU+nb9ptDPIqG6ML12Zt+UkKCXJqp07d1nfmmWGa/Mtp843
MmfnVV6a3+QZFxTM5zLv/l1emT/+k2nnJf/mDyvCNVU=
           "]]},
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwVz7kz3WEYhuFXa4mlSUNQMCGhiclETWE7zgkKpMgM6iCSihkVOvuu0ZIZ
wd9gT4NIZWkoZUxKNLlOcc99vud93u/8vtKe/rYvGRExioGsiPXsiDUcvYg4
xiF+4QR95k/8jEeM5EUMY0Z/0/kHNlApq8DfzIid3Ih73uX3nNCt5hnzLvd1
4gbTzlXycfMJXMv+ueuKv5uNyb7ypfMgf8MQ/tg5yIm44EP+becCi3op8yX+
yHOc5AVO8Dy38mt7zek3ODfxLLfwJDfyNDfwFJ+79wz76f+xt8fnnG9egDy0
6HXJUt6bxEudhKze99ehQ9aOtjTyQjuZ8hIuRRGK8QoN8hp3fdI9c8+d36d8
y0u+Yzn9TpTrluGz/B269Sv1Vs1W8CD7ydvYwlvdN+iV1+p9wH9pzUdn
           "]], LineBox[CompressedData["
1:eJwV0LsvnXEYwPHnSAwct8RBlRC3WsRlc2nLYGKTmrpJg6KE0WXxJ3QvjVFi
aOfWomUROREml0FDGDrREHrwOcM33+f2e543b93IzNB0IiKWsZuM2CmIGMb/
vIi84oi0+E9RxBkS+pd8hQP1Q2TMvefc/IiU+b/iTf6JL2ofeAu/sI3fqDGz
b9dkScQnTCEpT+GruJRHzYzhQHzPD9lvwhQa7WhAPY5xhG9uDRRG9Pi216jx
7g3Pc6edC9zFs/zDjhXe40d+wire6S9yNy9xD8/xEp/zuDufxW/trZVvuPfd
3UHuVTvRP0UTXqEZLW506L00385VnEG/d2n9F+JW9Upu43X1Uk7h2tsyM/lq
fRiXf0QD1uQT2X/iXbnZCtzI/yGp15jt+a4MHvCER9ybv+U7nJu5QI75ar7C
JZ4B1jZLgg==
           "]]},
         RowBox[{"-", "5"}]],
        Annotation[#, -5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwVzssuQ3EUxeFNhbSn57QkGGDAwN0ziOAFTMSwFVPeSFKXXl7DTBOjDhi6
G2pdBiIaXwe/rLXX/q99znz1ZO94KCIqyCURB8WIfSSliAI6/I38LYsYoS9p
xCtu5Xfo5yPm6GghoiY/wxZOzUWdFIUBugmteFtFx/xOu+jhCCWdum4Dl6ib
m3TWf/zZT+qsutGQ78jX+HVMyVvmpnyXbsiGdWrliGm7HN/XX8SVrOXdNd/G
MpZQlq3QCd1MZ5yW6C827dpupHwmLw92qMm3fe8Ch/bnNC9bcOeD/0QP3/jC
j36XjtF7bx7wiBk84wn/VZMzbw==
           "]], LineBox[CompressedData["
1:eJwVzrkuhHEUhvGjtV+BhIaEodJwBRQKzEwztiG2MNNJ6OwKLkBslaVGhw6J
PaG0jF6jEJR+iifP957/OW++6my+M1cUEQPIl0TslEas46I8YkI+50m+5EH+
4V98Y6YyYhod9g/kbHFEriJi//+2LOJD3vW9hya511sfVu2v4V3fl7cCT+lZ
MVuWe9wdy0u+x9wV5AdO2VswS/Miv5nfmb/yPad13/KLfMPPPG8vab9GXzef
8hlOMOdt1N41rjArZ9yk9CRRZdblpt1/taFRTqABde5rse1mXH7CIzbkfh3N
yOioN9sy28Sn2RGP6DzkYU7oGDJvtdeCP7gFOts=
           "]]},
         RowBox[{"-", "10"}]],
        Annotation[#, -10, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwVz70ug2EYBuCng5/QUpSIhZ6HQRyCUSIVm6WOgI0QktbgJxE0OAh2tFJh
M1AtIUETlRjMrg5X7u99n583X3ZhaSafiIgcHb0Rc8mIWVL9EUkefL+nIt7Y
74mYkh980uSLUT2L6Yg7882+iHs57y5Hl5mWHOfY94ksySO7D9kyt0nCd7n9
ptkbWWHd7g2W9Z+ae7a7To0XGhTUCnqLrLLGirsz/ZdcUbGzKm8ZYlv9Wo6Q
YZg/PYOyqPZqb9V5z9u77FB2/lXvVp+QWTrdPcq0NweYVPvW26LEgfO0/OFc
/YIn/bX2vzBGgzr/UfE8ew==
           "]], 
          LineBox[{2926, 3230, 3224, 3777, 2923, 3776, 3779, 3778, 2805, 3437,
            2804, 3548, 3938, 2619, 3153, 3378, 3377, 3376, 2914, 3215, 3214, 
           3222, 3223, 3088, 3087, 3258, 2794, 3148, 2912, 3747, 2913, 3748, 
           2793, 3542, 2792, 3543, 3933, 3541, 2791, 3540, 2790, 3746, 2911, 
           3745, 2910, 3086, 3085, 3254, 2789, 3147, 3221, 3220, 2657, 3084, 
           2909, 3743, 2908, 3744, 3152, 2617, 3937, 3544, 2802, 3435, 2801, 
           3765, 3766, 3764, 2920, 4142, 2661, 3389, 3388}]},
         RowBox[{"-", "15"}]],
        Annotation[#, -15, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], 
          LineBox[{2561, 3097, 2560, 3486, 3487, 3484, 2714, 3485, 3855, 3289,
            3564, 3563, 3788, 4198, 2665, 3953, 3952, 4019, 2808, 4281, 3972, 
           4195, 3011, 4250, 2701, 3267, 2700, 4249, 3010, 2812, 3445, 3444, 
           3550, 2807, 4253, 3459, 3803, 3009, 4248, 2699, 3266, 2698, 4247, 
           3008, 2811, 3443, 3442, 3549, 2806, 4252, 3458, 2684, 4187, 2994, 
           4184, 4186, 4185, 3233, 2664, 3440, 3441, 4023, 4022, 3854, 3483, 
           2713, 3480, 3482, 3481, 2559, 3095, 3166}], 
          LineBox[{2618, 2662, 3767, 3545, 3546, 3438, 3768, 4286, 4288, 4287,
            2921, 4143, 4144, 3770, 3769, 2676, 3255, 2677, 3961, 3960, 2968, 
           4178, 3042, 3797, 2969, 3450, 3962, 3963, 3256, 3453, 3452, 3451, 
           2970, 3798, 3043, 3799, 2971, 3454, 3964, 3965, 3257, 3457, 3456, 
           3455, 2972, 3800, 3044, 4179, 2973, 3966, 3967, 2678, 3259, 2679, 
           3772, 3773, 3771, 2922, 3547, 2803, 3439, 3774, 3951, 2663, 3775, 
           3154, 3229}]},
         RowBox[{"-", "20"}]],
        Annotation[#, -20, "Tooltip"]& ], {}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-5, 5}, {-5, 5}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyNnQe4lcXx/+8FhAv3ciuWX+wl9l5iQ89ijzGxd+zYSzSW2CV2sSY2bDEm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     "], {{{}, 
       {RGBColor[
        0.33397672886243995`, 0.12792855345845733`, 0.5864250111696041], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmWtwVdUVx88JAXKT3FxzD6TVqsROnbYf1PHJQ9CRQhCJiIp+aJ02vMLD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           "]], PolygonBox[CompressedData["
1:eJwtlV9o1nUUxs+a2+te3z+9v+9cBpkZRnbhdOqWWqYT/2SbaUY3JSpu6pyg
aE0tnEVdlIZSCnohhBYkWBcVXXihGVS61AqC6UVQeqH4Z5uFBIH45/PwdHHg
Ob9zznO+3/M95/zGrtq4dMMDEbEJGYacSREXqyMey0ecA6/JIg4NjzhfF9GL
3oV+GP0g0lSIaChH3JJ/VcRI8BjkZvzPAf6hElGNbw0yVIw4m8z9GslaiC/h
04fvbWKK4BV8eymccy25uol5KxfxJjIJrkZkK7if86zB9gt8l4l/As7fwGPh
+Cf87XFwBWngbAPoGfhR5E/wAD6jwXPg2wXfbeQifC2liPnknoeUyF/MjK+Q
bzf8eewVzv4O+Z6sj+jkvJ0UcAryDfi5ZLwf/1ngm+RYXBuxBPkbnJDRqhUc
9eDVJXP1kGMmuQroD2Fr59sg8c8mcx1AqjjfAvRPwZ8htegT0N8Hf4HcIf+7
cLSQ/xR872WumWp3Afs6xRdsq5YO7k+uTSP5LoCvIvPBu7A3gTs5z9voL3L+
Ic77LxwHayK+Qqah/5pce8UoVt9k6+MO3cSeT+buQJ9DvgHs7bV+I73VzOS7
fYnk4T7EtzrseeQw+KeKe6eI/WfdDf/d4MncsTn5jDrr1/jMgn8tHNty7hH1
ygjsv8PVjH8e/Aw+yznLXfw7wGcyc6tn1bsD+LRx3gbs/RX3tHp7nfod39cz
55oA32Zwa9lv+ZfuB+4qGItDXKqxaq031duOSo4Nvj0Mbsb+KrZH8O9LngnN
hmZMs7Yy86w9RcyKzDOoWWzjTl1F11S1VQ+qF5cm98JcpcC+vuS3UE+rt3Un
3U016X6Qmibn1kycVn2QvcQ3wjcDfKLi2dAMaZZu8G1h3jNwDbw9eRY1s5rd
l0uu1R5i5hE7WHbvqGfGCeP/eZ17dJH4M7+FdsBx8PdIFfYN8M2G7w/4XtFu
wudH+IrE/AceT3wBPFi0TTtGu2ZHcq8rRrHfZa61OE9m3jHaNSX0c5l3gHZB
Ab0PvTa5tzrQh4OHIcvAO5FJ4Bz5jtT5Dm3JNVatj6oGqg1n/iTs054805pt
zZBmqTr57OKs0SyX3esfiwP7bO7wQc47aQvc18t+a83MDe22sneJdoh2SSv5
voX/Q80EfG9kfjt96wEvTO597YwXwEuSz6oaHsOeS77rR8jTySLcy3nH1fvO
urt6VL3amNyL2jkTk2dWs7sPmY7+fPJuUg1Ui9OZa6uZnFgxp7jVQ9fxPZv5
LbTjm7D3wLcz5xqoFqqJaqNvrRX3hHpjDzFTk34azq2enYY+lLw79U+6BN5R
dC9qp2i33Cs4VjtkSnLNVDvtBO0G7Xjteu3sXmLvA5FF1+Y=
           "]]}]}, 
       {RGBColor[0.4150981865873199, 0.2689768603753719, 0.7004510335088123], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmQVsUVxT9m/2a+9b3RSrREUTLGJDiSzIwIOAiWAmaRZYQgDKhhV2SR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           "]], PolygonBox[CompressedData["
1:eJwllnmQ13MYxz92a9vdfuf3sxo0SiTX1IpKKtt06RC63F2OtnbTtR380YFi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           "]]}]}, 
       {RGBColor[0.4962196443121998, 0.4100251672922865, 0.8144770558480205], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXnUVVUZxk/f/cb7nXvvGW5miQkKBuaICjEIkgODWQ4BKiCIqTEqilAJ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           "]], PolygonBox[CompressedData["
1:eJwll3mQldURxa8M82SG933vW16MlqIzhNEBUyDrxHEATcI2BEUNg4RFxCCB
YVjEEsUIjMEwMGwiCiQmRlDLJUslf2QRZLHQSsBSI2gpEmMUREAxGiUkVanK
79T541b1vd19ur/7us/tVztj/g3zuoQQjrK6svI8hHlVIcw6N4T9xRAWsj/A
vq4ihKlZCL1ZsypDuBPjb8dyCGEi+ib227GfkobQA/0d2G+MQtjD2SgCROwf
wf419tPZD2c/KAnhRfZrCyHMIV4NvoOwua06hAlgvIt8NWsR+4WscpkcWdOR
X8T/MPirif8+8R8klVXILZz1RPcW+VwI3hj2L6F/g/1dYH1C/n2Rh3J2Gvly
zm4F7xZWJdhTyedt9L3AmIRvMzn+nvz+yDqB7kb2u5CPdwvhCfzPLdu3nvgF
5OPEvAr/evQnkAeDPwd9C9/zHvJB1ljkPuBPAX84+wVdfac9wLsW/D+Bv4N1
injdwewE+wdgFJEHlkJ4FttR5L8V/efCr/Qd6a7m5c59P/oFyGPAW8n+h9z5
B9iXUt9FibPRxP8G639dfAfdwL8XjCPoj+A/F90A4j0Dfhv5PIh/FTazsO3F
9x0FqxH7VuynYlMm/x6p7/5r4N+Ef8b+GunYj2VfgU0z8W7EpitySn59kBuJ
9zH7Y6mx+3FWRjcxNfZs/Nfgv75o2zWclchtJ9+4H11GTruQE/3m4Kecpcj9
yO/76DrBHA/+X/CfgP4QGPdgv6noWtA36luH4/NUwXc+DPnvxHwZrP9Sn3ux
n8MaiG4fPq3ag/kk2Ndx1gjWx6zn8d/Jup78r2JtQreNfRPyp2D2xb6DeNXE
2wNGXu0YO9B9Ad7v+PalnF3KXS8j/4Xke4p4G7H9A/oz+C9BPx7dA+S3CN8L
wJuMf29idBbcU+qt91j34H8/NiPQfZm5dhRDscZy9lxwjX8HOSNGW5V7fgr6
1sy9qpqYq9ixe/8+zh4l9kBibsb3JjAGINeWnds+9G+jfz73b6OaUe0sYv8K
2JvwOUBu53A2rdo9XQv2EvSvo78WvLuRT+mburmn1Fsfpe6tlXxvFfd3nJz6
Y1+P/kPkmZF/W2Hchf95ZXPHs+B9BXlEZC46hH13sB4CI6o0Z2xCnob+6+p9
9Idjc564T5wwTfUTu5bVM+qdcYm54Rg5bUf/Pc7qK9zjl4B/lhz649tMPv9B
jlPHjrEZhe108H6p35v6asK/V+LeVA3v5X4Osm5FHsHZEHSn8R/e1TX0z9Q1
ploTJ32C7UnWcwVziLgk4ptb+f5J+C8h3r/F19XmQHFhv8S1uxH7K5Dn5+aO
Vez3gfUGdzIEuYH1JvJpzvYg72Z9F/vVYLxKLqfxWQ9+XeLeU4+/UHQPq5ev
Qf8Ztj8p+i7EYeKy23NzoWriDuTxibnvQzAfx/5N7B9jP5B1EPu6snvjLJi/
RjdI/IJ/U3fuXlysN0rxwZ+BPCD2bzmOfZH9R6yWar9Z5+TmEHGJOORd8n8d
zBnkPor94MR3oLvoYF2a+A51l+K8Y7F7WL08BLx1ui/WTPybsWlIXOOq9TrW
XmxX5H7blHNb5BpWLauG12K7mLOjVX7TOrB9ueTfXm/mAeSfc3YG3VnW49j2
jc2lo8Go5Nu2ZO51vQlbkV8oOfZEfuPp4I9krUbezf0uRb+AO9vN3Q1TP2C7
LTZ3iyPFlbXEu7vKnChurE39VqvGL0a+H4w/dzPHjcb+q9hvKZgT+id+Q/SW
iCNnY1vLWU90vbCvQR6MvhG8K1n/Yv8A/iexvxn8dciLM7+dM8jvTuQ1rNvR
fYrNFvQLI991Wb+B3tvUv91Qvmky37YdfUeFZ5LFqWcGzQ4vsYp872jwVpDb
HvAGoRuaeJZQzQ9Dri777dUbrrf8kth3dTXrPPRziuaWnsSbhG0DMdr5ljow
x7A/VHLt6s5nYrs8N1e+Rbx25CORc5kK3g72O1O/Nar5KxPPYJrFxMmp3jfw
1lb6zdjNvkvZXCkOrUBuxv43wT3Zmbkn1ZsX4fNbcn+15LsUp7yCPDFxL+/C
pwX5W6yhBWN8E3lkZK4SR0bi+tx3v42cJrH/EZhLu/iOVyD/jfi/Ehdh85De
Ns1rlZ5xhqF/B/3TBddUDfp7M9eiOKoh9puit+UL9D/TbFf07PJjzSvksz7z
bPk+eBuQH4tsexiMh9n3waYh+A28HLm9ZC6YgP3ykjlaXC2OvA795sy+egPH
Fc0p4hZx5JncHCQu0pt+A/aP5r4r9eAvkO9jHa7ym6G345HMd62Z66fIt+Wu
Lc3AmoXFUeIqccxf2S/LXQvCaI1cQ6qlJuJdjP9TsWtbnCBuaEw8S6jGLsL3
4dx33Uq8lZlncM3iejNP8vssjzw7qEdXZH6T9Tar59X7mmE1y4rTJ4DdVDRX
PMPZvMw9pF4Spx1C91nq2tcbVENum4vmdtWkanN27tlIM7dm75qie109Nka/
V27uUs2odk5k5k5xsrj5+syzmn7D3rqvomdrzTxDyKUtc276j6D/CiNTzz63
8E3txPs8MZeIY3aV/Gbp7RKnbCD2OyXfrWpUtdoZebZUjbaIz3L3rt7sC8E/
P/ZsIY76El194rdAM+BlyOvI5/xKc9Ja5HbWzeznqt6Ql2WW28i3RP7LY+eq
mU6z3dbctawZbgO5vBabyzWzanZdFpkLFWM9tlfErmXN1AWwP0jNHZqhL0CX
J57VNVNkyHHZsdVz6r2OzLWiHFchz488e4izBySeATQL6D9gmXg9U7+delMn
R+559b444gh3OTJxb2rG/Af4/wdCZsuy
           "]]}]}, 
       {RGBColor[0.5737613661287864, 0.5435370519035629, 0.9097253540741593], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnm0VcWVxi9vusM7dzwXHFAQ0Y6AhuEhgyAgU4vgM4waGWRo1CgLFKMm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           "]], PolygonBox[CompressedData["
1:eJwtmGmUVNURxx/dM9OzdPf06zeo7CAuMGhQNhlFRRgQZZOBAXRkG4JoJCIq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           "]]}]}, 
       {RGBColor[0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHe4VNXVxue2mTv9nDlXEWyJsQJqYomiidgwicYG9iQqakSJJZEkH2KJ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           "]], PolygonBox[CompressedData["
1:eJwtmXm4jVUbxl/7DPucYw/vu/fOcIQylNCEvgxJgyaVCiUyE5IoKmMRGmiQ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           "]]}]}, 
       {RGBColor[0.6930474506790265, 0.7351965980697337, 0.912444709395743], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXe4VcXVxvfllnPu4ZS99zl4KWoEUTB2kcQEFDQ8iYIlliiiiYWiKBeu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           "]], PolygonBox[CompressedData["
1:eJwlmHu8llMWx/c5Oed9q/fyPM97crooFRUi5fIZI/fxQYUp18IMuoo6HSSd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           "]]}]}, 
       {RGBColor[0.7526904929541466, 0.8310263711528192, 0.9138043870565347], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1V1lwFVUQvSR5vAe+mTczLywlexCCmgSlrMIqoEqJRChBEcUFXMqAuLMq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           "]], PolygonBox[CompressedData["
1:eJwtln9MlWUUx58u0kXzvvd970Wh/C0h1USqtdlmrRQkDRCm/VJbbaD2w6Ur
jeXaalFM0RVYVmzV0lZeQGlBaaW4kkQ0zahmFPY7qK2RUuZSp9Xn23n/eLfz
fb7nnOc85znnPO+kypXzV0Sccw18w/hqA+fy0p3bmOZcU8y5Zr5nkVewthau
gm8h8jLW1sGdBk8Hz8U4z3NuD9+V4McznCtKOLcDfgjuffQ/Rf8N8BXwTeA9
4Dz5BBeAK8HT+IYIKJ21Pt+5++Hbos6V4m8Gvl/hGwFXxNpMdHfHnZt4oXMD
4P3gOvCf8IvBFeBl2L+J/BZfI7gW/gT8QnAZuCO0/x3/24n3YfCP8HXgcnAT
2IfP5GtF3pyw3PzGmbYgz2OtE/0uvgXINcQ3APcV9s/Dt7H/cfbKGOHcJ+w3
F53z8Ec54xzk2QnL3dXYFyOvD+M/ybdBvrFpZb814BS+mhOWu+PYtCD/y36P
wvWzRxe6TehUp5vNR+DlYf7a+V4Gl2ETgZuBzjzks+T4+vRwDX4Ta73Evgac
Yv+KkcRAXSQ5/6twD7DftcSeVL6xvQGbdHQLsbkI/irPZJ1BZ2mHb4RfwloB
/Evgk8MtJsX2TmC1MZz87Ew6dw94p7M7uxc5G/0A+QP8leBvjme+qvimJazG
VGu6g3L4QvSLo3aHukvVSFGIq8EXgxNRu4N6z2pEtVIMfwQ8KmZ3cxC+k/Pl
g0+AD4O/Bjd6VpvaQ3vNAq+CW87aJGK5JGa5Ubw3s19zWD+trL0ItwM8BvwN
eBc4R/Fz/js4w6XIq+G/x3YiOZhC7rcn7a5T6OxG/yb2e2SY3XE++p+xtivN
euo98nVE8Uat5lR75YH16iA535S0GlQtqifrPKsZ1Y56QL30NPr72fsQa88g
b4XvRN7L9wT4ADlgW5cJPoh8I3xh1GJehX0OeIB8Tec8Z9DvBv8S+levTQms
13uIp5p4fuWMNRHbowbuMs9su/F3G/q52E+O2v2q1w6xZx/6HdhXJa2mVduV
8IPYfg7+Kzx/O/42821Avw+8BfkU+22MWI7eVn7QXxS1etXsWK36jdiZzvnW
w+pl3aHuci36S4m/jLVRCZtJmk2aif3I13nGqb41u37w7S6nqgaRv8D+FPIf
5H89urcQT4+zmmjC3+1xO/tY1sbBLUB/QprNvGz8vZs0W915D1x2ptWOeiYL
+WP2GB21HlWvFuLzMfh+cBm+J2Ra7+iOxyO3wQ+B2zWP4e+M22woYY/FyA/F
rTfmgx/UrExYrlXzM/G/CPxchsVYDz8u094K1Wgx/N/EfE2G1YRqoz2ch8qB
ctHlW699CZ8FLsXHh9j/w1oD9usC6y29QS0xm4majXozeuG/1fzCtgf8nW8z
QLWiPXPhc0ZaLntZK1Xh8g2ifwx8AfJh3/ZSTY3F/zHfel1vUEHMeli9rJgU
Wz7+pjp7Q27FviNmvak383ViHR2zszjwPnwtDaz3VeOq9TO+xaIYTvs2kzSb
ZqMzC9tzns169Yx6Z2XcYtWeudgfiNldaeZvw/fdcdtLM+ou5Mkxu2u9wUfx
/0LMZrnepCXo13r2du3Dfwpur2dvj3pMvVYSnlczUrPyvsDeTtW8aj/fs1r4
/83g/N2+zQLV3Bj4hsBmh2ZaPfJrgc069Zx6L5W0WaI3ZSvytqT1pnqgBbkq
bnepqxqPfktgb7veEL0l533LlXpUvXq5Z7Wqf5Cz6D4V2Fulnn8SOSuwt15v
lN6qn33rRdXMT77lQLlQf+ut/w/ivkGd
           "]]}]}, 
       {RGBColor[0.80726725, 0.861883, 0.894034], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlV1olmUYx+/e7d3zunqe530fZ58Ok5hrxqqjCjLRhbOIZhQUURR5VARF
QXRSUAeimdKHIIEdFFS6uaKCaOrM5r5aq2wunVrTsqBC8UClj7mDfn//N9jB
zXM91319/q+Pe+Hqp+99qhRC+IRTx/miHMLusulFCf9zQjiFwGOVELbDHIb/
bxbCWejTeQg9aQhfIbeuFsJOTg/8PvjTiekJ5MegZ7HzGfTf0Kc5b2LzI3S/
hn4VvXF8noDXjEwr9m/C3z/wP+D8rDiQfRL6RWxugT6DzCbo7dDbOMPIrOF+
JDH/BU5jo30dw2YH3+WcafysbArhIHedTY5dOpJXruK3xBj/irqT2N/F/afY
H4Q+Dn8b9B7lR8yQ5/M9ytlQsn/ZHI65P1Cx/UNVYzqLwmH+j5Sd75epsZ3J
zFtXMX9BQwi/Ir+Zu8mafVWR7a6ZPxT1zsa6KOYzEVv5kS35GUXuY76z2N8F
Hcixd24I6+t9L19d1Ox39Fq4vwt6Cvpy6Ccyy8yH15/bjuypXrcQ5x/I3cB/
G/5+JL/9JeMiTC6DXxUO8L9PXY/P5zpm9ZPyUj1uq1zosdWR/xC+vuHuYb59
mW0ewkapsHw7vOcbraPcvy3bt/xuzIzVCnR7C8es2OeDZ3+d8RF9ouL+rKXW
fQO9V5C7CplV8BYWrl0H/CLK7Iy9vyliniX2dTPnEXS/I45H+b6WGcMr0JtK
3fc7CK6v5hpNwDsX+0AYj6D3Er5Uns6YWzP9eSuMZcjPgOFMzZi3cd8E/xL4
A/AvqndeyqWzsJ0VfNsL47kS+WeI6Sg+nuX7HKeC/O3YuCP3zN+p2DPnfg/8
DZlt/qD54u516K2pZ0CzsB/6ZOZ5fDt1/Nck7od38Xscv+/wPVg1vw2Z92qe
kX7ofcgvhl5S8rypD9QD53LnU8ptV/Y198JeNV4Sa3C+1tzPa/B+0NytRW4U
ujt1rrLZHty7wvnP1PtCtWuFtxv6GPLvo/db7nkYyby3pqNN7cI0cX1VZ9Vb
Pabdpz6oyy1zceKdeX/FM69dp97Poq52m+xr1k5WPNsH4oz/kphWPWVL8pqn
feUL+HREjLQXhbVw7incw918l2f2fTX0yxXrLgjeQ6NxF22t2dfe1LVUTddk
tqvdKKwezB3rUMRBtVBfqSfUG5oPYa76DsK/MuIm/O6LO6Qrzu543G9jZces
3lbPqffewv7i1L6mqp4b1VfYijcec1T/qQ+vw+beqmsxD96e1PHpzdE+U70U
5+AcY9US8bs2MQ7aBaqf9uiHsZ/V16sKx6OZWJpa/3F21GF8tQoTeEeqtnM9
dEPsT/Xpsrhj1bd6x8b+947Iv/iKW/EfSOMuKMX9WnWewls7V7gNxP2/KOqu
zzxrkxED7ayJuOta4+w0N7geqoXeQNHqW/W3+rwX3SF85dxdmrof89jDeqeF
4drMcyD72o3as9q3O+APxDemPve7p37dHP/F19vVVfjNupvvT1XP9Y3w/wN4
wjiJ
           "]], PolygonBox[CompressedData["
1:eJwtlUlsVXUUxg/vAQ9r7/++ATRRGiRGKoSqKzFRjJDYykIWxCnOkBhdqCgu
iIkmsmDGCRNFVhoVacHCRkrFgqUDooLWhCIog7BQA3EBBKTtwt+X7y1Ocs7/
O8M9452+ZOmilwsR8Ro0HhrKIi6WIi5AuyoRa6Dv4d8oRnwMdqExYgMGJ3n7
HGwmbzfDD06IeCiPuKka8cikiK/xdS5FvI7+Kfg92K9DXo/ND3V/m7Fdlezv
NG9bwEaRj6D/J/KXyGPIO4t+EzaMzeX693UpPm93Ee9H4j9O/J3gH6J/Frwd
fG9m31MmRnSCX+Z7Nhac427wr8DHrok4iLwOeX/m2NPQ70Z/NvK/6M8lRoHc
/kPnTvi/eWsG688cS/rfoN8NfqXkGOuTdaSrbxwB2wqdKfkbd4B9m7mWJ6DP
wFqSY50gn1fw1zQ5YnlDxAD5X0rOUbn+BD0Bvxj6GX4m9rfjqw25B7kReTLy
EcUg1jiaOxFsR+5aDIBvBStDQ3zfPnR2J/dEvfkAuoi8PTN/CbqKvAv7qdif
wr4H7EFqsobvPU7Ml3L3RL1RDY6C/wMdU++JfwP4w7lnRTVsTraR7X3o341u
F/2ZU/A3vQ3+FPgh8MPQ0/Cj5Yj56PbRs3vR70XnL3Rh4zv4Z+v1WIH/Nr7t
EG8tYDfyDYfhn6sxE9jOwMdv+FpGvD7wM+h/iv4nVfOqkWq1ANqLP8zjHeyf
zF37JuQDyMuxH9KsY9OB7UjZuWhmNDvtVWOqmWrXhs0S5MXQbLCVFfdCO6Dd
eiZ3rjzHxuSdUz8eRX961TOj2ZGPFuT5yZjmd23FNVAt3uKtFfz3smfjHvwv
BRtALpdc4xeTZ1SzqhnZAH9/1bbqkXq1DDo5wTVULccqrp16OlpxDVQLzcBC
bHvLnj35Vy9Xg3cUnZ92vbU+n6rpA7lvhmIdhB7LfXM0Pw3M/C8kcht0a8k9
1az3NDqXWbz9QayP8DktrHMc+Y7MmPQ1C531eW+CuuCvA8/Bk2ao7Bqr1nrr
Ry7mnvVtUG/mG6Zb9iby+eQd1a4G37cncw/VS+1oa3IP1AvdwHnJO6xdVg1f
hZ9Rvwe6mcPEa0FuLnnGNeu6OboluhF9mW+K5PP421Z1D5W/bI5h3498rmCf
8j2YvGt6m5W5x+pFhv5+9Ltqrq1usm7zCzXv0i3gz8Nvrzk3zbRmWzdHt+cA
+Gpya8/MD0KrkDeBTyq6B+rFXPB5Je+odlU1Vq01c9eDrUTnvaJ3TrsnH/Kl
f0xH5hus+ukf0Yk8JfO3a2Y0OzXka+uybt37+Pu14JpoNrSj2tWjyO9q3rif
ww3eee2+clSuemsDK+S+jZrRffjuTr6F8llFHkmeBe2c/i1fVHz7tDP6l/wP
o1MPOA==
           "]]}]}, 
       {RGBColor[0.86083075, 0.879745, 0.8700376000000001], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFll1olmUYx++97/Nuurfn/dgGfRhCFCNzWkeGgzqSdpIHRen6sCKIOog6
UTqIudBSyqKCmRqSUBFINsIOzFBzazYQOrFlkh2Ug9zWltQ2V7lp/5//Szq4
ua/nuq/7+vxf1/3c8vSLD75QSCmNahW1TpRTGtK63JzSlWZ/Qw/kKfWWJFNN
6WvRPaILot/OLD+ry6+Jt0LrnPRM6M7vWkWdT2qf0lrWYP540J9Lz0uS/7eS
0h8hs0TyX5Qtx13sTIb8HZLv1Pe3km+S7VdFd2p/X/znRe+oa+nsL907XLdf
J8K3beJfEH+79qPXKTbR74o+JHpe9EDNvk832/9nW1MaXJzSc9pvl419OpvT
vkRrp+hx7S257xyWnnbRq0QPiV6hs49FZ9LZIfoj0Veqjo1Yjsmf7aJnRH9f
cNzEf3PmuImfHB0smy6G7KzWSNH6DgZ/m9bxsvnX7hQyxwGfWOZFfyP6EnUs
Wxfyg2XzzxQtOxB6kEd2quAcDGhl4j+jXKyV7vvaUro3N++SYuxWzK+Lf6Ni
fKRiTLRXjRtqcGvD/7FRx60l+1qIuKYjDw9VHM/1untRujeVfHd92X5g+9OW
lPp19pVkLrQ6p7+K16X1p3Q8Jf5oi+0tlm8rq47vMem+oer41om+KHpO9GzV
GPu7yXX5UXEd1X5I+JmuGFfX8LWR+iqfp+rO/SKdj+bWie4HGt0j+Nyt7wli
0n5J8qsXKa91n7+idaBo3B2hj6Rzg3Tt1fdqyfcVbQ9bXY3G/JjokyVjTKJp
f929Qw/lFeeBfGwumT8imTZ8k/KuqutEve7JXdeToeefivN8QPyGmnELfk/X
bKs9eu62Jt/D3zbFkslef25f36g7ns1h95Du79d3f9U5XaoYTok/rDvvSean
ont0i+hfxL9cdT6v5lV2S6ILNWMErICZ5SXPF/B8rsW9zwwA7/QDWEJvX+SK
e92NvjsmubM6O699LDcewMVNVcuP584B9aN2YHkw+qI3sy3i+C16nxlwZ9Vz
5QnlbyF6nF4HIx+UjN/53DLIPiq5PdJ1t+jGqv37IXesV2eF9ocrngurwt+d
kSvy9GHEiL9gghjB776wNRMzilk1E31OX5GDnsghPUQv0c+p7PkO5vB9V2b9
G0Mf2GPeoGt75ACMHYu5QY7w4a2Kccwcxf47me+Tg02hCxzRC+ANLILJ1tyz
7WDMOmLdETUkdnb0M58GY3bRQ2BobeCD3C2O2XM25MnT1sjVcOhbmoy7vsjn
bPT+Qu7+xLdluW1gCz1HA6Pgk/k8GW8TfUDv0AvNNc8Z5g1v3UTMcOZeb/T4
y5l3+mJ91Jc606P9wV+Tmc8MZA4zA8E5bxQzTWau+tYZdu/PvJPPI4EdZggz
EZ1DuWfM5vBhKvwCA/QqPftZ7lmJ/rtyzz/6lPqCkXWBE3KchT+Ddee6O+Z0
Kfhnaq4J7wOY400kloVmvyXgfk3ERyzMj+Xhd0fJccLn3sq4O1K3Dd4E3hDe
FHqTuu6KunB/d8QOzsDeUPzDgG1678uKbdUU4+PRg/QiOdwTefyubv28XdxL
8c8ARtCLXXBILMwEcEV+1sa+PmjOF0JmT3yjnzwiBw6pIbUEY/Qe9qhRV5v7
k/8OeJeDTy7IEfkBU/DxBxzTL+ikn+YjD7xbYPd07pjmwn9qy/8Pc3hL9Ac5
/KRuPv9H52PuTOjum/Efxf8UeV4es7c/Zvux3HNrd+CD+IbDH2rYEXVEN/LY
ZSYdj7n0ZLx3vHu9MVeQoc96Yt7SO3ujf36uGSf8u/0HDregfg==
           "]], PolygonBox[CompressedData["
1:eJwlk0loU1EUho/JezGpvJekBkQtgiKKdcBVpV24UrPQ4oQTigVXCqVuFBfi
gFORKirUCURBRShK121xaikKgiujLejGEa2g2FqrNlG/37M48P/33DPcc/47
c8fudS0JMytiAZbJmdUAvlSZrSmYteXNmkOz9qRZZ2SWjs2S+D/jX41/I7yE
bxS+Hl6XNWvFvwybhe8v/EboMX/AAflvwkN4EjyVs5PgQXJ8JH8vZ2V4iaYK
8Cn4TwRe4y18OzlHwTaJ2tTbGntshfob4HO4fybwO2Xuj8GvUW8M/gPcz1kn
eB9nHbytjNWnzRrVA7Vv498T+ptHyH0Hvhd8FZtL/CfsPPil+gUP4j8On491
cf8h/CD4MBboPrwdfAGrgW/BnoBnTzQboN4wfG3Ka/wifhy+GX4UngK/w4op
zzEN3IXNgP8kvofel8Pvhj6z08Q/jzz2unrKeg/q5RDWG/nMNLsr3G+KfWfa
nXa2KfYZapaX4dvgOyeb9WXIw3uXEl/CjpBrGP8p/CsKPjvdKYIbqHdM9Thr
xN+d97v3iB8g9hm8kPae1bs0JC1Jc1U515y0Nx0exT4zze4xfFfsO9AutCPt
Sm/UW9WTektm/a2aqWabi3w3qqnaCc4OhD5jzVo5lVsaGMffDV8Y+k612zJ3
Lgau4QrY6PFS4BqeAH7PWVvgmvgAHsHOBq657+BH5GsIfYfa5etqf5tm9Aac
if0v/Nc49Yci15b+RB98HnyIv1DH/RfUy8MXgBdhPcQuyfquVmG1sZ/JpzdU
c7c/9lhpTto7pz8ZeA7laoV/DVxT0tbv2P+GNCwtL8a+JTzmFfXrs66d/dhK
7lYi/1v6c0/zrmlpW2+uxXcf60h6jVt516y0qx08wPcPhaqkhQ==
           "]]}]}, 
       {RGBColor[0.9143942500000001, 0.8976069999999999, 0.8460412], EdgeForm[
        None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVD1PVFEQnQv7XthN3r27ugYsVWKxNFYa+AWKIRJQ/AD2JcI2snH/hgkV
0pFskALsNBojJYkFnZX6A5BowFajDajneCaxeJm5c2fOzJx33rvwsDfzeMDM
FvEM4vmdzOZzsz+wN2AHhszKILvi/jnYR3ja8JeQc6mKevifz8g/gH3XUM23
wizCdlkfhH0W/gPY2Vx3jD/NzJ5UzD5hiF6QPcQ824hvIF7Ds5irN/u2c53H
4Ie62QJ8g13PlMs5t4JymP++oV6nmGeqpjk5+ybuRpB/D7aD8yjiXfjPgdOv
6I793+J8BfHlXPWs3Q/ag/mn4Os+/BPYhaiaO02zrzhfR/yL88r8FvL3gvZf
8V25O/edzMX7sannS++7C/sq05yca9f92aZq56Lsm0w4tbr2uYX71SBOiHPb
eR+FvxPUq3QO+s7DXcci9seGOK8iNtdUThv+D+wzg9rvSZxvO+/9TNyN+P7k
YT7qbsNn4IwvfM4yCpPYz1xP1FLfMcjPzajdx5O4Zt6BaW7uhvC/d0zdBFMv
xnn/M2nnX7BTwHkNnAn4a5k0R+5bUTxfS//1Rzz2pj4+mLTPPUvXFLU15vyR
R76vLa/jDHtez1ruxJm7znnpM+97jLtw102vGaxL35W69MK8luuFuHx3001p
sYqci1F8XgVoERXnPb+zjmtuzXdtu4aXXLe867h/WChvGDhHSVo8Tvomlj3n
pNC7uZz0TdPnzEeF+DmfpDliDkX9J4jJvn8B0FqEgw==
           "]], PolygonBox[CompressedData["
1:eJwlkjsvhGEQhWfX7vpWst+7diOISmxEXDvCL0CicV8sidAg/A0tOsmWoiNE
6PUa8QeQsDQal8btOZlikjlzOe+Zmbd9dWdyO2lmXVgKW4jNLtNmh4Al/LZg
9kJ8NGP2hD9NbCMya8LuGs1aiO1Tv4c95qgFj2e8R72pvNkyuCdh1gd+LJiV
smbrxBrIfYkTv0S+C78M/xbcMXYD/xCx07Rrkra3otlEg9kaPTnwCPlzchX6
6/GHsTPwlWLk+8FH+AdYDX2Lsc+mmHLZvHNJk7Q1B59FM2rWQfAJ+AKbAXeC
q2nXKK2vcCbxx+B4Dv6m3q7yxkrsMeW0k1pwDnHtkp/DHyB2nHbOb7j+wIvU
djNPL/5y7FyqUa12pF1NUvMefGbN3oH+B/TPU78ZuaZr9peN/VYV6pPMel/w
Wu1Qu2wNvhv1qHc2dm26qW4rDdJSpv8nOIe4dNM6/J+c32oK/BHc5Oumn/i3
aChGPtNv8D+gv7AETtAfxf4XVKPaf5ggTXQ=
           "]]}]}}, {{}, 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], 
          LineBox[{3618, 3894, 3669, 3671, 5203, 3670, 3864, 3555, 3863, 3668,
            4564, 3593, 4098, 4099, 4100, 3885, 4097, 4096}], 
          LineBox[{3626, 3895, 3674, 3676, 5205, 3675, 3886, 3560, 3865, 3672,
            4546, 3562, 4071, 4072, 4073, 3867, 4070, 4069}], 
          LineBox[{3659, 3897, 3677, 3679, 5206, 3678, 3887, 3580, 3878, 3673,
            4557, 3581, 4085, 4086, 4087, 3880, 4084, 4083}], 
          LineBox[{3661, 3898, 3847, 4834, 4833, 5103, 3597, 5200, 4105, 4835,
            4106, 5199, 3592, 4562, 4094, 4095, 3884, 4093, 4092}]},
         "45"],
        Annotation[#, 45, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], 
          LineBox[{3347, 3911, 3348, 4289, 3255, 3725, 3909, 4563, 3344, 3768,
            3544, 3769, 3346, 3770, 3345, 3729, 3261, 4316, 3376, 3936, 
           4679}], LineBox[{3389, 4347, 3390, 4968, 4967, 5191, 5190, 4965, 
           4312, 4604, 4603, 3689, 3868, 3561, 3866, 4068, 3782, 3370, 4311, 
           3929, 3780, 3366, 4310, 3369, 3924, 3928}], 
          LineBox[{3501, 4490, 3502, 4491, 3482, 3827, 3499, 3879, 3500, 3833,
            4082, 3843, 3521, 3844, 3520, 3834, 3504, 4521, 3524, 4026, 
           4779}], LineBox[{3542, 4535, 3543, 4537, 3723, 3724, 3540, 3883, 
           3541, 3846, 4091, 3842, 3519, 4538, 4024, 3719, 3718, 4518, 3518, 
           4014, 4023}]},
         "40"],
        Annotation[#, 40, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], 
          LineBox[{3352, 3915, 3353, 3727, 3726, 3913, 3912, 3910, 3349, 4290,
            3692, 4293, 3351, 4291, 3350, 4292, 3730, 3935, 3934, 3933, 3373, 
           4313, 3695, 4315, 3375, 3937, 3374, 4314, 3735, 3736, 3395, 3957, 
           4687}], LineBox[{3407, 3977, 3408, 3790, 3789, 3954, 3953, 3952, 
           3629, 4610, 3372, 4346, 3387, 3949, 4685, 4686, 3783, 3932, 3931, 
           3930, 3625, 4602, 3367, 4600, 3623, 3925, 4677, 4678, 3776, 3777, 
           3365, 3918, 3923}], 
          LineBox[{3483, 4459, 3484, 3820, 3819, 4640, 3649, 4489, 3650, 4641,
            3481, 4488, 3498, 4486, 3497, 4487, 3828, 5149, 3654, 4652, 3655, 
           4653, 3503, 4520, 3523, 4025, 3522, 4519, 3835, 3836, 3527, 4028, 
           4780}], LineBox[{3538, 4530, 3539, 3722, 3193, 5047, 3536, 4534, 
           3537, 4536, 3318, 4517, 3517, 4022, 4777, 4778, 3191, 5036, 3515, 
           4515, 3516, 4516, 3314, 4485, 3496, 4015, 4768, 4769, 3186, 3717, 
           3495, 4008, 4013}]},
         "35"],
        Annotation[#, 35, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], 
          LineBox[{3100, 4675, 3917, 3362, 4309, 3361, 3773, 4676, 3919, 3621,
            4599, 3363, 4601, 3624, 3926, 3927, 3101, 3781, 3107, 4684, 3946, 
           4345, 4344, 3371, 4608, 4609, 3950, 3951, 3109, 3788, 3117, 4693, 
           3973, 3405, 4375, 3391, 4619, 3633, 3978, 3979, 3799, 3409, 4391, 
           3426, 4390, 4982, 4981}], 
          LineBox[{3118, 4698, 3983, 3411, 4376, 3267, 3741, 3393, 3958, 3394,
            4349, 3700, 4348, 3392, 3955, 3956, 3110, 3737, 4320, 4321, 4319, 
           4323, 4322, 3696, 4317, 4318, 3938, 3939, 3102, 3731, 4296, 4297, 
           4295, 3355, 4298, 3693, 4294, 3354, 3914, 3916, 3728, 3256, 4300, 
           3356, 4299, 4963, 4962}], 
          LineBox[{3148, 4756, 4007, 3478, 4452, 3713, 3714, 4757, 4009, 3479,
            4453, 3303, 4482, 3494, 4481, 5031, 5030, 3185, 3152, 4767, 4012, 
           4484, 4483, 3313, 4512, 4513, 4511, 5035, 5034, 3190, 3156, 4776, 
           4021, 3514, 4514, 3317, 4531, 3534, 4529, 3533, 3721, 3720, 4533, 
           3535, 4532, 5046, 5045}], 
          LineBox[{3157, 4785, 4029, 3528, 4523, 3508, 3839, 3525, 4027, 3526,
            4522, 3506, 4655, 3656, 4654, 5151, 5150, 3829, 4493, 4494, 4492, 
           4496, 4495, 3485, 4643, 4644, 4642, 5144, 5143, 3821, 4455, 4456, 
           4454, 3480, 4457, 3463, 4629, 3644, 4458, 3643, 3812, 3449, 4432, 
           3464, 4431, 5012, 5011}]},
         "30"],
        Annotation[#, 30, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwl1ldwVlUYheEDDhoVUpASUKx0vECwoCgI4zhDUFBEDMpIC6GloSChIyV0
lGZBiI0iQhJKaIqJtABSowIJnUhRL9QBBB1H8NnjxTtr7/Wtb5+zz3/Kf1+f
zC4ZlaIoSqwcRbXjoyjGuGX1KHoED2NS1Siaw5+L2XgX72Ak/6D6IWSYZyET
S/lHE6KoDEcQFxtFl+6Iojr8p2Xb4TW5BrxrvB7GB3jFsuerRdFO/jmaUiOK
+qEvitTqyn0lX4dupgfoQexHvZDXl8zPcLx7zA/x76aldD4vNc56SMF53jkM
4f9Cf8UF/IyLWMhvZK1s2eG4wbuOYfzKzuUmRHjG+pVoLn+23CzMRBf+CF4P
a3S3t2SkOb90vGLc3J660RL1WN4u+qD1U/Q1s97vtIT+QXfRH2X7h3OQS6Gp
6IcPkay/mtxC40X4CDlyn9BPsRgfIxej+UesdRRDzd8Ke8JKfiIdZFuPqrXC
Y5jK/zLUsRwr8AXG8o+pH8d48wl4G6v5Y+m4cCzc7rxecn5jwv2CURiAZ3lV
1AYan7LGPnv82/w7+hfdS3u5RkONO9LW5km0zPr19JbTeH0JiMMojEaFa54s
9xPN0fu8vsm0E73Ii1d7itaSTURtTFfPVM9CGjKQjt/k6sjXRQO5RmiIXPl5
6vMxB2vM54bzlr9XtgNtLpdEr+NfrDYvQJ5zzw+EZ0s2j162l9PumVXWyMMe
6+XT6/QAvUEP0tOy7fXc4po9YI36uB9n9K7hbVPPttZa4+78WH3rjNejENPU
NodnCBuwCRsxnt9V/mXkmE/FlPCb8s9Z8zxahPvXsY+5Px43bo0nwrWTKZIt
xtf4BlvCvcDvFu51zDCfhZmYyK9GY3HWeW9X32GdndiOafzpSENntRh7SDc+
oxZDOzmHCt4OtZJwTV2Xfeavql2xdoU1V/PWhveX7DpaKLsOhcbrscHvsRGb
9RXKL+MtxzD9K+Q28ReFZxqLwzPIH0fHY6V8rmxnXhaWyC/FaLWxGIML/D60
L5bJz5WfF96R/EWy863fW20BLXAe+Ugyn2TegT6Hjjimtxwn9LWzvxHWyLSn
kXQrtlnrbLjHeTerV+ipba2Z8s311TA+y6tFT9Oa9AzN1vu9eila6TtE42kc
ZugtCM8xViEfeeF55p/QdxITzSdjUriv+I0dvwnahvvP/dGGpjpWW+u2wRSZ
pbLL8BmW4HOM4ZfJlmN42B+yURDeLc7zOMpx2T4TrJcl10atpWO1wEPYY/3d
aBm+BeH7wqtifFh2T+gN3wH9l+ggtcEYiN1qu/SVYCf2623Ca4rG4beTH66v
zHHL0TO8X8O3w7r9cJg3NewNObiNdyuelKsZrjkm8Lvymll7r3x9msYbHL4n
4fkOx5K/6nyvoT8/Sb5j+G3lu5i/iBfQ0LwYRbiirz69TK/iT2yx9p3hGaTp
9neX8bf8VOMB6I8L4ZtiTxfpVrUfHKe33D96Xqe90FSuJ20W3nv89jLVwzH1
ndBzCifDO1XtfbkPwrcV72FBeL/zS8P9hSHmb+KN8NtX/f+/xX8PDD63
           "]]},
         "25"],
        Annotation[#, 25, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwl1W1M1lUYx/FDglCRIFibkJDeWoqoMysRIUlgudVogGWliMAL60WwwJoP
Wy+ytbVqEx1qomKUrtxaPizLbNVmL5rVlsrKLLVlUssKMhsPifY568WX33Vd
53dd55z//b9vJja21DQnhRC6/LntphBOZIbQg5PoGBNCfnoIeeJ8TMDH8t/p
nbwX6WzaxteKfvkc+R+0D3+iU32qnrUZIaxBytgQkvGs+vX0BoxGGlLRpT6L
v513AxabN159rfo6LM0KYaP6w+o56p/zZmSHkImZ9mseF8IMWmjtEuZZ387f
ibfFN/PdgsPmfIgjuCqfYPa9enfx3M37Ol0gz1PfIC4SZ9izXTzb+kY6Ty3H
+l7xNTOC/Kp519CtluBLqC23Vo9L6n+jSU+J+lae+TzV8hp5DZ1ET/MO2Os7
+gO+R5u8yH2K452wh/dF9RJxKfLFeThtZpY9Ws0p4tlpfhd64/MzYzHvS7Sa
1qIGv1oby5+F8XpzkYNX+VZZfwZPow2t6OPP5b0VBXyV8ul0F/+AuFu8z54H
5R1xvjOdkW8Wz9XTJt8iPsgb1JNQihK8p2e/exzAuzgm30cf0XOeJun5iV5H
f47PnE7TN4RBjJJ/bfaD9DhNocPqXzlTAU2W/6IvlV6go2kvXWJ+ivUv7FdO
K/CEtSXOu5IeUm8Uv2ZmA91G98f3U1yrdxW2qj3q3XsMZ+M7J3/L7Pf1HojP
I97PrD7eddZ2q+9V2+FsVWot6OZ/A6vjO481uKBeT1fEHv52/gfUnsI23k7U
Wdtk3nJ6Tv0d+zwvv1++ni6ip/R+izLnW4BKvpV4Wf8rKOdZzXtO/CPOYFh+
lmabV0FHxedDk2ll3Fv/gPM0iFfgFKbYY7v6kPog/o1zkG7Pcs+rAvfJF8bP
0Zwy+qm1ZfEe6NPTj0Z7zufdbFaZmR20WN6gnokTvJf1H6c9OIlm+Q7eFv2l
/Lv5imgDPlM/ii/FU+LnyDs5Plf6DV8VTcjr6Ba+JjPm8PZYK6QvqK1Hmnoq
ivmy+cfhOfXa+I7xHYvfY/pkfIdQKB/hmcx/VHwPvey+c+k/9BPeSTSBGe43
CzMxMf7W6sulhfKE3o9wBG+qNfI3xd86956OK2rL+Dap1dF08x/irRZX0bT4
W8BTGr+78ovO+xuW6n0c563X6R3mKZBPw43yXme4Ih6Je/CPYCfPXfHdpcPx
M0Z9/K1DJabyDlm7nQ7SO+gYe/5F+3GI/zD9IPv//zv/AZd/3sM=
           "]]},
         "20"],
        Annotation[#, 20, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwl1ElsjlEYxfFbQ42l2pqiopUQYoEaS0MEpShatKYIEjbEtDDT1rQxzyrG
thYisRCJRKvYsbFAiCEsjC2tudj53Vj8e+5znnOfe9/3e9PMpasLVyWEEAb6
k5kcQm3HEL7THxiWFMKv1BC6dQjhfUoIH7C/fQhtZD52CqEOH/AJ9ajUC/IJ
+ChbhwO8tvJf9L+iERnmfaPN5Lo4p5e6Qd3Zup3smrQQnjk7k87Uu2HOcOv5
Zt1Tn0CiuhVaYoC6NR1pz33rQvlt5kxVp5ibTRN5g/RK+KUow0P1Uv4SnFAv
kOstP42252Xpn+KX47n1Iv4Od15BS2gZSlGpt5Nm2TsEgz1HV/UD982yXi2f
Y95iuRR1Ko7GnrnHaKNeA37b04SrvD6epy9+8n+hnDdE/jRtUv+V+4MeZu6m
65yRJz/C+ePoU7l0/ihn5WA0JuhdkZ+st9uMXSi174hcCb8Ue3iV8f3wc+Vf
yS6gh9Xz6SFaLr+Sf0j2IKrkj/AX6r/lb4jfgno9raC74vvBRfuq1OfoBZzH
9fh72VPkfsWYjUb1Ws8wx/qS+bNoA6+AfqaFtIo/k35ST6f1dAat5OfTOvUU
Og1TUaC+5qx8ejL+3rjoLmfjPWiT3nj040+g/eO3y+9Jx6rT6Ria6l71tMiz
7dWfQ/fRYrqVpsmNijmaTd9hMz8p/jbW2/jbkesel+OZdBkee4eP8MQ6231r
zLvrbq/trba+Y30byTInZb6ZkSb3Lr5ztDH/ln4tavDKvo6yB2U/y3aS7e68
N/EbpdUyL2Vu0hfxe4/fOG1hTqZ+Am2OZhhqxiJskt2MjVgmu4Xe51fIF6vT
zZ4b31l8F7wetEh9NH7nOI4L/CR+bjyTTqId6AZ+OzoxzpXbijO8O+Yvd85Q
/mTPkYcM3rz4DjxTRvL//1v/ALImoU0=
           "]]},
         "15"],
        Annotation[#, 15, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwl00tvjGEYxvFHsKFmOu2wIOkhcSqpNjLTJkIJRdsVVqatpulC0pl22kHU
Rkoi6QHFAnXYSCQsLPgEaNiUaqvaTYuWlR0+gd8bi3+u977u676f551DZVff
qfyqEMIUmjeE0F0aQg5ZPImFUFsUwo7iEHZiO96p+/T6kUfGzBleRwlFgddO
S2gCk3qlNIla8zWoToTw1O59elnZbvTYc5nXxetR55CSnVFPxkP4gI8o8Ov4
c/wp9SdM4yJ/AN/tWEYa65IhFGE9VtRD7tDg7IOo9FyBRXti+nEMmr+Cq/gl
P0KHMYR7snfxVX7ReWW8jJmsutzzb/mN6k1I4pD6L/7ggf44jrr3snwjXaHH
6EN+E/2hPk5/0mb6iP8YL82/wi2fz6j6OlpkcjjtPQ7LHsGSO2XU991xHDfk
bmIML6J53qAdY/QObmPBzDwazB9Ao51nMaI3imEMmHlu/hnq7C+o62Xn5bbo
f6Ft3jet16+X1vvM26w3S1v1Unq9eteiz8+eb0ih193y2C+3pK6nnZhwp7fR
d+75vJkLOBf9ruyYkyu3r9VzWfQ9ogLvZaucvRu7sFc9K1tFTzrjBGrUM5jG
WvUeuoauxhvnTchuM9tid8LOYryO7sLfym/ix3lt6kux//+Xf/mPak8=
           "]]},
         "10"],
        Annotation[#, 10, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwl081vzFEUxvHboFRnRtspYUFVmnSl7RT1WtpJpFol1B9Qodppm5CgVjoL
1v4HbIiwQIiFIkH03aosRMKOtjOtBRsRPjcW3zz3POece8+985vaMxd6zpeE
EGZxJxHCinQIq7ASTdjFG6cTeIeFZAhb1oWwGeNVPDRWhjDAb6D99Kq6Xn0D
cv0YFef4R6pDmNe3gEXUYht+yM2oeY9ZfEMGh+xxSf9F3LfeyNuEF+KXeIU2
/k7eX7qDtsSZ8VBcStdgNXajLp4f74DvWJsKoZ53jrbaq48WzVNAHX6aaw8d
4g+jBSl1SdzQPyrfrX9JzXK8B9KoRrnadppF3jpnnkU9c95oqMJ+KI8z4Ilc
J+1CB0rjW9FOfnecX3yUHscxPOVfM8N1dFgPIuGMglwRX/FbzwZnr0dG3Sn5
w87O82/ybuE27sU5+SP8NnqFZukXOkYr1VThl3jOvh/xAVln9uERysSP6cH4
m+EAStS3xvvRvTTEt6T7sQ8P1F821wjarZtjjp7FGO85PutJOTuJafEUMvH9
+E10kOb1fXKHN+KC+DUt0rd0Qv0kavRvjd8cf1L9NKbit+KsXNyTnqa9uGvd
INeI7fgj7qFlek/SE3gWvwGaSP//z/wDPOVqcQ==
           "]]},
         "5"],
        Annotation[#, 5, "Tooltip"]& ], {}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-5, 5}, {-5, 5}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnQd0lcXz9xMCSUi9uTeigoooCKg0RWrgroCigCgqRfgpRZEqKFIFKUpV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     "], {{{}, 
       {RGBColor[0.3513598983749142, 0.158153190654939, 0.6108591588137201], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG1sluUVx++bp+3zFih00gJdIqAzy5J9H+CmMQKiVqC0RDa2bEuEthRK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           "]], PolygonBox[CompressedData["
1:eJwlk8tLVVEUxleeezv7nB3UxKvVJB1Z0B9gD2kgQrO414GWQTWwWwOvTnpA
ZYGJaAWNCoqQ7GEQhA2aBL0GhRERiTRqktAo8IFpNdB+H2vwwbeee+31aDpR
K/fVmdkBUAA7M7Pnidk+sCGYXcrNrmIYx3YRfjia/SyaVTaaTcEPgeGC+zRg
LxAzQsIb4Bz8DLgOHwYJvA8Mwb+S4yCxnaAMr6KrwLeCceQEuQR/iv8z8zca
yT9KfX+p7R8Yg7/Gp5daquADvq9Ss0H8B4n/hbwAehLXzWFbVw7yX8a+Bl8C
F5D7kRfh/fhP8NYKupPk/p16LtWs2q9l/nYF+4zi0dUjfyP/Ir5GzBi2ZbCa
uo9826lvAtsjcIpcHciP4U+Ib4PvB/eQ3yO3JK6TbRu6Qp3n3A6fDT6bbjAH
r0av9T417+Gt3dT3AlsJOcceg/dSORvwPR98Nvqj/loLPpsu7D+Cz1SzvYO8
iVzHg/emiNwTXSeb/vw59RjFtoIZeLfqhdeIORZ8xpq1ZtoYvWbVrh0ZgDeR
7ztt60TXDP8TfDZX0K3C30Wf7S7s08g78JmEl8En3r+deW3q6S34S3QDxN4k
ZpbYN9F3VzvyFl5Pj+6a71Ap956r99JNkn899b9MgRbyGbq9id+EbuNo8F3V
H5uJ79WOFH2nVoj9mHutmtl07jWoFs3kdOYz0qxUY2vuM9KsdCNng++Mdkc5
lftB9N3RjehWNmfeG9W0Bd4Vvde6ySPRe6LeaKfn4Q+j75puSLf0JfVeq4fq
pf6ov+pG1rD9BzJuhao=
           "]]}]}, 
       {RGBColor[0.4672476951247426, 0.359650771964817, 0.7737534764411604], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmguUldV1x79779x7v3s/jKa+MF1tg6uoVCMoMMTwMgw2mrQREV+8B1BE
ecOAigiIhIeC0SSKUjAQBSG2C19NUBFQV6mAiFoxiakrUVFE3haBYcTuH///
rGStOeuce77z2Gef/fjvfabVkDG9R+eTJPljIUniLxmeJcns6BibJkkulyRj
om9wlNWlJOkWv/NRZpWT5J4oD0S7ke9R9456Q07tq6N9adQ1UcYnGv+TKE/F
782x9oToGxYlF335KF9Hf1Osf7yk8fQnUc6N6u0Y3znK6GifVUmSHweR7wdt
82LOoCiXRX/XHJOSZGhUO2NeU4xZEGOnxXp3Rbkv5veL7/sSrdlYTZI7o++W
WOd0zltMkq+ib3uMfS/Knvg2Mcb3j3IwxreO9Y5H+0C0J0TdN8reaF8ce10U
pUXMuT3G3BZlZJQRUcbHmOujTHfN+BeivsF0zPQ6rL8o9j8lrz3a58Wba6LM
KIsX8KdDTjz5v6gWRLtLlK+j/ZXv56oo4+I8P4v+j1Lx8mfm/y9j3mNRfhGl
Pvrme+7rMe6WGPdK8ODMoHlJTZJ8wHmDnqNec25ed8dd8/0xj6Fvlvsnxvh3
4XP0j4/2uChTo31XzP0q+lPfL+26nOom9yMnP/XddY76eNT1iWg/7vHI2mzv
NTUvnpxrGqAPufpTnKFfnOGTONNQr1mI8nSs8WDUY2P8K/FtSPx+Oca+k6r/
w6jneP03S5q7wPwZEvX9OdHTzW3k/1CNePFm9I8oS26uRa5j/9ooHaM8HP0P
RTnMfjFnQJTDieT1SJR/jtKTs0QpIssl9ddGOVaS7jTrSY35M+iv1kDmDkXd
nvsvaT6y0SNRf12U13I6T8H8P2aeQy/3NR8eWs6/TCSDbaPdOtqT4w73xpg1
ie5zd0l3yv1+XlLfB1EWBB/mR2mI9p6SZGGix98V4wvx7Visuy7a+eDL8Gj/
NtpdgjetowyK38/FHfSJ8c9k+s6+jKHe5/Z5yG58Wx3t24rqh0b0C5rPQN6w
J3mdsSHKQJ9rWYxdWhKvX8rJFnyRSNe3mw/o2nTbnaG+f3j+Sk46w2/s0K6S
bNHJca5J8Xt7or7P3b88J92/IKcxi6Ns5F6rag9LxTvmYFv3FqVTyNPknGTu
uPUfm9bH+oAtRs+Rp5zlmW9NHguNx9w3wOdDlt6I8Vui3JaTfD8b5cac5K/J
sjQyznxrlE+if73tKmtNsj1vNC+gB3m833SiC/d5DDT3tj06YTfM/0bbp698
jh4F7fN8lHujXOK9Hg57XRM8WBj1kaCxMcr3c9KRo25PDRo3B7/utk4cs79A
jxk/1rrT5H7sDDaoznd+t20vdzQtypmJZGe67TO2eYbHrPD4c6J9kftbJpIt
9kA3m+07sgfN0Fm0rb4nJxvFXcy23sLXOW738xjuaaX7e0b7yahnRemIf8nJ
T+AjVplf+NbB5jv8/m5OvIbP38vJL3KnA91f533nmc/1Xod2X6+Pvk+074Iv
+M9eBenbZcHz/nGue6PdMvSzEt+viHpnyHFdjNke9RJkuCg9OjNTO4v+K8u6
72ieWIO1+kX9tzFmaYz5VtQDChqDPIyNumeUT2P84qLWZU10l9/YE2zLYvff
WhANO6J9VujX7JCft6JeGiWLMb+MekvsuTW+fzvk6nfx+6oY//uqeLjBcrs9
E654KcaOKksfusXvH8WczVH/S9TDo+8HZdlZfPS/FqQLA3xf3CNnYV/O0yfq
5ebjxFQYZESm+ayDrT816P15jPt9zO9co/5OiewldK5PdAesgd3rmJO9xqZ1
slyh4/3d3yGRHCFPtb7nVdYxbMuv0dtEfhuf2T0nfzjYvmOSxyNjjF3g8eCr
+bZFdUHv0KDngUQ2n/vA74+LvpuMe5b4jiqmod5rLjANYJdOQUNtlNNLstUr
Lf/grict/2NivdFR/jMnuRleEK86VWUzbwq+7ozfa6zL17uNLj8Q+3cv6B7b
5YTb9lpfGm2rwH3gTzDFLO/bPqczLPeazFthO3C32+1sPxiDnUfvmmx7/6Gi
u/tj0PZOrD8q6BxZI9rGe83H43ubKPti32+XhR0W2cYftl+YjNJEfzXq56Pv
OeO5JZnw6crovy7qpdi/KNtKwjHY+M62D8h2l7zWwf4PsRxwp+CdOcZUzOF3
wfdc77tmPnPqo76wrD2IDV71WkNsiyb5frt4feZd4v5G28bDts99fRfn2EY1
+N7BS0dsP7mDibZ7/d1GHk7gxJx8EbiOmGSY5XSo6VkW6yyNsrAsn3DE+9Z6
L3QHbLLHeAYsAY7YaL3bXxJWSYwH0AvqGcbh7POa9wKX0oZv4Jz7a6Sn5xY0
h/FtLXetzUt4h99EPpATbBI+Dd+GTxmfytb+Nu55fkH+C0yzx3OHWA6RQfzU
LMYU5CfPrgqPDUhlH47Yv+P/32jmVewzvyzbjM39xDK82jiBMeCoacZSc4pq
43PBTp/57tZGvct2hnsHJ4GRkLU3jDeId3Za5te4Dd0veh3uGewIzeBM/GdP
42F0n9jt/Wh/VNY598e5zowzvh809Qr+vJqK1/8efVfH7/+N/j5R18a8SdH+
ONY6nIqPRzx2iG0d9hy7h709N9o7gobdYM+8MCn6+E9goujfH78boww2/jyQ
l11G945EPTDKqmg/EWM/Lkjn3sxk87H9W6M9Pfb6U6qYdLrPxXfOiH0bHN92
BM03xNgzMtnQs6L+2PIJf3pXRe/tmeZN8zoz87Jh4JTrMuPjGPtIWfqALjxa
Fl3cC9gTLIud+XnQu8kx9oEYMy9+H0wlC+gR45d6Hdo56wL6wT1vtcyAeeAr
/uhKyxiyNdJt7DCyQiwE/qFvgfuRA2QLH9oq+s4u6+4GeDy6PwL8UJTfOSPO
dk/w+vSoT8kUN1dS2RzwK9hmdazbgbUL6vvcdubmsmwuPou6ldt8X+cxZ7v/
mrxiftZHf9H1PdbBV93ubtnfbRs42hgKnQLTE1e/aVu3zvaw3nMYv9W6id5g
69baRu1ym7PnnQfgjonjiWPAQtgMdBVMOs1t9PQ1y/qDVdG1wXsNMn96WobB
S8gxdv0t23biA/wBNg08hh6+7/WxBdgE+IDt6+56ltuznRdi7qaC4lDi0VnW
de73Ytt1sAqx3nzr/i7HkauMYWotJ2syYcffZMI/8KbO2Olm479dcd4p4Kuo
T4szz4xvp1Z1f9wxutzL8oZs9rO8Ycc2+O6wYegyc9FnZB4dyFsGd/kuvmWc
Cd58xLbm0Uy+FD7iT+HlNsdZ28zPG33/yBlyelIm7Nci6h15+XL8+Dll2SNs
ETHOpfZ36O8jxm2NzmkQExGLkZuoR67A5bHmgEz3yFzioD32Wd29/3rTQO6K
++AuiAMutpzfaVtCvEMMAWaC52DDSZ6b8774VvwQ44l3iBHBi82xKdgIH4Qe
LC5JF/raByAHdxTVD0b/t6gXRfnvRDW/ibHn5WW7nrL/wK+w527rEXdHfNnZ
fAD70AbjgTcne8wNnos/wld1NW+PmU5o/syygbzu9Hj2BPdNcJu4rZ/PC/1g
hvWJztTXcoXdAfMRG06JMQdKGvulbUGd5XyQ9RHZGOg26x0wDsEG9LfsoUcD
3G7GRtzdbPfXGhv0Mw343Ot93skFxbDwYK/vgLsGI3Ty3F2WdXSP/N93zUP0
toPHgJEnmj+HPZf75Q6X+B7B8g1eh7iko+mc5v2hp5992/WZ8nzE7MTp8Ao+
sQ72o6N5hb/pYJ5DM/ESOQxiQ/I7xBr4SeRmo202+SzOiPzgm5EhcnJgTTDG
qsDqp0f/ryuS5dXGiug/uSlsUbuol9coz4jNx5diE1aSh8hrj0Eev8jy86L5
P8FYrktVOPRh5wOx01Ntqy+MMRfEmOmZcu7Y4NujfiJoOiX2XV4RNsEmQFdT
jHsvfo+KNX9SEF4hfthclR35VSqcQr4MrNJUI9/5gHHgatu0jalikHWZ4pHh
Jf0eU1RsS4y7IVP/+kyxLHgVjIxtusYYifwnPpV8Yr33XWpMdY5pnhrzT+Pc
mXLRD5n/M8A64JhMGOTivHJF66M+P688Enf2qO1ea6/JvjstJ+hdGjxaGLS9
Z8zzqLEKMehSy8aWGNMleNEmlex0sfzgSxmDP2WPR+zLyJXja+lfZtt7Av/Y
B0M/5+A8jCU2e855J+rnbfPJ9f3C68D7py1jD3keGOxZx3eMRz4ecj99z3pN
5j1ju7/QMQ73+JhpgJ4Ned0b+cBHjPu624c8a5/+jGkAsw0Lnt3oWJ53GXIg
E8FCmd48NgSvToqx3ygJB6GP5J3RZd4+TnI/cfwG74s+nVYjzNApU/+zlndw
CjFO1bHtd+JOHkx13x0sI+cGv86J8laqXPqH0b+lqBgJ2sgbIDMXWF7WW06O
OtbDJy5LhR8nVkUjtEI3WL57SXj+vVS5pt9F3TuVPP849vp+phz3rqrwD2dh
3N9keqc5NRP+Bod/M+jfXhENnINcBryAD9wtd889gpvIm7TIyScyjjH/kUl+
/74iG3fUeAm8Q76DXAc5D9rEau9WlUNfjc1IpSPtMsk+2KU5d04NpiL2BBfh
g9DLNtZNcNZwxyzdyoqbwF8jjKPez5TbecvvOIvsh7GrxAdnFPSbuO3KkvZC
r9Cp8zPxmdgJO/R0Jn/eN1NfG/dT85u74Dyc6wBvji30vrIgztpY1psObzvf
qEgekAvog86DXu88r0lOhNzIf6XGNmXJ52LnqdBB3g6Rc3J+t5Cv8nsd9zPH
uWViJ2Ko/VW9M8DTZt9CzXnoZwxvE+QSyCmwxzivucM+ERsF5tlbFv82O7aZ
5LzZu55HPnNSQW9IvB+Rj21wLrTBOJw29Vi3iQHHOD9G/p7Yg7iDPNw409Dg
tfjGG+Uorz/a/fjkkW43r9/g78j+WOP/EV6THBbnbbBscI4Gn4W3WuJJYslb
KoqF3w0+fxW0dYr2R9Gem+rN6u2yYnVk7/Got0bdNtadmUjmbzL921LFcX/O
lEcmt/pYVVgD/oIrmYdPZO4DmexEy4po+ceSfMvRvN6c8NW9HAew3r6ysAZ5
4gHGz4My7XOlY9gbU8kksgku2+97vbwsH4z/JcdHXhQa/lzWW9AL4PiyZGRj
WXPBN+C6A1W1D6LTLUQT9BwoKl9BnHUoFQY/qaJcJvkC7rqVY1hsFjTwhoXc
o8O8yc13LqrR+Ype9tu0oZOcJLHGe85NQjNy/bFle4fb6PV84/mvjUtZB5vV
sqr1nwoaP63K71zEAXKybeTGNxh3kw+8wm8Ho1PZbWw2vh57DP7ADsBj3sOI
m8nxYEeabcV+51uIkw64jb2GB1enOgv5Vs5zeSbbdXkqvsP/azPFBMQJYFri
vD8UhU94ezzk99yuZcnJUdvTI7aTn9VoDr+RqbXFv+RNNhm3TLAfRf4WZ8Jt
U4I3n0eZwJtoVT4ZHIlfPlyWT0gyxXrDvAb4i3X4vawge8Xvn9qX48dvyjSX
Nd7IlAvaho5kyn1Xoi7x/wC8xUT7C2Q12seq8lH40Quafad5gk0/2e+V8GGX
4/H1qfAAuGBoUbiUd0/8MOvgz0Y439WQ6g0eu70nVYxOrI4ve8F6calxQa1p
wCZNsl1amMk+4sM7m6/4UOT5ByXJHBiwtbEleWmwOXE3OkO+FJwBZgf38+1g
Ubn+5hwZNXEEsohMHoo1xhYVIzCH+Hemx4Lvwfn40i+KWotvxAVtozzu2GCe
41P62pkm3rt6luW/6YdW8P2KTGdZnik2IEYg73tbKgxYk+quZpoW4vKL7MvY
r63XudA0sBfnbWd6wDqMB6f9KpMsvxP7FFLhvkmp3h6wAejR9Ir0qo/3/cJ7
Vx1TbIl6oLEKmGVuUXYKfqNDO5wz4f9poPfLVPEUOYL6mPNBWXHFzqps5V7H
DsjRyZYlbNIO0zTTd8Y9/aioXB9zwKpgVmjHHuyzHcCOfmq7+j+Z/NDDqeQT
2QTnk4eBX8gJmBAe4Yda2R/jv/pnWqc+lX3fad+NXR9pmwnW+sx2ADnc7bOA
g3bYZlaq6l+Ryp8j250cq3EWfBB5bvL2xBO8TeKDtsV6r1eV59xU1ZsteQny
E2BisHEP2/Pltul/qKr9dxXZGu7izqpi/3aO9VvG95UF+Up4SEwI5l/l/pYu
fOd/e2oz2beOmew7OvdEtF9OpcetK8oNYDfAreTgeIvFT6P35F7b/xW2uMGx
WxfH1GA9+Ih9PbsiGlpVlJ9A58jttLOfaJ9J/6ZYB8+rCON/XVZcgR25PvqO
l9XPd3DcXMvn1Kr8yF3kiuPb4tjr5Ip8Jr4TeeR/N8iJg9fxw1eVlZdeU5Ys
IVOctbX5j39mHWzNbs8DW/ZwrNIzU66xl9f50nYem83d8vbdsyi7N9K4Cx8C
zzkzb9DdjevQa2wT9qW1YyNoQP4fty5gH7AN5DpaVOTDwd3YHt6kiR1O+IGi
fp/vtbD9/M/aZN8R8Q15DWzeHQXhbfBHT8svdD5pjM07JHmnTs4DgZuJ0cAS
Uwqaz7q8aRNvHzG+HeW1kN2C38vg2VbPJd5j3ybsZSZaiXXurUhv5lX09nvE
/4fG/68hz+Qurq3In5BTAVd2sx9f61wUuTf+x4R91zn26eox7bzXd1LJaVfL
6mXGpl1T+XXOiI9G3m+xzMNnbD12nO9bfBbiZvwmd8PbCG//tfat3exfoR2d
hH7y9eTtedf6pmNwfC9vifSzRj/rFjHdokx284ep7B2yui+VjHC/nIe8Ivla
3h3WZnrzetGxzwivtbUsmUF26oyfwdEz7BfwD7lU+bk2/E9ERXd6dVW+jfMj
YwPMC/gAliBOxLaD3eHTsfi2qaK3gR9WlNsjp9DBmGeZcQ6YGt1EzoixibVf
yhSTEOegFx3Mf+i/zvfO/W93jEyszBvTSGN4/B/3fF9Fuke8hw0c73iJuAmb
QD6LmAzcMtwxyFzHhifi94L+t6OX97/VY64wBm2yjvf0+pwFH4bt539JOHsP
28ybPZccF7ESOZE6z2Uv8mojbKNu9Vk4+3jvzdz2vkfyvMRX6NbbqcaM8zd8
Jj4M/3W8qvN8XdW7EriId2rswBTr7B1ug8feKkvWVpRlnyfbJhC/4T9XRf1U
VWuclkmOb7Rd2p3Kx71c1v/XsldTVd+GmZ5LqsIs36vKFt5mWzTFbWjAPpOT
ATuCo8c79vzEcS9318m2BRt1k+8Omaz1eVhnlWl+vaK1b3f/KLdHmk/Qxt01
84LzDvd94f/IgfymIPneVlU8cndF/3dLHvDdVHaPN2ZkF38CJscXVINHD0a7
mMpGsN/dphl6OcsJ+SsLk/C9znkJ3h3IgZOPJ8dMDp53ANZmTXzGh/6/1jGp
eApvb84UhyNjL1qORlmWmDPKfgrdRscJRLET0D/IGIq8FThqizEh+WZi0Jst
n2CTzYW//P8pcg6v/x9mpPpo
           "]], PolygonBox[CompressedData["
1:eJwllneMFWUUxWffe7tv5g0IwlKNGpASg4gK7sZYkKYIFqQISAcRRQGVIoZu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           "]]}]}, 
       {RGBColor[0.578021583434152, 0.5503820356952117, 0.909822473907073], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXvUV1Max4/3/f3O75yzkXhNMkiJcRkMCeWyJJVLI8O4zYhKJYwst6Vo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           "]], PolygonBox[CompressedData["
1:eJwll3mwjmUYxt/znfOd710IoRyRbE3GEhWyNdkipCIxNVSW0DpZRpZsaSZN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           "]]}]}, 
       {RGBColor[0.6632259295414664, 0.6872817115281911, 0.9117648705653469], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuwV1UVx0+/x/mdBwpIil2QwEejjVy4isVFzTJTuSojKSUzJYkYChdI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           "]], PolygonBox[CompressedData["
1:eJwtl3uQj2UUx9/57W9/v/d5X9FSyC7ZqGHGpWXV2ogQCRvJpD+iNsp1l13K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           "]]}]}, 
       {RGBColor[0.7484302756487808, 0.8241813873611701, 0.9137072672236211], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHnUlVUVxi/ffe+973lfwIRy4jOjNDFwhalBpkyOqxgUM/RDJQdwgBhE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           "]], PolygonBox[CompressedData["
1:eJwtl3mwlnMUx5/e9Vm6UVHRzcyliJI204JSWozRIiUtSiJxUxnakGw1NYV2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           "]]}]}, 
       {RGBColor[0.8263970714285713, 0.8682622857142857, 0.8854638571428571], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl31sl9UVxx/66+/3e+7zdCxuYqLYogKtKUx8C86YCAVFXpxSnTAQI2gy
l7mXZGbWLcEak0mpkqkohm4TM2VbJopkFKGrwtYKmAxwagJMENh0kJklOlGY
0+D34/f8sT+e3POce+655/2ce+5tP7zhBw1Zlt0zIssqWluqWfYnARMF/70x
y/bp/16tJ4RbqnVV4ME9IXiL9ncIniQm47Werv9m4fsFnyH4HMG/KrLsH+Jf
z7Ps14KbhD8i/O8E9+nc8ynL7i7Mf55oXtO6UzRTtDdS+G79f0v43ZKhVbjZ
Otss/HLhFwp/qmJ4rfCL4uxu0R0V3KvvN8LvFP0R4e7RXVXhHtW3UfhdWl8R
/WUN1qk76G8M/A7hOwUPC54suLXw2Vt17wLBfxTuYcFrcvNfVWbZxY22IzZc
Hff1aV1Sz7K3BPcI/6ToD4t+hHg06EyL7HNS+1XOS5/fir5DNDNFM0O4xwQP
C14k+lzwcdH3CX61anthK87D523Rt+obJdw5nBPdfsHfF8/1ddvvlPD3654J
Oj+ovb2CLxG8XfA60Vwhmj2if068R2uvKnyDzswX/xoyimepvTWiuVhfqf2v
sC/acfrG6ntRNAPC36j9fsEvCJ4leL/2Lg3bPib8Z9i3tG/xMXe/VbdMC0V/
luAz67bFmNx6od9fdG4o/LKsZllPI5Yz2+MDnb2p7lgkDof0P1nwdbpzhOg3
BX6F4FFV08Hj+eAztbDeF+rcnEbHOnH+SvCBX7POdjTahn9L1vcLvYX/ku5e
22Abzw6aCZK/TevE0r7EpyuF2xt+wT/Y7w+NziNya3PcOztg+BwUzeSI8+uT
7TZXaye2yJyn6LdONO1aL9PeS6L5utaK7r1LuLm698rkfJ+i9ZZGxxO2I05/
FLFK/GH7aaI/ULf/Fon+G7nvWyr4a6Xt8EbyubuiPpxfWoY2rVuEG0AvnWnT
2Rat7cLPDT9uj3/w5+fOK/LrM60/Ft9ZgqcLvknyXynew8ggeJLgu3WuWXut
4tWPvwrf9YBw2yu+m3v31R33D5TGgyPeyG/iiVgaWTq/yDNqFrXr6cIxktUc
JxuT693Z2p+qMz/R1nf1PSp8JvxKrW06sxIZtP4zWc93k+vTosjZfQ22O/BH
4YPjWsc0OkaJz9Oxlf5fSPY9diaG9krO1aLZp7UzOX/aRfu9ZJnuRJbkGKN+
LBB8geBJuWvjgarr47aKdSHeDibH2YHk/JwTtf1Q5MDbyTE4O/D4G3le19oV
PsJXd4YMl+uuq5NtPSPZT/hrs+AHtbdBNN8svE/dpGYujTi+TvuL5a9b6+bb
pv28Zhpkbgt6cqU15CffiXtiflnu/LtW/Dcl07fk7mnd0cPerDpWidljybX+
aHI8zo14+DDZX/9JzrfOwB/WXYckx+3Cv5fcM/6ltUffSXoSuZWs13hqo+jn
6XtQOjyr/TEV11b6DGfpQc/JPv30Ycl8fdV86GvIO7Xm3nRDad91ls5TdED+
lRX7Gh/TE9pqlpceN7Zmf56Wu1ZTs/tyx993Ctdu8FcVzoPzas7HLcKfTT3S
Xa9K9iHdf5FoflZYTuSlH86rup9eXvN8QO7TG+gRT2ndWrMc6HhIZ57W/8HS
sU7MPy64V7hPovbu0l2vaz1QWO+j0ZdXUDO1tmvdWJr+kZgFsBe2eim3bTeV
7sf0Zfr/M8IfIz4L70HzkeBthf2IP1+LWkpNfTx6Ez1qPbWe+GuS/SPXyLmt
uev1icK+OhH+Gqy5dpGnE6IOUA+GSsuPHvhpOOYZagZzDDbcEPk/KrdNltd8
Nz7AFwPC/zt8gU9+HnVyQdR1fID9D9XdJ5Yk97SWsC09hb5FLRms+C7qDD7M
Yi5CT+78qni/X7rv0//Jvy2Rd9iSPKXXrNXdI3X+y6Xty95a0XfVnZPkI7SH
oz+Ro+C5l3wgL6gLp0rHT1fMLLOitnJuZpy9NPKFeJ5AzZEO+3PPm/Q4eIKb
H3PIlMJ9vSPmNeo/fvml/us682TsM0OQj9gbW2GbxZEPS7T+tzDPI7n59lec
Mx8XzudxyXrMD317tU7Tx3xNHWP+o5+iEzUNvVgXB55aSO+jt12QPHs05bYP
dYy5Z2zcOTJz7sOT+D5e2qYzCu/3Bc2eBtdhehPyLNfXEXJND9nQGRz3kRPs
gXuoZl24P2tyDnYX9ltXzFXQdIW+zK3whMc6yf+w+P1U8r8j2daL7gOtN0fv
gR+8Oc/Zmcm9+JpkHHei7yrdl8lHT2ht195S8X5PPN6MGZVZlZx4Nmop7w/8
Qi+4Jni25p7HmNmwL/G7Pd449dIxQCwwB20LPHqgD/a5MHyBT+bnjk/itDV6
Z3PMkA+FzNSk3sjZIzETH49ehF7E+X2554nf696DoSO6dufuZwPif25un+Jb
ajH1nZrxae4YYQ7CHsQ6vn4jcw5Wmhy/xDH53lNzbAPfVrgO305/yR1DOwrT
9gZNc5wl/r9duJfcUVi/FTH/wA++2H5h4Zpys9bVzMzIIJk/zC0bOYpMyEad
uKWwLiOSbbDi/+zWEzKQx4ORy8T34pgBeEO0xsyGL/EptiCvqbnAf07OJeaL
l2vuPfSd5jh/ReTFy4FfEjnIPUdL48mXvybT98fb9FjUuumRP8Q5NYm3CXVp
c7yFqavvR/+ijzEznhHvixeT44DZhHfN6Lp78CfJNY53YUPUT/oV+2fF24c8
3h/18Jl4R/Oe7oi8Jt/oQ/Sjk4VtMxDxNi3yfnTEy9iImVF1260tasu4iOf+
oAFeFn7m7EDMF/SsqwvTTZTsHyfbdGthWXqjtkwLuCP0QFfeZ8wmzFG7ww97
okb1xAzAff9L1nc4dEQ/8nAg6uGk6LMbomZ2RT3BzuDRbUPEy0DIzP1TQobJ
MYcjw1DM/+QZ7xt6C/PtznhfQ8NMRNxCQ18FxxzI7ID8xBJz1pzoTZfEDAk9
M96uwO8NHtiRNyL6tERfGoyZ4ReRR+TTmWE7ZP4c/HsmSA==
           "]], PolygonBox[CompressedData["
1:eJwtln1MlmUUxh9e3vflvZ+XaC3pnwSyFBxYLirMVSKVTiVFsUGJLqOt+qOv
rS3bmrPa1LKtEuaatD42s1ZZYoEJZWparq3SGBsYIH1YWK0NU9EsZ79rF3+c
7ZxznXPf97nvc67nmdT8aP0jiSiKWpAkMjMTRbNxHELGQhTNRb7KjaKbwHrz
oqgQvITAz/BVgTVgr8Y+g70e+xZkL3opviKw6cg1rNWN/AB2IhtF29NR1JgT
RaPo68C7ie1CFsRRdBf2GvT+VBTVgV+BXUjuVuQT8qfhK0OvIeZq9Bx8rex3
JWtuwO4Jxoqw12N/xJrFrFWJbx9YOuu98/Dlod8JvoP1CqntDPYyYvpyfea7
0QfBe6g9In4IfRFSxVrTcS1Ef5vzzWSvx/HlYvezxua0c0bH19TaOnMFscVI
WdJ3pLsqA9/G2jvxTQKbqpiEz/QF+D3YLWApZDP2KexGcucjJxXLnp3stQG8
BH0ZvufRL4BvJP4BfIexv2aPUezfkT2c73NkhL0XEb+EvY4jCWKvRfazXpac
SvQpGd+demAOuYuR79AXENNHXe9gV2KXILuJvRQpGu+PG8AmYk8Zr/fmYJ+w
3cgM9PvY49ukz6SzVY3jxfgmkLsR/FzSa24Hex/7MmqJiH+M899KzDzO/iNy
Dvwcvsvz7KsB+1VnJvc6cjrwd2GXJ33nU9V/yLPs9ynxLxFfjpSityPfE7uF
/X6hX/KJfwv9Pc1H2j1agF2DfKD3IX527BpV6z5kFvpTxH+YdEw1+PmM95pF
Cf9pL91XwjNQC/4uMiHlO+sg/0BwrHruS/QH1WMJ16haL0YKiD/FGQvQ74g9
KxeBj2EfRYrBtnDmYfQXNT9p98T9se9Qd1nIGk/rrOzRRn4WuUSzSMxI0jWr
ds2UZusgvmVgz+DLSZsTdgT3nHpPZNIS3HPqvRXYp9GPqSbsJdjHg2dcs/4z
diNrHcA+j36AJfajvxnci5qpPuxapJf4AXx1xA+Ad2HXYg+LC7RGwpywgvN1
E/8x2GTsPWCT1UPoE5Eu7BfAr0q7B5uJXxrMVeqBes1KbC4cJn6v3j/2XYmT
SsifRkxnrt9Mb7cqdi3iBHHDjcG9rp5V77YH97Z6Qr3xemwuUo+9plkO5k6d
eQ34w9hHEubkh9Bvj/022nMO+tzY3KE30FtUB/eeOE/cdyHjWdWdRGC7grmr
gf5I5sNZ1J9KuUcS6PODe189OQ99LfmZtDlrZzDHi+vPIs8Fc6649xvwlbE5
XFyuHOU+ScxPrDUfWaW7zfjuNdMd5LYG90oDZ+gldx3SmjSnrUVvBp9B7lJ8
f6KPBPeOeli9vFKckfCM/4bepPqwF2APod8b+2zqOfXe0eBe0Zvr7QeDYyvA
27mTIxlz62qkHKyH/LqUObUIfRcxVfoWgA+jL9f75HpP7Z2fMRe8jGwTvwX3
jmpQLeIgcZG+MQPoncj1Ka8xiP5HcK3yCbst47tTD/yreoL3Vs2qvTz2rOjO
KtA3ZT1r4og2cv8mZnnSZ9bZc2JzpTh/Ifjp2NytmRiL3RPqDXGkuPJs7NnR
N+ef2G+kt9I3qRT9YOxZ1Bu/oW9PcG/oznR3TbG5QjOqWT2BVCd8ppPoh4L/
LfRNOay31ZukzDlNrLc142+T/jGeYK3FGX9rxQHigrbY3KcefhW9LfhbqW/Y
X3l+U72tOL4/z99IfSu1Rz35r8T+tuuf5Bj2UNZcKQ7aFJtDxaX6Jpex9/8t
ly80
           "]]}]}, 
       {RGBColor[0.9029163571428571, 0.8937794285714286, 0.8511832857142857], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVD1MFGEQ/Y5j93b3TEClVTQahVOw0IsWEi1BqE6DeicXuaPRQi3txCNi
QWGsOTsTEykodtUTYiRW2omFRDFi8IcYbBRF7XyPN4nJfZm52Zn5Zt68b3ZW
LhcuNTnnxnHSODXPues4dRh7Q+dewNgH+RHfBn3nWiFP+9KXoY9k9P9Wk+QZ
0ycQN4izCp8kK/tM4FwRchT5Nzc710jJpxtyH77NwfYbvnuhz0Jfh94OPYF+
P3Iuhzpi+L+BrebrDuZ/HKiW3fg+gZgS9PfQb0IfgP4Keh45WhHTY/WzbvZw
B7UOQd8EeS4jvR0+lYz+s9+viC8gvhoppmp2fq9YLGssZ/7nK1ueK1nZphB7
A3XehX4C+uFQcXnIbbC3Qe+BPuapN/ZVtfy8a0uzsCNu7DsxfHliw5B4EbcB
5H+LXL3QDyD3k0Dx92B7nZa9Hzm/438J+lXo9Yzu4+wKsM/D7yRkB7534nTD
J07pfmK9BN8LkA3IR6F8dtisGMPe52E/Bj0H+0UnDFeyqoV5OpFvEfFFcoR3
e/pGO2upW/8v08pzFH796O0g9D2GGXm6HfbpULXfjjTbqs2XfCKvTkXCnfiP
B+L187RyPgxl53zKxgHOjPfQ3uWE6yHDgZJ8IpeYg370eWY86wiEH+smzrs8
3ce7cp6+0T5pPbJu4hf6ys+eJ41XxPxTSpgMGSdp59v5gNMC/5WU/rfYjBZw
8NvAh9iwNvKEPuQV8Thu9bO/Nuux7Ov91w1X7gHGM453fHM6tDPPeqS3/CvS
PKkvGyfIjR/AY9oTJsSsbn2xvzXjHjnYsNyrtmO4a5gnb29ka6A76cN6pjzh
RZ4twacPctF2FPtnbBfmHsNvf1Y48Q6+kcTeC/EgrrFhtWA6c/AdbmAXqK/Y
8H8aCKOZrHhMPnM3fMF5h3znQ/GEPbNfcnDE5svZzhp/+P7IA3KgEmlfcW9x
R5B3R5BnLdA7/2mcTOxNXQs0mwfwGQ3kzx1TjLTruPMSe1OfQ+28OZs1JTHh
7JmPOBJDYluzmfKdka/k6t9I++hPJHyJcylSn+x3OFTcmMWetf1ShPwHJUTI
jA==
           "]], PolygonBox[CompressedData["
1:eJwlkr9L3EEQxSfqxd3vWYRoqyZE/HFGRURip52KNrkIMXcQUKs0+ifkUNDC
4rBWOyGQFFd4KipBsUq6GEGIihIhNnZqfnV+HlMMvLfz5u3szD6dnMlOV5hZ
N1FF5BOzYcAoOAfui2arCGqIF+DmYNZD/kul2SD8e3TtAGdH4C7yQ+Bj8m/g
50Te3PMCPIVntsrPJsETnJ2hfQe/qDZroL6Ou9aITXIfiMfoiymzVJqeonvn
0J+irw3e2zI41JjdRPfKU3MLXuKOIvnxh2Zl6v/CZ/F6C9+jNkP0o/2G50v0
P+Gz5ObQ/EfbCu8lX4JnqN8J7vWaWIdvocmk/M0n1D8h3wb+xFkz+d/kC+Ac
+k34v8S91YN6kUbaMjWNwT3lfckbtuGjaHbJRc4W4BvcsVLhM6qHD8O/0vsz
PDYSD2G96TD6TDQbzaAEb4rurZ7+oB0j9tE+wn8Rv1/RZ6udXIHbiTJ4kbgN
rpFWMzkg94o4rPQZaBZ6o96qnX1Ge010PuBd0qC9C+6lGWvW+kP6S3rDUPQd
aBfyzIJ/BK9VD+rlOf7rKe+5ndxO2nepmbyHf0x8lvqzheA70+40wxb4fPC/
pT88kvif1d+VZ0faZ6xZa4db5O4Blolngw==
           "]]}]}}, {{}, 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], 
          LineBox[{106, 3047, 2537, 2659, 2658, 2955, 2526, 2527, 2523, 2651, 
           2650, 2951, 2514, 2515, 2861, 2860, 2091, 3063, 2644, 2187, 2498, 
           2088, 2858, 2087, 3062, 2636, 2183, 2487, 2080, 2854, 2079, 2730, 
           2176, 2928, 2731, 2360, 2359, 2357, 2067, 3080, 2479, 2705, 2996, 
           2234, 2995, 2233, 2340, 2806, 2805, 2998, 2237, 2471, 2821}], 
          LineBox[{120, 2545, 2547, 2546, 1976, 2015, 2401, 2400, 2534, 2533, 
           1972, 2011, 2394, 2393, 2095, 2522, 2743, 2387, 2386, 2385, 2090, 
           2513, 2741, 2377, 2376, 2375, 2086, 2635, 2182, 2634, 2181, 2486, 
           2078, 2365, 2077, 2485, 2175, 3002, 2239, 2807, 2808, 2809, 2273, 
           2292, 2291, 2347, 2265, 2346, 2283}]},
         "25"],
        Annotation[#, 25, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwV0D8oxHEYx/Evp/y7zsJKN50omZQJKYs4roSYzujPTf7EIIPbxIDCYGIQ
dQbFRN2J3WK4w8wqKcTL8O79PJ/n+f6+fX/xdCY1VxZCyOABkWgIRzUh1NWG
EENVVQj7+gPsISIrx2dlCE/8jBJ2zLZRUOexoW5BKxLIYh1nZo3chJR6GBPu
CO5dlZ2oYzzGSbNR/uVF2bE6wkPcL0vynf6Qd/X36qVqu5hHr/yLC/JZnsE0
OuUffC2/wYu3TOnTeMMrLmRFTKonUEIROdkjsu7b9J1x57f4B98Y+f8H9m6R
x6B+AAv2L/UV3nnFzfoE4s68c5+dNfW5WQN3cD3neIW7zHvQjXZZG6LyU17m
P2thPBM=
           "]], LineBox[CompressedData["
1:eJwVz7srhWEcB/DnnMFxmZgZDEwWZxYRZ3PpDAaRy4BSTGxml0G55+SWS1Gi
5B8wGkQ6dQwM6hSLOorFwucZPn2f3/f3vm/PWz82k51OhBCmeOOoMoQTjkmV
h7An99mNc1UIZST1JflFkW27LV554T5lz7NdgcOKEA5I2zVzZ/dJTrfDsO81
6vOsm9dYZUBfp3tiybzIAv36Od2pnI33lUnZI+ftu2Ui3lv+mjtkxj3a4ywn
7XLOm87f9j+UmNCPs6J/N39QZFQ3wrI+YR6K9/T+oNyQQfcnr/xTgT5zL488
cKHLk3HuosGzt/La+22ylRZq9TfyXN8Un5Wd1OjT5mp5Kc90/89nPdg=
           "]]},
         "20"],
        Annotation[#, 20, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwV0E0rhGEUh/GjFDOTEsux8Q0wU97SKJZWSqwopaxmZC3Ku4hZKV+AZIP5
ACgJeYlZYOutrKwnG79ZXF3n/M+57+fuaZ0sDOdrImIah3UR+8mIQioij8b6
iPZERAZZHJiVOC3v5h704lh+gjP1OQYwiLL7jtCkbsa2c4vuXcYS/vQrPOrs
GF7svOEVG/Jx2QTe9X36Dvsf6l2ekldkneocd/Gv2R5XOMez3M8FuzPI4wqB
Ifmc+TwW8ChrwEj1TfpVfHv7BdLyFuzIiviRXSKhTqLkzJr5Ka9zqvpPvGlT
vYU2ZJFBEc9mn3af+IvLfMc3/MDXfM+3/Mi1XPG9f5ENO0U=
           "]], LineBox[CompressedData["
1:eJwVzr8rBHAYx/GvcnfObwszE5PBZhQxkIgRJZQ7HRb5cUoy+g8Y/AF+RFnc
pQxHOaMbDMQqPwolcuV1w7v39/k8z/fpaZ6cH06VhRBSSFeEkKgKYQ5J1Kjb
4yHU8gGvc1dlCB96jd4t3MQnepu8qO7V78OZLIsMBtU/+r/Yxqq5NNZQiNmN
W3MFjGAUd7JjPHo/YQzjmMC5fS/cYdcUT2MGF/Jv7pSneAEJWRKz2JH/ybp5
iXu4yHul2/WL7hny7ucBRGSR6hDKeVe9zCuoQwPqsYGoHTEc+bulPuR988/u
z6FVFrenrXSDuah3DK9m3vCOa3OXJfub4zxfcYZPOcuf/n/hRv2gzvM9/wMh
2z/W
           "]]},
         "15"],
        Annotation[#, 15, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwV0DsvQ3EYB+DXIC6VWJC4BI12ZSKl0riMwuAjNE2YiGBAYqADEpG4JD5C
ETUgkbjEYmxHg11islhsPB2e/N7/75z3tOck88vzS3URUaDUENGXiOinl9bG
iKTcltPNET/mTnNadsl1WZRl1254aYpIOU/ISaa41d9RMVeZZY53v1Wmzfzs
+hOPfNjv0LWz5/mjjJFhnCyHnLmv4P5f87A5J0fkt71zeex8ygk55xX9Kmu8
2fuTM/oNuckWFX2VBC3s6op8+p+vdJt7uLZX8txLLqjXXcmd2g4DpEnVvot+
Xx4wSN45b3/IfC+P5JduofY+clFmdA/yH+krMys=
           "]], LineBox[CompressedData["
1:eJwNzr8rhAEYB/BH5A7/gIFyblIMxMTssmGwY0Dh6k4pq8WGIsvRvZTFZhDK
cur4G4j8NohNqavLZ/j0fZ/v87zvXWYmP7ncEBHTPLZGHLVEHJIwm44Y0t1z
YN6nRJ+5l2oq4otd3Q4ZXRcV3SdJm29R5sS3mtw0suYmRZpmihTYc5e4q7vJ
yZx5VNbkon3J85/diMzLYblpt0XF/poF/TxzDNp/yzP/5YEP+3cG3Pdzqrvj
x90253YXXFI3T8kb799SZcI8zqp3N+yvdFnZY+6Wv3LMft1zwfMKRd50r7Tr
s+Zjv/lifuaJTl0HS/wDFQg5Mw==
           "]]},
         "10"],
        Annotation[#, 10, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwVz7srhWEcB/CHAceh3P4BRRa3cpkoNiHDUeyyGFAYlEsZyWRxKbnklsnk
VsQkLMhlMGCR3Bkp+Zzh0/f3+z7Pe9735LZ1x7oSQgjDJKaFkCLnUkNYYJ4k
RTQaQrW511wle+S2boct9u35kRDSzWmsmZ9015zxoPtNDqFA/yPv7Y/6N87t
qzybO7h19m3vNOeZs8gmg4guUx7IF3kox+g3j8oLz61z7D0n1NNAI5u+e8i9
YUooptAzpbIo/q3uTMhye6ksk5VUME6i8x2/fWmedP4R/1/2XWp0tTx7xwuv
7OnrdHXx/2l/Z9o+wxSL+j7dnzlmbpLNMqJblbP2AfMgWeSQzQgpvuVGXnPF
hvtfvHrnES2ebeXD2Wf83bpTKs3t7i15fpkV7nT/dFhJhw==
           "]], LineBox[CompressedData["
1:eJwV0TksJFAcx/FHIhhHIllhJEs0EpFIVCoKR2FKZFfjjk1I0KxC5YiWhEoi
KpWzQKJYFOhmnAV2yUYodtXYYnck+5nim9/x/7/35ijvG20dSQshzGAvK4Ta
SAhfaH9OCAM0LTeEOd0uv63rQS860Y0ubKE0O4Qy3Nu7tf8dP/BRd5wZwm/M
8bMo0UdxiQtM66YwiXbnI7oE4liRl9wfozHaQpN02GyZb+braANtQiPmUeyu
KO7MruV97xfJe/Rn6vM4/ws1qe9svqPrMP+MT6jWT+qnMIFZOaGvpFVynG9z
vhXjcoG8Tw/wDUf2DukJXbBzTDfpBj7oC/HOJ/Hq7QH5hf6T/2LI/h+8Ic/d
+bjkH+0l7T3z7/RJvuJvUr87Vu2tYR0VODN/0J/SC5zjqzxIx2i9tyJ8Bp9F
s7GoS/e//wfxLU2L
           "]]},
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         {GrayLevel[0], Opacity[0.4], LineBox[CompressedData["
1:eJwV0TlLnUEUBuC5REjiFbRxb1waLfwB6i+wExfwGpVoEYOKxsal0B/gUglq
pYU7pLGxEVwCrgQTUAtFEFwiBsEFXCr1ucXDe87MmZkPvtymjor2SAhhmD8f
Q7jn4VMISxxFQ9jTJ30OYVFdyxdq+Go/JhdlXmII9bJaXycrZRXTTLFvf8gd
gwyQpk9l1d0XzDszYW5BbnKj3pDpMirTZCYZlNFu7dG5E3VrfJ4V/Tl36ite
1QXeepP7+jM6uHTmg+ziWt0tEyky28KhtWVnzrj2jaUUU8J3e838MN/Lf3WP
TOCfulOec0iEQvcFeUCKOpln9Qtt8W905xtP3vrm/LMMMkI2WezY32Xb/Ijc
kb+sb8lVuc5afNbdk7LPTD/plOtj5jLUP+WMfo5ZGvSjzowxzra366w3Wr83
/8Cttd/k2P8rj+2fxv+3Ppd83gGPFlPx
           "]]},
         "0"],
        Annotation[#, 0, "Tooltip"]& ], {}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-5, 5}, {-5, 5}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 CellChangeTimes->{3.544460832990636*^9}]
}, Open  ]],

Cell[TextData[{
 "What can the set ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y", ",", "z"}], ")"}], ":", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "+", 
       RowBox[{"b", " ", "y"}], "+", 
       RowBox[{"c", " ", "z"}], "+", "d"}]}], "=", "0"}], "}"}], 
   TraditionalForm]]],
 " look like graphically for different values of the parameters ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]]],
 "?"
}], "ItemNumbered",
 CellChangeTimes->{{3.5444536632862835`*^9, 3.5444536947881255`*^9}}],

Cell[TextData[{
 "\tSpace if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", 
    RowBox[{"b", "=", 
     RowBox[{"c", "=", 
      RowBox[{"d", "=", "0"}]}]}]}], TraditionalForm]]],
 ".  Empty set if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", 
    RowBox[{"b", "=", 
     RowBox[{"c", "=", 
      RowBox[{"0", "\[NotEqual]", "d"}]}]}]}], TraditionalForm]]],
 ".  Plane otherwise."
}], "Text",
 CellChangeTimes->{{3.544453773844473*^9, 3.5444538320260773`*^9}, {
  3.544459604976591*^9, 3.5444596736517534`*^9}}],

Cell[TextData[{
 "What can the set ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y", ",", "z"}], ")"}], ":", 
      RowBox[{
       RowBox[{"A", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"B", " ", 
        SuperscriptBox["y", "2"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox["z", "2"]}], "+", 
       RowBox[{"D", " ", "x", " ", "y"}], "+", 
       RowBox[{"E", " ", "x", " ", "z"}], "+", 
       RowBox[{"F", " ", "y", " ", "z"}], "+", 
       RowBox[{"a", " ", "x"}], "+", 
       RowBox[{"b", " ", "y"}], "+", 
       RowBox[{"c", " ", "z"}], "+", "d"}]}], "=", "0"}], "}"}], 
   TraditionalForm]]],
 " look like graphically for different values of the parameters ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["D", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["E", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]]],
 "?"
}], "ItemNumbered",
 CellChangeTimes->{{3.5444535465818276`*^9, 3.5444535866638794`*^9}, {
  3.5444536259034123`*^9, 3.544453649337917*^9}, {3.5444538617950745`*^9, 
  3.544453937279518*^9}}],

Cell["\<\
\tEllipsoid, Hyperboloid (one sheet), Hyperboloid (two sheets)\
\>", "Text",
 CellChangeTimes->{{3.544469200330642*^9, 3.544469221748618*^9}, 
   3.5444694070190926`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], "==", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "-", 
       SuperscriptBox["z", "2"]}], "==", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "-", 
       SuperscriptBox["z", "2"]}], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.5444687400591908`*^9, 3.544468944364381*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1XXdcz9/3R5kfW5lpiJSZLeJFRmbxIVtE9koZn4xkR2goZVa2jGSPeGWk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     "], {{
       {GrayLevel[1], EdgeForm[None], 
        GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmAd0lVUWhf9X8vJeYGgiZUILTZAeQgCRQSkiDB0EpEiTXoIgDkUcQEC6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           "]], Polygon3DBox[CompressedData["
1:eJxN3QnYttX0NvDree7nHjVpTqg0qSikgeZJM02kaNacaC6a50FKSikNVEhI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           "]], Polygon3DBox[CompressedData["
1:eJwtl3dwVFUUxt/LluwuVQUDgoZQQpTeQu9FAelNAuPQIXRCG0DaiAgIqDC0
0KTMCEgRUCkqiEoJIQihOdIEglGUErpUf5/n/fHtu+c77dZz78b1GtZ+aJTj
ONtBAIyPdpwZruO0CDrO0LDjDAO74HaCb8B9dJ+gew3+Cg7RfseJhauPbl4I
P+SS8NlwH2CXDdcGeavPcdKIPxtuC74l4K65Zr8ZuRt2HbDpBDqCSXDXwQ7s
doLdIBfybrACfWV8n4DvyJsfzKE9ju+XxNkKBhP3DbgEsJkBZuM/Eq4echzf
ESAFJMJXA2uIeYD+LeJ7jjhnwS76Whvf32jvI+Z6fGdi0wCbmhHHSYJrS3sK
feqP7QAQBaCco/hlgOrYnEA/nBzDwAhwD+5t/PPT/pWYY3BohRyL3R9wWQGb
29VwHck9CJtyxK0AKoJF2IXRR8BwfHsR7yl8XdfGqHEthKsetrbGepm+1Ibr
gk8p2u3hutJOAjex+57vh/AzQH7kX0A/uNPk30rsbeAoXAb5qpKnCnan0OWA
W2Av+uuM+2u+U+j3bHw7YdMZPA0ZfwN9V7/pcrw5vYycBTYQMwYuH/Hzgipg
HtyPfhvHFeIk4F/H9caGbRLcY75PwTOQlxyX4H4HsdjmQd4IitO+CPcDMdcj
f8s3C+6Uz9ZEazOamD8jn8fuHEgn52jkUSAG/WXyTqR9Wbm9PaO904+xhuFS
NPdgNMhNX9JBIeLERNn+H4jdKOz2EWO/9hoYHrE11FrmAifwHQKfiO8D+ncH
NMb/GnIlUJ72ZyARu+uM4wl9TGZ+VsAdx/8xssu3HXqXOCEQ9tk52gXfB7ve
IIKcpTkFV8EydD76dh5Uot2TfvUCvT2ofQ7dn8SdHjR9a/I+Ra4YMP1D9BO0
X4i3GJslqhFw88lXj77H0i6mGCGrCaoDhxjfar4Xddbp5w2QSowo1QdsluHb
EN8lxE8FjWgPIG/YbzrZnAGx2rv4zgBf4PucmInEvovNZGxTsckHnzdse30P
9gXgSoZs7jSH/f2WS2c1BX09+LrgLjZ/6Zx7a5jtjUFjXARSwVLyvhux2rmf
OAnIQ8ifV3UJ2xg4F30U8IEA8EdMVwhdMGI1S7Urmfzx+Dckbg45+TiP+HkI
/lVtAYT9v30fPAha7RiHTx/8W0astowEKaACxmUYRybfDdiWwDdNtgHj0sjX
k3ZZbKq4dj5mIbdEzsH2IbiAfQ+wB/1N+tuEdlOf7bdHoBDIDNh+vIn/i9ik
4/+KY/v0cdDGqbEfo30cdKSvDYlxxW81QPU0E34wfj5vb2qP5oYrSZx0n9We
sfiVAiuxaxxt+dWPDM2L7gSf1TKtdQ3ibnKtviiHcp3F7rlj9rLRvtA51Hk8
CDpgUzHa9q/WWOvaCm4+OcuBdeQtRczS4C760nDxoDBxTpP3edjW5R6Y7a29
1vpN0E/zCLeU+MtAe9qT6UsqsY5iV1V7A74Lcmu+pYgRD8Z4/VPdSCbHbfz6
oP9KfQVTse+L3If2YtUubI6AjIDx49AnEqd3tPnp7l6A3UJw1btn1uoOVFv1
EL4HsY7o3NK+QB9PgrLItfCtqbkFt9HVD9m5XE57ILhFH++FrU6oXhQnXnNi
fRqye2sY+s3EOo0uM2R3u+74O/B54B7xvYDveVAE/V508yK25qpxuYhVFP9/
VNfJu0010m936ee6BwK277T/0sBz5FX49iB2G/jCxH/Vq2eqXSuR4+DjtZeQ
C9I+hN9+3S3IJ8mTD9/8YLJqJ37dBfw+ZjxzwNywtevQj13Y3fAbX57vWOQJ
YDzYSLw48pxxrd6r7msOltOfzcTbAgbqfGFTA/6Yzq1qO6hAvGzNCb45Qdtz
2nuXQnYP6d3yE31fGbT1Ud1rgW1Jv62VztNS7JKJddNndV81QnWgAlxHvROQ
0/D3u7YeWhfdFcrhYhMFanh3nmz76s6KtjqjWAnYrcFmtd4G3lnQW2CO9qz3
TtC9/zK5CoIiIIY+H4yyt9ts8laG2+O3WrgAfx/9iALPsGkAVwu7XNh199t4
VCtU71T3JtL3s67tg7ne2izU2xUuGd1qfFaBMqA73Bq+nfVu8tnZ26H9GLK3
jt4828FhvQHQVcN2ET5LwGKQgXwI/UEwA/18+uKGrX6r/x9hM5CxtQzZWdeZ
L6Z3AfzyaEMG7UbYPvKbzTpyncInE4T1XiNmPvhZekuDaWA48hByVMJnumv3
jd7obbQP8C8LyoGRcBs0/7SngvdAX92V+B/A7zBI03hUD4hR3LW3/BXv/dlU
d5PP5kvzpjOj/aZ1HYT8mmv7UWdLes1lT7gQ8bLgmgRsP2tfJ+PbH24O7Zne
Pd0Vrh3+bcE8nWN8ewZtLPrf0Rr7qj4b62T4SXpXgnPYrVNNg2+OvjN2XeGT
glZjNZdHsNnAHKboLgLNXXsD6Fyofm2ibxOZ35fgX1Be1V5iXnLsbaj3oO79
aXBr0K8FC0ABr36qjr6FPg7bbsR7HfsE3ZnE+Ru7+IDtI+2n97FdAVeQ7wT0
tWjXBs1UG/22P1Uvkoi1lPxFkZvR56agGf5F4QeTw69ahM8pcAg0xKeKajo+
U1y7C9QX5dRdkqjz4Vr+oqoboAP6aNU72u9ErC7rf5r+r2k9/gP32880
           "]], Polygon3DBox[CompressedData["
1:eJwt1WlsVkUUh/GL0PK2DRGwQkJBWWIiKmJAjYiiERKJIqsCFVxAEYRS0UTD
Iio0YEVSCiWCYRNokSoSJFBllaUsAkoRRSirGzuRsoimWvxN7vvh5Dxzzn/O
LHdmbovBr/XOvSGKomyWynqlRVFRnSjqUTeKeuKM2lHUORFFd2u3JnyA9ZMf
mhJFB8UuyD2Ny2nnKbBNjfl8RnoUvUPXtVYUteLfZrNou9N9gOfip/AF9erT
b2U1+pbzk/WdrmYkf0K7iRq/8E312SReJP+D3Eh8zByWy50hL+NH0Swz51k0
LfFOmtm4K32eceeIPY4n4Cf0zZM7Qf+e+CRcSH8dl9I0w78Z+135pviAeA+a
IdqjjNUdNxDfLz4BF+AaPBEfoRmPD7E7xadprzfHPH6V2mNocsWPm8PY9Hgt
l2nPsz54BV0F/aLa8d42TIvXfpG/iW3GVXw+fQ3NJXwz2xHq8MfF2+OX1d5g
jHZ4SFif+K3Wvhjfh8+IF+Of9Xkfn6Zda20njT1G/gCubQ8m4gK6pTQptI3Y
XlxPrVbyibC38jPEr+ItYo/yV9gufRexYtxfvnX4pubcL1nne3X+5huzCvwP
3z+cD5qH1JxmTqf07YgXhb2g+VxsYdgLvAwX0y+heVZsMS7B2fhkOJc0dfhT
bEHgRLzeCvX/tM5KfrJ4dTjn5tZMu43+w60hh2Wof5r+nHhe2DNcEvYBnw3r
FZ+Ez+El4ql4oz4d8NDwnbU/pRmGZ9L8pfZs+SJ8DX8nX0e7j7EGsDvEqtyL
BuZSQZOjzlH5fWHPw/kRn6rWJZygP8vPT66xJIylf3OxXLnSwLQ1+jym/XEi
vpvjwxxwX5xDO1r+GZyVPOfb1BqIK4y7Ha+heSPcJ7wBn7JvG/nnw5kUzw53
W7uLGjvCXqjfGQ+jX4+Xiw3Fa/HrarbA5/XN1G5qXrX4Evo1dHvxaPlJdCVy
jfg55jdP/a/Fh9M0D89DajzWefpObB3tBX4qTWVa/IZc0fcwnoGv4p30F2mm
i32Lq3AhfhNvVX9L+Pb2fjD9LvEt4n+E9wuX45N4LN6WiM/keFyo7ipjN+HX
sWr8kbmNSMRzXhPeMXyvmj31uS5fxVrTZoYxxF8SLzBuIXtYfCX9N2L36F9A
uxm3TY/XPjd8b5YTzo1xUpIWOJX9qMZ+1kG+sT5T9e2mZiP8IZ4nvpQtxy3F
suWW4RZ4nP6HjFfJuogNMs5Isb40z4ndHs4JXpo8V5lsSqgvV23M/OTbXmxd
mdb1Be3i8Dbhn8QfDG8i3RF2lFWyDDUPi7elKaOdpj3buF/ht8T34B7q1hij
Hf2K8KNS90ntnnxWevzPWkA7hdXHN7KFYR/U/E+dg+K34S/xK+GtV3Ml7q3/
q+qk8b3qxm/ULer1oelE01F7tXwZy5JfHe5AOMP6rsLb8ai0+G38nT6iu8aX
hncgnEOaNnhAevwvuAsPxB3UGmR+A4KpMTO8e+HtpanQfkSNJWrtS96FT9Li
f01p+GdZ/3G5z3COWi+K78Mj8QvJ+xj2oYG+e9TPMq2GYf/UGEe3C7enLaPZ
jdulx+dtEx5B0wXXM/5w/Gt4D431L39/uNcp8T0N7/zl8E9XL1eunGa3/LFE
/K9ZF+6f+CZj5/P/A4KlKm0=
           "]]}]}, {}, {}, {}, {}}, {{}, {}, {Line3DBox[CompressedData["
1:eJwl0L9KQgEYhvEv0LLL6C6iqaUbaAmpSaIaylTMIZtCIpsljLSgoEBFcmgp
GiMK+t9U0GW4SNFPGl6e9/nOe85wJjLrs9mRiEjLWiJiipRxBvNjEVd6Vc/p
FeykIi7dVvk2X8FlWZItvoDzktPPbFu2c7zAx3lx+A23tFtp2JMRm3jh1vK8
h4v8EBvSlAz/wV951ZPeebEdxQ+ewDus+2bf5lY/0O/xBAduT/bP/IgfS1ff
xarsSZvv4Lftje0pr/AaPriV9X39Ua/jO17bveE5/8JPmdZLuCFFmeRZrKX+
/+8fph02Gg==
         "]], Line3DBox[CompressedData["
1:eJwl0M8rw3Ecx/G3on3/DX+GnFz8AU4oDpMDYrS0CSct5cdxyWWbKGpsRe1i
OS4x+ZHdyJ/BYcXjm8Oz5+f56r3JhrO5iZWBiJhCbjBiVIyjmUS0dYNvec9W
wpVu6eVMxI5e4kUsYFvP8gzWvM/d1t1O6rxeTz+vL+wNnrYXbJu41nX7Dc/r
CldRw5z+5RiKePPO8KvbhHv6Hl397eaJf7hje8Cz7utTf+tF1/gETe99PsAh
LvWd2y+3u/pMl9Pv1S37I2/Zj2zH6Om2/T39f/Qnf2DMe4OLKGBEr3I5+f99
/wDJrziB
         "]], Line3DBox[CompressedData["
1:eJwl0D8vQ2EYhvFHUvEnfAjfQ2IgsUsktdCU2GiUwaBqF0xaQUKbCBbaRFIM
0sYmghhq5yMwmfzeGK4893Wf5z3nzRnJF6aWeyJiBiuZiDEyiYP+iBKvmhvm
uG4CTd7Ag26br/VFrKKITZ4z57Al39hZkOexzpdwrjtz/sKc1hd0i6jxOmqe
5fi+XEnfxywf6o0YRld+tzMgD6LNO6h617fdJ89+zEfdC470x/jVPfMr+Tp1
cindGWUcpn07LedvccLreNPd81fzzjxNd8UX/0RHd8k/5C6y8p65ix2M8oqd
Yub///4BTGA2bQ==
         "]], Line3DBox[CompressedData["
1:eJwl0L1KQnEYgPFXKgyCvIYupAYhaLUhEIxQaK0h+tChL2lLsGhIwwgqQUGq
C4gi2qRBGqrNwFtwaPMnDQ/P876c//8czlxhc3kjEREZbE1GLBgWkxElnda1
6Yh9vaT37J91RRf1Ke/yDrZxYC5wHkd6nYv84EzLPeMXtfSK/aq+0Df2OX2r
83zJNdSxZp6dikjhS8/wJ985P6Hfddf5oWffdN3+T3d1Q3/wIz+hoQ/H34Vj
XJnLfM19Z17c09Q9fWJ/r3/1q31HD3Sbf/gbWX3OZ6hiPvH//0YFUzBV
         "]], 
        Line3DBox[{1151, 330, 1865, 1864, 1863, 333, 1903, 1902, 390, 1221, 
         1914, 392, 1207, 1208, 1209, 391, 1305, 1306, 475, 1959, 1296, 472, 
         1957, 1958, 442, 1939, 1940, 1941, 441, 1262, 1942, 440, 1257, 1256, 
         338, 1159, 1158, 1157, 329, 2202, 1151}], 
        Line3DBox[{1862, 332, 1162, 336, 1154, 2203, 1155, 1156, 334, 1265, 
         2249, 1266, 445, 1261, 443, 2246, 1258, 436, 1936, 433, 1934, 1254, 
         2244, 2243, 435, 1964, 1299, 2260, 478, 1962, 479, 1304, 1970, 483, 
         1309, 481, 1302, 2261, 1301, 403, 1225, 1224, 2229, 1223, 400, 1217, 
         398, 2227, 1220, 361, 1874, 360, 1875, 1190, 2212, 342, 1867, 1868, 
         1164, 2206, 341, 1872, 331, 1152, 1862}], Line3DBox[CompressedData["
1:eJwl0M1KQlEUhuFlnMipIjSwSbcjpJhCYDMnQUVeQ7OiQajTIugHiggi+plE
ipE1D4TCIIJoUJCX0CMNPr73XXufteHM1hvza6mIKEthSpPUZMSEdPBvEnGn
n9IRI3yLv/Uj/9HX/Eoe+BfftuOc9/gnv8Ats6bc4GM91Fn7T/EbfnY3w0/4
K3+RGT4wz+t3ntNnzj/wNG7qe/t70sKX7vbH7+Pu+F3e0at8Wcq+PeT75kv8
QB/xFVx1VtNzuigLeMvZrjtVXDJr8z2+yCuywXf4pi7x9eT///0BKBwxgA==

         "]], 
        Line3DBox[{1310, 485, 1311, 2263, 1312, 1313, 486, 1433, 2306, 1434, 
         616, 1441, 619, 2051, 1436, 608, 2040, 606, 2305, 1427, 2039, 2038, 
         607, 2321, 1471, 2075, 651, 2077, 658, 1490, 2328, 667, 1482, 527, 
         1348, 2276, 1347, 528, 1387, 1386, 2290, 1385, 570, 1384, 561, 2003, 
         1381, 560, 2009, 565, 2006, 1382, 2289, 564, 2022, 2023, 1403, 2296, 
         503, 1972, 504, 1329, 2269, 484, 1310}], 
        Line3DBox[{1314, 488, 2268, 1328, 509, 1979, 507, 1978, 508, 1980, 
         510, 562, 2004, 563, 2005, 559, 1380, 2002, 555, 1377, 556, 1379, 
         557, 1378, 558, 672, 1492, 673, 1491, 671, 2085, 1489, 670, 2084, 
         668, 2083, 669, 618, 2048, 2049, 2050, 617, 1435, 2307, 620, 1496, 
         1495, 489, 1315, 490, 1316, 487, 1314}], Line3DBox[CompressedData["
1:eJwl0L9KggEUhvFjJNka5BSBhUkUBE1B3kQupUlRQ1NZN1IYDrXUIHQJtQVt
BYE2ZqE3kELRH9AG+0HDy/s855zvg+/L7B4WKomIWJNsMqJLFnUrFbGgP/hQ
OnyZ345FfPNXvsR/8I3ZtfTxi14didi3a+M8/nR7wDt8hc/LFn8339Y5XtZP
9lm8jjdkFj/qcz3j9gGf4YZOj0c0dZWfyJT9HZ8wP+aT+p7X8LTdnh54/6+U
cNVuaF7EX2anPDyzyXfkko/yC13hVzrp/gjXcc+35vScvOHn1P//+wNhny40

         "]], Line3DBox[CompressedData["
1:eJwl0L1KgmEcxuG/kVRzQmMKESbkUhQehm59CCGEU3oiQRTvUktBnUFDNtYm
GNSUVGBHoKE1GH1d0HDzux7xQd83V2tWGqmIKFs+HTFwKOqbPk1HLPOQX3mV
YyKixyv87vPLqYiRXmvLruzT+UWfbd33H3VNG+70uMR17nKBd/iB81zlRd3Q
TduyBeeO3tkJt/VY52Yi7vmQM3zLBzzLN7zPOf810XnNWp2//Na3/diu869W
9cidD97mhMdc41OedHePz7ipF3pufc9a0KX0//v7A28uLw4=
         "]], Line3DBox[CompressedData["
1:eJwl0L0uRFEUhuE15PgriIKJCMk0xPSmExUThUxiKLT0DlGJn5JItOMCREGn
EDQqjCtwAUJikjkSEp3Gc6J4863323ud7JzSWrq0UYiIVUwnEZ0dEWP47IlY
5pmsy5JuFC3+gZquyJ+7I5p4wki+JzOsmE/c+TZ/oc4Xcaj7tX8kW/qabhYp
38SPsxm+Z97HARb4g3xEwzzeG/FmfscVv0bFXjt/p7NM3ujOMaGfxIvujE+Z
yzg2D8lhFPP38Ht3+u0PYJtv4VLXxS9kInd0u7jjt+jTrfPT/G0YNFflPOZQ
4K++X0n+/+8fwjAtpA==
         "]], Line3DBox[CompressedData["
1:eJwl0LErxHEch/HPXXQ/WSTD3SVyFsXOdN3IDdclrqwyk8skhe0oK7fLwmSQ
GGzE2f0BirrB70rZKC8Znp7v8+5zv+EmVjcW1zMRsYLZ/oi+bMQYeklEQ6e8
zCXbKLq6rp9zEXnd4Sc8ovj3O07R8P5xe+T2Uy/pGlr6237AXXvdVsGm/rI3
uax3eQ/7qOp7fsCx9xuPD0S886W+Qkl/6ElO+dp2hoJ+0VO+faqneQaH3nku
oIiWHnJ753ZEb+kmLnTOfs6Jfdu2g1s9aL/hNd3mEwx7V3kB88jqOX5N/v/f
X/l8LgQ=
         "]], Line3DBox[CompressedData["
1:eJwl0M8qhGEYhvGH+swMM7MY2UjJAUijLCQmSRZjMzaydQAsxKwkJhsLhzFJ
/oWdGuxlL4pI4gCmbDS/L4u7676e73nfvt6R1fWlta6IWJFWJiLTHTGVROSw
ip/ZiEUs8GmckYr08XO8kF39CrO5iGvc5qdYxx7nm/qm3qvvYN7ejVmJN3gR
C5KXfT6OZTnWB+0+2R3jR3w0vQ+/zSb0S/1LP8M3HLL/iif8BZ9lXq/jVvof
ssAb+Ov8Hlb5AS7jn9mhXtN/vMdcei9umLV9m+Xv/EMG9Fu8k3vpT8/Yqdl9
5MP8AROcTP7ftwPPiC3b
         "]], Line3DBox[CompressedData["
1:eJwl0L8rxHEcx/E3xX0P54gsUucfkGKSgW+SAcN3YvUHsEjHIOlYDP6MS0JO
TCassitX51divEGZPGR49Xw9X70/3+E7vLKWrbZExLJMtEW0t0bc5yJK+JVE
ZLYH3s/v8FZuZIC/4auk+rfbdbcNPvP3FjM8tDX1Jf1An8cK/rjfwzlexk3Z
kln+hHU50Rs4lI94xjP+gRdYsn3qVX3Et45w0PZoG+XHfAzHZV8vYo/0SoUX
3F677eM7vBM3sGrL6WX9VN/GK8y7v8RdXsNz6dJTnJYp6eaL+O79AnbwSUzw
Jfn/v79/Oy3Y
         "]]}, {Line3DBox[CompressedData["
1:eJwl0c0rRGEYhvHHDAs2asrCjpomlCxmYTfYyMdOSax8NBsLH4koSomUEolS
yp6ykDRTQtSkRNmN8gcoe2XFb7K4uu7nOfd5z1uneXJ2aKYqIvJI10YUExEZ
vuE7tMj3XEZWfucPPMuPyYgHTNVEzNVFlOQlnjYX5ZLONY+Yx3Alr3q+Jq+j
XOnzChrkk+qIU6TkIx72/jHXV77DWczbPXGn3YLczq3OLNjlzW3mcZ7Aj3vm
uAvd+DandLd0B81J3UP+td+w65MzXOU+tZ7ty436u/yps8yL+JJ7dHI40+vn
Xtx6/6ByHzmDPfnSbpObzOfytjzqzLR5wFkXdjt2b87skF/4FYXE///4A9xL
NCE=
         "]], Line3DBox[CompressedData["
1:eJwl0bErxHEYx/HHOYOb1JXBdkkX6qYbbHIGkYlC2U4sypVEFKVEikSilLJT
BklOSNTFQjbkD1B2ZfK6DO/en8/ze77fvvXLFEsDUzURMY6W+oirRESWr/kG
rfIdfyAvv/MnHmojnvRiXUQpFTGYjKiYzcmTZmW54vsFj+ijOJcXfV+Sl/FW
3ecFNMqH7jhCWt7nIecPuEG/5zymzR65w2xGznGbOy/NJvR2vchj+PXOLi6g
Gz962u6a3X49aXePg1fMeuUsJ7wnZbYjN9nf4i9n53kW33LBTieO7fVxD26d
362+R85iWz4zW+WMfiKvy5sYdm+z2anZhv7qzhfk9GcuJ/7/xx8FrjNY
         "]], Line3DBox[CompressedData["
1:eJwl0b8rxHEcx/H3nTsiIXVdMlllNcpAlPEYLBYWDCzKoMSC0UAoV3KDksi/
4Bg4oxAnk1xJUlY/Hpfh2fP1en8/38/n+6NjfDY3k4iICXTWRxSTEVfoki+5
hNZUxI/ews24SUfkGyKOayKmuE8/krfkWtdL+jVS8oZZUb5AUn/kJ0xb/63/
YlJuNNt2RhPP6VkedK1glpEXzA7lJR62Z5vZgT6v73IeY/IKr2INo3qPtRX7
LOsj+iLn+NNsXe7lD/Sb3XO39bc8oJf5AUPyqfNO8FJ9T95E2f2vekHex5dc
MXvjHf1Zfpf37Hmn11Wf235pTiErJzjD7Tj3rc+S///hD8EdN0k=
         "]], Line3DBox[CompressedData["
1:eJwl0L8rxHEcx/G37zmhJKVLt5llNZpcBpNfwy36JguKSRkY2JDBQEikTllE
/gaOgcmAOKNcSZKVPC7Dq+fr9fq8399P30/n+OzQTF1EpNTVFFFOIq4oVx+R
NEdkqINvwDw24kM24hA/MhG7/DtW7R7x6/rUXIl/01f0W/w2vcpneE4D/JO5
CvXz99hj9xELckoF+VPe8I0vHNaN0rJclXudF+U1eZVWaEw+wH2a548x774R
s0vyAuXkkr4dB/WLujlqlXf0LTgpB/66Z5p/4Z8pI5fxgjbtZuVbfgK/7V7X
/lV/YqePP8UpZ3u6O/nHTJt84427a/N4mfy//R/WgDW/
         "]], Line3DBox[CompressedData["
1:eJwl0TsoBVAcx/G/i3INcstgE6Uog0fuwi2LvLabAYk8FqnLQBQlIqWUlFLK
bjDIwKIYkNnjbh6TsiuTfG6Gb7/H/39Op07t5Fw2VxQRU3hMRDyhJRnxQt/x
gbT8StvpG70ujnjgJ0ojcuURN/ItZuTLgjcb5WfNsiURw/y5fkVe5deQlxfp
Mqr4I3vHSPEHdNAdh7RCbkOLs3fyvP6epnVNaNBfyNP6RnmMjuPHOztoJzL4
llN2t+z2ywm7v7oNuUdep5XmRfoy7MnV8i79tLdEF/DFd3lzBif2emk3rtyx
X3gPP2BvxNl6/ky/qa/ht+mQvs+8Tj4129Hl3dnKP9Pm5P8//AFltTIy
         "]], Line3DBox[CompressedData["
1:eJwl0DEvQ3EYhfG3qoOmdoOlSTs1kjYhfAAscg3SWtAisYi6uQmLScRgYhGL
hfABms6ii0HEpr6AWC1Wi58YTp7nnJv3P9zydrqyn4uIlnyORHRHI1L54BmW
pViMOMIvWzIWccZ/eMl+zL/5nL3CF3FB5qWqb+C6NHgXp/MRT7zuts4HfNc+
zi/5pL2GtzJh62NPKvy0EHEibzzDVN750P0AN/U992181F/tz7ijZ/amdw7x
xXaAq/rN3x2/xjYmtg4u4xY23J771vPWBdb0NfsUXukP9juc0Wflni9hUvj/
n7+WuSp0
         "]], Line3DBox[CompressedData["
1:eJwl0MsqhHEYx/HH4V1Q2ChZUBYOCzmVw7gCC41SdjQ1JCUz0zsXYCEL9rJx
KHIBYuFYLBQxNtyBuAGWlI8svv0Oz/P8e3s78sXpQlVE5PBeHVGojSjhjR+t
i0j5Mj7kH2R1G3JzfcQmTWoiPvXj+gxWdV9yk3kjGvAtd9Mu9Ni/s1O0W8Cw
PIhbXb/5DV3WD+lacCgfoM2sVT7hj9HJrycRa3jlU/rirkQv5Tl6RVfc5fh7
s2t5iZ9xn+rLWJAf9M/mFfqICv9Ep+xd8Hv8Ds74XXpO9+mA27w35jFht/3v
e/Sn5r38rH5L7uO36Qhd1I3RI3mSZpP///4LtjYx/w==
         "]], Line3DBox[CompressedData["
1:eJwl0L0uw1EcxvGftzTFbtAWnUQwSDe9CP1raIwS2qFl1zBYGmWzsIpQiVgN
jOYWCRZcgnAH/SSGJ9/n5ZwznJnN3WRnICJKlB+OaNLPYERxJGKZOkMRtdGI
a1yTy/SUjriQC/yK81v2Jf5Bf66/xzNs6t75N+rKPdzW9fgXvuLuKzZ0e95Y
l6v8s/1D3+KP6FM+tH9jWz6mL/4WF93J2+5wStfBafkGs/ICVrx1iTn9PG7I
V5ix1/lxTHCVUvyJbcLZWZzEUyzZ5vDP3xzgmH4ff+VHrKX//68PEPYp/Q==

         "]], 
        Line3DBox[{751, 1148, 1059, 2606, 1213, 779, 2384, 774, 2383, 1163, 
         2582, 2581, 1065, 2393, 1189, 2591, 795, 2391, 794, 1199, 2595, 800, 
         1191, 798, 1197, 2593, 1196, 803, 1423, 1422, 2689, 987, 1416, 1414, 
         986, 2520, 978, 1390, 2681, 977, 2680, 1388, 2512, 922, 2485, 2486, 
         1327, 2653, 1100, 2660, 1331, 929, 2496, 944, 1363, 1365, 934, 2663, 
         1337, 1338, 815, 1210, 2407, 1211, 751}], 
        Line3DBox[{802, 1194, 1195, 801, 2395, 1204, 1072, 2596, 2597, 1071, 
         2603, 2604, 2605, 1074, 1214, 2409, 806, 1206, 1205, 807, 1362, 1361,
          946, 1360, 2666, 1359, 945, 2499, 2498, 2497, 1105, 2687, 2686, 
         1113, 1420, 2688, 1421, 982, 1395, 1396, 802}], 
        Line3DBox[{827, 1226, 2611, 1228, 826, 1232, 831, 2615, 1248, 845, 
         2620, 1081, 2618, 1253, 2428, 2427, 849, 2466, 1298, 2640, 1093, 
         2639, 869, 1273, 2630, 1088, 1268, 867, 1272, 2452, 1270, 868, 1514, 
         1513, 2724, 1056, 1518, 1516, 1044, 2560, 1023, 1473, 2545, 1024, 
         2710, 1479, 2547, 993, 2692, 2693, 1424, 2521, 991, 2523, 1426, 994, 
         2542, 1015, 1449, 1451, 1014, 2539, 1446, 1447, 827}], 
        Line3DBox[CompressedData["
1:eJwl0DFLgmEUxfEr2lBb9AHCrxA0mBEEEblEOubk6xq2ViAFQTUF+fYBEglC
qK9QtEZEa1NQqBRCJNIW/aDh8D/n3Huf4ckn25VGJiLK9JiLmKe5qYgHLGQj
nnBnMuIZl+QiFs372NQv4B72cMP8gN+nNX4XSzgzEdHmV+1c4LS87o0VuWY+
xpZ+hIn8g6m8jDm7Dd0A+7Sl67idxaH8SZdyRr7n6/jl9o5P9Yn8Lf9641bX
0r3xx3hCqe5VPuQ37R7hme7FTVU+59/NT/VXfJfG8od5zfxavqHF7P///QF/
JjD8
         "]], 
        Line3DBox[{2421, 1079, 2470, 2469, 1090, 1274, 2631, 870, 1276, 1275, 
         871, 1498, 1497, 1043, 1494, 2559, 1493, 1131, 2718, 2719, 1021, 
         2703, 2704, 2705, 1020, 1469, 2543, 1470, 1019, 1467, 1468, 844, 
         1246, 1247, 829, 2612, 1230, 1078, 2423, 2422, 2421}], 
        Line3DBox[CompressedData["
1:eJwl0M8rw3Ecx/G3Zs3XLu44+DMclOxIKYVCWynLyZKbg4MfB4yrshRuzlrL
n8BBkfti46JJRIvLHnJ49vrx/rzf9f0OLZamVroiYh733REPGE1FDPdGPPFN
TMoF5HSvcjmJaNEZ3SwO5QO86ebkHX4bWxjRVegxcnxfOmLCnXGse7uJQd2F
eT+d1m/o1pCVExyZleQMn8Yq/0jrGHDzmZ7ba9CMfE2XaNveLV8x65Fv+CL9
0f/iTs7K33xCl/HFv7u/a2cP+1j4+wZvG2ZN5OUz+cO7svkJ/6Iv6E/5T32N
tnRXtC1f0irGUv//uQPlDTZe
         "]], Line3DBox[CompressedData["
1:eJwl0DtKA2EUQOErE8UMam2hAXdhIb4LFWIRIY3apJGALywEK5dgbZC4CRFx
E4piK0mMEUNArIJikW+wOJxz78zPP8xM5ah0OBQRW3jORbxgKYl449mMNKLJ
m3aruqfnsay7vGN/kY+Yy87ZLWIB2/YbvI5TXeQznhyOKOlzPaXLel8nek0f
6FQf8yiP4ES3uIFp93S4jYLOOzPBj+Yf3/HA4+a+HuMn85+u6j1cer+GVO+i
4VkTLXy5552vnPnUr7rLdfOHvuZvc0//8p35PrtX3/AtVpL//zgA6bov3Q==

         "]]}, {Line3DBox[CompressedData["
1:eJwl0cErA2AcxvHfYmaKXCzLSezEwVWtppVykGRnEofVFAflJFGERaQlf4C/
YS0njUguTnJ1csSFJOUjh6fv833et3dr619YmVlORMSivCYjBtMRb5hqixjR
R9sjknoFG3wJT/lFKmKuI+JMf7S/8CO9rg/pdWlIzda03eh3cs4v8UoKehkr
ktdXcdiba5jjUziAGdukXvTZJW/12cZxwtblrJfneUGK0sN3sfr3ffVtrLk7
5m6Zb/J5vPbeup51diLTti1cs21giR/gvszq3e53ypOexYwce/Oe/7jzLU19
x7bp7JPv6be2Z28mbFX+wFvwkLfiB/+Sd797Lv3/P/wCl1wzVA==
         "]], Line3DBox[CompressedData["
1:eJwl0c8rw3Ecx/H3xGwiF8tyI1GcnFfTSjlIamdF1IpEqZ2kKcIi0g7K1d+w
lJRGJBcnuTr5A/xKy8GjHJ49X6/X59PnW1v/wlpxNRERi3hvixhKR3xwKhkx
Jie5FSupiEv9qj1iviPizHaKZ9ub7UiuyyNyHReo2Rq2O/kB5/o13yAvl3gJ
OXmdR71b5kF9mgc4Y5uSC75f9FafbYInbV3OevWcnkcBPfouV7Esb3PN3XF3
S3pFn+Nb723IWWcnmLFtcdm2yUX9gPcxK3e734kXOcsZHHvzUf91p4mGvGOr
OPvW9+R726s3w1bVn/QWTuDQ9qX/oIlPv/tw+v9/+ANDxDN0
         "]], Line3DBox[CompressedData["
1:eJwl0b8rxHEcx/G3wY+7Qv4B0SWcG4QkoyQZZUB+nmxyixTLrWYj6SJdBuVH
Bos/QQwmySLKIOny2+Ahw7Pn6/36vL+f7r7fxmxueLEsIubxWh7Rkoh449qK
iG65hqtxLi9XRRzKV5URS8mIY/lC/6I/kS/lTmfXuMGpLm/vSX7GmfmO79Er
T/AUeuQZbrKb5XbzCCcx5s5d92d0C/IAT3LOWbP9fvO0eRZzGDRvcQGr8iYX
7Q7ZHTevmEd5X7cjp3gPed0RF3UHf//PvM0FLMtdfkMHSnKG0yi4897cINfj
QS55fk2u43Xnt7oNTun63PWqf9T9eMdt8jd/4QNp8ye/ozXx/z1+AaZfOfQ=

         "]], Line3DBox[CompressedData["
1:eJwl0b8rxHEcx/H3DX7csZoMl5ISl3QkBiUhmyjlN2c/gy5nkb9CkUS6SYkM
Uv4GpbBg0U2S4QabH49vhmevH+/35923u7bCxnQxFRHr+K6L+MEvutOK+ogc
TdF3fPHtjREjDRH7mYhXXav8QmtmLdjTD5tn9VX9kdzJd6Em99I8SsnM3jE2
+XNa8f6C7si7mPL2TD7RP3gzizn9pL6iP9BvJ3foISb4Al3FMkblDrtFu4vy
mDzuxow8L5/yWfOcvgdr+nZ5hQ7IS3QBg3yVvuGW/6QfyXfavZaf+RtaTn4T
/t7tsttP/KX+CiWzR/nObMusWdfPZ2ieDuma+L70///wB4CSNSg=
         "]], Line3DBox[CompressedData["
1:eJwl0M0rhHEUxfE7oxkeC7Ixkc1s7FA2IzU1UlNWIivldTUiNmrKRpESEWkW
Ejt/gyYbb0WysZSdf4JS+EwWp+8559776+nJL65NrqYiYp6GWiL6k4imbMQn
ZVojsvTNv9I+n7bzYedJTuENbut/9W9yoTnih170x/qcvrsxk9uwg2b5PTsH
NMVvYtXtFk7ICzTs9s7uhv5QP81X9CP6mryjX2l8E+5SJz+KJSpSl9xud8xu
We6R83ThnZz+HMf1GfNefRX79OtYlJexQiX+AW/pkn/GR7p3W5Pr/BHOuH33
5pV+Cb/oVH+Cc2bX9upmZ7qEBvk0FswHkv9//wc9uS7q
         "]], 
        Line3DBox[{1861, 1552, 2382, 1793, 2576, 1866, 2376, 2377, 1565, 2448,
          2248, 2629, 1821, 2627, 2137, 2240, 2616, 1814, 2233, 2128, 1916, 
         2610, 1915, 1614, 2055, 2054, 2538, 1749, 2056, 2309, 1750, 2540, 
         2180, 2052, 2534, 1747, 2701, 2053, 2536, 1673, 2483, 2482, 2264, 
         2650, 1674, 2652, 2266, 1675, 2492, 1694, 2285, 2287, 2159, 2664, 
         1982, 2275, 2125, 1905, 2408, 2223, 2110, 2200, 1790, 2570, 1861}], 
        Line3DBox[CompressedData["
1:eJwl0Dsvg3EYxuFHmrQlIbQjSVn4AoaSMlgNmibSweTFQBxiNJik7aIpHQy+
g0NCYhAmJhEfgE2kicVisNUlhl/uw/9+3uEdS3Yq2z0RsYRib8QUTrMR3XTE
UF9EDnmkMhEzdBYj/Amati2s2SY40u3/dbRkt6JbxIF845uTugq9R11Xpf32
OdrAIP+FATy769o80lf5m6+7f5B/+CI+9O9IYVrOes+gYXOhO0fbd2vyGT9u
8yYnNsto6691x/TW+x2/qm/KV/wh7dhv6J7kXf4TL/yct026hXnduvtLuicX
vI2irFuQh92X6YQun/7/z797Ii6g
         "]], Line3DBox[CompressedData["
1:eJwl0C9Ig3EQh/ETwakMFKfFIJhsVmEGUcHgVqbgH1yaiFuZ1TrDNAl2wc1g
UtBmEQVxccG4oRbDRFiz7zMMX57n7nd3L7yzhaON8kBEbMrScER6JGJiKGId
M5KVGXUFT6TEzzFvtiEroxHTiYg3vsh38FkW+JT+I9+yc8qf+B5PYdKNFp/k
Y7zNu1hR/5lt8ZBX/U9s4qC3b/7O6+7XZM7sNh562+1/Xy541cw+/+BFubd3
1r/FD/S/8FL9on+NHfWP3PCmm788K7dyJ8v6Dzjubd7+Ma6qc/avMNRJ/bXE
/3/sATJ1LDw=
         "]], Line3DBox[CompressedData["
1:eJwl0D1LQnEYxuEnEc3jEIGbELQVtDWFCA5BQzRYQ4NbhG7W2ORguknQUCHZ
JygEQRqahQhqE6LJtoiiva0LGn7cL899/sNZPjjabc5FRBWpbMRWLuJ6PqKC
C/4Sh5mIFq3pnnDOL9n26KO8mUQU5T2+S0/0D3wV91h3L+g72PdWXpdgyn/Z
dvkszeDMti3/2m7gQ5dGT1+SP/lT9xSdoeONO3qLV30dI37Fdkzf5JpvV+V3
/sZ+ov/mf9BEw33N/Rkv2LY5pgto2A5tyrhC3rZPF23S7jvuA7mQ/P+/P9Po
KUU=
         "]], 
        Line3DBox[{2388, 2389, 2390, 1799, 2456, 2457, 1825, 2258, 2455, 2146,
          2257, 2256, 2147, 2333, 2332, 2190, 2335, 2722, 2334, 1855, 2709, 
         2708, 1845, 2685, 2684, 2683, 1844, 2292, 2515, 2293, 2171, 2297, 
         2298, 2122, 2218, 2219, 2117, 2589, 2209, 1800, 2388}], 
        Line3DBox[CompressedData["
1:eJwl0L9KQmEcxvFfS2rQ1KLkUAiRLTpIN1BEFAhpkWNWs4o0BU1N3UJ/ljaJ
Gmps6AaChpamyhuQk0vg1OfQ8PD9vs953nPQxcNuozMVEXtSno5o5SJ2MhE5
qc5EPGUj6tLRb3m+rCvLiszaNHFXzjzbxmPbR32Dn+sGvM57/JJv8AW8kgPb
N7nlbZz3jQomtgW+xH94uPOFc7pEivqh8y+/4HmcyJr3XNuu4w2ObO6ky6u6
Hp6kvwUrzn18x3ubV/cf8NP5NP1eStsP/Ys+cR7LM//GodT4PrZk0/YIV3Ul
9wfZ///zD54HLKA=
         "]], Line3DBox[CompressedData["
1:eJwl0L8rxHEcx/G35fwYDEZFnRKxOFa7rk7qlhsMSnc2riOJbsDIaKVE+bpL
mfgfUAYG2ZTBQroUA4eHDM9e79fz/Xl/h296tpxfaImIGRTaIw7aIno7IvKt
EcOpiBzm+TLWuE4UzSXMIWufyGP02SXIuZ9E1W4DdW7f/ta3p/hNroI9fhcT
3KJ+aL72ZsU8IrvdbMtB/JgH5JNdWo572+C6sOP+ge/hH+UX94l+/VlvmrfM
3/JVf0HG/aW+zF/JE66GC3Nd3tgv+W4Fp/q9fv7n7d/crPKj3B3O+IZc55p2
VbzjA1kcIcGYd9Pui96WkNGHUv///RfohDhG
         "]], Line3DBox[CompressedData["
1:eJwl0K9LA3EcxvGPxXnOJGLVYyw6m01YM4loWDQIBsfmZIoisuB/IGJQLIYN
NqNgtQmiGP2RxaRlyIpo8HUY3jw/vs/3uLt0rbGyORQRy8jnIkrDERU6PRrR
GYlYQBepPKZP+BubT/4Dczh01tL/4gcvScQ+fc2eh5rzvnyn77p7S5vyF3ad
7eFCv0HfdVs45cvuntNJ+2/MyxP0zbajT/kCjuzb8kA/w5fQ4M/sp3Bi86hb
xT2O5QdatznIvtfdZ7mnL9q36ZO8jkt+0WaHbmNJd529Iz9uO+vulVxN/v/f
H3z3LQk=
         "]], 
        Line3DBox[{1881, 1589, 2035, 2302, 2690, 2174, 2025, 2024, 1722, 2516,
          2163, 2001, 2669, 1837, 2667, 2000, 2502, 2503, 1703, 2711, 2082, 
         2548, 1768, 2552, 2327, 1771, 2569, 1788, 2102, 2338, 2191, 2723, 
         2101, 2336, 2143, 1944, 2451, 2252, 2141, 1943, 1646, 2632, 1956, 
         1656, 2645, 1828, 2641, 1965, 2467, 1811, 2418, 2417, 2228, 2609, 
         1809, 2411, 2116, 2208, 2588, 1576, 1877, 1586, 1882, 2594, 1881}], 
        Line3DBox[{1815, 2241, 2617, 2132, 2236, 2235, 2133, 2313, 2312, 2182,
          2315, 2541, 2314, 1737, 2525, 2524, 1697, 2495, 2494, 2493, 1695, 
         2273, 2662, 2274, 2157, 2277, 2278, 2108, 2196, 2197, 2107, 2359, 
         2198, 1789, 2584, 2585, 2586, 1798, 2613, 2614, 1815}]}}},
     VertexNormals->CompressedData["
1:eJxkfHc81e3/v733yp4h2atkXYqKEioRDZEyMlJpGBUyszIqVCiUUoSkocso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      "]],
    Axes->True,
    BoxRatios->{1, 1, 1},
    PlotRange->{{-2, 2}, {-2, 2}, {-2, 2}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx0vXVYlcv3PgyKIooIdndhYrcPx0RFxSbsbrH72Ap2K4jdjV3oYBcqFrYg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     "], {{
       {GrayLevel[1], EdgeForm[None], 
        GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwt2Xegz/UaB/DfOZyOcxyzISspScN222VkN1CaqpvbTcMootIiUSktkmxK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           "]], Polygon3DBox[CompressedData["
1:eJxM3XW4dlX1NeDnxHv6Oee8Kt0gJSAN0iEoKSFSKt0dIqnS3Z1SCogIohjY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           "]], Polygon3DBox[CompressedData["
1:eJwt2Hu8V1MaBvB9TuenX+fUOaemchkZJU0TSaVR0STJKAaDBiGELrpJIeNS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           "]], Polygon3DBox[CompressedData["
1:eJwV1nt8z1Ucx/HvmM3YbEoPUWrZWB4RhUYuhXIZYy4TKdMeSno8iqTkvkrE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           "]]}]}, {}, {}, {}, {}}, {
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0rlLHVEYQPHP3chzBRtTKaLWVvk70iaIuCAhkkRbBZdaBWujESUKIrg0
Cu4mEUMKcSFGUbRxAXEptLBI9PdIcTjnuzPz7nDflNZ9fP0hJSL6kZmIeMOv
MiNqcyNOUiOq9T7/Qb3OT4to5AYsW1tEmZ7labTlRFSY1/UPtJurzN/1N1S8
iPjJvXjMjujjEmsvMaS/oECP8GZ+REKP6l19pM/sf45jfcI7fMr7yed5GFN6
kCdwae8184ZexYV5xbyk11CeFVGcHnGv/7r2Dw+6yHqG9Sedo0N35kUU6mYH
1qxbMyLe6Sa06Pfcxu3cwV18iFm9zVtodB7T5t96D3XmSfOu3kG/M5njbl7g
efToXzzK1/yVr/jI/zXg1c68U6X+rAdxbh7mW77BuL7mMV5FqueXeAUF9k5L
7qVnkt+A+cG9k3oOCfM8tyR/1xl84gtu5Tuu4bc4SP///TwD7ElZ6g==
         "]], Line3DBox[CompressedData["
1:eJwt0rlLHVEYhvHPqHEhRrG1CgRcgsaIqI0GQa8KLhhcbsw17o2FYqGgCYJF
REFcGpc/RrAStBM0dtYq2CWFSkJ+AykenvedOcw358y8mZz/NJcVEXsoz424
5wEXPhdGjOmdcgppPaP3yxmM5luTrOOR5D6G5GHUyR/5PdfiuDiiWf8gvy2K
mHkRca1P8w0v8AMv8wru5Qxf8iin8dfsC31I/oKclxE/9XF5Arn6JGfj1Nrf
Zp3wL77lBtdLzG5Mnq838UhexFyOfXLr64hFeQmz+iof8D565G6k5A5ux67z
aNNr5Aps6y36O7kaWUnnZpTKX7mM/5ibKrAfbjLzmdv0J57himznwuvetVKu
wrr+A1PyJg/wIFblfk5jx/7X9GG5HRv6N71V7sKW3st9OJPPsSuf8h7v47v3
udQP5Ss+4mJ7yku+9ytnzCX6o3+k1hk+cT3f8e3//+cfGR9D3Q==
         "]]}, {}, {}, {
        Line3DBox[{1254, 1253, 3737, 1252, 2723, 1262, 3739, 1225, 2712, 1226,
          3723, 1213, 2708, 1214, 2742, 1233, 3725, 1231, 2714, 1230, 4058, 
         2715, 1232, 1221, 4056, 2710, 1222, 1223, 4057, 2711, 1224, 3803, 
         1429, 2806, 1428, 3802, 2805, 1419, 1418, 3808, 2809, 1435, 1436, 
         3811, 2811, 1438, 1413, 3795, 2799, 1412, 1415, 2801, 1404, 3793, 
         1405, 2797, 1409, 3794, 1408, 1407}], 
        Line3DBox[{1255, 1256, 3740, 1257, 2720, 1258, 3741, 1260, 2721, 1259,
          3738, 1261, 2722, 1251, 3736, 1228, 2713, 1227, 3724, 1229, 3726, 
         1234, 2717, 1236, 3727, 1237, 3762, 1321, 3759, 2757, 1320, 3761, 
         1306, 3752, 1301, 2749, 1300, 3754, 1308, 2770, 1352, 3776, 1350, 
         2768, 1331, 3764, 1325, 2759, 1323, 3763, 1324, 1328}], 
        Line3DBox[{1264, 1243, 3730, 1244, 2726, 1247, 3732, 1246, 3731, 1245,
          2725, 1250, 3733, 1248, 2719, 1249, 3734, 1235, 2716, 1217, 3721, 
         1215, 3720, 1216, 3748, 1299, 3751, 3750, 1303, 2751, 1309, 3772, 
         1346, 2767, 1348, 3775, 1327, 2760, 1326, 3768, 1340, 3770, 1339, 
         2763, 1337, 3767, 1338, 1808}], 
        Line3DBox[{1292, 1293, 2743, 1294, 3747, 1288, 2740, 1283, 3745, 1284,
          2741, 1285, 1274, 2733, 3743, 1275, 2734, 1276, 4061, 2744, 1295, 
         2745, 1272, 2731, 1270, 1271, 1464, 2824, 1465, 2825, 1461, 3816, 
         1460, 2823, 1462, 3817, 2821, 1442, 1440, 2812, 1439, 3812, 1441, 
         2813, 1443, 3814, 1453, 2819, 1457, 1458}], 
        Line3DBox[{1319, 1316, 2756, 1317, 3758, 1318, 2778, 1373, 3782, 1376,
          2779, 1368, 1367, 2789, 4065, 1385, 2791, 1357, 3778, 2773, 1356, 
         2775, 1362, 2776, 1363, 1364, 1550, 2865, 1551, 2864, 1531, 3842, 
         1532, 2858, 1545, 4078, 2863, 1528, 1527, 2852, 1526, 3844, 1523, 
         2850, 1522, 3845, 1538, 2855, 1537, 1541}], 
        Line3DBox[{1332, 1333, 3765, 1329, 2761, 1330, 1349, 2769, 4063, 1351,
          1345, 2766, 4062, 1311, 2753, 1307, 3753, 1304, 2750, 1305, 3760, 
         2758, 1322, 1315, 3757, 2755, 1312, 3756, 1313, 2754, 1314, 1509, 
         4075, 2844, 1500, 4071, 2839, 1501, 1505, 4073, 2841, 1504, 1502, 
         4072, 2840, 1503, 1485, 4069, 2834, 1484, 1474, 4067, 2831, 1475, 
         1476, 4068, 2832, 1477, 1479, 1478}], 
        Line3DBox[{1372, 1369, 2777, 1370, 1371, 2785, 4064, 1383, 2786, 2787,
          1358, 1355, 3777, 2772, 1354, 2771, 1353, 2857, 1544, 3847, 1542, 
         2856, 1543, 2866, 1552, 4079, 2867, 1536, 1535, 2854, 1533, 1534}], 
        Line3DBox[{1375, 1374, 2780, 1377, 3783, 1378, 2781, 1366, 1365, 2790,
          4066, 1384, 2788, 1382, 3784, 2783, 1381, 2784, 1380, 2782, 1379, 
         2859, 1546, 2860, 1547, 3846, 1548, 2862, 1549, 4077, 2861, 1539, 
         1525, 2851, 1524, 3841, 1529, 2853, 1530, 1540}], 
        Line3DBox[{1393, 1391, 3788, 1392, 2792, 1386, 3785, 1387, 3787, 1390,
          2795, 1400, 3805, 1433, 2808, 1434, 3807, 1424, 2803, 1422, 3800, 
         1423, 3801, 1427, 3834, 1510, 3833, 3832, 1508, 2843, 1494, 3828, 
         1493, 2836, 1488, 3824, 1489, 2849, 1482, 3822, 1483, 3837, 1516, 
         2845, 1513, 3835, 1511, 1512}], 
        Line3DBox[{1394, 3789, 1389, 3786, 1388, 2793, 1398, 3791, 1397, 2794,
          1399, 3806, 1430, 2807, 1431, 3804, 1432, 3810, 1425, 2804, 1426, 
         3843, 1507, 3831, 1506, 4074, 2842, 1490, 3825, 1491, 3830, 1496, 
         2837, 1495, 3829, 1497, 2848, 1519, 3838, 1518, 2846, 1517, 3836, 
         1515, 1514}], 
        Line3DBox[{1403, 1402, 3792, 1401, 2796, 1406, 3797, 1410, 2798, 1411,
          3796, 1414, 2800, 1395, 3790, 1396, 1437, 2810, 3809, 1421, 3799, 
         1416, 2802, 1417, 3798, 1420, 3840, 1521, 4076, 2847, 1520, 3839, 
         1499, 4070, 2838, 1498, 1492, 3826, 1480, 2833, 1481, 3823, 1486, 
         2835, 1487, 3827, 1471, 2830, 1470, 3821, 1473, 1472}], 
        Line3DBox[{1452, 1450, 2817, 1451, 1449, 2816, 3813, 1447, 2815, 1448,
          2826, 1466, 3820, 1469, 2829, 1277, 2735, 1278, 2739, 4060, 1279, 
         1280, 2737, 2736, 1281, 3744, 2738, 1282, 1298, 2748, 1297, 1296}], 
        Line3DBox[{1456, 1455, 2818, 1454, 3815, 1444, 2814, 1445, 1446, 2827,
          3818, 1467, 2828, 1468, 3819, 1463, 2822, 1459, 2820, 1269, 2730, 
         1265, 2727, 1266, 2728, 4059, 1267, 2729, 1268, 3742, 2732, 1273, 
         1291, 2747, 1290, 3746, 1289, 2746, 1287, 1286}], 
        Line3DBox[{1570, 1571, 2882, 1572, 3851, 1573, 2879, 1577, 3856, 1581,
          2883, 1582, 3855, 1583, 2902, 1627, 2899, 1557, 3849, 2870, 1555, 
         2868, 1553, 1554, 3848, 2869, 1556, 3940, 1773, 2970, 1772, 2969, 
         1771, 3939, 1757, 2962, 1758, 2963, 1759, 3938, 1770, 2968, 1769, 
         3937, 1763, 2966, 1764, 3959, 1830, 2992, 1829, 1828}], 
        Line3DBox[{1574, 1575, 2880, 1578, 3854, 1579, 2881, 1580, 3853, 1561,
          2872, 1560, 2901, 1562, 4080, 2873, 1563, 2900, 1628, 2903, 1632, 
         2960, 1756, 2961, 1754, 3934, 1753, 2959, 1755, 2964, 1760, 3936, 
         1765, 2967, 1766, 3935, 1761, 2965, 1762, 1767}], 
        Line3DBox[{1576, 1568, 2878, 1569, 3852, 1567, 2874, 1566, 2875, 2876,
          1564, 1565, 3850, 2877, 1559, 2871, 1558, 2973, 1777, 3941, 1776, 
         2974, 1775, 2971, 1774, 2972, 1752, 3933, 1750, 2958, 1751, 1768}], 
        Line3DBox[{1586, 3857, 1587, 3859, 1596, 2888, 1599, 3862, 1594, 2886,
          1595, 3870, 1623, 2912, 1624, 3871, 1619, 3868, 1618, 3867, 1602, 
         2889, 1603, 3911, 1709, 3910, 2938, 1688, 3898, 1689, 3906, 1703, 
         2937, 1705, 3908, 1706, 2954, 1742, 3927, 1743, 2957, 1747, 3932, 
         1746, 1748}], 
        Line3DBox[{1635, 1634, 3879, 1633, 2910, 1650, 3885, 1653, 3887, 1597,
          2887, 1598, 3876, 1622, 2898, 1620, 3869, 1621, 3878, 1610, 2892, 
         1608, 3864, 1609, 3915, 1714, 4085, 2944, 1700, 3904, 1698, 3903, 
         1699, 2936, 1702, 3905, 1701, 2956, 1729, 3922, 1719, 3918, 1720, 
         2945, 1721, 3919, 1722, 1734}], 
        Line3DBox[{1636, 1638, 1640, 2904, 3880, 1642, 1644, 4082, 2906, 1646,
          3881, 1648, 2908, 1629, 3874, 1614, 2895, 1615, 3866, 1616, 2896, 
         1613, 4081, 2893, 1600, 1601, 1605, 3863, 2890, 1604, 1212, 1211, 
         1210, 1209, 1202, 1203, 1204, 2707, 1205, 1834, 1835, 2994, 1836, 
         3962, 1837, 2995, 1833, 3961, 1827, 2991, 1824, 3958, 1823, 2989, 
         1825, 3970, 1800, 2981, 1798, 3948, 1796, 2979, 4087, 1778, 1780, 
         2976, 4086, 1785, 1787, 1789}], 
        Line3DBox[{1676, 1674, 2927, 1673, 3892, 1675, 2932, 1685, 3896, 1681,
          2929, 1680, 3894, 1668, 2922, 1667, 2924, 1663, 3890, 2919, 1662, 
         2920, 1664, 1731, 3923, 2950, 1730, 3983, 1876, 3010, 1875, 3011, 
         1857, 3976, 1858, 3017, 1881, 3015, 1868, 3980, 1869, 3005, 1870, 
         3981, 1865, 3003, 1864, 3977, 1863, 3002, 1861, 1862}], 
        Line3DBox[{1738, 1736, 3925, 1733, 2952, 1718, 3917, 1716, 2949, 1726,
          3921, 1724, 2947, 1728, 3930, 1745, 3931, 1695, 2935, 1694, 3912, 
         1711, 2942, 4084, 1712, 3914, 1612, 3865, 1611, 2894, 1590, 3858, 
         1591, 2897, 1617, 3877, 1631, 3875, 1630, 2909, 1649, 3882, 1647, 
         2907, 1645, 3888, 1643, 2905, 1641, 3886, 1639, 1637}], 
        Line3DBox[{1749, 1744, 3928, 1739, 2953, 1740, 3926, 1741, 2955, 1704,
          3907, 1690, 3899, 1687, 2933, 1686, 3901, 3902, 1696, 1697, 2940, 
         4083, 1607, 2891, 1606, 3872, 1625, 3873, 1626, 2911, 1652, 3884, 
         1651, 3883, 1589, 2885, 1588, 3861, 1585, 2884, 1584, 3860, 1593, 
         1592}], Line3DBox[{1790, 1788, 3944, 1786, 2977, 1781, 3942, 1779, 
         2980, 1797, 3949, 1799, 2982, 1801, 3971, 1849, 3973, 1822, 2988, 
         1820, 3957, 1821, 2993, 1831, 3960, 1832, 4008, 1923, 4005, 3026, 
         1922, 4009, 1924, 4007, 1927, 3031, 1915, 4001, 1917, 3038, 1935, 
         4013, 1937, 3040, 1893, 3989, 1895, 3035, 1939, 4015, 1941, 1943}], 
        Line3DBox[{1802, 3950, 1803, 3953, 1815, 2987, 1817, 3955, 1812, 2984,
          1813, 3966, 1844, 2997, 1845, 3968, 1839, 3963, 1838, 2998, 1846, 
         3969, 1848, 4019, 1944, 4088, 3036, 1904, 3993, 1905, 4004, 1920, 
         3024, 1918, 4002, 1903, 3021, 1891, 3986, 1884, 3018, 1885, 3987, 
         1886, 1887}], 
        Line3DBox[{1807, 1335, 3766, 1334, 2762, 1336, 3769, 1341, 2764, 1342,
          3771, 1343, 2765, 1344, 3774, 1347, 3773, 1310, 2752, 3755, 1302, 
         3749, 1219, 3722, 1218, 2709, 1220, 3779, 1359, 3780, 1360, 2774, 
         1361, 3781, 1263, 2724, 1238, 3728, 1239, 2718, 1240, 3735, 1242, 
         3729, 1241}], 
        Line3DBox[{1809, 1806, 3951, 1804, 2983, 1805, 3954, 1816, 2986, 1794,
          3947, 1792, 3946, 1793, 2978, 1795, 3967, 1840, 3964, 1841, 2999, 
         1847, 4089, 3041, 1910, 1906, 3995, 3994, 1907, 3996, 1908, 3023, 
         1909, 3997, 1901, 3020, 1890, 3985, 1889, 3019, 1888, 3999, 1883, 
         1882}], Line3DBox[{1810, 1811, 3952, 1814, 2985, 1791, 3945, 1782, 
         3943, 1783, 2975, 1784, 3965, 1842, 2996, 1843, 3972, 1850, 3974, 
         1826, 2990, 1818, 3956, 1819, 4018, 1945, 4017, 4016, 1921, 3025, 
         1913, 3998, 1911, 3022, 1912, 4003, 1919, 3032, 1902, 3992, 1896, 
         3990, 1897, 3033, 1900, 3991, 1899, 1898}], 
        Line3DBox[{1854, 1853, 3000, 1852, 3975, 1851, 3007, 1871, 3006, 1872,
          3008, 1873, 3982, 1874, 3009, 1659, 2915, 1654, 2913, 3889, 1655, 
         1656, 2918, 2917, 1660, 2916, 1661, 3893, 1677, 2928, 1678, 1679}], 
        Line3DBox[{1860, 1859, 3004, 1867, 3979, 1855, 3001, 1856, 3978, 1866,
          3016, 1877, 3012, 1878, 3984, 1879, 3014, 1880, 3013, 1669, 2925, 
         1670, 2926, 1665, 2921, 3891, 1666, 2923, 1657, 2914, 1658, 3897, 
         1684, 2930, 1682, 3895, 1683, 2931, 1671, 1672}], 
        Line3DBox[{1942, 1940, 4014, 1938, 3034, 1894, 3988, 1892, 3039, 1936,
          4012, 1934, 3037, 1916, 4000, 1914, 3030, 1926, 4006, 1925, 3029, 
         1928, 3027, 1929, 4011, 1930, 3028, 4010, 1931, 1933, 1932, 1200, 
         2706, 1201, 1198, 1199, 1206, 1207, 1208, 1707, 3909, 1708, 2939, 
         1710, 2941, 3913, 1713, 2943, 1693, 3900, 1691, 2934, 1692, 3929, 
         1727, 2946, 1723, 3920, 1725, 2948, 1715, 3916, 1717, 2951, 1732, 
         3924, 1735, 1737}]}, {
        Line3DBox[{2022, 2023, 4116, 2017, 4113, 2016, 2739, 2028, 4118, 1997,
          2727, 1998, 4108, 2009, 2745, 2044, 4126, 2045, 4127, 1965, 2710, 
         1966, 4093, 1971, 4136, 2062, 4135, 2755, 2063, 4167, 2118, 4163, 
         2117, 2775, 2116, 4168, 2123, 2784, 2095, 4150, 2093, 2772, 2094, 
         4152, 2098, 4159, 2110, 2111}], 
        Line3DBox[{2029, 2027, 2026, 2738, 4117, 1995, 1996, 2732, 4111, 2013,
          2015, 2733, 4112, 2014, 2742, 1980, 4098, 1972, 2713, 2634, 4096, 
         1977, 2716, 1961, 4091, 1962, 2709, 1963, 4092, 1964, 2891, 2366, 
         2889, 4235, 2365, 2376, 2892, 4236, 2368, 2367, 2897, 4401, 2379, 
         2895, 2350, 4229, 2349, 2902, 2325, 4221, 2322, 2872, 4392, 2289, 
         2290, 2874, 4394, 2295, 2296, 2297}], 
        Line3DBox[{2030, 2032, 4119, 2024, 2736, 2005, 4106, 2003, 2729, 2000,
          4104, 1999, 2734, 2638, 4123, 1978, 2714, 2635, 4097, 1974, 4094, 
         1973, 2717, 1982, 4100, 2636, 4140, 2068, 4345, 2757, 2067, 4141, 
         2069, 4138, 2057, 2750, 2056, 4151, 2646, 2791, 2133, 4173, 2650, 
         2788, 2100, 4154, 2102, 2786, 2105, 4157, 2107, 2134}], 
        Line3DBox[{2037, 2036, 2743, 2639, 1991, 4340, 2723, 1989, 2720, 1990,
          2726, 1985, 4101, 1983, 2718, 1984, 2884, 2358, 2888, 4234, 2357, 
         2356, 2910, 2383, 2905, 4402, 2904, 2338, 2682, 2882, 2339, 2683}], 
        Line3DBox[{2050, 2049, 2748, 2640, 4343, 2048, 2747, 2041, 4342, 2040,
          2741, 2035, 4341, 1960, 2708, 1959, 2722, 1988, 4102, 1986, 2719, 
         1987, 2774, 2114, 4162, 2115, 2911, 4240, 2384, 2385, 2912, 2382, 
         2898, 4239, 2362, 2361, 2909, 2908, 2354, 4398, 2353, 2883, 2352, 
         4396, 2348, 2881, 2341, 4395, 2337, 2878, 2336, 2342}], 
        Line3DBox[{2051, 2047, 2746, 2039, 4122, 2038, 2740, 2034, 4121, 1969,
          2712, 1970, 2721, 2637, 4103, 1992, 2725, 1993, 2724, 1994, 2885, 
         2359, 2886, 2360, 2887, 4233, 2363, 2364, 2907, 2906, 2355, 4399, 
         2344, 2879, 2343, 4397, 2347, 2880, 2340, 2684}], 
        Line3DBox[{2109, 2099, 4153, 2090, 2771, 2091, 4149, 2092, 2782, 2121,
          4166, 2120, 2776, 2122, 4169, 2113, 4160, 4161, 2112, 2061, 2754, 
         4134, 1968, 2711, 1967, 4129, 2046, 4128, 2012, 4110, 2011, 2731, 
         2010, 4109, 2008, 2730, 2007, 4115, 2020, 2735, 2018, 4114, 2019, 
         2021}], Line3DBox[{2135, 2108, 4158, 2106, 2787, 2103, 4155, 2101, 
         4156, 2104, 2783, 2119, 4165, 2097, 2773, 2096, 4164, 2071, 2758, 
         2070, 4142, 4143, 2072, 4139, 1981, 4099, 1976, 4095, 1975, 2715, 
         1979, 4125, 2043, 2744, 2042, 4124, 2002, 2728, 2001, 4105, 2004, 
         4107, 2006, 2737, 2025, 4120, 2033, 2031}], 
        Line3DBox[{2137, 2131, 2132, 2785, 4174, 2136, 2138, 2790, 4176, 2139,
          2140, 2789, 4175, 2060, 2753, 2643, 4132, 2052, 2749, 2053, 4131, 
         2058, 2751, 2642, 4130, 2055, 2752, 4344, 2641, 2054, 2940, 2459, 
         4264, 2452, 2938, 2453, 2944, 4268, 2463, 2449, 2935, 4411, 2691, 
         2934, 2425, 4257, 2424, 2922, 2423, 4255, 2394, 2914, 2393, 4245, 
         2396, 2916, 2401, 4260, 2442, 2441}], 
        Line3DBox[{2141, 2125, 2777, 2126, 4171, 2127, 2781, 2647, 4170, 2124,
          2779, 2089, 2084, 2766, 4145, 2083, 2770, 2644, 4133, 2059, 2767, 
         2081, 2765, 2082, 4146, 2085, 2933, 4261, 2447, 2448, 2937, 2450, 
         2936, 4262, 2451, 2467, 2947, 2946, 2434, 4407, 2435, 2929, 2436, 
         4410, 2690, 2930, 2431, 4406, 2689, 2928, 2429, 2430}], 
        Line3DBox[{2178, 2179, 2185, 2816, 4358, 2186, 2214, 2827, 4364, 2198,
          2197, 2821, 4362, 2176, 2656, 2811, 4357, 2175, 2174, 2810, 4356, 
         2163, 2803, 2654, 4351, 2162, 2804, 2164, 4386, 2259, 2999, 4421, 
         2554, 2553, 2998, 2545, 2990, 4419, 2546, 2543, 2988, 4300, 2544, 
         2989, 2504, 4285, 2489, 2963, 2488, 4277, 2490, 2964, 2491, 4293, 
         2516, 2972, 4415, 2517, 2518, 2519}], 
        Line3DBox[{2188, 2189, 4182, 2183, 2815, 2184, 4181, 2187, 2828, 2664,
          4365, 2201, 2823, 2662, 4361, 2173, 2172, 2809, 4355, 2161, 4177, 
         2157, 2802, 2158, 4350, 2160, 4383, 2675, 4382, 2847, 2243, 4194, 
         2235, 4376, 2841, 2234, 2233, 4385, 2256, 2858, 2274, 4387, 2276, 
         2862, 2279, 4204, 2280, 2866, 2287, 4208, 2286, 2285}], 
        Line3DBox[{2193, 2190, 2817, 2191, 4183, 2181, 2814, 2182, 4180, 2177,
          2812, 2155, 2153, 2799, 4348, 2154, 2800, 2652, 4347, 2144, 2808, 
         2169, 2807, 2170, 4354, 2171, 2978, 4417, 2532, 2533, 2997, 2552, 
         2996, 4420, 2535, 2534, 2982, 2981, 2499, 4281, 2697, 2968, 2496, 
         4279, 2696, 2967, 2480, 4275, 2692, 2958, 2478, 2479}], 
        Line3DBox[{2211, 2212, 4190, 2206, 2826, 2207, 4366, 2215, 4191, 2199,
          2822, 2200, 4185, 2204, 2825, 2205, 4186, 2159, 2653, 2805, 4352, 
         2165, 4178, 2166, 4193, 2232, 4374, 4373, 2839, 2669, 2240, 4197, 
         2253, 2864, 2250, 4195, 2251, 2860, 2275, 4207, 2284, 4390, 2679, 
         2856, 2266, 4203, 2271, 2270}], 
        Line3DBox[{2213, 2208, 4188, 2209, 4189, 2210, 2829, 2216, 4192, 2195,
          2820, 2196, 4187, 2203, 2824, 2663, 4363, 2202, 4184, 2168, 2806, 
         2655, 4353, 2167, 4379, 2673, 4378, 2844, 2239, 4196, 2252, 4205, 
         2283, 2865, 2254, 4198, 2255, 2859, 2269, 4202, 2268, 2857, 2267, 
         4206, 2265, 4201, 2264, 2263}], 
        Line3DBox[{2257, 2249, 2853, 2677, 4384, 2246, 2850, 2221, 2665, 2831,
          4367, 2219, 2835, 2668, 4370, 2225, 2849, 2244, 2848, 2245, 3020, 
         2605, 3021, 2607, 3032, 4426, 2628, 2627, 3040, 3039, 2572, 4312, 
         2568, 3003, 2567, 4310, 2570, 3004, 2556, 2702}], 
        Line3DBox[{2260, 2258, 2854, 2678, 4199, 2247, 2851, 2676, 4200, 2248,
          2852, 2223, 2224, 2834, 4369, 2222, 2833, 2667, 4371, 2226, 2836, 
         2227, 2837, 2228, 3023, 2615, 3024, 2613, 3022, 4423, 2614, 2629, 
         3038, 3037, 2571, 4311, 2705, 3005, 2569, 4309, 2558, 3001, 2555, 
         4304, 2701, 3000, 2557, 2561}], 
        Line3DBox[{2262, 2261, 2855, 2220, 2666, 2832, 4368, 2217, 2830, 2218,
          2845, 2674, 4381, 2241, 2846, 2242, 3019, 2603, 3018, 4422, 2604, 
         2606, 3033, 2630, 3035, 3034, 2566, 4308, 2565, 3002, 2564, 2704}], 
        Line3DBox[{2282, 2281, 2288, 2867, 4391, 2272, 2273, 2861, 4388, 2277,
          2278, 2863, 4389, 2238, 2670, 2840, 4375, 2229, 2230, 2838, 4372, 
         2231, 2843, 2672, 4380, 2236, 2842, 4377, 2671, 2237, 3041, 2633, 
         4338, 2632, 3036, 4427, 2631, 2616, 3025, 4424, 2617, 2620, 3031, 
         3030, 2562, 4307, 2563, 3015, 2601, 4328, 2602, 3016, 2579, 4315, 
         2580, 3007, 2573, 4313, 2574, 2578}], 
        Line3DBox[{2316, 2317, 4227, 2318, 2871, 2319, 4224, 2334, 2903, 2313,
          4216, 2314, 4219, 2293, 2869, 2294, 2306, 4213, 2305, 1955, 1954, 
         4090, 1953, 1950, 1951, 1952, 2707, 1949, 4339, 2706, 1948, 1946, 
         1947, 1957, 1956, 1958, 4271, 2472, 2471, 4272, 2469, 2950, 2414, 
         4252, 2415, 4254, 2419, 2925, 2391, 4243, 2392, 2915, 2386, 4241, 
         2387, 2405}], 
        Line3DBox[{2320, 4220, 2321, 4225, 2332, 2877, 2333, 4226, 2335, 2900,
          2315, 4218, 2291, 2868, 2292, 4217, 2303, 4212, 2304, 2311, 4215, 
         2310, 2312, 2890, 2685, 2369, 2370, 2371, 2457, 4263, 2456, 2458, 
         2455, 4412, 2939, 2454, 4269, 2470, 4270, 2417, 2920, 2416, 4253, 
         2418, 2926, 2395, 4244, 2389, 2913, 2388, 4242, 2390, 2404}], 
        Line3DBox[{2331, 2329, 4223, 2327, 2876, 2301, 4211, 2299, 4209, 2298,
          2873, 2324, 4232, 2307, 2870, 2309, 4231, 2346, 4228, 2345, 2893, 
         2377, 4237, 2686, 4267, 2460, 4414, 2941, 2411, 4251, 2407, 4250, 
         2410, 2919, 2412, 4256, 2420, 2921, 2406, 4248, 2397, 4247, 2400, 
         2918, 2403, 4259, 2440, 2438}], 
        Line3DBox[{2372, 2373, 4317, 2582, 3009, 2588, 4321, 2589, 3013, 2600,
          4327, 2590, 3010, 2591, 4322, 2592, 4324, 2595, 3028, 4425, 2623, 
         2624, 4334, 2625, 2550, 2699, 2994, 2548, 2549, 4330, 2612, 2611, 
         2610, 2609, 2608, 4329, 2511, 4290, 2510, 2970, 2505, 4286, 2485, 
         2960, 2484, 4296, 2522, 2973, 2502, 4284, 2503, 4297, 2524}], 
        Line3DBox[{2374, 2375, 4318, 2583, 3008, 2584, 4320, 2586, 4319, 2585,
          3014, 2594, 4323, 2593, 3011, 2596, 4325, 2597, 3027, 2622, 4336, 
         4337, 2626, 4335, 2551, 4303, 2700, 2995, 2507, 4288, 2508, 4289, 
         2509, 2969, 2506, 4287, 2487, 2961, 2486, 4294, 2520, 4295, 2521, 
         2974, 2523, 4298, 2526, 2525}], 
        Line3DBox[{2427, 2426, 2927, 2688, 4405, 2428, 2951, 2952, 2466, 2945,
          2465, 2477, 4274, 2957, 2473, 2953, 2078, 2762, 2077, 4144, 2079, 
         2763, 2074, 2759, 2073, 2761, 2066, 4137, 2065, 2756, 2064, 2649}], 
        Line3DBox[{2433, 2432, 2931, 2444, 4408, 2443, 2932, 2446, 4409, 2445,
          2948, 2949, 2468, 2476, 4273, 2956, 2475, 2954, 2474, 2955, 2080, 
         2764, 2076, 2760, 2075, 4147, 2088, 2768, 2087, 4148, 2769, 2645, 
         2086, 2778, 2129, 4172, 2130, 2780, 2128, 2648}], 
        Line3DBox[{2437, 2439, 4258, 2402, 2917, 2399, 4246, 2398, 2923, 2422,
          4404, 2421, 2924, 2413, 4403, 2409, 4249, 2408, 2943, 2462, 4413, 
         2942, 2461, 4265, 2464, 4266, 2381, 4238, 2380, 2378, 2894, 4400, 
         2687, 2896, 2351, 4230, 2308, 4214, 2680, 2899, 2323, 4393, 2681, 
         2901, 2302, 4210, 2300, 2875, 2326, 4222, 2328, 2330}], 
        Line3DBox[{2495, 2494, 2992, 2547, 4301, 2531, 2976, 2977, 2530, 2985,
          2536, 2537, 4418, 2987, 2538, 2983, 2145, 2793, 2142, 4346, 2651, 
         2792, 2143, 2796, 2149, 2797, 2150, 4359, 2659, 2819, 2194, 2661}], 
        Line3DBox[{2497, 2492, 2965, 2694, 4278, 2493, 2966, 2695, 4280, 2498,
          2979, 2980, 2529, 2528, 4416, 2975, 2527, 2984, 2539, 2986, 2147, 
         2794, 2146, 2795, 2148, 4349, 2152, 2798, 2151, 2801, 2156, 4179, 
         2657, 2813, 2180, 4360, 2660, 2818, 2192, 2658}], 
        Line3DBox[{2514, 2513, 4291, 2512, 2971, 2515, 4292, 2483, 2959, 2482,
          4276, 2481, 2962, 2693, 4283, 2501, 4282, 2500, 2991, 2698, 4302, 
         2993, 2540, 2541, 4299, 2542, 4333, 2621, 4332, 2618, 3026, 4331, 
         2619, 3029, 2560, 4306, 2559, 4305, 2703, 3017, 2599, 4326, 2598, 
         3012, 2581, 4316, 2576, 3006, 2575, 4314, 2577, 2587}]}, {
        Line3DBox[{3078, 3729, 3079, 3730, 3080, 3740, 3091, 3737, 3090, 4340,
          4021, 3747, 3122, 3119, 4122, 3746, 3120, 3129, 4343, 3116, 4117, 
         3744, 3114, 3115, 4119, 4120, 3113, 4116, 3112, 3111}], 
        Line3DBox[{3165, 3767, 3160, 3763, 3159, 3765, 3153, 3152, 4137, 3758,
          3151, 3218, 4172, 3783, 3217, 3216, 4171, 3215, 4174, 4064, 3220, 
         3193, 4157, 4158, 3192, 4159, 3195, 4029}], 
        Line3DBox[{3292, 4188, 3293, 4190, 3279, 4182, 3278, 3274, 3813, 4358,
          3694, 4183, 3281, 3280, 3815, 4360, 3283, 3282, 3814, 4359, 4030, 
         3240, 3794, 3237, 3792, 3228, 3788, 3229, 3789, 3692}], 
        Line3DBox[{3344, 3835, 3307, 3821, 3306, 3305, 4368, 4068, 3304, 3845,
          3363, 3355, 4384, 3841, 3354, 3360, 4199, 3699, 4391, 4079, 3375, 
         3376, 4208, 3369, 4203, 3365, 4201, 3364}], 
        Line3DBox[{3424, 3422, 3857, 3421, 3879, 3450, 3886, 3704, 4402, 3880,
          4042, 3851, 3407, 3408, 4397, 3854, 3410, 3409, 4395, 3852, 3402, 
         4394, 4037, 3381, 4222, 4223, 3398, 4220, 3397, 4040}], 
        Line3DBox[{3462, 3463, 4259, 4258, 3490, 4260, 3483, 3482, 3893, 4406,
          3484, 3485, 3895, 4408, 3478, 3477, 3892, 4405, 3480, 3481, 3924, 
         3925, 3524, 3919, 3523, 3708}], 
        Line3DBox[{3640, 4318, 3633, 4314, 3632, 4313, 3618, 3606, 3975, 4304,
          3607, 3608, 3979, 4310, 3622, 3621, 3977, 4308, 3626, 3625, 4014, 
         4015, 3655, 3991, 3648, 3649}], 
        Line3DBox[{3712, 3586, 3950, 3587, 3952, 3580, 3944, 3711, 4086, 3582,
          4301, 3959, 3549, 3548, 4278, 3935, 3541, 3542, 4275, 3933, 3543, 
         4415, 4050, 3569, 4291, 3570, 4298, 3575, 4297, 4051}], 
        Line3DBox[{3042, 3043, 3050, 3048, 3049, 4263, 4047, 3511, 3512, 4267,
          3914, 3519, 4266, 3520, 3915, 3514, 3911, 3513, 4083, 4023, 3749, 
         3131, 3748, 3130, 3154, 4140, 3762, 3157, 4139, 3150, 4136, 3147, 
         4134, 3146, 4379, 3335, 4193, 3334, 3349, 3840, 4383, 3348, 3343, 
         3834, 3339, 3831, 3340, 4089, 3685, 4019, 3684, 4018, 3676, 4333, 
         3675, 4008, 3677, 4335, 3680, 4334, 4054, 3679, 3686, 4339, 3042}], 
        Line3DBox[CompressedData["
1:eJwl0D1LwnEUxfErBQZqKggVLdmraKqpLTP0HbT0hLkERbi0SVG9jKZ0Edtr
bGgLpLUHqCBQWiSjjzQcvuece3+XP//iZr2yn4iIKj2nIl7ojQ5zEcuZiBWa
ycrTETv8Lp2bzelq/AW/h7PyNp7JWzgv13EBG+mILzd/+FN3PvkmfmCYTXpz
KSf4Cf5bP7I7wB72sahfMr+ip/FuPuKGr+g72KZH/a/c4q+pJ3fHN91YtH/H
31JDzpmt6gp4IifxAKfw3o0UHslpfJCP+Qy/Rhv0rivjOpXo1TcO7XSy///x
D2eyL3M=
         "]], 
        Line3DBox[{3721, 4091, 3053, 3198, 3779, 3197, 3873, 3441, 3868, 3440,
          3878, 3436, 4236, 3423, 3858, 3701, 4400, 4081, 3411, 4228, 3385, 
         4212, 3386, 3387, 4038, 4213, 3388, 4329, 3566, 4288, 3560, 3559, 
         3961, 4302, 3594, 3957, 3593, 4419, 3714, 3974, 3599, 3963, 3598, 
         3967, 3268, 3810, 3259, 3253, 4351, 3800, 3251, 3799, 3250, 3248, 
         4177, 3249, 4352, 3802, 3256, 3289, 4184, 3127, 4128, 3126, 4127, 
         3056, 4056, 3057, 4095, 4094, 3064, 3071, 3726, 3054, 3721}], 
        Line3DBox[CompressedData["
1:eJwl0bsrhXEcBvCvcr8dwmFEUcfAxmokJoui0EFSLmFWssmibAwWi8vI4B9A
GQyUW8lhksVyyK18ZHj6PM+v933Pec9pSM/2zeRExKS8lUSslke8c4MFFRHV
pRFFsm7nco15rElEjJVFJDnONo5yxT1pttgpGdAHpbUyImH3692y6Louppy/
Om/X55x1cJm9XGIPT/nGY2Z5I0PuObCv9UPe8l7Szo/sjP4gU/a0fOmdPuuT
E/YHF5jvfea57Z3O9U2ecYP78uNZl/aevivf9oW9o59IsWc+21f6o5TZL/aD
npFh1z9xhE2sYjOTrPv7bVnLO9+hUE/q9bLlGRV2o55la+n///MLoJE79Q==

         "]], Line3DBox[CompressedData["
1:eJwl0D1KQ0EYheEvaiFcTQzBRojBws5G0AUYXIEQC0uxCBYRFESx0ZBoY2Hl
AnQVBkEjKbMAMYIRLQXT+gPmuVic+573m+HOMHObO2u1TERU5DzrMxXxlUTk
JiIueRY7WDav6w1ZyEUcTUZcmB1gie9hEXdxHmu4mI+Y0df1ipzafyZl/RCX
cNx6J/0fX+WfssUf+EBv4zu28A0/ZN96l5+4V1OfxgYW8BgzuOLsP3u3+Y07
t2TE7Nnarf6CV3gtY+avvK3fyyjv8zu9JxvOesTEvJq+CS/xWVzGIv54s6f0
bP1X/07+33MI2qgv1w==
         "]], Line3DBox[CompressedData["
1:eJwl0DsvQ3EcBuAfCUlzzqG1tpq4bEZWCeETSJfGVqOEhbokDBqJRUwSk8vn
kNbUdLOoDhIWIQw+gRBPY3jzvO8/55YzUdtc2RiIiKqcjkQM5iN+koh8GnFh
D9upnsi5nbHNBmdGI+pZRJk7nOYWz9yzzSl7Uvb0ihw7n2edOecdOdGXnO1z
gbtcZItfvOMn32XN9bf2m95klw9y5LwhBd+1XNB5YI/xkMF1tnzzi97kMy95
Jd+edW9f6zcy5BmvdlvvSc7+sLv6o1Rd/8RVlpmxxJTjLHGu/w7vLOqz+m/y
/3//AEVcMOA=
         "]], Line3DBox[CompressedData["
1:eJwl0c8r5HEcx/H3Wi4zY7A4sCdxcCDksmcXJw5+FLXKbCEHhFIKJTfnzZCo
veyfgIPag12MHwcHJ9tOyQknhJTy2BxePV/P1+c7n/lV822ia/xDRMxKQSri
oxSVRnxPRyT0DazEdRyRh2RElfMfeqO9RR55DZbgpv2zXiUJnpRq/W9JxJaU
8Vr+CetwAP9hXm69Nl0WcaL32o/xVK7tKXtO77Ef4r5c2bv5L/eO6Wfy036O
K5jDF+dZfVWO+BpOeL5Qn8QibHP3a3HEKH/GYVywP+GZ7Lgjg5fO8rLNB/m8
Zy74H36Pv/EBD3DI+Y1+Lbu8E5ewAxcx5zwhX/g0n5JWfc9W7/O068V6g96n
90spb+Jf9Tt91vs34xxvxGFcds+MvZxneMX/39x3zqbf/9836lBCaQ==
         "]], 
        Line3DBox[{3750, 4130, 3134, 3143, 3773, 3177, 3901, 3496, 3898, 3497,
          3904, 3501, 4268, 3515, 3912, 3516, 4413, 3913, 4044, 4251, 3466, 
         4269, 3529, 3530, 4272, 4048, 3531, 4324, 3616, 3615, 4011, 4336, 
         3672, 4331, 3671, 4009, 3678, 4016, 3682, 4427, 3717, 3993, 3656, 
         3994, 3318, 3825, 3314, 3315, 4380, 3832, 3341, 3839, 3347, 3350, 
         4194, 3332, 4373, 4071, 3331, 3357, 4196, 3199, 4160, 3201, 4167, 
         4025, 3757, 3148, 4142, 4141, 3158, 3156, 3761, 3132, 3750}], 
        Line3DBox[CompressedData["
1:eJwl0D1LQmEYxvHboS1PtQQ5CE2NfYEKHBIcXGyqsaYMfPkGbX2I5rA0kF6M
FiObyxbD71AuRqFu/aThz/++ruc59zmc9cNqqZKKiCIelyIaScT2YsQJz5Yj
2rwnb5qLvMFl3TUKck4+5Z5nv5BZiag5W+WFdMSLboSsXNcnuhk/6z6xpq/K
EzvO5YL5286heYoj+YYPeKT/MF9gXx7LZ/PvsKOpG+DV/je0nb1zH/e4w67z
W95y/4F3+EfXNV+5/8S/ch95dORLfXN+Vy77xmPvm+payf//+gOINDL3
         "]], Line3DBox[CompressedData["
1:eJwl0DEvg1EUxvHTboQiMVgQ0clo9EraqkFtSCy2isSCnVmDJjVXxIRKiJil
MVu6+AiSSuxNFxJ+bzo8+T/POeeee3Pnqkebh5mI2KDCSESRFsYjXnIRr2MR
q3xNrYynWMELPMDZ0Yg9nMFh+jY/NRExxGfpS56Uf83/UM/OP+xjRv9af52/
xS28wRquObONLfme8vw0faR3YRcT/MRL/SW+ke6TO+kuepef5TO8wiad83Va
1k/cceLcDv+kVsBHXMEW3pk/1k/kqjfv0qLam9o+307fiSWaV3/IDf7vHzZI
LAY=
         "]], Line3DBox[CompressedData["
1:eJwl0LEuQ2EYBuCPyVBUDCUsJ+oGGCwWqiUxaRhqJGk3BhfRSggSa+WUpAkD
OpNI3IG4BAOjiCaY+jSGN8/3/uf//3Nykp398t5ARFTkeiQin40oZCJKcqPP
6kXzijzpVT6wxsJoRGfYM95yiXdsO3PPbb0iqflcWtaPOT8WMWf9yJxaO2WT
J7zgGd+56D1vTDglDWde9GnzK2e4Kan1lmyYV91d5pW+xUuus8lwb9fc9e2f
/OaPjDvzpf+a/ySnf9g/ZH9OEn1QnzBPym7/G1hlo/+veMg11lnko/3P7lww
H1hbzvz/3x4l1DDt
         "]], Line3DBox[CompressedData["
1:eJwl0bsrxXEcxvGvUhYcRspAshzkyO1QLBiEZHI5C5NBRwpFuQwsLqfcR4PL
HyAZmBjslFKIXEYMVuQlw7v383w+39+tX+HgSHcyLYQwib7MEI6yQ+jlYVTl
hPAQCSEpX5ineBlt5kvcxU/2U/IE6vUGjMpnzp/a1eljepzHOcmxrBAqkWFf
khtCmTxsXspRvJkXm4+5x5B5kVkh0s1f3OOZI/av8jc+nfv5y1xg/iG/40vP
dd2O883yOjdxqzONvKW38CZvoFUux41nruhlchTX+qKeJ+fjVq/iO67mR07Z
18o1uNenPXeVZ3iNZznmzBxv61uYlzd54W+GuH29dzuQ91Gnx/U9eRftegfO
5E4+50PXX3FCv+QeTvj2Y+/RzwOocOYk+////gIJtEIb
         "]], Line3DBox[CompressedData["
1:eJwl0T0vQ2EYxvHHYqLUNxChjQihVCQsukkEHdi8hQGh0sXsZSShh6STxs5g
Y7N4SSw2G+mgDBRfQPzE8M//uu7cz3POyWmez2XXakIIS5ipC+EiFsI0ryDV
GMKVviovolt/aghhQd7DmF7Wj+QIo/qd/Q15UM5zmte5j3O8zMl6mTu5HbXu
aImHkJDbUNVb9by7vpx50eP6q1zBp3mT/i2/o6p/8M/f3PkD+8NygTNc5B0e
cWaOz/RTJOQkHr3Lrt4hd+FNH+IK75v3yCk86wNc5k3PiXiLD3mbi3xvP4Ve
zyqYlcwiPkbavN+8JJ9gXJ/AtXxu75az+g1P8QNP8qxvu4z9/59ftrc7fg==

         "]]}}},
     VertexNormals->CompressedData["
1:eJwUW3c81H8Yr/xaVGYilb1HWSmpT0gLDRIyKisNe6+IFKJUKiSKMookhTIe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      "]],
    Axes->True,
    BoxRatios->{1, 1, 1},
    PlotRange->{{-2, 2}, {-2, 2}, {-2, 2}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1XXVYVU33xRa7fcXuwE7MaxfYgoFd2IWiYiEqYKNiYLfY8SqKqGO9r4mg
iGKgIHgFBKWRS/38ft9ZM7rux188z3o2+8yZM2evtWefu6f6hDmDJ+c2MTGJ
NjUxyfPrb2iV+u89b17UPbhmKHPYJFJ0Pl5Ct7tAks5kYNK2Hg5WEh83sebH
HdmJEi/j52bzMPuTuBleuWrSx3hdvbwrY56WDJB47hXlZ5YdkCDxuc+P5HK+
qDfyv2LNcN0FkzhRJFfmmdGHUqQ98G3lK7VxNEmVOMajX9J12uWxys+UWs+3
HCmhxl+il5nt+UKh0s+xIQ+G/mvyU+Lw066L47Mi7sm6IkWShUORSJ3ZuRZJ
RXMlibOvT3kUG5yhc4m021a1QJzErXr1sNrfPEva73/jFZDvVKJ4tHZwwzRT
ZR9+cHSgr1ucxGGP8XS+mpy36+E0aQ88omX6/fC76brO7yNWD1h8TmfidHu1
8/z6uowrcx7Z5Y+T9wvcQp/X/0nGD4mH1r1UqUPUWQH7s3aLivq0U/OwZsel
q48K/pTjwTwMPz3OZNvAVIk/qvzmToh7tLTH/He2tsjvmeEvGl5osPZSVpyc
T+D83DHOWlttHDasUPbAsX4edHUNr5QeJtcPniPGAxzPC35ab/64vmRcmNFz
h/07q7xDlhxU6xbjxHiA4/niuWD8wPP2bvd8RHyatA9Odhv/ITLeaH6mZt7J
93KxwmF/LajYqZm5fgrvpOVHW77MkPbAHV3vzbSqkSntw+528bE2TZXrB/al
WvcLtjqVInHcL/z0tnjffX1CpsT7ZHe92MIz2cge9+WxrNHUfS8M0v+PzxGP
by9JF9VD+v2dnZ0t7YskDC112tMgcYyzYu78Tf99bGzv3+5exoWCar0FbMsw
afFBL6/L7wXGX6XAI/PvXbN1cf3ydR4Y8k3i8I/3BfMAHH6a2FwovdY0TeJ9
7z8bWb14nFwPGM/FUjGj7FfGy/UAHP5hj7gBHPaISzca1Kxm+2s9wh73ld8y
6EGegkny/UI8WXOua+rXX9cBjvsFDj94jvCD+Mn+YT/UpGCDw2EGiWOcWLcO
pnMHb/wRL987vl/giMN5m3jvivn13mCcHN8kX1AcaxhYvs6X4qFyPvfMMQvr
uEXFNx4/cMTV2d8H9d97MUXieI6Yn8V7bEekB3yT+BjzJe2r5kqT4wEe/MV8
7OKtBjk/wCcFtuh7el66nB/g5cbWqnLzV9zFPPB1YY/3FDjsHRYPn9z2c4Yc
P+z5fmGPeavm2LXGuV/rCDjsb9ad9sn8pl764XgI/ERmJfNrcxQ+LjvILiTS
y8ge/sHj9ap2iyu4P1rOG54XxtnwU+iCdItEOT+PYtObv9ElyvcX+O67twc6
VlL+cd07ixcNmrHolPQ/9ZbFRKu8SYJ1hdtSy9x9MxIF64qI9B7dvN7HC9YV
MRXMBj+3TRCsK+CfdYJ/2R4DZsxMEsz7E0YcibuzMVkwj7AfrMMbTbrbNs5M
Eawrns2IWeyYmSp2Z4R/u2Sm8LPn3r5dlu+n4HgInPWAnV/l+in70wTrgcL9
akbuup0u7Q3Tg6zzeiaKuP2OA8/lzxCsN4CzLuL5h/+WFWoHlNyfIng9YJz8
vmOcrBP4vmDfpedEfd/RqYLjA+yZl61OrdijWxonWG8MfTj41OT0OMH8nmty
w0WN9iUK1iG8TrA+4Z91yLGV1fKd+xYvTCYH5ivrcFTpFr9dMRXzxMlx3nlt
uLwi8pgAzjqh4bgJCUW/pwnm2WV/Ne1v/dEgmMfxvGB/YtucVs3XJUucdcLR
g9HuJlUzBfP+3IF5pnX6kSlYn2CeWZ8wTrwv/U9fu2qX1zrJ+4L1zAF3p3Wx
H9V6W7yj+dUHPulG9pgHrB/WObhfxD3YA2d9HvT9xfV7/dX6B946vFdzG12W
yEE/CNYbvarGDTiiyxY56AqRg64QrCswn3VG13g2Z47SFcCZr7EemK+xfliH
IM6w3sD8MO8AZ12BdcK8hnXFOoHHDxzPkXUCrsu6hXHY4znmwPuCdQKeL+so
PEfgLe9emfjzotQJIgedIHLQCSIHnSBy0AmC9QDeC+Z3jtvwD35hPZa8L3tr
uXMpgvUA4jnrAfAd8Ds+L+v983yrtOc8i/0ABz+yfgBf56ATBOs93C/rBFw3
B10hOM91KWddvkXKD8lTHk0sJ/vnidRxPguc89ndO+qWLOIRbWQ//KNHesk8
oTrklZh/4Kz/M/pOdShdOtRIP+O60HXIu6fccbLrmTvO6LrAYY/ngutyPgsc
+SzwvPmbvNclhumM9KHZrZqn8gbooA/letNw5C/wg/Fzfo1xYh7AF7mjbCsd
z52kQ34Be+CcVw5sG9VommO8nAfYX3eIrtWrkJofPPdDJdu8yJPnp9TV8AOc
8+UnmdPCYgql6jhfNsxbaBJxOkXH+S/8cL7ctP2M4Cd7kqW91FHaPPA+FXDM
p9QJzS6ts4+ON1onsMc+D+wxb1gPThsr7r+7+IJaV9rzxXWBYx9M6qWeiYMu
/q3X8T4b1g/v1wHHvg3s4Z/3/VruqxIaUDrSyD/WFfZV5Hg0HPtF8r0+fr16
9Urn5L6W1G+a/YNcCY3MxiaoPEjDjdb5spCZ9yqekjj4COPHc0RcwvxzXgZ7
5OnAYY/8FPyLeYMfxH/gWFfA4R/5vuR97XnxeOAHeb3kd20e+LrA8V5I/xqO
9xS6Bf6xPhGHsQ55vwU45gH4k/dr0wevN57PMhVN929rlyj9YPyYT/aP99Qo
T9fGz/l471JnT9V/9U3H+wCYZ94HwP0Cx7rCffF+FHCsB+CIG3iOwF1Kv/i5
73SiUfx5XaVogvXSdHldrPOkRsvbddlrkLiMA50aDx/9VNnLfSptHphH/tr2
pn2lwmnSHroX45R5upafYv45P8W8Me8DRx7HvABdyjwL/8xr4H3mNc7jwGsy
Hyfe53wTfjB+5nGMk3mc81z45zwX98t5OnDk6cyPnA8C53wQ65/zwc3Pd41+
vD5Zx/kgni/ng8Ch85mnoDOZl3k9gJc5T4cf7Bsw37E97pfzPifhMbplxaNG
+TXGz3llna07p3wzqPlxetjZIs3hpHxevG8DHHqY+Yv3Q6Te0/YBmB+xn8D8
CD3M/Mv+8f4a7W9oOO9vAMd1WdfhvljX4flK3X4lrPmWltvkeJhPgTOvcf4I
HOuKeRN5HPMd8jLmO/hnvpbr/8bAge1WqveL81ziEcF8zXli3rb5rtS58s3I
HveF91Hm79r8YD0zb3LcAA9inDnwqWA+xThz4E2RAz+KHPhRsB5AfMiBH0UO
/CiYB/F8gX8+kbl8755EHe/bwB54DnwkmE+xTnLgTfleDL57Sug2SN6U79e4
FyNDbH2VPesl3n+QulSLzxjPgtp575qlq3Hus3Z9ar04XnCdaIJV4buzI+MF
11PiN81toTdJElx/Ac77/23yT32cp2Cc4PoU7IEjn9JvNd/fPuur4HpZgOfh
ufqfnwTXAWHPdTHYc13vQyf/TpV+fBNcd2ta061qF89kwXWukc1iby4/lSK4
3jE3LmTyk1//z/Us4FxP2TH/ZPXtpqmC6yCwB476qddfLT6m+ukF1xNdYs9F
L28YKrjejfvluifmh+vysOc6Juy57g8c/mMG+7807Zoh/XAd1qtqcL8z0f6C
67/AuQ473zxPrty/xsffIQDneiiuy98/wB54jUvVcn+6lC5x/m6h/0f3MWP2
GATX0d493d3H3TFdcB0tqObHdvkKpQmux+E5ct0T1+V6K/D5Z29XjGyi6okb
h62rfORJuuA63ZWmuw77WCQKrk9hfXI9Ee8X1x+Bc/0L479tn3tAVpyqP7pe
vjqgmpuaT8ybY92Ku156JQqun8I/cKwT4FdO9kldE6DqvJgHrrcC53o0cK7n
epw7eDPunF5wPRHrFjj2E4C732xxP2PBZWmPdcXfe8Ce64yw5+89gPN3Glj/
/B0R7B3t1jqVKfFZjgf2/H0RcP6OCH74+x/Y8/dFc3slN9IVixRc38T98ncp
l1sM+hxZ5LPg71jgn7+fAc7fyYRa9Bu23+OsxLFPMvDE4hdpfS8J/l4Lfvh7
FeD83Qhw/l6lTImiP16djxZcF8b9Fkld7h16MdoI5++ImDehl5g3gfN6ho7l
9Yy8g3mT/XDdhHkTeoN5E/o2B94UOfCmeBTYvnJZfyPeFMyP0CHMd8BZP0Cf
sH5APsV8Cr3HvIl8inWFr4f1xoHPDQLxgetuzKeYZ+ZT+GE+xTiZN+GfeRb+
mU+hP5k3cb858KZgHsR6YD5dOHbW3EFNsgTzIMaZA88K5ne25zr+g3oP/Uau
N+JTkQOfCtZRWJ858KxgnsU6z4EHBfMg5oF5CvMP//Qdjsh9RGw8cMOIl0UO
vCxy4FnBfMrzCT2AdcI8y/b83QKuy3VJ1rfAmUcQl5hHsO/EPII8nfkXeTfz
qflOnftjywTBfIp9BuZTfCcD+0Pbu90rEnXayD9/L8E8i30G2PP3MMyzwJkf
gbOuwDwceHTrTlhMmOD6I/Mpzyd/B8K8iX2VUPv5Ca+2HRP8/cYh13KdzD1O
C/4eiXkT8Zb5EeuN+RTrhHnQ6Z5brZ79FO/wdzImx5f4+W1WPAsc7wvvw2M9
8z48cN4/x3vE9Q6sf65rwA/v50u+oP183FfoRafdwzZfkroI7yPXX+CH6yy4
LtdPgWOcyFMQx7iOAN3CdWH44Xouxs/1X+BcR5b6pFbxmeVaqLqJfK+pPgUd
yPVc+V5o9tCZeO+4zgvc6lNQQNfSn438fJj9PH/xK9FG98t1XhlnNBy6WuoT
qitJHUL1I6nrqB4BPcZ1JcRVrpfBP3Dk41LPUD1L8iPVg5Cfcn0HfrgeB97k
OhHsuU4HnOtNGP+aqnt6/R2o6nfYP+H6i4zPVD8CznUc7G9wfQr2XJ/C8+W6
NnCuawPn+j7iG9e1Yc/1ethzfR/2XOfC+LleBnv+fgD6k7+jgB/+jgLj4e8E
gPP3AMD5ewbgXL+TfER1beBcT8d98fcVF/uFPLjT96Lg+j78cH1fXpfq+znw
hWC+YH3L+8nMF6yjuM7FfME8eKeE5cP4imekHuC4BB3F8RA6geMJ53dc1wPO
dT3mI74vrvcxP7Ie5v35HPhI8jvXK3ndcn7E9VPmKegi5inojfnOZo8diqj3
BX6Yp/BcoMe4Pst8wfqQ67bMI6yrua7EcZ7zVq43MR9BpzEf4X6ZX1DfyYFH
ZF7GdZAc+EIwXyDPyoEvBOsf5FPyvqguhv0Erpswj+C6OfCI4DiP94XjOef1
XKfmOMk6mevIzEd4jsC5joP1yfUj5jvMG/MI7yeA7ziP4zo48wXvJ3AdinmE
/XM9l3mB3yP+7oLjP+Ih7Pm7COYF4NVqnyrca/sJwfVx+7Su1XYdeSq/8xw4
qfutgboEHfCvpc6fahan9lGBy/2c6xtapCSkSBz5S43uWzJNBiTpJkQXqTrx
ynuJ+5iMKPuqQ7LE4afNEK81l26k6t5+nlelz61v8vvPncssR7s3yZT4d/PI
qzUtEuS+JXD4Kdsp93arfQZdvoYZNreeRsjrHituGW67J0Xie7K+3Kr9KkbV
77TxIE+sMzHVadeKeIkj37S/lWBmlhgv/WDeTAqOGnPqlrrfh22GW17sEC7n
DTjsLTd+yrWiW6KcN/hPfFfG/GxMnMQxHseQbmv/nqpwzM+4ozELy+nTJD68
0inH7W5q/xY49sdef15QxrR8psR9PX+Uf+6t9oExTtj/WPTA1tMnU+Ldn7Ta
uic82cge42mZUaZ5Xw+DxKP7udz88VrVE3HdQRu6vMpeo+pZsM8X0cZyxCxV
X8M8w/8o3+pedmfSJY7nXvfNvSbWqcoe4y8fmLqjx40siR+qF6s7uCzJaP3A
vnCD4PvP0rKl/ar9NSqWOavqpLBf0G7m0LKFVD30zbPE+dOHqe/8n3nN3XY6
JlXiY7/3H3bO94W8ry5e522aBqjv3qvfbNTZ7EuGxNfUKVTcp2e4HCf8YP1s
Xul/pEzST4ljnTz88Pbp2t3quvB/6LZd+xXOBonfHbW+g29KrJF/zOfQ2L4N
5rmo8eC65iU29g1cnC5x2M9wzggc+Guez6ye1i6lt/p9Qa8miXFz6igc44mY
MyX8un22xHcF1i+XLyhazidw3NdBhyIN3v9at8Axzy0OXIuqPTxTjge45eKB
QxpvMUgcfkoV6N5gUzcVHxrom54+uva1fE+Bw08Hrz5DfromShx+1tZdV29o
jUS5HnC/1yZbDcp9MUXirxy8upcYpZfPHTjm4XT57rcsR6v10GbJrIvreyYY
rSus/8hVz+zvfM+SfjDO3duPlZp3IFniGOe54j5fmrZJln6mNx9a9dv2ZKP3
EeP/u0fen4/6JEheqHQl1yjdN7W/x3H+i3Vmg7YjkwTH+chgZ5eojsmC4yH8
cPwfOyPAa/K1VMHxvINNg2smngaJj2lxOcq5SYLcZ2M+2hLw97DTP1IEz/PL
JjPDskf8FBw3Ku0ZOd47ReFvx7Ycm/9pjNx/Yx7Jr9/4btsh5R/PF/Yczysm
dhgwLipOcPxfMsnUfnv3RMG8U1D3s8IPl3jBvGPjmfj3vPR4wbyQWLXChal2
yj/WSbngsk8P7zNI3KbRz+Vpb1Q9guP8X+4xK/t5ZwrmEVmno/jMeObF3qf6
P1X1L+Ydl6ufwjPLKv+FAtIPCOd0I3uM3823zJ4nn9ME8xTGz7yQcPB4vpcX
0wXrhyX9nl8+0SJTcJyv8D7lr0tp2YL5ovO3qjfSvLMkPtanw6rtx1W9D3gH
O78pp+erulgOvCA4bnvvSv33UdxPiRusntU7W/aFnE+O2w9fbxnbfKVBcBwe
Uu/KbNeF6YL5AuNhfun7ynrS8zCFY/3vLvZ3gOX9LMFxe/yeprMW1VQ4/GxZ
cu5Zz3nZEg822ZTU/ZaM24Ljtu2XsqaPymQKjtutw6pllrfOFBy37d0XL/q8
wSCY1/o5Giza7EkVzLO1Vu/L+zExVXCcb1t1Zv8unQ2C43nvO0PWDVyXKDj+
Iy5xXL175lnr2nuTBcf5T8sXLPQ+myKYF1rkm99+fW3lH/b1qq1xHn0jSeQQ
5wXzMp4j8/LAY6v0d1zUesN122T3DWzVPlkwX0yZvcmyT0qWyCH+Sz/IR5i/
jn3/6dFprF7H/IU8AvyF+0U+xXpsukPrYkPfxBj5QX4E/oI9/LNuxzhZbyMf
ZP35veo4+7jZap8Q8QT53ej910SfCkoPHw0q33nydbUfCD+wZz3cMP8Yn2Zf
1D4q/Mj9HMqPOg9/caTB+nijeYA98hfY476g83Fd2CNvgj3mbX3BhmYjBqh8
rdxtjxfFE9Q+oYzz2nxy3ofngnwE14U98hfJU5p941VPt9zKUvnRo6AXfU02
vtYZ6SvNvpqX+eR9G5UfjJ/zxJ0XvPZ+1IVLP1jPmAfoVeBbX73bGJUWq2N9
C//Qw3gf5X4O6fAhB0aO/donXPoBjnlgPYz7gv7EdWHPuh3PF7oOfnBf0NXA
q17dEVy9d4KO9eHg2ct6Oe9I1rF+xnigk4HjflmH21k6TmkRHG3kB+OHnpf5
lPZecJ7Vfd69cxGLVZ0COO5X77rXf8mFdLn+gXO+/9quxMcbbROM3seX685H
uASrOgLWrcXDaRk7XdKN5icr5Eeq6b0XOs4rp73t2+3MOVVnwXVxX8gHJe9o
84n8DvajHTyWnS2s6jscx6AbgZ96s+ZCy+cxcn+M4zD4heMw28M/61usH9a3
8A8+4vgDvc1xlfVkp2nVTri/VftpHCehJzleQedzfGb9DHvoeY6fbI9xsm7E
eFh/jjJ7Wai2t9qv4/i5IDAtYutIle/IurBJr6OmVio/svEbrBsQq/bZOI5x
HoQ4xvkU1hXnC8Ch/zkOI49gPoVu4TiM63Ichi7ieMi6EfGQ9cmTDm0jJ76P
NcLhh3Usni/0J8dV6Fv42dNh1uOClV7oWCfL35lqOpB5YVKUv/mmzWo88M86
HOsHeimHeCtyiLeC4y30LXCvxSHd7e9EG9ljflhXY5zQ4RwnOa/pMeddSbNm
CTrOj2odTd7cZUGSEQ4/nDfhfUF+hPUWETP3xZdnan8e6zahcK2HNmvUfjjz
AvIp5kfofNj/O3PRo1P7VZ0C42k/6ECtOiquiv7/DJ8/cFy8/C7o3yl9XWsY
fuqAB80ssM/FVO2zJVX613pdSIT8PnCIy/bariJL4iUL1HMNVPmdjr/btHn9
plZ2msI7puxIfm6q9v2uHyptU+6t+j7z856wC8/3GiSOcV68pb9kcEiXOHS7
k+34+9+sDHI80O13u83X17iULnHo/3pdT1p+zFT35bRjY5kaC9V+Zudnhyql
v3kvx//3u1pD3t3MlHidYl7T5gQajO4X152w7pLZxcaZEsd1+zbbF9Rwv0Hi
xbITNh0xV/vwNZY9b/thkPru1N2ruN/kSZkSl99FD+jQ9G2zLIkjr+w0tny/
tsuyJY75GTT8exmHspny+WKce7N2/LiamiXxjs2zr1x1STZ6Lhj/tT7umeb/
ZEnc/k3mqtot1D4brtvw+eNLs4Tah4R/+Plx7m3vKe4ZEsf4/UoMH9dknUHi
GH/U1rh4m2OpEsf89H11KzAqNVWO52nF1b0iWqr9XuDw/+PR9sy2Eeq6aQ8i
d7UKVvu3WA/y90cd11543SBR4rhu+uTEpi3dE+V6wHNx1S3dKnorPF/Gc9+5
XVT9AjjG8+bTlxU7uiRLXK7PpCpXL99OlesE1y3UZNThQYeSJS6/P9w8q80/
PilynMDt+2XvW3E3SeLne3WzK9ld7dPCD+53mW7xN6/fxgN8ntOemhXWxEsc
47kwd/Np25/xuia3pld8GPVU4jPMB94/+z1OZ/Ij7nHW00ESH9d2wb0NKxV+
eLTjnFpRZ2RfTfjBdSvuiwuuNkPhuC+fvou7luySIP0Aj399bfyrT/ESxzy3
WNrMPuA//RY0vG7w6eWNfutrCv9yn9/jR9X1AxVeLiPSzzpab2SP53W35fXj
Dkkp0j/wtrrSXyofTpH2sg/q1ZJBNl/TpL3cZ+jk1vLz4TRpv/HhjKR+V1Vd
CfaPg1ee3FEw1ShewU+Bx8s6PN1lkLghsvT93XaqHgT/DhltBwW6/NZXU/P/
dfILq4yv8Ub2iIc1kj3t+/yVKe2Bf1heIvDVywxp/yr/KW+xWtWnYB8i2lav
81t/S4xz2uEdDUd+UnUxrE88l0n3nZ71HqviNvA+p8x+jj6s1v+BSdvyl36h
6pLwM/fhlfEJw/VG9yu/az32vPXwzB9G8afk6b/KFT6cKjj+zI/5kro/SeHg
Tegr5s2lB3z7tL+ZJXLgTcG85mW/7uvBPgbB/Fjob9NXzrsNRjz+fcX8M69T
1HXlftdI/znbDArHOtnaMvJA3svpgvnufYLVos0+mSIHvhPMd865B9/895eO
Yl6DXsJ1fV84rjk7R+33Mj+2n1mn0+rDBsE82Ny1Serk8ZmCefBjTPvza5tm
CebBzFLt68UuUfMJvGi/y5+3xmYI5rW6/Yc2jrmn/GD+N7RL9+pUI1PkwI+C
+fRo56VbXiZniRz4UfoftMa6WJVT0UZ+MJ7y/+aaZbYpQzA/JtVzWhO+Vq0H
zMOboGKvz9unS7ymVVRgYG21j818B5z5KKVfwZDpXZMF89HAIr3eTvFNFcyP
Z63PBa6vmyiYH2uuqGgduTFRMD+eOLf/h0cfhT+os3zd+fqqnsV8V98ro+vU
48mCeerYsEPFR3dKltc90a/uLv8Kav+ZeXDu6Dv5F95LEsxT27st/jruW5xg
nnIbtE+vWxYnmHfwOwLmnWrHJm7x+hAvmDc9d9/r5eekcPgPdvN+Xjw5Xvpx
KvIgn13kUdn/kOPSvhJrRqek/BDMj4WSdh3sPU3ZiwmH/Ar93peSeLB92reE
HRmJgvkryir0cYP4FMH8NX5Ye9OX+1ME82P5CzNEjK2az43usW3vflH1Tea7
QL+2aYUi0gTz3Sabi8N3HkgTzEfye37iI+DMj7I/J/Ejr3PwIPww78Ce+e7e
6MwmWeUyBfPdzUlbLsz6pOw7e/Z3Fat+69Oo2Zc22J7q/lv/RubrxmHHxq30
MAjmtXl3u1YqdSBF4l0/Pyzy8Zaqq7IOrH9ih+2S/3yHouHVomOmXmqpN7KH
f+dnL/6ZOPGnjA+1Z9cNsXJT+5/AkedyvoD9Aeh53O+dd6sWmFY6K39fCfvH
2v6G/B20hiN/h/5HHLMtXef0zZZqnxY4rot8BPclv5/U9LCMJ7p8l6uNUvUX
zCfsWSdbtYkoMLuv2m+XfrS8Gzpcxj0NR14g+VrDkc/ifheO8uoQXlzto0pd
odlzXoNxIv8Fj8j9NMoH4YfzR8wz54nVM46PsTobbTTPcn+75frbIXEqn9qz
PXBXKYtwo+eI8WA/AfNWp/ntylN+29fl7zCxP4D5BM77DFNfXOng46D2w/Ee
YT0gbwIeXqvDtybT4oyeu6HrwAvTT6YZjQfrfHh0/d2l2qj8PaVdRe+2jdT+
OfzAnvcZ5Hi0fQbEB9zXnh5BhfuaKf0M3MPKboPPZ6WfF+TxqPTFW9XRYH+5
jJd/w9/68sFe/n6B8gu5L0f5hW/XFx9t1qp9fskX6eP73HqicMwnxsn7IcX6
BmzNH2Qwssd1kY/gupgfzpuAc940xmLCkuluqt4He//DaQu2Rykc1x0Ycmto
fGiy0TrB+uQ8He8L57Ow53wTOPJNGf81P0b5r4Yj/8U6wfvF+cvsD59turxS
dV6sQ9gjDwKOecP+EsYj68uNjga8/5XPYjwFy+67OvT3foMaDvtCJSqavMpW
8wOc9yte21ctcrC7qifiuhVXb1hoFaPqpMwj0Mk58I7geAsdyHwBPcz8wroX
8wNdzTwC/Z8D7wieZ+Qp/FzAp8DXnq8XuLqpqjcxT4GvOW48bFK5Vu1Mla+N
yB8Q0PO6qnMx74QGn72j26p0eI+Oj9o0rKbqFMx30MPMU8grmXdO6y/tsVia
Lph3OP+CH87XMD/Iy3LgHcG8g3yN+aX494WVu2Uo3YLrcj4OnsW8wX/C/ba1
ctdX9ReOVz+LrY2ccMggmEd4/hEPOa9ff9a6YoPDaUbrB/6RLzOP9NuypNAo
73SJHyl69Gy3earuwPGTdTtw1u2In6yrET9ZD8MP8j7mL9bDwFkP1w1yuGCz
WtU1YJ/eas2L9zcUzvzC+w+zx55cXPuxwcgecZ7nB/PJeQdwzjs+7WgbG3FF
1TFhH9n/yTDL3/rjcZw3yh81HPkj8OnO1xc5tTgifzfNfMR5Mfwc9t5pk2iS
IDgOc56+/YDf2w8NVT2U+euo3rHek34qbwX+dv6NXpti4gXzEfIO5oXJK/R1
j/7nXAkN/3voRJ8qv/X9Y73E8wY/PVLt924apcYZdnhSl0i93qjfYI1R3xrY
vI4QF0aeX3p4k+qXC/yYg82XRvUUXicifq/h0TfhZl8wupAuWfYLBT7TevPb
i/tVH2bg37t9WT70Worsm1q29TIX/9Hx4mVUlSFumzN0vYd+S1geEytx7msK
XExdMrKVq0H6n9l0Sc1WD56KbzuaFezXWZ3fBLy1hbfTs1jVpxf3VX1+j3Vt
76t+vMC7P/Yc1OhgirTv6PXYfuLDX+/Bh0Pp//ZMlP6BLy56pczElHg5P8AX
Wu93KeiscIznSkHrvCWnq/GUd8y+Xf1NkuhxIPnq/IXp0j/wLQ4DjrXbo+63
wm3nVPuBP8WwL+X3FPuVj8Ae+AhLr97bJqr+0sDPxlUKOVBG4fBvmnTx/VBL
1e8a81x91MpUv2TVFxp44oBnN6oeSdU9jb+x0KPTC4lzf2zgk86+v1zgp+r7
ius+O367/+Qf6lwe4M8DRu8OuK/OKZP3O75nyqql2broPP1PZF+Pljj0MPxg
/v0WJXRtfitVdyPvKEOnuQrHONFvEM994MfLXp9vZck+wLBv33XIiJ5HDNI/
nuPI2w/snyem6JZY9D3ZbnO8xLlvNvy/6/3XxNlZ6pwa4MM7+D+IuZYucbwv
X/vPN23eKlO3YeuUPIV+vefAuX8y8FFz56bOz8rWHdz7ZpnDwTS1zrX5yT0x
0T+ukLIHDj8Yf7alW/TbCpk6/8cRRy2WpUuc7TE/p6+OSznsm6kzLDvmtuOZ
QeKwH7pyYJFRH5Ilzv2W4f/M8nlnnujTdG8jcnvV902ROMcB+ImsP9sif3d1
/h3sfX0q1Pcak6Qz2Ou2dk/US5z7b2MeGvdz97KZpJ4XcI/+usXnj6hzqbCe
27YZF1kgJcsoTj7bvML0c61Eo7jaNNf47AebVX9g4H3WzzoXK369B597TX8x
4LXEuc8wxlNuVNEjBa+o/rfAi5+KW/nmSLLo/tc9r5FhKn7y+SPA30/q2DPK
1SA4nl/c0LSYaK/6DwP3nWK3b8JBg+B5s558/Vmh8aqPKMafa3xn1xrp6nwW
PK/jGzx9PmfFC46T+2f9c/rminjB8TyoWcvv+fqpc3CAjxn48ZhTtOq7K9en
zafK/aaqPrTw36qUftyVXmr+EWc6pqz8UMlJ9T0Gfm3zokffd6r+xpi3PgtO
VnROSBUcDytOTfoYeED1lwb+sWOnRpUMPwXHSe5XjDjm3cb8yZUmWYLjuT5k
1cqt49T5OMAtvmR0squucIy/WZG32QV7GwTz7MVGceXLbFHrAfbJt/TzK8So
cz0kbjrA1e1ZluA4vGFdtYPNl6g+tJjniSOXLjccMIhRQedN889U8Rb3y3Hj
pZ+bmc31TMHxgfud4vkG7vD0XxGeJg6Yvdk8xEnFWz7nBevQaWhq5KEr6YLj
qs2FdrMWt80UK64MCZmRyygeCuaFxSnvnu28kSVyiKuC42e9SReLbf6l23OI
nyKHOCk47vF5K8DHT15qcTBBnbcCP8lbzOz0PqqfOey3vpricHJ0kngxqk/N
D99UPOTzU+CnZNedo250Vn3Ucb9br8dZux9PERwPS70uOmZ0Zpbo+2jA0eHu
yUo/aPfF/IX7Wmf9pLxVhwS53ri/bmJg+6Vr3kboemh6rG/uCbZTHsVInHkW
OHgWflJsu8bUe/ZNx3H+067pZe74vddBJ8AeeJTGL3hP4Qc6FjiuCz0JPHPe
sfNTxsbrJmr655kWB4CzXsq+Wvfr9eAkHetA4NCBwOGHdRpw6DTcL8YPXoM9
/EMHAsd9Qf/jusCRLwCHf+h/+AHO+YKJ2599I4FfLO476XvAU10bTbfDD/Cr
mn62wDmzbjmcM+v25zmzmGc832KGWx1MLNX4gS8hPQ8cel6ev+b2Z19Q4Bin
//rl9Vv1T9AdGRxvk7dDuPQDHSLPS3L7s98pcPiBzsT6BA6dI88ncvuzz6fs
o+72Z1/Th5rewHOEfZqml+AfON53PEfoUsQ9+IF+LmbZaeixBUkSZ70HfISm
e+EH8wM9CV4Azn6AQ58Dx/qHTsN8Ake+iXgl3yPKI/BeIB9BvALOehjzjHN/
gGM+oavlOVxuf/YBBl/Anv1j/qHzwSOYB9iDp2Rc0nCsB4wf+deFbAe/WW3D
Jc56G/PDeXcuw+mqhQf/1NlQHgqc81Dg262OJQ6tmanz0fIyjJ/P8ZTrWeuP
BBzzg3xBnvvm9mc/c+RlsAcuzzVz+7NfN/gX9jwP8n61PJR5Afqc+WubxpvM
U9DJzFPQ1cwvyBc4nkOfM4+wvgXO+hbPF/qWeYrPxQAO3cvxFued/ZyknUeJ
OK/tyzE/QiczH3mW7bl3v6XKU3C/yFOYd5AHMU8h/2Jem9q+wbc25ipfwzrk
PAX4oUBnc7f1Csc6WbfYv/KJqepcDNwvn5cB+7Fa/sI8gvM7mEeQBzF/Ia9h
XoDeY37BeXzML9CTzCPQh8xfwFlHsf4EznoS/tEXFLoU44F/5hfocOYj1vPA
oSeZd1ZpeYGtlqdgnFjnHE+A79fyDoyT8w6sZ+hh5p1LWv7F/II8i3kEfY+Z
R5Bf5MAjIgceEcyzyL9y4BGRA4+ILto+A+5LnpcRbvfhdhnFI7z/IO9XyzeZ
X7AvwfzCeTFwzouBt9HyYuYR9CtjHkFeybwgfy9PvMD5KeYN+S/rFp4HjPP6
u6gRUct+rc+lM27VPBEtce67xftjk5d+KVvZNV7wfiPskcdZfNgR7LjToDvR
K3Vq9Wlxgvc/0ZeJ95PRn4r3XdEfjPf9ZvYuWNE0LFnw/h7sZf57K63PrfKZ
ugUiaXM97xTB+3u4Lu/zY5y8nwx75I87tO86bN796DGrXbjEuV8i75Ojnx7v
P+O6vD9f7V31gK4fYwXXKeCH6xpzF5q6LQ0yCN4Xxfzw/nM5jw7LRnmlCd6/
7XGvz9Eqa9MF78c67J7s0rhVgqA8Wq4H3rdsVfhbyfbrkgXl6XI8yNOPDm2X
a+VP5UeOp0LahOEX1LkbwK+F/pgfmK76uPI+OXDen4d/XHdWaQtX0VA9F+D9
8h+0qLRXnXsC/xtiixhsByT9ys/qTuoXoxe834vnyHUirAeufwHnehb8cD0L
48F9mRcZlPrsV577OmLcgjE9wiXO4+G6Eq7LdSvgXG+CH4zf5IHfkajbqt8m
148WZdZtWqXGC8H1Gthz3Qf3hftt93jmhbBR6r3jehk/d+fXMbuc41IExyvu
h8n7VxyvuC8f3t/ce21r1W2cJTheYX/y/ro1qx+cjhZUJzKKq4j/HJe43yPv
73G8HZt0K6PxdnWOAOZT73R4RdRqg+A4tuFBnje+SaovN+/3cjwx5Oq1qMOG
DMHxh/uC4rkX23633+a7an54v5fj20zvyu/qzE8XG9aeO93cXMVPngfev+3+
I+brxcdG8U1wfIN+M/WzKF3giFF8Exx/Dla6XmRmlnpewEvY7Wmkb5YpdjZI
bJB7tVE8FBz3bGvcX1g9KUtUPRwTnJRH+Wd7jKfuvzPXNbuo+sQC//Sz/C7X
n7/WAfEd5sd1daxf8jzlB3jLFqOGjGmcIHj/k+Mb8jiOP8hrOP4g3+T4Vub8
iIa5OiaIgneX+VbTq3jIfRe5PuX4/Uot2xavBdehOM4gD+U4vOTppsB8tgrn
/WSOe4uSHlVd2k318+c6EcdD1H04viGf5TiGfJbjHvenxX3NDLu7MGxvimiY
EJ1V9H6MxNme6194jrxfBJz3nbDeeJ9KnptA+3XynALa34Mf3pfDegPO+gQ4
8ynvtwOHjm2o8Rr88P457KGTyxWJ/Xb1Fy/Lc3BonxM473NincA/+FGeH0H7
rsDhB/z+qLhPiZRoveD9THkeDe0vAef9JXneDe0X2Wt8wftF4C/e14J/4NDn
iCe8zynPwXH78/w44DK/03Q1cN5Hhf7kfUJ5HhntQ0Jn8j6kPP+I9tnA77zP
hvHw/nBZTd/y/iTseZ8TcZvyerl+4Oe6pj8xz9K/plexPnkfL3JrUuXWd6MF
5V/SnvdLEWe4/rJYizNc38H65P3SqhqPw577yXM9CDjXlTBO3qfFOLl+BJz3
aYFzHUSeV0L1GuBcr8E4uV4GHM8FehXjhz10JvxzXQk416E4DkP/ID+ifXvB
8Rb7URxvuQ88cJznxXEMupfjIfiR4zB4n+M26wQ8X+hA5hHonNZafkd1DcHz
zPzF+9LMC7M0foSu4P065gvwPvMFdD7HeexncpzHOUEc51OPHO8X1TdBcNyD
LuW4yueU8b4Qx3/kBRz/ZR8eiv+yvxDFSegHjpPc7533kaCreV+OeQH7hMwL
yFPk+Va0Twj9zPuEHLdZt/N+IMdt1u3Aods5PmM/lnmTdRfi1Xotv3uo5Xe8
b8ZxmPNHrjtwfMZ+I8d/zpuA36vld/3BknTBcRh5H/MFdCnHYeR9HLdZ33J9
gePwWNLJXNdYqOl8WQchnc/1Jo7nyDuYv7ifPNdlOG4j76j9omv7Z5Z6+X0I
eJO/i4N+Wz7UZ6pX73Ad7++h7gx74Me0+gXvw1hq35PAHtfN4TsWXQ7fq+iC
yv6z4kB3NX6sN/YPHPvknF/n8F2r4PuCPd8XniPmE/OP+8J3OJwX4LtQ1le9
tO+xWZ/EauNkvYR5gB95/jh9twOcv0PA+Pn7AdzvrXapQxbXVuMHnkMdX+RQ
rxcRmt7j74djitU+2rOI0f6A7t2WkE/jFqm8HvPAeT3wUdZ2PhvGqDwa682q
4fpylSboBa/z+1bbHSu9Vvkm8Bz2dUUO+7dieXDdlo8bqf1GzGeWzZK/tnZU
15V1rv+ti3TBOL+VvqvJQVfo7mnj5++yXmn7n/zdy1ttPvn7kKHavj1/h4B5
4/U8Uptn/o6lhttuC/Mbajy43wt7020ntlZ+gC/T5o3rmznkHcJF2+fh9emq
7Ztx/esNzvWjOjj6kuG5Bz04M2fOcnXOgtzn2VU6YuVm1V8UuPeK5NuDpqv+
t1gPKf55j/Rars4dgH3zZlYjN/qkSj/YV7F8Vzv8Vrjqg4rxfFzbpvfLEHVd
4ONahv6YPUf1s8V6u1tx2emn0aovK/Dd768Pz6+Plziu67bJombP96pfq9yH
3LQ5sWS7dInjPR2wYIXeNE31vwVewqx186XDFQ4/efbvml93i+pPK+syPdtN
XxSdKu8X+OzGfZa2DE+TOPwMf7jgcPUB6vwF4K8/+2QEPsiU9hjP1UkjyuxN
yZLjl/vAqXurffxb9c/HfIaHPG0yYrDq+4p5+z60Z9sl51X/VczblF5dfbaF
qXMT4Oe8q19qdESa9I/n/m5RoSJh91Q/VdjvHOn8+OsPdd6B/H7eL6HY2QHK
HuNxMRSaWThOnV8A/OBbW0uL9qqvrNyvK1P3Vau16vwC2Od3mHl7x0zVXxf2
3R+e+L7VUZ1TgHEW0nkFdfFW/UtxXy9T+9YoPUvdL+Z5+Pzyc32Xqz6owNsM
+6vpil/rBDj8pDrbH/3iqPq7YpwBtXutDbVT7xfGmeRyfdQrd3VOAdbD9MJf
ROJK1d8V499QpGlr85Wqfz5wOxeXPXtnqT6cGE+N1T7NraepfqoYf5PtFvkX
Lk8XHB8+7ah66v021fcbuKG4fc+H09IEx4H1979emHgjVfB7OvPa6rEhMapv
J+63sXedZWVjVD9/4HnbhUZ1DFb9P+FnWu26RZ/GJgh+r89fqVmrTRc1flnX
GDNhs/lX1WdV1n8b2Z8+9Lfq24/3q7XNpby1UlV/VOBFPLu4XxqmcFzX/KrY
+f63/o3w/9a8Qr9jEWmC3+tSD+t+Mn2UKfi9troQnv4hSfXbh33p8UNW7hms
+nZiHt7d7FC15XnVt1PG+YPJFQ+GpQl+T4MjNp2d8I/qMw/7wimJQ4oOyBD8
/va1qe/WOVb1vZd1t9lX5u+3Uv08MZ5iC2t1Kxqr/AN/GL96Tkwb1b8Ufhz1
3XoViVT96oG7NBzwM2qVOucCfn52nHPKY5LqGwz7jx231Kq/TPWZx/gfzFra
pWeo6vsKP403e3zuM031+4V982EBacmX1XjwHBfkWpIxeJXqd4r5rLp370PP
RapfKMbTdchsu198Kjg+xEXG1+humyn4va69w+PQ0tWqzyd4n+MS9APiBu4L
+gH8Cxx+mGdl/qjxBXDoCvAj1rmsL2i8hvHguoiTsIcf5keMZ3zZzPNnftMh
8HOqawPb8790iDzXw+1/n/eEPJT5HfMzutvTbiGxSicAh06Q54y4/e/zreC/
baFhG4JjlW6BnwIav8hzB9z+PF8GOPwgnsO/nAfSOZgH6C55noLbn+fsAJf7
PO0bjfVckSj5An7AO1jPuC70AHD5/aHGs/ADe/A+cKwH8B38AGd+xHoAf8lz
Mdz+93lG8vtzTSfAP+6L9QbGD/0AHOOHDsG8YTzDKxwu82Cw0l0YP/Qtngvy
0P6kD4G7Lu/Rct1IpdPgZ9K8jmd2/TZvGCd0lzynw+3P85iAYx5Y5+C6VzQd
iPHjvqAb5bkhbv/7PCz4h97jeAIe57iEOMlxBvGW4wN0AscZ5mu5/0x8Dfy2
xtccZ0qWOLxo6kaD4HhS9mYL+0LbkwXHn4IXp6wq5KT0EnDoJY4b/4w4kLn2
+2/nDbn9ed4Qx6V8pFtgz+cZwR76h+PYdE3ncJzB+SYcZ8A7zBfgTY4z0IEc
35po/Mjxh89zwXXBvxxnimi6guPSgQLd3M8sU+f1AIc+4XXL593gutAPHK9e
a/qH41Va58OmU8cpfQKc+R3rCrzM8YrP8ZF1GdJF8ndAmi7iuAR9xe8v9CHH
JehzjkutSK8CL6zpVY57pTQ9yfEKepXjEs4P4rgEncY88kjTexyvPptnHLH8
7fwd2EPHyv6cmk6bX2jWnWLeqt8XdLLNYme7f9JV/2rY55k4ZlfTjqqvOPSY
6+UWPaZuVX3FocfsE6bOWhSVJnG5P2BYctJvqOo3hetmzEqc3ylD9ROD/aL1
A6s2eqBw+G9XpLHHWWfV5w3j7G26s9u5dNXPDfqznu+5x5vTVP83jL9D93WX
M0eovt+4bmW38+2j3FSfN1z3WNsznjvdVN8/uf8walbjShOUH1y337SVG2y/
pUkc132Sd0nrLzGqfx10r1/1bWM3PsyUOPx0iA7b1nio6iMH+9o+ziOGOKu+
avBfu1rNym+cVX8q2M9759Lv+mzV909+z5Nm23HLHNVfC/jal91vhM9V/f3g
v9WE8eGvt6s+V8DvP+z2pUCU6oMNP5nPy7crGpcg+1/BvmepBiWtQ1QfMOCm
3UosN/utr7X8frJ1/L03X1X/auBfnH3axzur62Lepo/xTm09V/XdwjwMmGr+
Le8v3Qg/wJebXbVZokuW9vDjWr20d56Vqj828PQqvXOdrpco7bF+EtNDtkxw
N0h74PeO2CckWKq+01g/efW+m/yuqT54eC9uzne64j1C9cED7u/0PbFD2Uxp
Dz9dfaNr3fyWKu1l34BHze4/O6L6/mE8BU11Nx1/vdeyDyG+j7rx3GPdbPX+
4n5blx8cti1c9VcHXicrV4Wyv/Ij2MPPlwkjqz7wTTVa/wmVDo/0jFL9cnFf
l+b2a/RXmuozBvsLT2ynVdpsMIpje2rsiLh3WfWbwv3+vW2U2e6vaYLjzKzn
F5P6p6k+zJiHy8d+HF3wWOHwcz76jFsrZ9VvCvaRV37FVesMwfGneL3FLyLT
VF8vzE/9qHbpx1LVfWF+tn2a5z7tqbLH/Zavccit1AjVVxnX7bDAf2ZxN9UH
DOMsWvJ0i5uuqk+y7G9w7m5jy7HKD8azcNXJC8Uj0wTH+QZLXXwj2qo+ybB/
fPjFgwLDVJ8x+V33i9PLC6xU/bHl99XJXVI9Z6m+bbivfhaWXTasVH2c4L9l
17rXR81X/ZHk9+EdUt1e7lJ9jDFOh6cBU8bPU/2RgEcUEKkh31XfYOBvy4an
3Fyp+gzDf8ynGaY3v8QLjkvl52W1aPdO9acCHrxvQ6/B01TfY9zvBb9RpRZ5
JAuOJ9/bDVjdooPqQyX513du0NMfCYLjjKlP8TM3nFT/KODb+vUfsLC26kuM
9WBWJv+VcpsMguNM9I295U72NgiOD9MDS/WZ+0vXcXzIEzbiq9NB1ccM70tm
weyC54erPmbA797ccvlLddV/DNdtUt0utHE7tR7gv2FW+KVVV9R7ivua+MOp
fUqYer6Ytx3mVe7H3UwVzFNNB3iOWDJb9e+FvcmzS8fvzE8THJeKVQs/us9X
9buDTgO/A4dOA4/L/tKo+1Dfe+hq8C/eF/iBTsB4oEs5TkKnMc8CBy/L/t5u
f55DARy6Ebws+5Djez86pwP20Amyr77bn+fFAIc99B5wjBP6EHEMOOsx+Md5
K8Dhn/UY7Pl8E9hDR8EP5hl6D+OU32uVGXqj9XOlr2C/q8KMB47Dlb4C3p/0
G+7LnvSz3N/T9C1w6HNrTVfjecG+QTf3Av5PMqU91g/0M95H2LOukN+xaLoC
9rhuifLOLdfbqvUM3L3OaLugmqo/LXDocOAYD+sT4Kw35O8BSW9gnNAbwDGf
0IeyP7zb/z5XBc8dOlP2J9T8sD4Ertf0oewP7/a/z0+Bf9alwKFL8bywrqBz
gGP9tCG9JL/f0/QVrgs8T5WR2U1+06XAV5sf2eaoU34wz8iDMD+4LnQvcPiB
/sd15e/cX9a43v43fQv86iDvOmd/6VuOn9AhHJdw7gDHpY0aj3P8hH7gOAzd
wnEVOofnk+M/xj+yzO7rgb/xCNYDeITjJJ/XgPEPrT+7zsDVCocf6BCOn3wu
CfxAx3L8LLYp4Ow8neofC5z1JPzj3A2On9CNHA9Zf2LeoD857tUfLQJbRqcJ
jsN8zguuCz3PcXLO/Zi/T3qrvrLw/0TTkxxn9qUujj1/TekExKVGk60m5zFk
CY6f0O0cP63Nq5n982v8HJ+jNN3OcYx1EXDWRTJOki4Cfod0EfDLe3r+HGtQ
OMZzu9ytRnc6pwuO8588P9b0+E3XAc/t06ZjKyul6/BccM4FxzHWscBFxMCu
J6apPqvy9w7DHgz5nqD6qeJ5QZ9zvD1+5bXdsDilt4GXyHUwdO4G1TcVfiZp
eo/jPJ8DIusvuhqDi8UpP1i38++u3flL6gvWaTgHhOMk8jiOh8hTOA4L88n6
p7/peeDlC1uaWfzS8xw/95Z52f/8KqXbgb8qlen07299KlYEDJhr2KYXLU+X
CMjOTtQFuMxrltRqnjz3HDh+Rx/eaNrwwKwfIniy47/Z2aof1LuuE1wiF8aJ
ZdUjbmZnp8s+LUP8Hf0W5FJ+gIdt8LX59spFVP3/76B+6N5O3H2mWr518lxv
4Pid+1LHkxbb5kXL62I8yXunOH16Gib9F3y/ubr+dZg8f5zHH3o7XGe+MVmO
E/Mweoph06CZ8dJ/24JlusfPV+etA9/jYHLyWLg6nx04fr9f2zOwb4iDXvp/
OaK6W53VyXI8wF90dg5IOpoi/QNvkpb76tj/9NfH+W4Y55GUBYcO6KU97gvz
UyJfyZEfyk6U+MQDr1+9zRcnr4tx1mxQbKjP8mj5fIFXmvVXtanL4uR567iu
U7ciHn2LRsrxwP8bR++DnUrtln5a/ReX/RYctnws2DJPnHj7X//Cr3+LndeL
h0r/wLF+tnR+27L6sjix/L/XVf09ut2pVHRLosSxfh6ef2deuKC6LuzNPDNO
2C+Nlv4xHo9szzce78OkPZ7739tmewcdSjHy32f2nU6zwuKlH+DdPmx9GWuS
Ku0tVwTFbN6hl+fOA8d9LV02sFNs3lDpZ/LMpAvHTNVzAb7zXoNSSTsS5XzC
T2ymy7AkO7UOYe+z9Nma/Xq1znkeqvp9mBXV20niEZtzF9nnqp47/MxsWunA
YWf13HHdPaMbPw8rrZ47/GAe4m8WLx3v5Clq/Pc9FVYHpo6Pqrtb2gPHeCwT
Ut3uLIjW8TpEf2l+r++XvhZQ1D9Mx+81+mDze/325ahXJrnipB8838K3FtTT
HUjRcVwqHdlqxqaP8dIe+OcPXR6PyVL2R0u1M6s2Ya4cJ8exGr2eVj6a1xgv
4/R2+spDrkZxbE6Q2+mG3adIe7x36N+O6yKeJJWotbewo17iWFd3V6w/v3KR
sof/QaNXNFq8N9EIjy7RL/Xwimgdv4+4Lr8vExZF173/MUw+d6w3zD+vK8wP
v9d9kw5trlgw1Mj/jK2NaiWuStZhvQEf+zR/s6d51XjwHMe93l5o+BG9vO6e
8hNKLm2zU16X1+fOOubL2hZWeAEHO+sXp/XyHF7gvt9SgyssUPOP8eB9hH/g
n19+E6tdk+U8AMd7Lfu0a+OX7692XZ4fh2W5Rl9frq6LeIK+98DXjxqb0foX
bzGPHAndndpup16eSwUcv7NgvpO/zyoae2/oEhXnq3WY3fHa4jjB8T9kpMfL
M56J8vwp4LUsL1wOnKHOVcR7BP9pTtHp4xIV7+D3LC2vmNs6554leSpXvUaD
J7vrBfMaft9hpE+0+0qPjzmxMUrxfnr+EYtXxHyS48d1Rz7uOq949lfB/HXg
XrjL4swfgvnRusCgPKP0YYL1A8bDOgH3lbTv/dhi7kqf1AtZNChrU7RgnnUs
3uVEVqg6pxLrYdCFLVVcc8cJ5oXY8PU1GuRKlfZYD7huN69ybT8fUPyI+WH+
rRGxN2pr4VDB/Ivnxfw7wv5akTVL1XoADvvRXlMnmRRXvCZ/76avcydig17w
OM83ete4XuBuyUcYJ/OyffikMyfyRQrmne258kyYEKyeC/CSTQ+NWf7LL/NO
Xc/3r/bX3i1Yn+A5Mu8D3/G5/ILc8xTvY/zvxw+2Hbhc6YqI7HPvOy5Vzxc4
3iOO53iPEE/4fXzXp+y3b47KHusT8YTXFfMm5tNvWsfUGzGKN7GemTdxXw/K
NLzYYbviZYxnx9wN+26lfZK4fE+1OAY/Mg5oOOyxHvYtdDqauVfxF95TzA/s
EccQ92CPcTKv4Xkxvx8LnOr5T9NJgvka98XxFuuc4z+uG1Q3yiLBwlOuQ/hh
XsP7y/Ef64T5EeuZ+TTln+NO+Q6nyPnEeHJlDB9d1D1ZMO+YLLRstXaumn/4
x3pgPj3xapr98lyhgnkf9m82leyze6viZczz3uc7P848kmI0P2feHjmzwina
yA/rB/hhHj+RmTzGMa/KC7AenoycYOZwTOlqPN9mReKqFdyqdDJw8DLiA8ZZ
aHWhUjW9VJ4FvJbHmpP3v6o8DuPfXG2G69yfKv+CvdQPmh+MH3kWv6e4L17n
F9qsLrx6v9IhWJ+4L44PyB/h3yh/1PwAN5wf83jBWqUfgMt8lt5TOT+03m6t
rqx7sy9FcH76rtfJKXkyUwTnpy4+e8u6flC8Bv8tQt48nBU8WfB+Qrn3bdOG
OawVnO/L9Uz5jnwv6DlWdD99tf86pX+Ap6zte+7cAaVbgGd6tGvo4q50FPBj
hQ/cbrNf6RA8XzkPNM/QY/xccF3WjZ/S9zffuU/FT/ivmbfIkyGuKu7J/DGw
+fVycz0E61t892Wx0Tn+4Euli/D92PHntXudqpcgn5f83q92X+HiHSPfL3xX
Nrtn2Zk7K4VLP8AH3J7Ywee10o24bs2Rz942PJ1ihM+rM8m8ybJ4I/8uH4t/
rDpevdcYT5vITf4756j3Gt+JOdobbrk0fSHt8b1Z2/h2w8sUDTe6rzVlD703
r/HaaB6Gf9v1ZntzvfQD/2cC/2391j/WaPxXz58IMH2nl88dfro+GDO4f+0E
uU5w3eNNQ8c1uB4j1yfu961Bv8esQbj0Azxm1rXnffyTpR9c1/TLBacgJ6U3
gLsV6Dl2xHmlT+DHa2XZSt6TlX6TvytpMLHRq2lq/WPeSndOqVm9WrjEMQ+p
uyu6n7gdYOQnd/GzP1pbvjaaB4ubxb7W6qqX9vCzKc3ixeUPsdI/7OtNjKx7
r5Vex8/9wv49xa/6xOh4nbQxbJg0MDhZx89lxISNQ/5drvJ04IV3JuV6cEbx
PvzMMbPIf21CnJF98aUJl1a/0st4i/G0bdNj58Nar3W8/jvennzzQdVwtd+l
3e9Sy/KuBQJj5XUxzwWnbfDqWiJcx+vzfdOJHT/MUHEY87OpUP85nRsk6Hj9
m03cOya89QujeVvo1fTScN8YyVPwU7Dl2DZDeuh1vA5fnfqUEhqgeBz4Vt+O
3fvZKd7H/MRXC/aa6RxvhC+vX2n4tXOK94H7FZifnO+D4nGM83CWlfv2Qa91
vP695rf51rtRuMQxb5+v9VwwoGa4jtfnLrebTfP8o/SM/L50ygbrGTNUnMQ8
1DdxdfxSJ0Hi8vso60bHKkxVcQb78BkupjUcKqk4iTpRTPzl3ONWBMi4gTpR
+LxpRxtnfjay3/K4kMm8SyqeYD//0Y3gKt2rqbiK8ZTcdH5CVEiQ2g/HueSr
h/lm/8aP2M8f+GDYT/FMb4RfD74x6KxXitF1x5xv/3iSrYq38vy7H0F5Zjqq
+Az7bnUKJDu8VHEe4yk0KfTwxlfOcn8e86avU2S2dWMVV3Ff9zsbpiReVvwi
63cvN6zbeVnFGdjf3NLzSsIUFa/g/8nsIj26VlfxFvM/YdKsba1zqTgG/6/T
LoR2vq3iD+7Lc3vXoablVRzGdR16Nr7tHBYkcXluYN0j1+867ZL7mcCrxZ6d
Zl9A5Y+YzwkhrcavfaU38uO7qNeJRr/tDwPXv++3b2OoivMY547jl9N/jo0z
wldOq9z7P/zL69l5Qv/Kw84o3pHniQ8uG3TKTG+Eex8YdXt1MxWH4efCsgF5
ekYEyfiG+dwYNuTozTVKH2L+L0f5JI4yUfEN4+wVPTE+fVSckf9sd+tnF6ep
uCfPoywTvqTb6d/2Y7X5mX3y45YDmSlG9vXMs8zzLPttn1az3+lyzP5siMIx
ngYTmlQu9krxCMaz/Xrfa9W9Y4z8pIjeiXV+27/FvEXca9a3aJUEo/v1bF5/
zvyaihcwzr/qtQ/yfa43ms8T80yazbkbq+N1PrD/xkp7y6m4jXFWntJtufgS
JOMk5n9VSO2203OrOAn/2+81bJB4PcDIT59xfSqXnKriJMZ57OvdQ6edVJzH
fa0Ie1fTfXycEX6w3PFaBYKTjfxEZJZu4XA2xSjezk/Tm38+rngK8/yx9dxj
Z4/t0PH7VfbTHGvXQkrfYn4un245620NFc8xnqmFtx9rY6Z4BOOxm3t35P4g
xUfY955a3SZfmGeiUb2v5iorE699Kn5i3zjtUIXDDzOMcfOzRbulfFDxE/u3
vM8J/+5jut2of1DFB+xvr7bOl2HrpN5r2PO+E/b/s79uLhe9Tu2n4bq8PwP/
Dw2Fp97bpNY//Pc4UsM7cpZ6X4AP6H3oTr2dat0C53wf+PIqnfd5zlfrB/PT
7HTklLzhxvjaS/XmllmwSz13DY+8PPHjhQTlH89rxl3DquVlVsnniHnwH/tp
yl+b9Eb2kSsiux9zTzTal+Dnjv2oZ5lNhvjvVvVZ7FdwXRv7FbxOYN/3VrHQ
Je7qOcKenzvGM8NuwZnx62breD+Znwv883MEznUu+OHniPvlecN4GkZ0Gr/k
kJo3+OHnCz3mP9n339Df4hje37UzvO0K/P6+aPj5vsssy/72vshzkA/P+Rl8
VuU1wG+e8VxceuVv9VbNT9vhWVerHVot9wcQ98Z2sR148EqsEY88L+/woObn
eKP441D/gV3x39bbs/4NkoMfqPMN4cd1XyGPNtVV/yWMf1Glqs7fSqg+S7Cv
PLR7cMIq9Tt32Ndx7HBzjp363T3sx8TsqzDTX51PB3zkNv9w9/PqvDbJX5sq
1HUPUues4fk+zLbplHpG9YOSfD370MbaVdT5aPCTlXqu1Oiyqv8V1mf1lMRi
nl/VuYSYt5XtXkVV//5Z3i/mrXVi/qRnM9R9AXf17z/n8iR1fpysa3ukHZhQ
X/WVknqpWOcbtn+r82Iw/pf4DsTtz32hhs+bL65QUZ0bgnmQ3ye4/Vnfyfa3
O24VEyR/fwcczwU4Pxf4Bx7rMvOad251DoXRdxpuf+6D4TnieyHgUbbbrApM
UueDGH1P4vbnvhnWFfwAX5l1uHbp+qovFuZ5S+/5m494q75YwLuiLu/2Z33E
Q3susl8i6qqo+7v9WX9plHfyoHPv1LkqwLEecF3JU9p6gH9eV5hP2IdUL73w
/L+qPxjwgUesx17MrfqHYz5fH2jkGzVK9XXH/LR8fOWmzXT1OxHY12n/apLN
zyD1+w5tPdzqWMS2Uy3V5wr4mQrnFnzZGSB/LwD/1fa6DnBcqX43hPsKOuJ6
+fI51e8d4y899fpR9/xq/MBtg5t1u3Bf9V0Hfn/um72zglU/cOBDkw++azdN
3Rfwi1s3TGtbS/UNA96p8pOP3YNUv248r+nrF5T4UUP178L4bTcmPoq9qPqG
AZf1U3q/pl7asr+Kj+qLhfnx1eaT39P5rUp31j9TfT6B4znye9FCe478nvbX
1gO/j8kt+1x63Er144Kf6mf/OTz5muorKPeXUGekdT7brOmyuhXV+IHLOqzb
n3WBV9pzx30Btzhja9E0WPULBS7rv25/1h2wruAH+LBRtwvfm6rmAX6y06wH
rRyv5g325T5UuL4jr5of2PvlGv+4xtMAOQ+wP5mnop/+13sB/7jfvAH/jZ/8
vmQX/W/c5vciWotv/D6OdGlV/GVFFf/hJ1R733n9I77x+gwu9ujw5UDFm7B/
YRaS++/Fin9hX3VWg303Lis+hT3iGL8X7lr85PVfufb75SVrKj6Fn381/uX1
D/3A67Be+6WrLr5S8RPzAL6GPdYn9AmvW/A1P8c0jd/5OQ54PuP5yorKv1H9
i9ZhgDafvA5lXYzWP+aZ1z+eF6//qDbuCY1eqfiG+4q+bLp/7SkVP4HX0N5f
1mkv/GcNjHBUcRjzvGtK0OY2VVU8hP3WDiHf6z9X8RDzP02LY6yjEE9YB+K9
Y51zVnuPWF+Zdq6VuqWi4hfgeB9Zd5VEXYz0D+6L14msx5EOidLm00iHaPPP
OkfW70iHYJ5Zh5zV+JH1Wy2NZ1l3gad4HSaGF+g4zUvxCOZhd5bl3X9fKb7A
vFn1XTPYpaKK8zJfxncgpHNGajzLuuL/AHv/Jzw=
     "], {{
       {GrayLevel[1], EdgeForm[None], 
        GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwl13nYzlUex/Hb48Hz2Jcs1WUpMjGNpaQsI9kV8QhZHowlW7bssmXJliUh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           "]], Polygon3DBox[CompressedData["
1:eJxF3XXcrlXxNfD7ibskJBRQuqS7O1SQLkFBkZKUUhrplJAOBVS6RToEBJTu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